/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.productlevel.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.mdm.productlevel.req.MdmProductLevelReqVo;
import com.biz.crm.nebular.mdm.productlevel.req.MdmProductLevelTreeReqVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelRespVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelTreeRespVo;
import com.biz.crm.productlevel.model.MdmProductLevelEntity;
import com.biz.crm.productlevel.service.IMdmProductLevelService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mdmproductlevel"})
@Api(tags={"\u4ea7\u54c1\u5c42\u7ea7"})
@CrmGlobalLog
public class MdmProductLevelController {
    private static final Logger log = LoggerFactory.getLogger(MdmProductLevelController.class);
    @Autowired
    private IMdmProductLevelService mdmProductLevelService;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868,\u4f20id\u8868\u793a\u67e5\u8be2\u5f53\u524d\u53ca\u4e0b\u7ea7\u4ea7\u54c1\u5c42\u7ea7")
    @PostMapping(value={"/list"})
    @CrmDictMethod
    public Result<PageResult<MdmProductLevelRespVo>> list(@RequestBody MdmProductLevelReqVo mdmProductLevelReqVo) {
        PageResult<MdmProductLevelRespVo> result = this.mdmProductLevelService.findList(mdmProductLevelReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2")
    @PostMapping(value={"/query"})
    public Result query(@RequestParam(value="code") String code) {
        return Result.ok((Object)((Object)this.mdmProductLevelService.query(code)));
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    public Result save(@RequestBody MdmProductLevelReqVo mdmProductLevelReqVo) {
        this.mdmProductLevelService.save(mdmProductLevelReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    public Result update(@RequestBody MdmProductLevelReqVo mdmProductLevelReqVo) {
        this.mdmProductLevelService.update(mdmProductLevelReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u5220\u9664")
    @PostMapping(value={"/delete"})
    public Result delete(@RequestBody MdmProductLevelReqVo mdmProductLevelReqVo) {
        this.mdmProductLevelService.deleteBatch(mdmProductLevelReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u542f\u7528")
    @PostMapping(value={"/enable"})
    public Result enable(@RequestBody MdmProductLevelReqVo mdmProductLevelReqVo) {
        this.mdmProductLevelService.enableBatch(mdmProductLevelReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u7981\u7528")
    @PostMapping(value={"/disable"})
    public Result disable(@RequestBody MdmProductLevelReqVo mdmProductLevelReqVo) {
        this.mdmProductLevelService.disableBatch(mdmProductLevelReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u67e5\u8be2\u8868\u5355\u5b9e\u4f8b")
    @PostMapping(value={"/findDetailsByFormInstanceId"})
    public Result findDetailsByFormInstanceId(@RequestParam(value="formInstanceId") String formInstanceId) {
        MdmProductLevelEntity result = this.mdmProductLevelService.findDetailsByFormInstanceId(formInstanceId);
        return Result.ok((Object)((Object)result));
    }

    @ApiOperation(value="\u4ea7\u54c1\u5c42\u7ea7\u6811")
    @PostMapping(value={"/tree"})
    public Result<List<MdmProductLevelTreeRespVo>> tree(@RequestBody MdmProductLevelTreeReqVo mdmProductLevelTreeReqVo) {
        return Result.ok(this.mdmProductLevelService.tree(mdmProductLevelTreeReqVo));
    }

    @ApiOperation(value="\u53ef\u66ff\u6362\u7684\u4ea7\u54c1\u5c42\u7ea7\u6811")
    @PostMapping(value={"/edit_tree"})
    public Result<List<MdmProductLevelTreeRespVo>> editTree(@RequestBody MdmProductLevelTreeReqVo mdmProductLevelTreeReqVo) {
        return Result.ok(this.mdmProductLevelService.editTree(mdmProductLevelTreeReqVo));
    }
}

