/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.role.service.impl;

import com.alibaba.excel.util.CollectionUtils;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.humanarea.model.EngineRolePositionEntity;
import com.biz.crm.humanarea.service.EngineRolePositionService;
import com.biz.crm.nebular.mdm.role.req.MdmRoleReqVo;
import com.biz.crm.nebular.mdm.role.req.MdmRoleSearchReqVo;
import com.biz.crm.nebular.mdm.role.resp.MdmRoleRespVo;
import com.biz.crm.nebular.mdm.terminal.resp.MdmTerminalRespVo;
import com.biz.crm.role.mapper.MdmRoleMapper;
import com.biz.crm.role.mode.RoleEntity;
import com.biz.crm.role.service.IMdmRoleService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ImdmRoleServiceImpl
extends ServiceImpl<MdmRoleMapper, RoleEntity>
implements IMdmRoleService {
    private static final Logger log = LoggerFactory.getLogger(ImdmRoleServiceImpl.class);
    @Autowired
    private MdmRoleMapper mdmRoleMapper;
    @Resource
    private EngineRolePositionService engineRolePositionService;

    @Override
    public PageResult<MdmRoleRespVo> findList(MdmRoleReqVo mdmRoleReqVo) {
        Page page = new Page((long)mdmRoleReqVo.getPageNum().intValue(), (long)mdmRoleReqVo.getPageSize().intValue());
        List<MdmRoleRespVo> list = this.mdmRoleMapper.findList((Page<MdmRoleReqVo>)page, mdmRoleReqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmRoleRespVo query(MdmRoleReqVo mdmRoleReqVo) {
        return this.mdmRoleMapper.query(mdmRoleReqVo);
    }

    @Override
    public void save(MdmRoleReqVo mdmRoleReqVo) {
        if (StringUtils.isBlank((CharSequence)mdmRoleReqVo.getRoleName())) {
            throw new RuntimeException("\u89d2\u8272\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (StringUtils.isBlank((CharSequence)mdmRoleReqVo.getEnableStatus())) {
            throw new RuntimeException("\u751f\u6548\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (StringUtils.isBlank((CharSequence)mdmRoleReqVo.getRoleCode())) {
            mdmRoleReqVo.setRoleCode(CodeUtil.getCode());
        }
        mdmRoleReqVo.setId(UUID.randomUUID().toString());
        this.mdmRoleMapper.save(mdmRoleReqVo);
    }

    @Override
    public void update(MdmRoleReqVo mdmRoleReqVo) {
    }

    @Override
    public void deleteBatch(MdmRoleReqVo mdmRoleReqVo) {
        if (mdmRoleReqVo.getIds().isEmpty()) {
            throw new RuntimeException("\u8bf7\u9009\u62e9\u8981\u5220\u9664\u7684\u89d2\u8272\u4fe1\u606f\u3002");
        }
        this.mdmRoleMapper.deleteBatch(mdmRoleReqVo);
    }

    @Override
    public void enableBatch(MdmRoleReqVo mdmRoleReqVo) {
        if (mdmRoleReqVo.getIds().isEmpty()) {
            throw new RuntimeException("\u8bf7\u9009\u62e9\u8981\u542f\u7528\u7684\u89d2\u8272\u4fe1\u606f\u3002");
        }
        mdmRoleReqVo.setEnableStatus("1");
        this.mdmRoleMapper.enableOrDisableBatch(mdmRoleReqVo);
    }

    @Override
    public void disableBatch(MdmRoleReqVo mdmRoleReqVo) {
        if (mdmRoleReqVo.getIds().isEmpty()) {
            throw new RuntimeException("\u8bf7\u9009\u62e9\u8981\u7981\u7528\u7684\u89d2\u8272\u4fe1\u606f\u3002");
        }
        mdmRoleReqVo.setEnableStatus("0");
        this.mdmRoleMapper.enableOrDisableBatch(mdmRoleReqVo);
    }

    @Override
    public MdmTerminalRespVo findDetailsByFormInstanceId(String formInstanceId) {
        return null;
    }

    @Override
    public List<MdmRoleRespVo> listCondition(MdmRoleSearchReqVo mdmRoleSearchReqVo) {
        List list;
        List<Object> roleCodeList = new ArrayList();
        if (!StringUtils.isEmpty((CharSequence)mdmRoleSearchReqVo.getPositionCode()) && !CollectionUtils.isEmpty((Collection)(list = ((LambdaQueryChainWrapper)this.engineRolePositionService.lambdaQuery().eq(EngineRolePositionEntity::getPositionCode, (Object)mdmRoleSearchReqVo.getPositionCode())).list()))) {
            roleCodeList = list.stream().map(EngineRolePositionEntity::getRoleCode).collect(Collectors.toList());
        }
        if (CollectionUtils.isEmpty((Collection)(list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().like(!StringUtils.isEmpty((CharSequence)mdmRoleSearchReqVo.getRoleCode()), RoleEntity::getRoleCode, (Object)mdmRoleSearchReqVo.getRoleCode())).like(!StringUtils.isEmpty((CharSequence)mdmRoleSearchReqVo.getRoleName()), RoleEntity::getRoleName, (Object)mdmRoleSearchReqVo.getRoleName())).in(!CollectionUtils.isEmpty(roleCodeList), RoleEntity::getRoleCode, roleCodeList)).list()))) {
            return Collections.emptyList();
        }
        return CrmBeanUtil.copyList((List)list, MdmRoleRespVo.class);
    }
}

