/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.terminal.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.availablelistrule.advise.Advise;
import com.biz.crm.availablelistrule.advise.strategy.TerminalChangeAdviseTargetStrategy;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.customer.mapper.MdmCustomerTerminalMapper;
import com.biz.crm.customer.model.MdmCustomerTerminalEntity;
import com.biz.crm.customer.service.IMdmCustomerMsgService;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.SelectAllFlagEnum;
import com.biz.crm.exception.CommonException;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.humanarea.service.HumanAreaService;
import com.biz.crm.humanarea.service.IEngineOrgService;
import com.biz.crm.nebular.mdm.customer.MdmCustomerDockingRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerDockingSearchReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.humanarea.EngineOrgRespVo;
import com.biz.crm.nebular.mdm.humanarea.EngineOrgSearchReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmBaseOrgSearchReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmCustomerOrgSearchReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmTerminalOrgSearchReqVo;
import com.biz.crm.nebular.mdm.humanarea.OrgVo;
import com.biz.crm.nebular.mdm.terminal.req.MdmCusOrgTerminalReqVo;
import com.biz.crm.nebular.mdm.terminal.req.MdmTerminalContactReqVo;
import com.biz.crm.nebular.mdm.terminal.req.MdmTerminalReqVo;
import com.biz.crm.nebular.mdm.terminal.req.MdmTerminalSupplyReqVo;
import com.biz.crm.nebular.mdm.terminal.resp.MdmTerminalContactRespVo;
import com.biz.crm.nebular.mdm.terminal.resp.MdmTerminalRespVo;
import com.biz.crm.nebular.mdm.terminal.resp.MdmTerminalSupplyRespVo;
import com.biz.crm.terminal.mapper.MdmTerminalContactMapper;
import com.biz.crm.terminal.mapper.MdmTerminalMapper;
import com.biz.crm.terminal.mapper.MdmTerminalSupplyMapper;
import com.biz.crm.terminal.model.MdmTerminalContactEntity;
import com.biz.crm.terminal.model.MdmTerminalEntity;
import com.biz.crm.terminal.model.MdmTerminalSupplyEntity;
import com.biz.crm.terminal.service.IMdmTerminalContactService;
import com.biz.crm.terminal.service.IMdmTerminalService;
import com.biz.crm.terminal.service.IMdmTerminalSupplyService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.utils.DatabaseTypeUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
public class MdmTerminalServiceImpl
extends ServiceImpl<MdmTerminalMapper, MdmTerminalEntity>
implements IMdmTerminalService {
    private static final Logger log = LoggerFactory.getLogger(MdmTerminalServiceImpl.class);
    @Autowired
    private MdmTerminalMapper mdmTerminalMapper;
    @Autowired
    private IMdmTerminalContactService iMdmTerminalContactService;
    @Autowired
    private IMdmTerminalSupplyService iMdmTerminalSupplyService;
    @Autowired
    private MdmTerminalContactMapper mdmTerminalContactMapper;
    @Autowired
    private MdmTerminalSupplyMapper mdmTerminalSupplyMapper;
    @Autowired
    private HumanAreaService humanAreaService;
    @Resource
    private TerminalChangeAdviseTargetStrategy terminalChangeAdviseTargetStrategy;
    @Resource
    private Advise advise;
    @Resource
    private IMdmCustomerMsgService mdmCustomerMsgService;
    @Resource
    private IEngineOrgService engineOrgService;
    @Resource
    private MdmCustomerTerminalMapper mdmCustomerTerminalMapper;

    private void sendChangeMsg(List<String> terminalCodeList) {
        if (CollectionUtils.isEmpty(terminalCodeList)) {
            return;
        }
        this.advise.adviseTarget(this.terminalChangeAdviseTargetStrategy, terminalCodeList);
    }

    @Override
    public PageResult<MdmTerminalRespVo> findList(MdmTerminalReqVo mdmTerminalReqVo) {
        Page page = new Page((long)mdmTerminalReqVo.getPageNum().intValue(), (long)mdmTerminalReqVo.getPageSize().intValue());
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().like(!StringUtils.isEmpty((CharSequence)mdmTerminalReqVo.getTerminalCode()), (Object)"a.terminal_code", (Object)mdmTerminalReqVo.getTerminalCode())).like(!StringUtils.isEmpty((CharSequence)mdmTerminalReqVo.getTerminalName()), (Object)"a.terminal_name", (Object)mdmTerminalReqVo.getTerminalName())).like(!StringUtils.isEmpty((CharSequence)mdmTerminalReqVo.getCustomerOrgCode()), (Object)"a.customer_org_code", (Object)mdmTerminalReqVo.getCustomerOrgCode());
        if (!StringUtils.isEmpty((CharSequence)mdmTerminalReqVo.getOrgCode())) {
            List<OrgVo> orgList = this.humanAreaService.getCurrentAndSubOrgList(mdmTerminalReqVo.getOrgCode());
            wrapper.in(!CollectionUtils.isEmpty(orgList), (Object)"a.org_code", (Collection)orgList.stream().map(OrgVo::getOrgCode).collect(Collectors.toList()));
        }
        List<MdmTerminalRespVo> list = this.mdmTerminalMapper.findList((Page<MdmTerminalRespVo>)page, (QueryWrapper<MdmTerminalRespVo>)wrapper);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmTerminalRespVo query(MdmTerminalReqVo mdmTerminalReqVo) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"terminal_code", (Object)mdmTerminalReqVo.getTerminalCode());
        return (MdmTerminalRespVo)CrmBeanUtil.copy((Object)this.mdmTerminalMapper.selectOne((Wrapper)wrapper), MdmTerminalRespVo.class);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmTerminalRespVo mdmTerminalRespVo) {
        if (ObjectUtils.isEmpty((Object)mdmTerminalRespVo)) {
            return;
        }
        MdmTerminalEntity entity = (MdmTerminalEntity)((Object)CrmBeanUtil.copy((Object)mdmTerminalRespVo, MdmTerminalEntity.class));
        if (null == entity) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)entity.getTerminalCode())) {
            entity.setTerminalCode(CodeUtil.getCode());
        }
        this.save((Object)entity);
        this.updateContact(entity, mdmTerminalRespVo);
        this.sendChangeMsg(Collections.singletonList(mdmTerminalRespVo.getTerminalCode()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmTerminalReqVo mdmTerminalReqVo) {
        if (StringUtils.isEmpty((CharSequence)mdmTerminalReqVo.getId())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        MdmTerminalEntity entity = (MdmTerminalEntity)((Object)this.getById((Serializable)((Object)mdmTerminalReqVo.getId())));
        if (entity == null) {
            throw new BusinessException("\u7ec8\u7aef\u4e0d\u5b58\u5728");
        }
        this.updateById(CrmBeanUtil.copy((Object)mdmTerminalReqVo, MdmTerminalEntity.class));
        List mdmTerminalContactRespVos = mdmTerminalReqVo.getMdmTerminalContactRespVos();
        ArrayList<MdmTerminalContactReqVo> addMdmTerminalContactReqVos = new ArrayList<MdmTerminalContactReqVo>();
        ArrayList<MdmTerminalContactReqVo> updateMdmTerminalContactReqVos = new ArrayList<MdmTerminalContactReqVo>();
        for (MdmTerminalContactReqVo mdmTerminalContactReqVo : mdmTerminalContactRespVos) {
            if (StringUtils.isBlank((CharSequence)mdmTerminalContactReqVo.getId())) {
                mdmTerminalContactReqVo.setTerminalCode(mdmTerminalReqVo.getTerminalCode());
                addMdmTerminalContactReqVos.add(mdmTerminalContactReqVo);
                continue;
            }
            updateMdmTerminalContactReqVos.add(mdmTerminalContactReqVo);
        }
        this.iMdmTerminalContactService.updateBatchById(CrmBeanUtil.copyList(updateMdmTerminalContactReqVos, MdmTerminalContactEntity.class));
        this.iMdmTerminalContactService.saveBatch(CrmBeanUtil.copyList(addMdmTerminalContactReqVos, MdmTerminalContactEntity.class));
        List mdmTerminalSupplyRespVos = mdmTerminalReqVo.getMdmTerminalSupplyRespVos();
        ArrayList<MdmTerminalSupplyReqVo> addMdmTerminalSupplyReqVos = new ArrayList<MdmTerminalSupplyReqVo>();
        ArrayList<MdmTerminalSupplyReqVo> updateMdmTerminalSupplyReqVos = new ArrayList<MdmTerminalSupplyReqVo>();
        for (MdmTerminalSupplyReqVo mdmTerminalSupplyReqVo : mdmTerminalSupplyRespVos) {
            if (StringUtils.isBlank((CharSequence)mdmTerminalSupplyReqVo.getId())) {
                mdmTerminalSupplyReqVo.setTerminalCode(mdmTerminalReqVo.getTerminalCode());
                addMdmTerminalSupplyReqVos.add(mdmTerminalSupplyReqVo);
                continue;
            }
            updateMdmTerminalSupplyReqVos.add(mdmTerminalSupplyReqVo);
        }
        this.iMdmTerminalSupplyService.updateBatchById(CrmBeanUtil.copyList(updateMdmTerminalSupplyReqVos, MdmTerminalSupplyEntity.class));
        this.iMdmTerminalSupplyService.saveBatch(CrmBeanUtil.copyList(addMdmTerminalSupplyReqVos, MdmTerminalSupplyEntity.class));
        this.sendChangeMsg(Collections.singletonList(mdmTerminalReqVo.getTerminalCode()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmTerminalReqVo mdmTerminalReqVo) {
        if (StringUtils.equals((CharSequence)SelectAllFlagEnum.ALL.getCode(), (CharSequence)mdmTerminalReqVo.getSelectAllFlag())) {
            this.mdmTerminalMapper.deleteTerminalByParams(mdmTerminalReqVo);
        } else {
            AssertUtils.isNotEmpty((Collection)mdmTerminalReqVo.getIds(), (CrmExceptionType)CommonException.IDS_NULL);
            this.mdmTerminalMapper.deleteTerminalByParams(mdmTerminalReqVo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(MdmTerminalReqVo mdmTerminalReqVo) {
        if (StringUtils.equals((CharSequence)SelectAllFlagEnum.ALL.getCode(), (CharSequence)mdmTerminalReqVo.getSelectAllFlag())) {
            this.mdmTerminalMapper.updateTerminalByParams(mdmTerminalReqVo);
        } else {
            AssertUtils.isNotEmpty((Collection)mdmTerminalReqVo.getIds(), (CrmExceptionType)CommonException.IDS_NULL);
            this.mdmTerminalMapper.updateTerminalByParams(mdmTerminalReqVo);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(MdmTerminalReqVo mdmTerminalReqVo) {
        if (StringUtils.equals((CharSequence)SelectAllFlagEnum.ALL.getCode(), (CharSequence)mdmTerminalReqVo.getSelectAllFlag())) {
            this.mdmTerminalMapper.disableTerminalByParams(mdmTerminalReqVo);
        } else {
            AssertUtils.isNotEmpty((Collection)mdmTerminalReqVo.getIds(), (CrmExceptionType)CommonException.IDS_NULL);
            this.mdmTerminalMapper.disableTerminalByParams(mdmTerminalReqVo);
        }
    }

    @Override
    public MdmTerminalRespVo findDetailsByFormInstanceId(String formInstanceId) {
        if (StringUtils.isBlank((CharSequence)formInstanceId)) {
            return null;
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"a.form_instance_id", (Object)formInstanceId);
        MdmTerminalRespVo mdmTerminalRespVo = this.mdmTerminalMapper.query((QueryWrapper<MdmTerminalRespVo>)wrapper);
        if (null == mdmTerminalRespVo) {
            return null;
        }
        QueryWrapper mdmTerminalContactEntityQueryWrapper = new QueryWrapper();
        mdmTerminalContactEntityQueryWrapper.eq((Object)"terminal_id", (Object)mdmTerminalRespVo.getId());
        List mdmTerminalContactEntities = this.mdmTerminalContactMapper.selectList((Wrapper)mdmTerminalContactEntityQueryWrapper);
        QueryWrapper mdmTerminalSupplyEntityQueryWrapper = new QueryWrapper();
        mdmTerminalSupplyEntityQueryWrapper.eq((Object)"terminal_id", (Object)mdmTerminalRespVo.getId());
        List mdmTerminalSupplyEntities = this.mdmTerminalSupplyMapper.selectList((Wrapper)mdmTerminalSupplyEntityQueryWrapper);
        if (!CollectionUtils.isEmpty((Collection)mdmTerminalContactEntities)) {
            mdmTerminalRespVo.setMdmTerminalContactRespVos(CrmBeanUtil.copyList((List)mdmTerminalContactEntities, MdmTerminalContactRespVo.class));
        }
        if (!CollectionUtils.isEmpty((Collection)mdmTerminalSupplyEntities)) {
            mdmTerminalRespVo.setMdmTerminalSupplyRespVos(CrmBeanUtil.copyList((List)mdmTerminalSupplyEntities, MdmTerminalSupplyRespVo.class));
        }
        return mdmTerminalRespVo;
    }

    @Override
    public void updateCusOrgCode(MdmCusOrgTerminalReqVo mdmCusOrgTerminalReqVo) {
        if (CollectionUtils.isEmpty((Collection)mdmCusOrgTerminalReqVo.getTerminalCodeList()) || StringUtils.isEmpty((CharSequence)mdmCusOrgTerminalReqVo.getCusOrgCode())) {
            throw new BusinessException("\u5ba2\u6237\u7ec4\u7ec7\u7f16\u7801\u6216\u7ec8\u7aef\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmTerminalEntity::getTerminalCode, (Collection)mdmCusOrgTerminalReqVo.getTerminalCodeList())).set(MdmTerminalEntity::getCustomerOrgCode, (Object)mdmCusOrgTerminalReqVo.getCusOrgCode())).update();
    }

    private void updateContact(MdmTerminalEntity entity, MdmTerminalRespVo mdmTerminalRespVo) {
        List mdmTerminalSupplyRespVos;
        List mdmTerminalContactRespVos = mdmTerminalRespVo.getMdmTerminalContactRespVos();
        if (!CollectionUtils.isEmpty((Collection)mdmTerminalContactRespVos)) {
            ArrayList<MdmTerminalContactEntity> mdmTerminalContactEntities = new ArrayList<MdmTerminalContactEntity>();
            for (MdmTerminalContactRespVo mdmTerminalContactRespVo : mdmTerminalContactRespVos) {
                MdmTerminalContactEntity mdmTerminalContactEntity = (MdmTerminalContactEntity)((Object)CrmBeanUtil.copy((Object)mdmTerminalContactRespVo, MdmTerminalContactEntity.class));
                if (null == mdmTerminalContactEntity) {
                    throw new ClassCastException("\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38");
                }
                mdmTerminalContactEntity.setTerminalCode(entity.getTerminalCode());
                mdmTerminalContactEntities.add(mdmTerminalContactEntity);
            }
            if (!CollectionUtils.isEmpty(mdmTerminalContactEntities)) {
                this.iMdmTerminalContactService.saveOrUpdateBatch(mdmTerminalContactEntities);
            }
        }
        if (!CollectionUtils.isEmpty((Collection)(mdmTerminalSupplyRespVos = mdmTerminalRespVo.getMdmTerminalSupplyRespVos()))) {
            ArrayList<MdmTerminalSupplyEntity> mdmTerminalSupplyEntities = new ArrayList<MdmTerminalSupplyEntity>();
            for (MdmTerminalSupplyRespVo mdmTerminalSupplyRespVo : mdmTerminalSupplyRespVos) {
                MdmTerminalSupplyEntity mdmTerminalSupplyEntity = (MdmTerminalSupplyEntity)((Object)CrmBeanUtil.copy((Object)mdmTerminalSupplyRespVo, MdmTerminalSupplyEntity.class));
                if (null == mdmTerminalSupplyEntity) {
                    throw new ClassCastException("\u7c7b\u578b\u8f6c\u6362\u5f02\u5e38");
                }
                mdmTerminalSupplyEntity.setTerminalCode(entity.getTerminalCode());
                mdmTerminalSupplyEntities.add(mdmTerminalSupplyEntity);
            }
            if (!CollectionUtils.isEmpty(mdmTerminalSupplyEntities)) {
                this.iMdmTerminalSupplyService.saveOrUpdateBatch(mdmTerminalSupplyEntities);
            }
        }
    }

    @Override
    public List<String> findByOrgCodeList(List<String> list) {
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmTerminalEntity::getOrgCode, list)).select(new SFunction[]{MdmTerminalEntity::getTerminalCode}).last(DatabaseTypeUtil.SEGMENT_ITEM)).list().stream().map(MdmTerminalEntity::getTerminalCode).collect(Collectors.toList());
    }

    @Override
    public Map<String, String> findOrgCodeByTerminalCodeList(List<String> terminalCodeList) {
        if (CollectionUtils.isEmpty(terminalCodeList)) {
            return Collections.emptyMap();
        }
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmTerminalEntity::getTerminalCode, terminalCodeList)).select(new SFunction[]{MdmTerminalEntity::getTerminalCode, MdmTerminalEntity::getOrgCode}).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyMap();
        }
        return list.stream().collect(Collectors.toMap(MdmTerminalEntity::getTerminalCode, MdmTerminalEntity::getOrgCode));
    }

    @Override
    public List<MdmCustomerMsgRespVo> findCustomerList(MdmCustomerOrgSearchReqVo mdmCustomerOrgSearchReqVo) {
        return this.mdmCustomerMsgService.findCurrentAndSubCustomerList(mdmCustomerOrgSearchReqVo);
    }

    @Override
    public List<MdmCustomerDockingRespVo> dockingSearch(MdmCustomerDockingSearchReqVo mdmCustomerDockingSearchReqVo) {
        return this.mdmCustomerMsgService.dockingSearch(mdmCustomerDockingSearchReqVo);
    }

    @Override
    public List<MdmTerminalRespVo> findCurrentAndSubTerminalList(MdmTerminalOrgSearchReqVo mdmTerminalOrgSearchReqVo) {
        QueryWrapper wrapper;
        List<EngineOrgRespVo> engineOrgRespVos;
        MdmBaseOrgSearchReqVo.setUpVo((MdmBaseOrgSearchReqVo)mdmTerminalOrgSearchReqVo);
        List orgCodeList = mdmTerminalOrgSearchReqVo.getOrgCodeList();
        String terminalCodeOrName = mdmTerminalOrgSearchReqVo.getTerminalCodeOrName();
        if (!CollectionUtils.sizeIsEmpty((Object)orgCodeList) && !CollectionUtils.isEmpty(engineOrgRespVos = this.engineOrgService.findCurrentAndSubOrgCodeList((EngineOrgSearchReqVo)CrmBeanUtil.copy((Object)mdmTerminalOrgSearchReqVo, EngineOrgSearchReqVo.class)))) {
            orgCodeList = engineOrgRespVos.stream().map(EngineOrgRespVo::getOrgCode).collect(Collectors.toList());
        }
        ArrayList terminalCodeQueryList = new ArrayList();
        if (StringUtils.isNotEmpty((CharSequence)mdmTerminalOrgSearchReqVo.getCustomerCode())) {
            wrapper = new QueryWrapper();
            wrapper.eq((Object)"enable_status", (Object)CrmEnableStatusEnum.ENABLE.getCode());
            wrapper.eq((Object)"customer_code", (Object)mdmTerminalOrgSearchReqVo.getCustomerCode());
            List customerTerminalList = this.mdmCustomerTerminalMapper.selectList((Wrapper)wrapper);
            if (customerTerminalList == null || customerTerminalList.size() == 0) {
                return new ArrayList<MdmTerminalRespVo>();
            }
            terminalCodeQueryList.addAll(customerTerminalList.stream().map(MdmCustomerTerminalEntity::getTerminalCode).collect(Collectors.toList()));
        }
        wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().in(CollectionUtils.isNotEmpty((Collection)orgCodeList), (Object)"org_code", (Collection)orgCodeList)).in(CollectionUtils.isNotEmpty(terminalCodeQueryList), (Object)"terminal_code", terminalCodeQueryList)).eq(!StringUtils.isEmpty((CharSequence)mdmTerminalOrgSearchReqVo.getEnableStatus()), (Object)"enable_status", (Object)mdmTerminalOrgSearchReqVo.getEnableStatus())).and(!StringUtils.isEmpty((CharSequence)terminalCodeOrName), x -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)x.like((Object)"terminal_code", (Object)terminalCodeOrName)).or()).like((Object)"terminal_name", (Object)terminalCodeOrName);
        });
        return this.mdmTerminalMapper.pageCondition((Page<MdmTerminalRespVo>)new Page((long)mdmTerminalOrgSearchReqVo.getPageNum().intValue(), (long)mdmTerminalOrgSearchReqVo.getPageSize().intValue()), (QueryWrapper<MdmTerminalRespVo>)wrapper);
    }
}

