/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.availablelist.consumer;

import com.biz.crm.availablelist.service.CusAvailablelistService;
import com.biz.crm.availablelist.service.TerminalAvailablelistService;
import com.biz.crm.mq.AbstractRocketMQConsumer;
import com.biz.crm.mq.RocketMQMessageBody;
import com.biz.crm.util.JsonPropertyUtil;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.rocketmq.spring.annotation.RocketMQMessageListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Component
@RocketMQMessageListener(topic="TOPIC_GLOBAL", selectorExpression="AVAILBLELIST_DELPRODUCT", consumerGroup="AVAILBLELIST_DELPRODUCT")
public class AvailableListDelProductConsumer
extends AbstractRocketMQConsumer {
    private static final Logger log = LoggerFactory.getLogger(AvailableListDelProductConsumer.class);
    @Resource
    private CusAvailablelistService cusAvailablelistService;
    @Resource
    private TerminalAvailablelistService terminalAvailablelistService;

    protected Object handleMessage(RocketMQMessageBody message) throws InterruptedException {
        String msg = message.getMsgBody();
        if (StringUtils.isEmpty((Object)msg)) {
            return "\u6d88\u606f\u4e3a\u7a7a!";
        }
        List goodsCodes = (List)JsonPropertyUtil.toObject((String)msg, List.class);
        if (CollectionUtils.isEmpty((Collection)goodsCodes)) {
            return "\u5546\u54c1\u5217\u8868\u4e3a\u7a7a!";
        }
        this.cusAvailablelistService.delByGoodsCodes(goodsCodes);
        this.terminalAvailablelistService.delByGoodsCodes(goodsCodes);
        return "\u64cd\u4f5c\u6210\u529f";
    }
}

