/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.service.impl;

import com.alibaba.excel.util.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.common.service.BaseTreeService;
import com.biz.crm.humanarea.model.EngineOrgEntity;
import com.biz.crm.humanarea.service.IEngineOrgService;
import com.biz.crm.nebular.mdm.permission.BaseTreeReqVo;
import com.biz.crm.nebular.mdm.permission.BaseTreeRespVo;
import com.biz.crm.nebular.mdm.permission.MdmPermissionModelReqVo;
import com.biz.crm.permission.mapper.MdmPermissionMapper;
import com.biz.crm.util.StringUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class BaseTreeServiceImpl
implements BaseTreeService {
    @Resource
    private IEngineOrgService engineOrgService;
    @Resource
    private MdmPermissionMapper mdmPermissionMapper;

    @Override
    public List<BaseTreeRespVo> orgTree(BaseTreeReqVo baseTreeReqVo) {
        List list = ((LambdaQueryChainWrapper)this.engineOrgService.lambdaQuery().like(!StringUtils.isEmpty((String)baseTreeReqVo.getName()), EngineOrgEntity::getOrgName, (Object)baseTreeReqVo.getName())).select(new SFunction[]{EngineOrgEntity::getId, EngineOrgEntity::getParentId, EngineOrgEntity::getOrgCode, EngineOrgEntity::getOrgName}).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Collections.emptyList();
        }
        List<BaseTreeRespVo> collect = list.stream().map(x -> {
            BaseTreeRespVo baseTreeRespVo = new BaseTreeRespVo();
            baseTreeRespVo.setId(x.getId());
            baseTreeRespVo.setParentId(x.getParentId());
            baseTreeRespVo.setCode(x.getOrgCode());
            baseTreeRespVo.setName(x.getOrgName());
            return baseTreeRespVo;
        }).collect(Collectors.toList());
        return this.convertTree(collect);
    }

    private List<BaseTreeRespVo> convertTree(List<BaseTreeRespVo> collect) {
        LinkedList<BaseTreeRespVo> rootList = new LinkedList<BaseTreeRespVo>();
        Set set = collect.stream().map(BaseTreeRespVo::getId).collect(Collectors.toSet());
        for (BaseTreeRespVo baseTreeRespVo : collect) {
            if (StringUtils.isEmpty((String)baseTreeRespVo.getParentId()) || !set.contains(baseTreeRespVo.getParentId())) {
                rootList.add(baseTreeRespVo);
            }
            for (BaseTreeRespVo treeRespVo : collect) {
                if (!baseTreeRespVo.getId().equals(treeRespVo.getParentId())) continue;
                if (baseTreeRespVo.getChildren() == null) {
                    baseTreeRespVo.setChildren(new LinkedList());
                }
                baseTreeRespVo.getChildren().add(treeRespVo);
            }
        }
        return rootList;
    }

    @Override
    public List<BaseTreeRespVo> menuTree(BaseTreeReqVo baseTreeReqVo) {
        MdmPermissionModelReqVo mdmPermissionModelReqVo = new MdmPermissionModelReqVo();
        mdmPermissionModelReqVo.setCompetenceCode(baseTreeReqVo.getCode());
        mdmPermissionModelReqVo.setCompetenceName(baseTreeReqVo.getName());
        List<BaseTreeRespVo> list = this.mdmPermissionMapper.findMenuTree(mdmPermissionModelReqVo);
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        return this.convertTree(list);
    }
}

