/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cusorg.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.annotation.Klock;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.CrmTreeEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.cusorg.entity.CusOrgEntity;
import com.biz.crm.cusorg.mapper.CusOrgMapper;
import com.biz.crm.cusorg.service.CusOrgService;
import com.biz.crm.customer.model.MdmCustomerMsgEntity;
import com.biz.crm.customer.service.IMdmCustomerMsgService;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.mdm.cusorg.CusOrgTreeRespVo;
import com.biz.crm.nebular.mdm.cusorg.CusOrgVo;
import com.biz.crm.nebular.mdm.cusorg.EditCusOrgReqVo;
import com.biz.crm.nebular.mdm.cusorg.MdmCustomerOrgSelectRespVo;
import com.biz.crm.terminal.model.MdmTerminalEntity;
import com.biz.crm.terminal.service.IMdmTerminalService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.utils.DatabaseTypeUtil;
import com.biz.crm.utils.RuleCodeConvertUtil;
import com.biz.crm.utils.TreeUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Transactional(rollbackFor={Exception.class})
@Service
@ConditionalOnMissingBean(name={"cusOrgServiceExpandImpl"})
public class CusOrgServiceImpl
extends ServiceImpl<CusOrgMapper, CusOrgEntity>
implements CusOrgService {
    @Resource
    private CusOrgMapper cusOrgMapper;
    @Resource
    private IMdmCustomerMsgService mdmCustomerMsgService;
    @Resource
    private IMdmTerminalService mdmTerminalService;

    @Override
    public void add(CusOrgVo cusOrgVo) {
        if (org.springframework.util.StringUtils.isEmpty((Object)cusOrgVo.getCustomerOrgCode())) {
            cusOrgVo.setCustomerOrgCode(CodeUtil.createCode());
        }
        Assert.hasText((String)cusOrgVo.getCustomerOrgName(), (String)"\u5ba2\u6237\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        RuleCodeConvertUtil.convert(cusOrgVo, this);
        this.saveOrUpdate(CrmBeanUtil.copy((Object)cusOrgVo, CusOrgEntity.class));
    }

    @Override
    public CusOrgVo query(CusOrgVo cusOrgVo) {
        CusOrgEntity one = (CusOrgEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(!org.springframework.util.StringUtils.isEmpty((Object)cusOrgVo.getCustomerOrgCode()), CusOrgEntity::getCustomerOrgCode, (Object)cusOrgVo.getCustomerOrgCode())).eq(!org.springframework.util.StringUtils.isEmpty((Object)cusOrgVo.getId()), BaseIdEntity::getId, (Object)cusOrgVo.getId())).eq(!org.springframework.util.StringUtils.isEmpty((Object)cusOrgVo.getParentId()), CusOrgEntity::getParentId, (Object)cusOrgVo.getParentId())).last(DatabaseTypeUtil.SEGMENT)).one());
        return (CusOrgVo)CrmBeanUtil.copy((Object)((Object)one), CusOrgVo.class);
    }

    @Override
    @Klock
    public void edit(CusOrgVo cusOrgVo) {
        Assert.hasText((String)cusOrgVo.getId(), (String)"\u8bf7\u6307\u5b9a\u8981\u7f16\u8f91\u7684\u5ba2\u6237\u7ec4\u7ec7!");
        CusOrgEntity entity = (CusOrgEntity)((Object)this.cusOrgMapper.selectById((Serializable)((Object)cusOrgVo.getId())));
        Assert.notNull((Object)((Object)entity), (String)"\u8be5\u5ba2\u6237\u7ec4\u7ec7\u4e0d\u5b58\u5728\u6216\u88ab\u5220\u9664");
        String entityRuleCode = entity.getRuleCode();
        Assert.hasText((String)entityRuleCode, (String)"\u5f53\u524d\u5ba2\u6237\u7ec4\u7ec7ruleCode\u4e0d\u80fd\u4e3a\u7a7a");
        if (!org.springframework.util.StringUtils.isEmpty((Object)cusOrgVo.getParentId())) {
            Assert.isTrue((!cusOrgVo.getParentId().equals(cusOrgVo.getId()) ? 1 : 0) != 0, (String)"\u4e0a\u7ea7\u5ba2\u6237\u7ec4\u7ec7\u4e0d\u80fd\u4e0e\u5ba2\u6237\u7ec4\u7ec7\u76f8\u540c");
            QueryWrapper wrapper = (QueryWrapper)Wrappers.query().eq((Object)"id", (Object)cusOrgVo.getParentId());
            CusOrgEntity parent = (CusOrgEntity)((Object)this.getOne((Wrapper)wrapper, false));
            Assert.notNull((Object)((Object)parent), (String)"\u4e0a\u7ea7\u5ba2\u6237\u7ec4\u7ec7\u4e0d\u5b58\u5728");
            if (!parent.getId().equals(entity.getParentId())) {
                String ruleCode = parent.getRuleCode();
                Assert.hasText((String)ruleCode, (String)"\u4e0a\u7ea7\u5ba2\u6237\u7ec4\u7ec7ruleCode\u4e0d\u80fd\u4e3a\u7a7a");
                Assert.isTrue((!ruleCode.startsWith(entityRuleCode) ? 1 : 0) != 0, (String)"\u4e0a\u7ea7\u5ba2\u6237\u7ec4\u7ec7\u4e0d\u80fd\u662f\u5f53\u524d\u5ba2\u6237\u7ec4\u7ec7\u6216\u5f53\u524d\u5ba2\u6237\u7ec4\u7ec7\u7684\u4e0b\u7ea7\u5ba2\u6237\u7ec4\u7ec7");
                cusOrgVo.setParentId(parent.getId());
                RuleCodeConvertUtil.convert(cusOrgVo, this);
                List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().likeRight(CrmTreeEntity::getRuleCode, (Object)entityRuleCode)).ne(CrmTreeEntity::getRuleCode, (Object)entityRuleCode)).list();
                String newRuleCode = cusOrgVo.getRuleCode();
                Integer newLevelNum = cusOrgVo.getLevelNum();
                if (!CollectionUtils.isEmpty((Collection)list)) {
                    LinkedList<CusOrgEntity> subList = new LinkedList<CusOrgEntity>();
                    this.convertSubRuleCode(cusOrgVo.getId(), list, newRuleCode, newLevelNum, subList);
                    if (!CollectionUtils.isEmpty(subList)) {
                        this.updateBatchById(subList);
                    }
                }
            }
        }
        this.updateById(CrmBeanUtil.copy((Object)cusOrgVo, CusOrgEntity.class));
    }

    private void convertSubRuleCode(String id, List<CusOrgEntity> list, String newRuleCode, Integer newLevelNum, List<CusOrgEntity> result) {
        List subCusOrgList;
        if (!CollectionUtils.isEmpty(list) && !CollectionUtils.isEmpty(subCusOrgList = list.stream().filter(x -> id.equals(x.getParentId())).collect(Collectors.toList()))) {
            newLevelNum = newLevelNum + 1;
            if (!org.springframework.util.StringUtils.isEmpty((Object)newRuleCode)) {
                newRuleCode = newRuleCode + "-";
            }
            for (int i = 0; i < subCusOrgList.size(); ++i) {
                CusOrgEntity cusOrgEntity = (CusOrgEntity)((Object)subCusOrgList.get(i));
                cusOrgEntity.setLevelNum(newLevelNum);
                String ruleCode = newRuleCode + (i + 1);
                cusOrgEntity.setRuleCode(ruleCode);
                this.convertSubRuleCode(cusOrgEntity.getId(), list, ruleCode, newLevelNum, result);
                result.add(cusOrgEntity);
            }
        }
    }

    @Override
    public PageResult<CusOrgVo> list(CusOrgVo cusOrgVo) {
        QueryWrapper parentWrapper;
        CusOrgEntity one;
        String ruleCode;
        String id;
        CusOrgVo entity;
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().like(!org.springframework.util.StringUtils.isEmpty((Object)cusOrgVo.getCustomerOrgCode()), (Object)"a.customer_org_code", (Object)cusOrgVo.getCustomerOrgCode())).like(!org.springframework.util.StringUtils.isEmpty((Object)cusOrgVo.getCustomerOrgName()), (Object)"a.customer_org_name", (Object)cusOrgVo.getCustomerOrgName())).eq(!org.springframework.util.StringUtils.isEmpty((Object)cusOrgVo.getCustomerOrgLevel()), (Object)"a.customer_org_level", (Object)cusOrgVo.getCustomerOrgLevel())).eq(!org.springframework.util.StringUtils.isEmpty((Object)cusOrgVo.getCustomerOrgLevelType()), (Object)"a.customer_org_type", (Object)cusOrgVo.getCustomerOrgLevelType())).eq(!org.springframework.util.StringUtils.isEmpty((Object)cusOrgVo.getParentId()), (Object)"a.parent_id", (Object)cusOrgVo.getParentId())).eq(!org.springframework.util.StringUtils.isEmpty((Object)cusOrgVo.getEnableStatus()), (Object)"a.enable_status", (Object)cusOrgVo.getEnableStatus())).and(!StringUtils.isEmpty((String)cusOrgVo.getCodeOrgName()), i -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)i.like((Object)"a.customer_org_code", (Object)cusOrgVo.getCodeOrgName())).or()).like((Object)"a.customer_org_name", (Object)cusOrgVo.getCodeOrgName());
        });
        if (!org.springframework.util.StringUtils.isEmpty((Object)cusOrgVo.getId()) && (entity = this.findById(id = cusOrgVo.getId())) != null && !org.springframework.util.StringUtils.isEmpty((Object)(ruleCode = entity.getRuleCode()))) {
            wrapper.likeRight((Object)"a.rule_code", (Object)ruleCode);
        }
        if (!org.springframework.util.StringUtils.isEmpty((Object)cusOrgVo.getParentId()) && (one = (CusOrgEntity)((Object)this.getOne((Wrapper)(parentWrapper = (QueryWrapper)Wrappers.query().eq((Object)"id", (Object)cusOrgVo.getParentId())), false))) != null) {
            wrapper.likeRight(!org.springframework.util.StringUtils.isEmpty((Object)one.getRuleCode()), (Object)"a.rule_code", (Object)one.getRuleCode());
        }
        Page page = new Page((long)cusOrgVo.getPageNum().intValue(), (long)cusOrgVo.getPageSize().intValue());
        List<CusOrgVo> list = this.cusOrgMapper.list(page, (QueryWrapper<CusOrgVo>)wrapper);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public CusOrgVo findById(String id) {
        return (CusOrgVo)CrmBeanUtil.copy((Object)this.getById((Serializable)((Object)id)), CusOrgVo.class);
    }

    @Override
    public void ableBatch(ArrayList<String> ids, CrmEnableStatusEnum crmEnableStatusEnum) {
        CusOrgEntity current;
        Assert.notEmpty(ids, (String)"\u7981\u7528\u9700\u8981\u4f20\u5165\u5ba2\u6237\u7ec4\u7ec7id");
        Assert.isTrue((ids.size() == 1 ? 1 : 0) != 0, (String)"\u5ba2\u6237\u7ec4\u7ec7\u53ea\u80fd\u5355\u9009");
        String id = ids.get(0);
        CusOrgVo cusOrgVo = this.findById(id);
        Assert.notNull((Object)cusOrgVo, (String)"\u5ba2\u6237\u7ec4\u7ec7\u4e0d\u5b58\u5728");
        String parentId = cusOrgVo.getParentId();
        while (!org.springframework.util.StringUtils.isEmpty((Object)parentId) && (current = (CusOrgEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseIdEntity::getId, (Object)parentId)).select(new SFunction[]{CusOrgEntity::getParentId, CrmBaseEntity::getEnableStatus}).one())) != null) {
            Assert.isTrue((!CrmEnableStatusEnum.DISABLE.getCode().equals(current.getEnableStatus()) ? 1 : 0) != 0, (String)"\u4e0a\u7ea7\u5ba2\u6237\u7ec4\u7ec7\u5df2\u88ab\u7981\u7528");
            parentId = current.getParentId();
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(BaseIdEntity::getId, (Object)id)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).update();
    }

    @Override
    public void stateBatch(ArrayList<String> ids, CrmDelFlagEnum crmDelFlagEnum) {
        Assert.notEmpty(ids, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((ids.size() == 1 ? 1 : 0) != 0, (String)"\u5ba2\u6237\u7ec4\u7ec7\u53ea\u80fd\u5355\u9009");
        String id = ids.get(0);
        CusOrgVo cusOrgVo = this.findById(id);
        Assert.notNull((Object)cusOrgVo, (String)"\u5ba2\u6237\u7ec4\u7ec7\u4e0d\u5b58\u5728");
        String ruleCode = cusOrgVo.getRuleCode();
        Assert.hasText((String)ruleCode, (String)"\u5ba2\u6237\u7ec4\u7ec7\u964d\u7ef4\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().likeRight(CrmTreeEntity::getRuleCode, (Object)ruleCode)).ne(CrmTreeEntity::getRuleCode, (Object)ruleCode)).list();
        Assert.isTrue((boolean)CollectionUtils.isEmpty((Collection)list), (String)"\u5b58\u5728\u4e0b\u7ea7\u5ba2\u6237\u7ec4\u7ec7\u65e0\u6cd5\u5220\u9664");
        Integer count = ((LambdaQueryChainWrapper)this.mdmCustomerMsgService.lambdaQuery().eq(MdmCustomerMsgEntity::getCustomerOrgCode, (Object)cusOrgVo.getCustomerOrgCode())).count();
        Assert.isTrue((count == null || count <= 0 ? 1 : 0) != 0, (String)"\u5173\u8054\u5ba2\u6237\u4fe1\u606f\u65e0\u6cd5\u5220\u9664");
        Integer terminalCount = ((LambdaQueryChainWrapper)this.mdmTerminalService.lambdaQuery().eq(MdmTerminalEntity::getCustomerOrgCode, (Object)cusOrgVo.getCustomerOrgCode())).count();
        Assert.isTrue((terminalCount == null || terminalCount <= 0 ? 1 : 0) != 0, (String)"\u5173\u8054\u7ec8\u7aef\u4fe1\u606f\u65e0\u6cd5\u5220\u9664");
        this.removeById((Serializable)((Object)id));
    }

    @Override
    public CusOrgVo findDetailsByFormInstanceId(String formInstanceId) {
        CusOrgEntity parent;
        if (org.springframework.util.StringUtils.isEmpty((Object)formInstanceId)) {
            return null;
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"form_instance_id", (Object)formInstanceId);
        List cusOrgEntities = this.cusOrgMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)cusOrgEntities)) {
            return null;
        }
        CusOrgVo cusOrgVo = new CusOrgVo();
        CusOrgEntity entity = (CusOrgEntity)((Object)cusOrgEntities.get(0));
        String parentId = entity.getParentId();
        BeanUtils.copyProperties((Object)((Object)entity), (Object)cusOrgVo);
        if (!org.springframework.util.StringUtils.isEmpty((Object)parentId) && (parent = (CusOrgEntity)((Object)this.cusOrgMapper.selectById((Serializable)((Object)parentId)))) != null) {
            cusOrgVo.setParentName(parent.getCustomerOrgName());
        }
        return cusOrgVo;
    }

    @Override
    public List<CusOrgTreeRespVo> cusOrgTree(CusOrgVo cusOrgVo) {
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().like(!org.springframework.util.StringUtils.isEmpty((Object)cusOrgVo.getCustomerOrgCode()), (Object)"customer_org_code", (Object)cusOrgVo.getCustomerOrgCode())).like(!org.springframework.util.StringUtils.isEmpty((Object)cusOrgVo.getCustomerOrgName()), (Object)"customer_org_name", (Object)cusOrgVo.getCustomerOrgName())).eq(!ObjectUtils.isEmpty((Object)cusOrgVo.getCustomerOrgName()), (Object)"customer_org_level", (Object)cusOrgVo.getCustomerOrgLevel())).eq(!org.springframework.util.StringUtils.isEmpty((Object)cusOrgVo.getCustomerOrgLevelType()), (Object)"customer_org_type", (Object)cusOrgVo.getCustomerOrgLevelType())).eq(!org.springframework.util.StringUtils.isEmpty((Object)cusOrgVo.getParentId()), (Object)"parent_id", (Object)cusOrgVo.getParentId());
        List<CusOrgTreeRespVo> list = this.cusOrgMapper.findCondition((QueryWrapper<CusOrgTreeRespVo>)wrapper);
        if (CollectionUtils.isEmpty(list)) {
            return list;
        }
        return list.stream().filter(x -> org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)x.getParentId())).peek(x -> x.setChildren(this.getChildren((CusOrgTreeRespVo)x, list))).collect(Collectors.toList());
    }

    @Override
    public List<CusOrgTreeRespVo> editParentTree(EditCusOrgReqVo editCusOrgReqVo) {
        List<CusOrgTreeRespVo> cusOrgTreeRespVos;
        String code = editCusOrgReqVo.getCode();
        String ruleCode = "";
        if (!org.springframework.util.StringUtils.isEmpty((Object)code)) {
            QueryWrapper wrapper = (QueryWrapper)Wrappers.query().eq((Object)"customer_org_code", (Object)code);
            CusOrgEntity one = (CusOrgEntity)((Object)this.getOne((Wrapper)wrapper, false));
            ruleCode = Optional.ofNullable(one).map(CrmTreeEntity::getRuleCode).orElse(null);
        }
        if (!CollectionUtils.isEmpty(cusOrgTreeRespVos = this.cusOrgMapper.ruleNotLikeRight(ruleCode))) {
            return TreeUtil.convert(cusOrgTreeRespVos, "id", "parentId", "children");
        }
        return Collections.emptyList();
    }

    @Override
    public void disableBatch(ArrayList<String> ids, CrmEnableStatusEnum enable) {
        if (CollectionUtils.isEmpty(ids)) {
            throw new BusinessException("\u7981\u7528\u9700\u8981\u4f20\u5165\u5ba2\u6237\u7ec4\u7ec7id");
        }
        if (ids.size() != 1) {
            throw new BusinessException("\u5ba2\u6237\u7ec4\u7ec7\u53ea\u80fd\u5355\u9009");
        }
        String id = ids.get(0);
        CusOrgVo cusOrgVo = this.findById(id);
        if (cusOrgVo == null) {
            throw new BusinessException("\u5ba2\u6237\u7ec4\u7ec7\u4e0d\u5b58\u5728");
        }
        String ruleCode = cusOrgVo.getRuleCode();
        if (org.springframework.util.StringUtils.isEmpty((Object)ruleCode)) {
            throw new BusinessException("\u5ba2\u6237\u7ec4\u7ec7\u6811\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().likeRight(CrmTreeEntity::getRuleCode, (Object)ruleCode)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
    }

    @Override
    public List<MdmCustomerOrgSelectRespVo> customerOrgSelect(CusOrgVo cusOrgVo) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().like(!org.springframework.util.StringUtils.isEmpty((Object)cusOrgVo.getCustomerOrgName()), CusOrgEntity::getCustomerOrgName, (Object)cusOrgVo.getCustomerOrgName())).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).list();
        return CrmBeanUtil.copyList((List)list, MdmCustomerOrgSelectRespVo.class);
    }

    private List<CusOrgTreeRespVo> getChildren(CusOrgTreeRespVo root, List<CusOrgTreeRespVo> list) {
        if (!ObjectUtils.isEmpty((Object)root) && !CollectionUtils.isEmpty(list)) {
            return list.stream().filter(x -> root.getId().equals(x.getParentId())).peek(x -> x.setChildren(this.getChildren((CusOrgTreeRespVo)x, list))).collect(Collectors.toList());
        }
        return null;
    }
}

