/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.customer.manager;

import com.biz.crm.common.BaseBuilder;
import com.biz.crm.customer.manager.MdmCustomerMsgManager;
import com.biz.crm.customer.model.MdmCustomerMsgEntity;
import com.biz.crm.customer.service.IMdmCustomerMsgService;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import io.jsonwebtoken.lang.Assert;
import java.util.Collections;

public class MdmCustomerMsgBuilder
extends BaseBuilder<MdmCustomerMsgReqVo> {
    private MdmCustomerMsgEntity mdmCustomerMsgEntity;
    private boolean isSave;
    private IMdmCustomerMsgService mdmCustomerMsgService;
    private MdmCustomerMsgManager mdmCustomerMsgManager;

    private MdmCustomerMsgBuilder() {
    }

    public static MdmCustomerMsgBuilder builder(boolean isSave, IMdmCustomerMsgService mdmCustomerMsgService, MdmCustomerMsgManager mdmCustomerMsgManager) {
        MdmCustomerMsgBuilder builder = new MdmCustomerMsgBuilder();
        builder.isSave = isSave;
        builder.mdmCustomerMsgService = mdmCustomerMsgService;
        builder.mdmCustomerMsgManager = mdmCustomerMsgManager;
        return builder;
    }

    @Override
    public BaseBuilder<MdmCustomerMsgReqVo> valid() {
        Assert.hasText((String)((MdmCustomerMsgReqVo)this.t).getCustomerName(), (String)"\u5ba2\u6237\u4fe1\u606f\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)((MdmCustomerMsgReqVo)this.t).getOrgCode(), (String)"\u6240\u5c5e\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)((MdmCustomerMsgReqVo)this.t).getCustomerOrgCode(), (String)"\u5ba2\u6237\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((this.isSave || !StringUtils.isEmpty((String)((MdmCustomerMsgReqVo)this.t).getId()) ? 1 : 0) != 0, (String)"\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        return this;
    }

    @Override
    public BaseBuilder<MdmCustomerMsgReqVo> convert() {
        if (this.isSave && StringUtils.isEmpty((String)((MdmCustomerMsgReqVo)this.t).getCustomerCode())) {
            ((MdmCustomerMsgReqVo)this.t).setCustomerCode(CodeUtil.getCode());
        }
        this.mdmCustomerMsgEntity = (MdmCustomerMsgEntity)((Object)CrmBeanUtil.copy((Object)this.t, MdmCustomerMsgEntity.class));
        return this;
    }

    @Override
    public BaseBuilder<MdmCustomerMsgReqVo> after() {
        this.mdmCustomerMsgManager.updateContact((MdmCustomerMsgReqVo)this.t, this.mdmCustomerMsgEntity);
        this.mdmCustomerMsgManager.sendCustomerChangeMsg(Collections.singletonList(this.mdmCustomerMsgEntity.getCustomerCode()));
        return this;
    }

    @Override
    public BaseBuilder<MdmCustomerMsgReqVo> persistence() {
        if (this.isSave) {
            this.mdmCustomerMsgService.save((Object)this.mdmCustomerMsgEntity);
        } else {
            this.mdmCustomerMsgService.updateById((Object)this.mdmCustomerMsgEntity);
        }
        return this;
    }
}

