/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dict.service.impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.dict.entity.EngineDictItemEntity;
import com.biz.crm.dict.mapper.EngineDictItemMapper;
import com.biz.crm.dict.service.IEngineDictAttrConfService;
import com.biz.crm.dict.service.IEngineDictItemService;
import com.biz.crm.nebular.mdm.dict.req.EngineDictAttrConfReqVo;
import com.biz.crm.nebular.mdm.dict.req.EngineDictItemReqVo;
import com.biz.crm.nebular.mdm.dict.resp.EngineDictAttrConfRespVo;
import com.biz.crm.nebular.mdm.dict.resp.EngineDictItemListHeadRespVo;
import com.biz.crm.nebular.mdm.dict.resp.EngineDictItemRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"EngineDictItemServiceExpandImpl"})
public class EngineDictItemServiceImpl
extends ServiceImpl<EngineDictItemMapper, EngineDictItemEntity>
implements IEngineDictItemService {
    private static final Logger log = LoggerFactory.getLogger(EngineDictItemServiceImpl.class);
    @Resource
    private EngineDictItemMapper engineDictItemMapper;
    @Autowired
    private IEngineDictAttrConfService iEngineDictAttrConfService;

    @Override
    public PageResult<EngineDictItemRespVo> findList(EngineDictItemReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<EngineDictItemRespVo> list = this.engineDictItemMapper.findList((Page<EngineDictItemRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public EngineDictItemRespVo query(EngineDictItemReqVo reqVo) {
        EngineDictItemEntity one = (EngineDictItemEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)reqVo.getId()), BaseIdEntity::getId, (Object)reqVo.getId())).one());
        EngineDictItemRespVo respVo = (EngineDictItemRespVo)CrmBeanUtil.copy((Object)((Object)one), EngineDictItemRespVo.class);
        return respVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(EngineDictItemReqVo reqVo) {
        EngineDictItemEntity entity = (EngineDictItemEntity)((Object)CrmBeanUtil.copy((Object)reqVo, EngineDictItemEntity.class));
        entity.setDictItemStatus(true);
        if (StringUtils.isEmpty((String)reqVo.getParentId())) {
            entity.setDictLevel(1);
        } else {
            EngineDictItemEntity parent = (EngineDictItemEntity)((Object)this.getById((Serializable)((Object)reqVo.getParentId())));
            entity.setDictLevel(parent.getDictLevel() + 1);
        }
        entity.setCreateTime(new Date());
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(EngineDictItemReqVo reqVo) {
        EngineDictItemEntity entity = (EngineDictItemEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        entity.setDictDesc(reqVo.getDictDesc());
        entity.setDictEntityId(reqVo.getDictEntityId());
        entity.setDictEntityCode(reqVo.getDictEntityCode());
        entity.setDictKey(reqVo.getDictKey());
        entity.setDictSort(reqVo.getDictSort());
        entity.setDictValue(reqVo.getDictValue());
        entity.setProjectName(reqVo.getProjectName());
        entity.setParentId(reqVo.getParentId());
        entity.setExt1(reqVo.getExt1());
        entity.setExt2(reqVo.getExt2());
        entity.setExt3(reqVo.getExt3());
        entity.setExt4(reqVo.getExt4());
        entity.setExt5(reqVo.getExt5());
        entity.setExt6(reqVo.getExt6());
        entity.setExt7(reqVo.getExt7());
        entity.setExt8(reqVo.getExt8());
        entity.setExt9(reqVo.getExt9());
        entity.setExt10(reqVo.getExt10());
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(EngineDictItemReqVo reqVo) {
        List engineDictItemEntities = this.engineDictItemMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)engineDictItemEntities)) {
            engineDictItemEntities.forEach(o -> {
                o.setDictItemStatus(false);
                this.updateById(o);
            });
        }
    }

    @Override
    public List<EngineDictItemListHeadRespVo> listHead(EngineDictItemReqVo engineDictItemReqVo) {
        ArrayList<EngineDictItemListHeadRespVo> result = new ArrayList<EngineDictItemListHeadRespVo>();
        result.add(EngineDictItemListHeadRespVo.builder().fieldCode("dictKey").fieldName("\u5b57\u5178\u503c").required("1").build());
        result.add(EngineDictItemListHeadRespVo.builder().fieldCode("dictValue").fieldName("\u5b57\u5178\u7f16\u7801").required("1").build());
        result.add(EngineDictItemListHeadRespVo.builder().fieldCode("dictDesc").fieldName("\u5b57\u5178\u63cf\u8ff0").required("0").build());
        result.add(EngineDictItemListHeadRespVo.builder().fieldCode("dictSort").fieldName("\u5b57\u5178\u6392\u5e8f").required("1").build());
        EngineDictAttrConfReqVo param = EngineDictAttrConfReqVo.builder().dictEntityId(engineDictItemReqVo.getDictEntityId()).build();
        param.setPageSize(Integer.valueOf(15));
        PageResult<EngineDictAttrConfRespVo> confResult = this.iEngineDictAttrConfService.findList(param);
        confResult.getData().stream().sorted(Comparator.comparing(e -> Objects.isNull(e.getShowOrder()) ? 0 : e.getShowOrder())).forEach(e -> result.add(EngineDictItemListHeadRespVo.builder().fieldCode(e.getExtField()).fieldName(e.getFieldName()).required(e.getRequired()).build()));
        return result;
    }
}

