/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.humanarea.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.humanarea.service.IEngineUserService;
import com.biz.crm.nebular.mdm.customer.MdmCustomerDockingRespVo;
import com.biz.crm.nebular.mdm.humanarea.EngineCurrentPositionReqVo;
import com.biz.crm.nebular.mdm.humanarea.EngineParentPositionReqVo;
import com.biz.crm.nebular.mdm.humanarea.EngineUserPageReqVo;
import com.biz.crm.nebular.mdm.humanarea.EngineUserReqVo;
import com.biz.crm.nebular.mdm.humanarea.EngineUserRespVo;
import com.biz.crm.nebular.mdm.humanarea.EngineUserUpdatePasswordReqVo;
import com.biz.crm.nebular.mdm.humanarea.EngineUserViewVo;
import com.biz.crm.nebular.mdm.humanarea.MdmActivityRoleSelectReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmActivityRoleSelectRespVo;
import com.biz.crm.nebular.mdm.humanarea.MdmPositionSelectPageReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmPositionSelectPageRespVo;
import com.biz.crm.nebular.mdm.humanarea.MdmUnbindUserRelationCustomerReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmUserRelationCustomerPageReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmUserRelationCustomerPageRespVo;
import com.biz.crm.nebular.mdm.humanarea.MdmUserRelationCustomerReplaceReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmUserRelationCustomerReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmUserRelationTerminalPageReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmUserRelationTerminalPageRespVo;
import com.biz.crm.nebular.mdm.humanarea.MdmUserRelationTerminalReplaceReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmUserRelationTerminalReqVo;
import com.biz.crm.util.Result;
import com.biz.crm.util.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import javax.validation.Valid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/engineuser"})
@Api(tags={"\u7528\u6237"})
@CrmGlobalLog
public class EngineUserController {
    private static final Logger log = LoggerFactory.getLogger(EngineUserController.class);
    @Resource
    private IEngineUserService engineUserService;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/page"})
    @CrmDictMethod
    public Result<PageResult<EngineUserRespVo>> list(@RequestBody EngineUserPageReqVo engineUserPageReqVo) {
        PageResult<EngineUserRespVo> result = this.engineUserService.findList(engineUserPageReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2")
    @PostMapping(value={"/query"})
    public Result<EngineUserViewVo> query(@RequestBody EngineUserReqVo engineUserReqVo) {
        EngineUserViewVo respVo = this.engineUserService.query(engineUserReqVo);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    public Result<Object> save(@RequestBody EngineUserViewVo engineUserViewVo) {
        this.engineUserService.save(engineUserViewVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    public Result<Object> update(@RequestBody EngineUserViewVo engineUserViewVo) {
        this.engineUserService.update(engineUserViewVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664")
    @PostMapping(value={"/delete"})
    public Result<Object> delete(@RequestBody EngineUserReqVo engineUserReqVo) {
        this.engineUserService.deleteBatch(engineUserReqVo);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528")
    @PostMapping(value={"/enable"})
    public Result<Object> enable(@RequestBody EngineUserReqVo engineUserReqVo) {
        this.engineUserService.enableBatch(engineUserReqVo);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528")
    @PostMapping(value={"/disable"})
    public Result<Object> disable(@RequestBody EngineUserReqVo engineUserReqVo) {
        this.engineUserService.disableBatch(engineUserReqVo);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7528\u6237-\u5ba2\u6237\u5173\u8054\uff1a\u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/customer_page"})
    public Result<PageResult<MdmUserRelationCustomerPageRespVo>> customerPage(@Valid @RequestBody MdmUserRelationCustomerPageReqVo mdmUserRelationCustomerPageReqVo) {
        return Result.ok(this.engineUserService.customerPage(mdmUserRelationCustomerPageReqVo));
    }

    @ApiOperation(value="\u7528\u6237-\u5ba2\u6237\u5173\u8054\uff1a\u5173\u8054\u5ba2\u6237")
    @PostMapping(value={"/relation_customer"})
    public Result<Object> relationCustomer(@Valid @RequestBody MdmUserRelationCustomerReqVo mdmUserRelationCustomerReqVo) {
        this.engineUserService.relationCustomer(mdmUserRelationCustomerReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u7528\u6237-\u5ba2\u6237\u5173\u8054\uff1a\u5173\u8054\u5ba2\u6237\uff08\u66ff\u6362\u804c\u4f4d\uff09")
    @PostMapping(value={"/replace_customer"})
    public Result<Object> replaceCustomer(@Valid @RequestBody MdmUserRelationCustomerReplaceReqVo mdmUserRelationCustomerReplaceReqVo) {
        this.engineUserService.replaceCustomer(mdmUserRelationCustomerReplaceReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u7528\u6237-\u5ba2\u6237\u5173\u8054\uff1a\u67e5\u8be2\u7528\u6237\u6240\u6709\u804c\u4f4d\u7f16\u7801")
    @PostMapping(value={"/user_position_code"})
    public Result<List<String>> findAllPositionCodeByUser(@RequestBody String userAccount) {
        return Result.ok(this.engineUserService.findAllPositionCodeByUser(userAccount));
    }

    @ApiOperation(value="\u7528\u6237-\u5ba2\u6237\u5173\u8054\uff1a\u89e3\u9664\u5ba2\u6237\u5173\u8054")
    @PostMapping(value={"/unbind_customer"})
    public Result<Object> unbindRelationCustomer(@Valid @RequestBody MdmUnbindUserRelationCustomerReqVo mdmUnbindUserRelationCustomerReqVo) {
        this.engineUserService.unbindRelationCustomer(mdmUnbindUserRelationCustomerReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u7528\u6237-\u5ba2\u6237\u5173\u8054\uff1a\u66ff\u6362\u804c\u4f4d\u5217\u8868\u67e5\u8be2")
    @PostMapping(value={"/position_select"})
    public Result<PageResult<MdmPositionSelectPageRespVo>> positionSelect(@RequestBody MdmPositionSelectPageReqVo mdmPositionSelectPageReqVo) {
        return Result.ok(this.engineUserService.positionSelect(mdmPositionSelectPageReqVo));
    }

    @ApiOperation(value="\u7528\u6237-\u7ec8\u7aef\u5173\u8054\uff1a\u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/terminal_page"})
    public Result<PageResult<MdmUserRelationTerminalPageRespVo>> terminalPage(@Valid @RequestBody MdmUserRelationTerminalPageReqVo mdmUserRelationTerminalPageReqVo) {
        return Result.ok(this.engineUserService.terminalPage(mdmUserRelationTerminalPageReqVo));
    }

    @ApiOperation(value="\u7528\u6237-\u7ec8\u7aef\u5173\u8054\uff1a\u89e3\u9664\u7ec8\u7aef\u5173\u8054")
    @PostMapping(value={"/unbind_terminal"})
    public Result<Object> unbindRelationTerminal(@Valid @RequestBody MdmUnbindUserRelationCustomerReqVo mdmUnbindUserRelationCustomerReqVo) {
        this.engineUserService.unbindRelationTerminal(mdmUnbindUserRelationCustomerReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u7528\u6237-\u7ec8\u7aef\u5173\u8054\uff1a\u6dfb\u52a0\u5173\u8054")
    @PostMapping(value={"/relation_terminal"})
    public Result<Object> relationTerminal(@RequestBody MdmUserRelationTerminalReqVo mdmUserRelationTerminalReqVo) {
        this.engineUserService.relationTerminal(mdmUserRelationTerminalReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u7528\u6237-\u7ec8\u7aef\u5173\u8054\uff1a\u6dfb\u52a0\u5173\u8054\uff08\u66ff\u6362\u804c\u4f4d\uff09")
    @PostMapping(value={"/replace_terminal"})
    public Result<Object> replaceTerminal(@RequestBody MdmUserRelationTerminalReplaceReqVo mdmUserRelationTerminalReplaceReqVo) {
        this.engineUserService.replaceTerminal(mdmUserRelationTerminalReplaceReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u5ba2\u6237\u767b\u5f55")
    @PostMapping(value={"/dms_login"})
    public Result<EngineUserRespVo> customerUserLogin(@RequestBody EngineUserReqVo engineUserReqVo) {
        return Result.ok((Object)this.engineUserService.customerUserLogin(engineUserReqVo));
    }

    @ApiOperation(value="\u4fee\u6539\u5ba2\u6237\u7528\u6237\u5bc6\u7801")
    @PostMapping(value={"/update_password"})
    public Result<Object> updatePassword(@RequestBody EngineUserUpdatePasswordReqVo engineUserUpdatePasswordReqVo) {
        this.engineUserService.updatePassword(engineUserUpdatePasswordReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u91cd\u7f6e\u5ba2\u6237\u5bc6\u7801")
    @PostMapping(value={"/reset_password"})
    public Result<Object> resetPassword(@RequestParam(value="userAccount") String userAccount) {
        this.engineUserService.resetPassword(userAccount);
        return Result.ok();
    }

    @ApiOperation(value="\u67e5\u8be2\u4e0a\u7ea7\u804c\u4f4d\u5217\u8868:\u65b0\u5efa\u804c\u4f4d\u901a\u8fc7\u804c\u4f4d\u7ea7\u522b\u7f16\u7801\u5e26\u51fa\u4e0a\u7ea7\u804c\u4f4d\uff0c\u5df2\u6709\u804c\u4f4d\u901a\u8fc7\u7ec4\u7ec7\u67e5\u8be2\u4e0a\u7ea7\u804c\u4f4d")
    @PostMapping(value={"/search_parent_position"})
    public Result<List<MdmCustomerDockingRespVo>> searchParentPosition(@RequestBody EngineParentPositionReqVo engineParentPositionReqVo) {
        return null;
    }

    @ApiOperation(value="\u67e5\u8be2\u5f53\u524d\u804c\u4f4d\u5217\u8868:\u65b0\u5efa\u804c\u4f4d\u901a\u8fc7\u804c\u4f4d\u7ea7\u522b\u7f16\u7801\u5e26\u51fa\u4e0a\u7ea7\u804c\u4f4d\uff0c\u5df2\u6709\u804c\u4f4d\u901a\u8fc7\u7ec4\u7ec7\u67e5\u8be2\u5f53\u524d\u804c\u4f4d")
    @PostMapping(value={"/search_current_position"})
    public Result<List<MdmCustomerDockingRespVo>> searchParentPosition(@RequestBody EngineCurrentPositionReqVo engineCurrentPositionReqVo) {
        return null;
    }

    @ApiOperation(value="\u7528\u6237\u89e3\u9501")
    @PostMapping(value={"/unlock"})
    public Result<Object> unLockUser(@RequestParam(value="userAccount") String userAccount) {
        return null;
    }

    @ApiOperation(value="\u67e5\u8be2\u6d41\u7a0b\u89d2\u8272\u4e0b\u62c9\u5217\u8868")
    @PostMapping(value={"/findActivityRoleSelectList"})
    public Result<List<MdmActivityRoleSelectRespVo>> findActivityRoleSelectList(@RequestBody MdmActivityRoleSelectReqVo mdmActivityRoleSelectReqVo) {
        ArrayList<MdmActivityRoleSelectRespVo> exampleList = new ArrayList<MdmActivityRoleSelectRespVo>();
        MdmActivityRoleSelectRespVo respVo1 = new MdmActivityRoleSelectRespVo();
        respVo1.setRoleCode("1001");
        respVo1.setRoleName("\u6d41\u7a0b\u89d2\u82721");
        exampleList.add(respVo1);
        MdmActivityRoleSelectRespVo respVo2 = new MdmActivityRoleSelectRespVo();
        respVo2.setRoleCode("1002");
        respVo2.setRoleName("\u6d41\u7a0b\u89d2\u82722");
        exampleList.add(respVo2);
        MdmActivityRoleSelectRespVo respVo3 = new MdmActivityRoleSelectRespVo();
        respVo3.setRoleCode("1003");
        respVo3.setRoleName("\u6d41\u7a0b\u89d2\u82723");
        exampleList.add(respVo3);
        ArrayList<MdmActivityRoleSelectRespVo> list = new ArrayList<MdmActivityRoleSelectRespVo>();
        for (MdmActivityRoleSelectRespVo item : exampleList) {
            if (StringUtils.isNotEmpty((String)mdmActivityRoleSelectReqVo.getRoleCode()) && !item.getRoleCode().contains(mdmActivityRoleSelectReqVo.getRoleCode()) || StringUtils.isNotEmpty((String)mdmActivityRoleSelectReqVo.getRoleName()) && !item.getRoleName().contains(mdmActivityRoleSelectReqVo.getRoleName())) continue;
            list.add(item);
        }
        return Result.ok(list);
    }
}

