/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.humanarea.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.humanarea.mapper.HumanAreaMapper;
import com.biz.crm.humanarea.service.HumanAreaService;
import com.biz.crm.nebular.mdm.cusorgbusowner.ListVo;
import com.biz.crm.nebular.mdm.humanarea.ListByPosVo;
import com.biz.crm.nebular.mdm.humanarea.OrgReqVo;
import com.biz.crm.nebular.mdm.humanarea.OrgVo;
import com.biz.crm.util.ValidateUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Transactional(rollbackFor={RuntimeException.class})
@Service
@ConditionalOnMissingBean(name={"HumanAreaServiceExpandImpl"})
public class HumanAreaServiceImpl
implements HumanAreaService {
    private static final Logger log = LoggerFactory.getLogger(HumanAreaServiceImpl.class);
    private final HumanAreaMapper humanAreaMapper;

    @Autowired
    public HumanAreaServiceImpl(HumanAreaMapper humanAreaMapper) {
        this.humanAreaMapper = humanAreaMapper;
    }

    @Override
    public IPage<ListByPosVo> listByPos(ListByPosVo listByPosVo) {
        Page page = new Page((long)listByPosVo.getPageNum().intValue(), (long)listByPosVo.getPageSize().intValue());
        IPage<ListByPosVo> iPage = this.humanAreaMapper.listByPos(page, listByPosVo);
        return iPage;
    }

    @Override
    public IPage<ListByPosVo> listByCusOrg(ListVo listVo) {
        ValidateUtils.validate((Object)listVo.getCusOrgCode(), (String)"\u5ba2\u6237\u7ec4\u7ec7code\u4e22\u5931!");
        Page page = new Page((long)listVo.getPageNum().intValue(), (long)listVo.getPageSize().intValue());
        IPage<ListByPosVo> iPage = this.humanAreaMapper.listByCusOrg(page, listVo, CrmDelFlagEnum.NORMAL.getCode());
        return iPage;
    }

    @Override
    public List<OrgVo> findAllOrg(OrgReqVo orgReqVo) {
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().like(!StringUtils.isEmpty((CharSequence)orgReqVo.getOrgCode()), (Object)"org_code", (Object)orgReqVo.getOrgCode())).like(!StringUtils.isEmpty((CharSequence)orgReqVo.getOrgName()), (Object)"org_name", (Object)orgReqVo.getOrgName())).eq(!ObjectUtils.isEmpty((Object)orgReqVo.getOrgLevel()), (Object)"org_level", (Object)orgReqVo.getOrgLevel())).eq((Object)"is_delete", (Object)false);
        List<OrgVo> orgVoList = this.humanAreaMapper.allOrg((QueryWrapper<OrgVo>)wrapper);
        if (ObjectUtils.isEmpty(orgVoList)) {
            return Collections.emptyList();
        }
        return orgVoList.stream().filter(x -> StringUtils.isEmpty((CharSequence)x.getParentId())).peek(x -> x.setChildren(this.getChildren((OrgVo)x, orgVoList))).collect(Collectors.toList());
    }

    private List<OrgVo> getChildren(OrgVo root, List<OrgVo> list) {
        if (!ObjectUtils.isEmpty((Object)root) && !CollectionUtils.isEmpty(list)) {
            return list.stream().filter(x -> root.getId().equals(x.getParentId())).peek(x -> x.setChildren(this.getChildren((OrgVo)x, list))).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public List<OrgVo> getCurrentAndSubOrgList(String orgCode) {
        List<OrgVo> orgVoList;
        ArrayList<OrgVo> list = new ArrayList<OrgVo>();
        QueryWrapper wrapper = (QueryWrapper)Wrappers.query().eq((Object)"org_code", (Object)orgCode);
        if (wrapper.nonEmptyOfWhere() && !CollectionUtils.isEmpty(orgVoList = this.humanAreaMapper.allOrg((QueryWrapper<OrgVo>)wrapper))) {
            list.addAll(orgVoList);
            for (OrgVo orgVo : orgVoList) {
                this.getSubOrgList(orgVo.getId(), list);
            }
        }
        return list;
    }

    private void getSubOrgList(String orgId, List<OrgVo> list) {
        List<OrgVo> orgVoList;
        QueryWrapper wrapper = (QueryWrapper)Wrappers.query().eq((Object)"parent_id", (Object)orgId);
        if (!wrapper.isEmptyOfWhere() && !CollectionUtils.isEmpty(orgVoList = this.humanAreaMapper.allOrg((QueryWrapper<OrgVo>)wrapper))) {
            list.addAll(orgVoList);
            for (OrgVo orgVo : orgVoList) {
                this.getSubOrgList(orgVo.getId(), list);
            }
        }
    }

    @Override
    public List<OrgVo> getCurrentAndSubTree(String orgCode) {
        List<OrgVo> orgVoList;
        QueryWrapper wrapper = (QueryWrapper)Wrappers.query().eq((Object)"org_code", (Object)orgCode);
        if (wrapper.nonEmptyOfWhere() && !CollectionUtils.isEmpty(orgVoList = this.humanAreaMapper.allOrg((QueryWrapper<OrgVo>)wrapper))) {
            return orgVoList.stream().map(x -> x.setChildren(this.getSubOrgList((OrgVo)x))).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }

    private List<OrgVo> getSubOrgList(OrgVo orgVo) {
        List<OrgVo> orgVoList;
        QueryWrapper wrapper = (QueryWrapper)Wrappers.query().eq(!StringUtils.isEmpty((CharSequence)orgVo.getId()), (Object)"parent_id", (Object)orgVo.getId());
        if (wrapper.nonEmptyOfWhere() && !CollectionUtils.isEmpty(orgVoList = this.humanAreaMapper.allOrg((QueryWrapper<OrgVo>)wrapper))) {
            return orgVoList.stream().map(x -> x.setChildren(this.getSubOrgList((OrgVo)x))).collect(Collectors.toList());
        }
        return Collections.emptyList();
    }
}

