/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.material.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.material.model.MdmMaterialEntity;
import com.biz.crm.material.service.IMdmMaterialService;
import com.biz.crm.nebular.mdm.humanarea.MdmMaterialOrgSearchReqVo;
import com.biz.crm.nebular.mdm.material.MdmMaterialPriceRespVo;
import com.biz.crm.nebular.mdm.material.MdmMaterialReqVo;
import com.biz.crm.nebular.mdm.material.MdmMaterialRespVo;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mdmmaterial"})
@Api(tags={"\u7269\u6599\u7ba1\u7406"})
public class MdmMaterialController {
    private static final Logger log = LoggerFactory.getLogger(MdmMaterialController.class);
    private final IMdmMaterialService mdmMaterialService;

    @Autowired
    public MdmMaterialController(IMdmMaterialService mdmMaterialService) {
        this.mdmMaterialService = mdmMaterialService;
    }

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/list"})
    @CrmLog
    @CrmDictMethod
    public Result<PageResult<MdmMaterialRespVo>> list(@RequestBody MdmMaterialReqVo mdmMaterialReqVo) {
        PageResult<MdmMaterialRespVo> result = this.mdmMaterialService.findList(mdmMaterialReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2")
    @PostMapping(value={"/query"})
    @CrmLog
    @CrmDictMethod
    public Result<MdmMaterialRespVo> query(@RequestBody MdmMaterialReqVo mdmMaterialReqVo) {
        MdmMaterialRespVo model = this.mdmMaterialService.query(mdmMaterialReqVo);
        return Result.ok((Object)model);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    @CrmLog
    public Result<Object> save(@RequestBody MdmMaterialReqVo mdmMaterialReqVo) {
        this.mdmMaterialService.save(mdmMaterialReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    @CrmLog
    public Result<Object> update(@RequestBody MdmMaterialReqVo mdmMaterialReqVo) {
        this.mdmMaterialService.update(mdmMaterialReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u5220\u9664")
    @PostMapping(value={"/delete"})
    @CrmLog
    public Result<Object> delete(@RequestBody MdmMaterialReqVo mdmMaterialReqVo) {
        this.mdmMaterialService.deleteBatch(mdmMaterialReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u542f\u7528")
    @PostMapping(value={"/enable"})
    @CrmLog
    public Result<Object> enable(@RequestBody MdmMaterialReqVo mdmMaterialReqVo) {
        this.mdmMaterialService.enableBatch(mdmMaterialReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u7981\u7528")
    @PostMapping(value={"/disable"})
    @CrmLog
    public Result<Object> disable(@RequestBody MdmMaterialReqVo mdmMaterialReqVo) {
        this.mdmMaterialService.disableBatch(mdmMaterialReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u67e5\u8be2\u8868\u5355\u5b9e\u4f8b")
    @PostMapping(value={"/findDetailsByFormInstanceId"})
    @CrmLog
    public Result<MdmMaterialEntity> findDetailsByFormInstanceId(@RequestParam(value="formInstanceId", required=false) String formInstanceId) {
        MdmMaterialEntity result = this.mdmMaterialService.findDetailsByFormInstanceId(formInstanceId);
        return Result.ok((Object)((Object)result));
    }

    @ApiOperation(value="\u6d4b\u8bd5\u6570\u636e\u5b57\u5178")
    @GetMapping(value={"/test"})
    public String getMap(@RequestParam String typeCode, @RequestParam String dictCode) {
        return DictUtil.getDictDataVal((String)typeCode, (String)dictCode);
    }

    @ApiOperation(value="\u67e5\u8be2\u7269\u6599")
    @PostMapping(value={"/findCurrentAndSubMaterialList"})
    @CrmLog
    public Result<List<MdmMaterialPriceRespVo>> findCurrentAndSubMaterialList(@RequestBody MdmMaterialOrgSearchReqVo mdmMaterialOrgSearchReqVo) {
        List<MdmMaterialPriceRespVo> result = this.mdmMaterialService.findCurrentAndSubMaterialList(mdmMaterialOrgSearchReqVo);
        return Result.ok(result);
    }
}

