/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.product.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.availablelist.service.CusAvailablelistService;
import com.biz.crm.availablelist.service.TerminalAvailablelistService;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.FileTypeEnum;
import com.biz.crm.eunm.IsShelfEnum;
import com.biz.crm.eunm.SelectAllFlagEnum;
import com.biz.crm.exception.CommonException;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.nebular.mdm.product.req.MdmProductMediaReqVo;
import com.biz.crm.nebular.mdm.product.req.MdmProductReqVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductAdviseRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductIntroductionRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductMaterialRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductMediaRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductSaleCompanyRespVo;
import com.biz.crm.product.mapper.MdmProductMapper;
import com.biz.crm.product.model.MdmProductEntity;
import com.biz.crm.product.service.IMdmProductMediaService;
import com.biz.crm.product.service.IMdmProductService;
import com.biz.crm.product.service.impl.MdmProductBuilder;
import com.biz.crm.product.service.impl.MdmProductServiceHelper;
import com.biz.crm.productlevel.service.IMdmProductLevelService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import com.bizunited.platform.common.util.JsonUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"mdmProductServiceExpandImpl"})
public class MdmProductServiceImpl
extends ServiceImpl<MdmProductMapper, MdmProductEntity>
implements IMdmProductService {
    private static final Logger log = LoggerFactory.getLogger(MdmProductServiceImpl.class);
    @Resource
    private MdmProductMapper mdmProductMapper;
    @Autowired
    private MdmProductServiceHelper productServiceHelper;
    @Autowired
    private IMdmProductMediaService mdmProductMediaService;
    @Autowired
    private IMdmProductLevelService iMdmProductLevelService;
    @Resource
    private CusAvailablelistService cusAvailablelistService;
    @Resource
    private TerminalAvailablelistService terminalAvailablelistService;

    @Override
    public PageResult<MdmProductRespVo> findList(MdmProductReqVo mdmProductReqVo) {
        List<String> list;
        Page page = new Page((long)mdmProductReqVo.getPageNum().intValue(), (long)mdmProductReqVo.getPageSize().intValue());
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().like(!StringUtils.isEmpty((CharSequence)mdmProductReqVo.getProductCode()), (Object)"a.product_code", (Object)mdmProductReqVo.getProductCode())).eq(!StringUtils.isEmpty((CharSequence)mdmProductReqVo.getFormInstanceId()), (Object)"a.form_instance_id", (Object)mdmProductReqVo.getFormInstanceId())).eq(!StringUtils.isEmpty((CharSequence)mdmProductReqVo.getId()), (Object)"a.id", (Object)mdmProductReqVo.getId())).like(!StringUtils.isEmpty((CharSequence)mdmProductReqVo.getProductName()), (Object)"a.product_name", (Object)mdmProductReqVo.getProductName())).eq(!StringUtils.isEmpty((CharSequence)mdmProductReqVo.getEnableStatus()), (Object)"a.enable_status", (Object)mdmProductReqVo.getEnableStatus());
        if (!StringUtils.isEmpty((CharSequence)mdmProductReqVo.getProductLevelCode()) && !CollectionUtils.isEmpty(list = this.iMdmProductLevelService.getCurrentAndSubLevelCode(mdmProductReqVo.getProductLevelCode()))) {
            wrapper.in((Object)"a.product_level_code", list);
        }
        list = this.mdmProductMapper.findList((Page<MdmProductRespVo>)page, (QueryWrapper<MdmProductRespVo>)wrapper);
        this.productServiceHelper.convertListDate(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmProductRespVo query(MdmProductReqVo mdmProductReqVo) {
        PageResult<MdmProductRespVo> page = this.findList(mdmProductReqVo);
        List list = page.getData();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new MdmProductRespVo();
        }
        MdmProductRespVo mdmProductRespVo = (MdmProductRespVo)list.get(0);
        List<MdmProductMaterialRespVo> materialRespVos = this.productServiceHelper.findMaterialByProductCode(mdmProductRespVo.getProductCode());
        mdmProductRespVo.setMaterialList(materialRespVos);
        List<MdmProductMediaRespVo> medias = this.mdmProductMediaService.list(new MdmProductMediaReqVo().setProductCode(mdmProductRespVo.getProductCode()));
        if (CollectionUtils.isNotEmpty(medias)) {
            Map<String, List<MdmProductMediaRespVo>> mediaMap = medias.stream().collect(Collectors.groupingBy(MdmProductMediaRespVo::getType));
            List<MdmProductMediaRespVo> pictureList = mediaMap.get(FileTypeEnum.PICTURE.getCode());
            mdmProductRespVo.setPictureList(pictureList);
            mdmProductRespVo.setVideoList(mediaMap.get(FileTypeEnum.VIDEO.getCode()));
        }
        MdmProductIntroductionRespVo introduction = this.productServiceHelper.findIntroductionByProductCode(mdmProductRespVo.getProductCode());
        mdmProductRespVo.setIntroductionVo(introduction);
        return mdmProductRespVo;
    }

    @Override
    public List<MdmProductAdviseRespVo> adviseQuery(List<String> productCodeList) {
        if (CollectionUtils.isEmpty(productCodeList)) {
            return Collections.emptyList();
        }
        ArrayList<MdmProductAdviseRespVo> list = new ArrayList<MdmProductAdviseRespVo>(productCodeList.size());
        for (String productCode : productCodeList) {
            MdmProductRespVo mdmProductRespVo = this.query(new MdmProductReqVo().setProductCode(productCode));
            MdmProductAdviseRespVo mdmProductAdviseRespVo = (MdmProductAdviseRespVo)CrmBeanUtil.copy((Object)mdmProductRespVo, MdmProductAdviseRespVo.class);
            mdmProductAdviseRespVo.setMaterialList(JsonUtils.obj2JsonString((Object)mdmProductRespVo.getMaterialList()));
            mdmProductAdviseRespVo.setPictureList(JsonUtils.obj2JsonString((Object)mdmProductRespVo.getPictureList()));
            mdmProductAdviseRespVo.setVideoList(JsonUtils.obj2JsonString((Object)mdmProductRespVo.getVideoList()));
            mdmProductAdviseRespVo.setIntroductionVo(JsonUtils.obj2JsonString((Object)mdmProductRespVo.getIntroductionVo()));
            list.add(mdmProductAdviseRespVo);
        }
        return list;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmProductReqVo mdmProductReqVo) {
        if (StringUtils.isEmpty((CharSequence)mdmProductReqVo.getProductCode())) {
            mdmProductReqVo.setProductCode(CodeUtil.getCode());
        }
        MdmProductBuilder.builder(this.productServiceHelper, mdmProductReqVo).init().check().convert().save();
        this.sendChangeMsg(Collections.singletonList(mdmProductReqVo.getProductCode()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmProductReqVo mdmProductReqVo) {
        if (StringUtils.isEmpty((CharSequence)mdmProductReqVo.getId())) {
            throw new BusinessException("\u6570\u636e\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        }
        MdmProductBuilder.builder(this.productServiceHelper, mdmProductReqVo).init().check().convert().update();
        this.sendChangeMsg(Collections.singletonList(mdmProductReqVo.getProductCode()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmProductReqVo mdmProductReqVo) {
        List ids = mdmProductReqVo.getIds();
        if (!CollectionUtils.isEmpty((Collection)ids)) {
            List list = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, (Collection)ids)).select(new SFunction[]{MdmProductEntity::getProductCode}).list();
            Assert.notEmpty((Collection)list, (String)"\u5546\u54c1\u4e0d\u5b58\u5728");
            this.removeByIds(ids);
            this.sendDelMsg(list.stream().map(MdmProductEntity::getProductCode).collect(Collectors.toList()));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(MdmProductReqVo mdmProductReqVo) {
        if (StringUtils.equals((CharSequence)SelectAllFlagEnum.ALL.getCode(), (CharSequence)mdmProductReqVo.getSelectAllFlag())) {
            MdmProductEntity productEntity = new MdmProductEntity();
            productEntity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            this.productServiceHelper.updateBySelectAll(mdmProductReqVo, productEntity);
        } else {
            AssertUtils.isNotEmpty((Collection)mdmProductReqVo.getIds(), (CrmExceptionType)CommonException.IDS_NULL);
            List mdmProductEntities = this.mdmProductMapper.selectBatchIds(mdmProductReqVo.getIds());
            if (CollectionUtils.isNotEmpty((Collection)mdmProductEntities)) {
                mdmProductEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
            }
            this.updateBatchById(mdmProductEntities);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(MdmProductReqVo mdmProductReqVo) {
        if (StringUtils.equals((CharSequence)SelectAllFlagEnum.ALL.getCode(), (CharSequence)mdmProductReqVo.getSelectAllFlag())) {
            MdmProductEntity productEntity = new MdmProductEntity();
            productEntity.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            this.productServiceHelper.updateBySelectAll(mdmProductReqVo, productEntity);
        } else {
            AssertUtils.isNotEmpty((Collection)mdmProductReqVo.getIds(), (CrmExceptionType)CommonException.IDS_NULL);
            List mdmProductEntities = this.mdmProductMapper.selectBatchIds(mdmProductReqVo.getIds());
            if (CollectionUtils.isNotEmpty((Collection)mdmProductEntities)) {
                mdmProductEntities.forEach(o -> {
                    o.setIsShelf(IsShelfEnum.DOWN.getCode());
                    o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
                });
            }
            this.updateBatchById(mdmProductEntities);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void upShelf(MdmProductReqVo mdmProductReqVo) {
        if (StringUtils.equals((CharSequence)SelectAllFlagEnum.ALL.getCode(), (CharSequence)mdmProductReqVo.getSelectAllFlag())) {
            MdmProductEntity productEntity = new MdmProductEntity();
            productEntity.setEnableStatus(IsShelfEnum.UP.getCode());
            this.productServiceHelper.updateBySelectAll(mdmProductReqVo, productEntity);
        } else {
            AssertUtils.isNotEmpty((Collection)mdmProductReqVo.getIds(), (CrmExceptionType)CommonException.IDS_NULL);
            List mdmProductEntities = this.mdmProductMapper.selectBatchIds(mdmProductReqVo.getIds());
            if (CollectionUtils.isNotEmpty((Collection)mdmProductEntities)) {
                mdmProductEntities.forEach(o -> o.setIsShelf(IsShelfEnum.UP.getCode()));
            }
            this.updateBatchById(mdmProductEntities);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void downShelf(MdmProductReqVo mdmProductReqVo) {
        if (StringUtils.equals((CharSequence)SelectAllFlagEnum.ALL.getCode(), (CharSequence)mdmProductReqVo.getSelectAllFlag())) {
            MdmProductEntity productEntity = new MdmProductEntity();
            productEntity.setEnableStatus(IsShelfEnum.DOWN.getCode());
            this.productServiceHelper.updateBySelectAll(mdmProductReqVo, productEntity);
        } else {
            AssertUtils.isNotEmpty((Collection)mdmProductReqVo.getIds(), (CrmExceptionType)CommonException.IDS_NULL);
            List mdmProductEntities = this.mdmProductMapper.selectBatchIds(mdmProductReqVo.getIds());
            if (CollectionUtils.isNotEmpty((Collection)mdmProductEntities)) {
                mdmProductEntities.forEach(o -> o.setIsShelf(IsShelfEnum.DOWN.getCode()));
            }
            this.updateBatchById(mdmProductEntities);
        }
    }

    @Override
    public void sendChangeMsg(List<String> productCodeList) {
        if (CollectionUtils.isEmpty(productCodeList)) {
            return;
        }
        this.cusAvailablelistService.updateByGoodsCodes(this.adviseQuery(productCodeList));
        this.terminalAvailablelistService.updateByGoodsCodes(this.adviseQuery(productCodeList));
    }

    @Override
    public void sendDelMsg(List<String> productCodeList) {
        this.cusAvailablelistService.delByGoodsCodes(productCodeList);
        this.terminalAvailablelistService.delByGoodsCodes(productCodeList);
    }

    @Override
    public Map<String, List<MdmProductSaleCompanyRespVo>> findSaleCompanyByProductCodeList(List<String> productCodeList) {
        log.info("\u5546\u54c1\u7ba1\u7406\uff1a\u6839\u636e\u5546\u54c1\u7f16\u7801\u96c6\u5408\u67e5\u8be2\u7269\u6599\u9500\u552e\u516c\u53f8,\u5165\u53c2:{}", productCodeList);
        if (CollectionUtils.isEmpty(productCodeList)) {
            return Collections.emptyMap();
        }
        List<MdmProductSaleCompanyRespVo> companyList = this.mdmProductMapper.findSaleCompanyByProductCodeList(productCodeList);
        log.info("\u5546\u54c1\u7ba1\u7406\uff1a\u6839\u636e\u5546\u54c1\u7f16\u7801\u96c6\u5408\u67e5\u8be2\u7269\u6599\u9500\u552e\u516c\u53f8,\u7ed3\u679c:{}", companyList);
        if (CollectionUtils.isEmpty(companyList)) {
            return productCodeList.stream().distinct().collect(Collectors.toMap(Function.identity(), x -> Collections.emptyList()));
        }
        Map map = DictUtil.getDictValueMapsByCodes((String)"sale_company");
        log.info("\u5546\u54c1\u7ba1\u7406\uff1a\u6839\u636e\u5546\u54c1\u7f16\u7801\u96c6\u5408\u67e5\u8be2\u7269\u6599\u9500\u552e\u516c\u53f8,\u5b57\u5178:{}", (Object)map);
        return companyList.stream().peek(x -> {
            String saleCompanyCode = x.getSaleCompanyCode();
            if (!StringUtils.isEmpty((CharSequence)saleCompanyCode) && map != null) {
                x.setSaleCompanyName((String)map.get(saleCompanyCode));
            }
        }).collect(Collectors.groupingBy(MdmProductSaleCompanyRespVo::getProductCode));
    }
}

