/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.productlevel.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmTreeEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.mdm.productlevel.req.MdmProductLevelReqVo;
import com.biz.crm.nebular.mdm.productlevel.req.MdmProductLevelTreeReqVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelRespVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelTreeRespVo;
import com.biz.crm.productlevel.mapper.MdmProductLevelMapper;
import com.biz.crm.productlevel.model.MdmProductLevelEntity;
import com.biz.crm.productlevel.service.IMdmProductLevelService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.utils.RuleCodeConvertUtil;
import com.biz.crm.utils.TreeUtil;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class MdmProductLevelServiceImpl
extends ServiceImpl<MdmProductLevelMapper, MdmProductLevelEntity>
implements IMdmProductLevelService {
    private static final Logger log = LoggerFactory.getLogger(MdmProductLevelServiceImpl.class);
    @Autowired
    private MdmProductLevelMapper mdmProductLevelMapper;

    @Override
    public PageResult<MdmProductLevelRespVo> findList(MdmProductLevelReqVo mdmProductLevelReqVo) {
        Page page = new Page((long)mdmProductLevelReqVo.getPageNum().intValue(), (long)mdmProductLevelReqVo.getPageSize().intValue());
        List<MdmProductLevelRespVo> list = this.mdmProductLevelMapper.findList((Page<MdmProductLevelRespVo>)page, mdmProductLevelReqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmProductLevelEntity query(String code) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)code)) {
            throw new IllegalArgumentException("\u4ea7\u54c1\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"product_level_code", (Object)code);
        MdmProductLevelEntity mdmProductLevelEntity = (MdmProductLevelEntity)((Object)this.mdmProductLevelMapper.selectOne((Wrapper)wrapper));
        if (null == mdmProductLevelEntity) {
            return null;
        }
        return mdmProductLevelEntity;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmProductLevelReqVo mdmProductLevelReqVo) {
        if (ObjectUtils.isEmpty((Object)mdmProductLevelReqVo)) {
            return;
        }
        RuleCodeConvertUtil.convert(mdmProductLevelReqVo, this);
        MdmProductLevelEntity entity = (MdmProductLevelEntity)((Object)CrmBeanUtil.copy((Object)mdmProductLevelReqVo, MdmProductLevelEntity.class));
        if (ObjectUtils.isEmpty((Object)((Object)entity))) {
            return;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)entity.getRemarks()) && entity.getRemarks().length() > 200) {
            throw new IllegalArgumentException("\u5907\u6ce8\u4e0d\u80fd\u8d85\u8fc7200");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)entity.getProductLevelCode())) {
            entity.setProductLevelCode(CodeUtil.getCode());
        }
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmProductLevelReqVo mdmProductLevelReqVo) {
        List<MdmProductLevelEntity> mdmProductLevelEntities;
        if (null == mdmProductLevelReqVo) {
            throw new BusinessException("\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)mdmProductLevelReqVo.getId())) {
            throw new BusinessException("\u4e3b\u952eID\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if (!org.apache.commons.lang3.StringUtils.isBlank((CharSequence)mdmProductLevelReqVo.getParentId())) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"id", (Object)mdmProductLevelReqVo.getParentId());
            MdmProductLevelEntity one = (MdmProductLevelEntity)((Object)this.mdmProductLevelMapper.selectOne((Wrapper)wrapper));
            if (null == one) {
                throw new BusinessException("\u4e0a\u7ea7\u4ea7\u54c1\u5c42\u7ea7\u4e0d\u5b58\u5728");
            }
        }
        if ((mdmProductLevelEntities = this.findParentIdByProductLevel(mdmProductLevelReqVo.getId())).isEmpty()) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"id", (Object)mdmProductLevelReqVo.getId());
            MdmProductLevelEntity mdmProductLevelEntity = (MdmProductLevelEntity)((Object)this.mdmProductLevelMapper.selectOne((Wrapper)wrapper));
            if (mdmProductLevelEntity.getParentId().equals(mdmProductLevelReqVo.getParentId())) {
                this.updateById(CrmBeanUtil.copy((Object)mdmProductLevelReqVo, MdmProductLevelEntity.class));
            } else {
                RuleCodeConvertUtil.convert(mdmProductLevelReqVo, this);
                this.updateById(CrmBeanUtil.copy((Object)mdmProductLevelReqVo, MdmProductLevelEntity.class));
            }
        } else {
            RuleCodeConvertUtil.convert(mdmProductLevelReqVo, this);
            this.updateById(CrmBeanUtil.copy((Object)mdmProductLevelReqVo, MdmProductLevelEntity.class));
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmProductLevelReqVo mdmProductLevelReqVo) {
        List ids = mdmProductLevelReqVo.getIds();
        if (null == ids && ids.isEmpty()) {
            throw new BusinessException("\u5220\u9664\u4e3b\u952eID\u4e0d\u80fd\u4e3a\u7a7a\u3002");
        }
        if (ids.size() > 1) {
            throw new BusinessException("\u4ea7\u54c1\u5c42\u7ea7\u4e0d\u8fd0\u884c\u591a\u9009\u3002");
        }
        List<MdmProductLevelEntity> mdmProductLevelEntities = this.findParentIdByProductLevel((String)ids.get(0));
        if (mdmProductLevelEntities != null && !mdmProductLevelEntities.isEmpty()) {
            throw new BusinessException("\u5f53\u524d\u4ea7\u54c1\u5c42\u7ea7\u5305\u542b\u5b50\u5c42\u7ea7\uff0c\u65e0\u6cd5\u5220\u9664\uff0c\u82e5\u9700\u8981\u5220\u9664\u8bf7\u5148\u5220\u9664\u5b50\u5c42\u7ea7\u3002");
        }
        int count = this.mdmProductLevelMapper.findMaterialByProductLevel((String)ids.get(0));
        if (count > 0) {
            throw new BusinessException("\u5f53\u524d\u4ea7\u54c1\u5c42\u7ea7\u5df2\u5173\u8054\u7269\u6599\uff0c\u65e0\u6cd5\u5220\u9664\uff0c\u82e5\u9700\u8981\u5220\u9664\u8bf7\u5148\u5220\u9664\u5173\u8054\u7269\u6599\u3002");
        }
        this.mdmProductLevelMapper.deleteProductLevelByParams(mdmProductLevelReqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(MdmProductLevelReqVo mdmProductLevelReqVo) {
        List mdmProductLevelEntities = this.mdmProductLevelMapper.selectBatchIds(mdmProductLevelReqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmProductLevelEntities)) {
            mdmProductLevelEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(mdmProductLevelEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(MdmProductLevelReqVo mdmProductLevelReqVo) {
        List mdmProductLevelEntities = this.mdmProductLevelMapper.selectBatchIds(mdmProductLevelReqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmProductLevelEntities)) {
            mdmProductLevelEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(mdmProductLevelEntities);
    }

    @Override
    public MdmProductLevelEntity findDetailsByFormInstanceId(String formInstanceId) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)formInstanceId)) {
            return null;
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"form_instance_id", (Object)formInstanceId);
        MdmProductLevelEntity mdmProductLevelEntity = (MdmProductLevelEntity)((Object)this.mdmProductLevelMapper.selectOne((Wrapper)wrapper));
        if (null == mdmProductLevelEntity) {
            return null;
        }
        return mdmProductLevelEntity;
    }

    @Override
    public List<MdmProductLevelTreeRespVo> tree(MdmProductLevelTreeReqVo mdmProductLevelTreeReqVo) {
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq(!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)mdmProductLevelTreeReqVo.getId()), (Object)"id", (Object)mdmProductLevelTreeReqVo.getId())).like(!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)mdmProductLevelTreeReqVo.getProductLevelCode()), (Object)"product_level_code", (Object)mdmProductLevelTreeReqVo.getProductLevelCode())).eq(!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)mdmProductLevelTreeReqVo.getParentId()), (Object)"parent_id", (Object)mdmProductLevelTreeReqVo.getParentId())).eq(!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)mdmProductLevelTreeReqVo.getProductLevelType()), (Object)"product_level_type", (Object)mdmProductLevelTreeReqVo.getProductLevelType())).eq(!ObjectUtils.isEmpty((Object)mdmProductLevelTreeReqVo.getLevelNum()), (Object)"level_num", (Object)mdmProductLevelTreeReqVo.getLevelNum());
        List<MdmProductLevelTreeRespVo> list = this.mdmProductLevelMapper.findCondition((QueryWrapper<MdmProductLevelTreeRespVo>)wrapper);
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        return list.stream().filter(x -> org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)x.getParentId())).peek(x -> x.setChildren(this.getChildren((MdmProductLevelTreeRespVo)x, list))).collect(Collectors.toList());
    }

    private List<MdmProductLevelTreeRespVo> getChildren(MdmProductLevelTreeRespVo root, List<MdmProductLevelTreeRespVo> list) {
        if (!ObjectUtils.isEmpty((Object)root) && !org.springframework.util.CollectionUtils.isEmpty(list)) {
            return list.stream().filter(x -> root.getId().equals(x.getParentId())).peek(x -> x.setChildren(this.getChildren((MdmProductLevelTreeRespVo)x, list))).collect(Collectors.toList());
        }
        return null;
    }

    private List<MdmProductLevelEntity> findParentIdByProductLevel(String parentId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"parent_id", (Object)parentId);
        return this.mdmProductLevelMapper.selectList((Wrapper)wrapper);
    }

    @Override
    public List<String> getCurrentAndSubLevelCode(String productLevelCode) {
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)productLevelCode)) {
            return Collections.emptyList();
        }
        MdmProductLevelEntity one = (MdmProductLevelEntity)((Object)this.getOne((Wrapper)Wrappers.lambdaQuery().eq(MdmProductLevelEntity::getProductLevelCode, (Object)productLevelCode), false));
        return Optional.ofNullable(one).map(MdmProductLevelEntity::getRuleCode).filter(x -> !org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)productLevelCode)).map(x -> ((LambdaQueryChainWrapper)this.lambdaQuery().likeRight(MdmProductLevelEntity::getRuleCode, x)).select(new SFunction[]{MdmProductLevelEntity::getProductLevelCode}).list()).map(x -> x.stream().map(MdmProductLevelEntity::getProductLevelCode).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    @Override
    public List<MdmProductLevelTreeRespVo> editTree(MdmProductLevelTreeReqVo mdmProductLevelTreeReqVo) {
        List<MdmProductLevelTreeRespVo> mdmProductLevelTreeRespVos;
        String code = mdmProductLevelTreeReqVo.getProductLevelCode();
        String ruleCode = "";
        if (!StringUtils.isEmpty((Object)code)) {
            QueryWrapper wrapper = (QueryWrapper)Wrappers.query().eq((Object)"product_level_code", (Object)code);
            MdmProductLevelEntity one = (MdmProductLevelEntity)((Object)this.getOne((Wrapper)wrapper, false));
            ruleCode = Optional.ofNullable(one).map(CrmTreeEntity::getRuleCode).orElse(null);
        }
        if (!CollectionUtils.isEmpty(mdmProductLevelTreeRespVos = this.mdmProductLevelMapper.ruleNotLikeRight(ruleCode))) {
            return TreeUtil.convert(mdmProductLevelTreeRespVos, "id", "parentId", "children");
        }
        return Collections.emptyList();
    }
}

