/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.region.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.mdm.region.EngineAdministrativeRegionReqVo;
import com.biz.crm.nebular.mdm.region.EngineAdministrativeRegionRespVo;
import com.biz.crm.nebular.mdm.region.EngineRegionSelectRespVo;
import com.biz.crm.region.mapper.EngineAdministrativeRegionMapper;
import com.biz.crm.region.model.EngineAdministrativeRegionEntity;
import com.biz.crm.region.service.IEngineAdministrativeRegionService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserRedis;
import com.biz.crm.util.UserUtils;
import com.biz.crm.utils.DatabaseTypeUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"EngineAdministrativeRegionServiceExpandImpl"})
public class EngineAdministrativeRegionServiceImpl
extends ServiceImpl<EngineAdministrativeRegionMapper, EngineAdministrativeRegionEntity>
implements IEngineAdministrativeRegionService {
    private static final Logger log = LoggerFactory.getLogger(EngineAdministrativeRegionServiceImpl.class);
    @Autowired
    private EngineAdministrativeRegionMapper engineAdministrativeRegionMapper;

    @Override
    public PageResult<EngineAdministrativeRegionRespVo> findList(EngineAdministrativeRegionReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<EngineAdministrativeRegionRespVo> pageResult = this.engineAdministrativeRegionMapper.pageResult((Page<EngineAdministrativeRegionEntity>)page, reqVo);
        return PageResult.builder().data(pageResult).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public EngineAdministrativeRegionRespVo query(EngineAdministrativeRegionReqVo reqVo) {
        EngineAdministrativeRegionEntity one = (EngineAdministrativeRegionEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(!StringUtils.isEmpty((String)reqVo.getRegionName()), EngineAdministrativeRegionEntity::getRegionName, (Object)reqVo.getRegionName())).eq(!StringUtils.isEmpty((String)reqVo.getRegionCode()), EngineAdministrativeRegionEntity::getRegionCode, (Object)reqVo.getRegionCode())).last(DatabaseTypeUtil.SEGMENT)).one());
        return (EngineAdministrativeRegionRespVo)CrmBeanUtil.copy((Object)((Object)one), EngineAdministrativeRegionRespVo.class);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(EngineAdministrativeRegionReqVo reqVo) {
        String regionCode = reqVo.getRegionCode();
        Assert.hasText((String)regionCode, (String)"\u533a\u57df\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)regionCode.matches("^[A-Za-z0-9]+$"), (String)"\u533a\u57df\u7f16\u7801\u8bf7\u8f93\u5165\u5b57\u6bcd\u548c\u6570\u5b57\u7ec4\u5408");
        String latitude = reqVo.getLatitude();
        String longitude = reqVo.getLongitude();
        Assert.hasText((String)latitude, (String)"\u7eac\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)latitude.matches("^[0-9]+(.[0-9]{2})?$"), (String)"\u8bf7\u8f93\u5165\u6570\u5b57\uff0c\u4fdd\u7559\u4e24\u4f4d\u5c0f\u6570");
        Assert.hasText((String)longitude, (String)"\u7ecf\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)longitude.matches("^[0-9]+(.[0-9]{2})?$"), (String)"\u8bf7\u8f93\u5165\u6570\u5b57\uff0c\u4fdd\u7559\u4e24\u4f4d\u5c0f\u6570");
        String email = reqVo.getEmail();
        if (!StringUtils.isEmpty((String)email)) {
            Assert.isTrue((boolean)email.matches("^\\d{6}$"), (String)"\u90ae\u7f16\u4ec5\u652f\u6301\u6570\u5b57");
        }
        String regionName = reqVo.getRegionName();
        EngineAdministrativeRegionEntity one = (EngineAdministrativeRegionEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(EngineAdministrativeRegionEntity::getRegionCode, (Object)regionCode)).last(DatabaseTypeUtil.SEGMENT)).select(new SFunction[]{BaseIdEntity::getId}).one());
        Assert.isNull((Object)((Object)one), (String)"\u5f53\u524d\u533a\u57df\u7f16\u7801\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        Assert.hasText((String)regionName, (String)"\u533a\u57df\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        UserRedis user = UserUtils.getUser();
        if (user != null) {
            reqVo.setCreateName(user.getUsername());
        }
        EngineAdministrativeRegionEntity entity = (EngineAdministrativeRegionEntity)((Object)CrmBeanUtil.copy((Object)reqVo, EngineAdministrativeRegionEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(EngineAdministrativeRegionReqVo reqVo) {
        EngineAdministrativeRegionEntity entity = (EngineAdministrativeRegionEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(EngineAdministrativeRegionReqVo reqVo) {
        List ids = reqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, (Collection)ids)).remove();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(EngineAdministrativeRegionReqVo reqVo) {
        List ids = reqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, (Collection)ids)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).update();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(EngineAdministrativeRegionReqVo reqVo) {
        List ids = reqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, (Collection)ids)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
    }

    @Override
    public List<EngineAdministrativeRegionRespVo> listCondition(EngineAdministrativeRegionReqVo regionReqVo) {
        return this.engineAdministrativeRegionMapper.listCondition(regionReqVo);
    }

    public List<EngineAdministrativeRegionRespVo> findRegion(EngineAdministrativeRegionReqVo engineAdministrativeRegionReqVo) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)engineAdministrativeRegionReqVo.getParentId())) {
            QueryWrapper wrapper = new QueryWrapper();
            wrapper.eq((Object)"region_level", (Object)1);
            return CrmBeanUtil.copyList((List)this.engineAdministrativeRegionMapper.selectList((Wrapper)wrapper), EngineAdministrativeRegionRespVo.class);
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"parent_id", (Object)engineAdministrativeRegionReqVo.getParentId());
        return CrmBeanUtil.copyList((List)this.engineAdministrativeRegionMapper.selectList((Wrapper)wrapper), EngineAdministrativeRegionRespVo.class);
    }

    @Override
    public List<EngineRegionSelectRespVo> regionSelect(EngineAdministrativeRegionReqVo regionReqVo) {
        return this.engineAdministrativeRegionMapper.listSelect(regionReqVo);
    }
}

