/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.availablelistrule.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.availablelistrule.entity.AvailableListRuleAreaEntity;
import com.biz.crm.availablelistrule.entity.AvailableListRuleEntity;
import com.biz.crm.availablelistrule.mapper.AvailableListRuleAreaMapper;
import com.biz.crm.availablelistrule.service.AvailableListRuleAreaService;
import com.biz.crm.availablelistrule.utils.AvailableListRuleAreaUtil;
import com.biz.crm.nebular.mdm.availablelistrule.AvailableListRuleAreaVo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@ConditionalOnMissingBean(name={"availableListRuleServiceAreaExpand"})
@Service(value="availableListRuleAreaService")
public class AvailableListRuleAreaServiceImpl
extends ServiceImpl<AvailableListRuleAreaMapper, AvailableListRuleAreaEntity>
implements AvailableListRuleAreaService {
    @Autowired
    private AvailableListRuleAreaMapper availableListRuleAreaMapper;

    @Override
    @Transactional
    public void replace(List<AvailableListRuleAreaVo> vos, final AvailableListRuleEntity ruleEntity) {
        this.removeByMap(new HashMap<String, Object>(){
            {
                this.put("rule_code", ruleEntity.getRuleCode());
            }
        });
        if (CollectionUtils.isEmpty(vos)) {
            return;
        }
        this.saveBatch(AvailableListRuleAreaUtil.packageEntities(vos, ruleEntity));
    }

    @Override
    public List<AvailableListRuleAreaVo> findByRuleCode(String ruleCode) {
        if (StringUtils.isEmpty((Object)ruleCode)) {
            return new ArrayList<AvailableListRuleAreaVo>();
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"rule_code", (Object)ruleCode);
        List goodsEntities = this.availableListRuleAreaMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)goodsEntities)) {
            return new ArrayList<AvailableListRuleAreaVo>();
        }
        ArrayList<AvailableListRuleAreaVo> reList = new ArrayList<AvailableListRuleAreaVo>(goodsEntities.size());
        for (AvailableListRuleAreaEntity entity : goodsEntities) {
            AvailableListRuleAreaVo vo = new AvailableListRuleAreaVo();
            BeanUtils.copyProperties((Object)((Object)entity), (Object)vo);
            reList.add(vo);
        }
        return reList;
    }

    @Override
    public List<AvailableListRuleAreaVo> findByRuleCodes(List<String> ruleCodes) {
        if (CollectionUtils.isEmpty(ruleCodes)) {
            return null;
        }
        return this.availableListRuleAreaMapper.findByRuleCodes(ruleCodes);
    }
}

