/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.cusorg.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.annotation.Klock;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.CrmTreeEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.cusorg.entity.CusOrgEntity;
import com.biz.crm.cusorg.mapper.CusOrgMapper;
import com.biz.crm.cusorg.service.CusOrgService;
import com.biz.crm.customer.model.MdmCustomerMsgEntity;
import com.biz.crm.customer.service.IMdmCustomerMsgService;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.mdm.cusorg.CusOrgTreeRespVo;
import com.biz.crm.nebular.mdm.cusorg.CusOrgVo;
import com.biz.crm.nebular.mdm.cusorg.EditCusOrgReqVo;
import com.biz.crm.nebular.mdm.cusorg.MdmCustomerOrgConditionReqVo;
import com.biz.crm.nebular.mdm.cusorg.MdmCustomerOrgSelectRespVo;
import com.biz.crm.nebular.mdm.permission.BaseTreeReqVo;
import com.biz.crm.nebular.mdm.permission.BaseTreeRespVo;
import com.biz.crm.terminal.model.MdmTerminalEntity;
import com.biz.crm.terminal.service.IMdmTerminalService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.utils.DatabaseTypeUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Transactional(rollbackFor={Exception.class})
@Service
@ConditionalOnMissingBean(name={"cusOrgServiceExpandImpl"})
public class CusOrgServiceImpl
extends ServiceImpl<CusOrgMapper, CusOrgEntity>
implements CusOrgService {
    @Resource
    private CusOrgMapper cusOrgMapper;
    @Resource
    private IMdmCustomerMsgService mdmCustomerMsgService;
    @Resource
    private IMdmTerminalService mdmTerminalService;

    @Override
    @Klock(leaseTime=1L, keys={"customer_org"})
    public void add(CusOrgVo cusOrgVo) {
        if (StringUtils.isEmpty((Object)cusOrgVo.getCustomerOrgCode())) {
            cusOrgVo.setCustomerOrgCode(CodeUtil.createCode());
        } else {
            CusOrgEntity one = (CusOrgEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CusOrgEntity::getCustomerOrgCode, (Object)cusOrgVo.getCustomerOrgCode())).select(new SFunction[]{BaseIdEntity::getId}).one());
            Assert.isNull((Object)((Object)one), (String)"\u5ba2\u6237\u7ec4\u7ec7\u7f16\u7801\u5df2\u5b58\u5728");
        }
        Assert.hasText((String)cusOrgVo.getCustomerOrgName(), (String)"\u5ba2\u6237\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        CusOrgEntity name = (CusOrgEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CusOrgEntity::getCustomerOrgName, (Object)cusOrgVo.getCustomerOrgName())).select(new SFunction[]{BaseIdEntity::getId}).one());
        Assert.isNull((Object)((Object)name), (String)"\u5ba2\u6237\u7ec4\u7ec7\u540d\u79f0\u5df2\u5b58\u5728");
        CusOrgEntity entity = (CusOrgEntity)((Object)CrmBeanUtil.copy((Object)cusOrgVo, CusOrgEntity.class));
        entity.setRuleCode(this.getLastRuleCode(entity));
        this.save((Object)entity);
    }

    @Override
    public CusOrgVo query(CusOrgVo cusOrgVo) {
        CusOrgEntity one = (CusOrgEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(!StringUtils.isEmpty((Object)cusOrgVo.getCustomerOrgCode()), CusOrgEntity::getCustomerOrgCode, (Object)cusOrgVo.getCustomerOrgCode())).eq(!StringUtils.isEmpty((Object)cusOrgVo.getId()), BaseIdEntity::getId, (Object)cusOrgVo.getId())).eq(!StringUtils.isEmpty((Object)cusOrgVo.getParentId()), CusOrgEntity::getParentId, (Object)cusOrgVo.getParentId())).eq(!StringUtils.isEmpty((Object)cusOrgVo.getFormInstanceId()), CrmBaseEntity::getFormInstanceId, (Object)cusOrgVo.getFormInstanceId())).last(DatabaseTypeUtil.SEGMENT)).one());
        return (CusOrgVo)CrmBeanUtil.copy((Object)((Object)one), CusOrgVo.class);
    }

    @Override
    @Klock(leaseTime=1L, keys={"customer_org"})
    public void edit(CusOrgVo cusOrgVo) {
        String id = cusOrgVo.getId();
        Assert.hasText((String)id, (String)"\u8bf7\u6307\u5b9a\u8981\u7f16\u8f91\u7684\u5ba2\u6237\u7ec4\u7ec7!");
        CusOrgEntity entity = (CusOrgEntity)((Object)this.cusOrgMapper.selectById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)entity), (String)"\u8be5\u5ba2\u6237\u7ec4\u7ec7\u4e0d\u5b58\u5728\u6216\u88ab\u5220\u9664");
        CusOrgEntity one = (CusOrgEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CusOrgEntity::getCustomerOrgCode, (Object)cusOrgVo.getCustomerOrgCode())).ne(BaseIdEntity::getId, (Object)id)).select(new SFunction[]{BaseIdEntity::getId}).one());
        Assert.isNull((Object)((Object)one), (String)"\u5ba2\u6237\u7ec4\u7ec7\u7f16\u7801\u5df2\u5b58\u5728");
        CusOrgEntity name = (CusOrgEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CusOrgEntity::getCustomerOrgName, (Object)cusOrgVo.getCustomerOrgName())).ne(BaseIdEntity::getId, (Object)id)).select(new SFunction[]{BaseIdEntity::getId}).one());
        Assert.isNull((Object)((Object)name), (String)"\u5ba2\u6237\u7ec4\u7ec7\u540d\u79f0\u5df2\u5b58\u5728");
        String entityRuleCode = entity.getRuleCode();
        Assert.hasText((String)entityRuleCode, (String)"\u5f53\u524d\u5ba2\u6237\u7ec4\u7ec7ruleCode\u4e0d\u80fd\u4e3a\u7a7a");
        if (!StringUtils.isEmpty((Object)cusOrgVo.getParentId())) {
            Assert.isTrue((!cusOrgVo.getParentId().equals(cusOrgVo.getId()) ? 1 : 0) != 0, (String)"\u4e0a\u7ea7\u5ba2\u6237\u7ec4\u7ec7\u4e0d\u80fd\u4e0e\u5ba2\u6237\u7ec4\u7ec7\u76f8\u540c");
            QueryWrapper wrapper = (QueryWrapper)Wrappers.query().eq((Object)"id", (Object)cusOrgVo.getParentId());
            CusOrgEntity parent = (CusOrgEntity)((Object)this.getOne((Wrapper)wrapper, false));
            Assert.notNull((Object)((Object)parent), (String)"\u4e0a\u7ea7\u5ba2\u6237\u7ec4\u7ec7\u4e0d\u5b58\u5728");
            if (!parent.getId().equals(entity.getParentId())) {
                String ruleCode = parent.getRuleCode();
                Assert.hasText((String)ruleCode, (String)"\u4e0a\u7ea7\u5ba2\u6237\u7ec4\u7ec7ruleCode\u4e0d\u80fd\u4e3a\u7a7a");
                Assert.isTrue((!ruleCode.startsWith(entityRuleCode) ? 1 : 0) != 0, (String)"\u4e0a\u7ea7\u5ba2\u6237\u7ec4\u7ec7\u4e0d\u80fd\u662f\u5f53\u524d\u5ba2\u6237\u7ec4\u7ec7\u6216\u5f53\u524d\u5ba2\u6237\u7ec4\u7ec7\u7684\u4e0b\u7ea7\u5ba2\u6237\u7ec4\u7ec7");
            }
        }
        this.updateById(CrmBeanUtil.copy((Object)cusOrgVo, CusOrgEntity.class));
        this.setUpRuleCode();
    }

    @Override
    public PageResult<CusOrgVo> list(CusOrgVo cusOrgVo) {
        Page page = PageUtil.buildPage((Integer)cusOrgVo.getPageNum(), (Integer)cusOrgVo.getPageSize());
        if (!StringUtils.isEmpty((Object)cusOrgVo.getCode())) {
            String ruleCode = this.getRuleCode(cusOrgVo.getCode());
            cusOrgVo.setRuleCode(ruleCode);
        }
        List<CusOrgVo> list = this.cusOrgMapper.list(page, cusOrgVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public CusOrgVo findById(String id) {
        return (CusOrgVo)CrmBeanUtil.copy((Object)this.getById((Serializable)((Object)id)), CusOrgVo.class);
    }

    @Override
    public void ableBatch(ArrayList<String> ids, CrmEnableStatusEnum crmEnableStatusEnum) {
        Assert.notEmpty(ids, (String)"\u7981\u7528\u9700\u8981\u4f20\u5165\u5ba2\u6237\u7ec4\u7ec7id");
        Assert.isTrue((ids.size() == 1 ? 1 : 0) != 0, (String)"\u5ba2\u6237\u7ec4\u7ec7\u53ea\u80fd\u5355\u9009");
        String id = ids.get(0);
        CusOrgVo cusOrgVo = this.findById(id);
        Assert.notNull((Object)cusOrgVo, (String)"\u5ba2\u6237\u7ec4\u7ec7\u4e0d\u5b58\u5728");
        String ruleCode = cusOrgVo.getRuleCode();
        Assert.hasText((String)ruleCode, (String)"\u5ba2\u6237\u7ec4\u7ec7ruleCode\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)CrmEnableStatusEnum.DISABLE.getCode().equals(cusOrgVo.getEnableStatus()), (String)"\u53ea\u6709\u88ab\u7981\u7528\u7684\u5ba2\u6237\u7ec4\u7ec7\uff0c\u624d\u80fd\u542f\u7528");
        List<String> split = CusOrgServiceImpl.split(ruleCode, 3);
        if (!CollectionUtils.isEmpty(split) && split.size() != 1) {
            split.remove(ruleCode);
            MdmCustomerOrgConditionReqVo mdmCustomerOrgConditionReqVo = new MdmCustomerOrgConditionReqVo();
            mdmCustomerOrgConditionReqVo.setRuleCodeList(split);
            mdmCustomerOrgConditionReqVo.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            List<CusOrgVo> cusOrgVos = this.listCondition(mdmCustomerOrgConditionReqVo);
            Assert.isTrue((boolean)CollectionUtils.isEmpty(cusOrgVos), (String)"\u5b58\u5728\u4e0a\u7ea7\u5ba2\u6237\u7ec4\u7ec7\u88ab\u7981\u7528");
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(BaseIdEntity::getId, (Object)id)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).update();
    }

    @Override
    @Klock(leaseTime=1L, keys={"customer_org"})
    public void stateBatch(ArrayList<String> ids, CrmDelFlagEnum crmDelFlagEnum) {
        Assert.notEmpty(ids, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((ids.size() == 1 ? 1 : 0) != 0, (String)"\u5ba2\u6237\u7ec4\u7ec7\u53ea\u80fd\u5355\u9009");
        String id = ids.get(0);
        CusOrgVo cusOrgVo = this.findById(id);
        Assert.notNull((Object)cusOrgVo, (String)"\u5ba2\u6237\u7ec4\u7ec7\u4e0d\u5b58\u5728");
        String ruleCode = cusOrgVo.getRuleCode();
        Assert.hasText((String)ruleCode, (String)"\u5ba2\u6237\u7ec4\u7ec7\u964d\u7ef4\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().likeRight(CrmTreeEntity::getRuleCode, (Object)ruleCode)).ne(CrmTreeEntity::getRuleCode, (Object)ruleCode)).list();
        Assert.isTrue((boolean)CollectionUtils.isEmpty((Collection)list), (String)"\u5b58\u5728\u4e0b\u7ea7\u5ba2\u6237\u7ec4\u7ec7\u65e0\u6cd5\u5220\u9664");
        Integer count = ((LambdaQueryChainWrapper)this.mdmCustomerMsgService.lambdaQuery().eq(MdmCustomerMsgEntity::getCustomerOrgCode, (Object)cusOrgVo.getCustomerOrgCode())).count();
        Assert.isTrue((count == null || count <= 0 ? 1 : 0) != 0, (String)"\u5173\u8054\u5ba2\u6237\u4fe1\u606f\u65e0\u6cd5\u5220\u9664");
        Integer terminalCount = ((LambdaQueryChainWrapper)this.mdmTerminalService.lambdaQuery().eq(MdmTerminalEntity::getCustomerOrgCode, (Object)cusOrgVo.getCustomerOrgCode())).count();
        Assert.isTrue((terminalCount == null || terminalCount <= 0 ? 1 : 0) != 0, (String)"\u5173\u8054\u7ec8\u7aef\u4fe1\u606f\u65e0\u6cd5\u5220\u9664");
        this.removeById((Serializable)((Object)id));
        this.setUpRuleCode();
    }

    @Override
    public CusOrgVo findDetailsByFormInstanceId(String formInstanceId) {
        CusOrgEntity parent;
        if (StringUtils.isEmpty((Object)formInstanceId)) {
            return null;
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"form_instance_id", (Object)formInstanceId);
        List cusOrgEntities = this.cusOrgMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)cusOrgEntities)) {
            return null;
        }
        CusOrgVo cusOrgVo = new CusOrgVo();
        CusOrgEntity entity = (CusOrgEntity)((Object)cusOrgEntities.get(0));
        String parentId = entity.getParentId();
        BeanUtils.copyProperties((Object)((Object)entity), (Object)cusOrgVo);
        if (!StringUtils.isEmpty((Object)parentId) && (parent = (CusOrgEntity)((Object)this.cusOrgMapper.selectById((Serializable)((Object)parentId)))) != null) {
            cusOrgVo.setParentName(parent.getCustomerOrgName());
        }
        return cusOrgVo;
    }

    @Override
    public List<CusOrgTreeRespVo> cusOrgTree(CusOrgVo cusOrgVo) {
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().like(!StringUtils.isEmpty((Object)cusOrgVo.getCustomerOrgCode()), (Object)"customer_org_code", (Object)cusOrgVo.getCustomerOrgCode())).like(!StringUtils.isEmpty((Object)cusOrgVo.getCustomerOrgName()), (Object)"customer_org_name", (Object)cusOrgVo.getCustomerOrgName())).eq(!ObjectUtils.isEmpty((Object)cusOrgVo.getCustomerOrgName()), (Object)"customer_org_level", (Object)cusOrgVo.getCustomerOrgLevel())).eq(!StringUtils.isEmpty((Object)cusOrgVo.getCustomerOrgType()), (Object)"customer_org_type", (Object)cusOrgVo.getCustomerOrgType())).eq(!StringUtils.isEmpty((Object)cusOrgVo.getParentId()), (Object)"parent_id", (Object)cusOrgVo.getParentId());
        List<CusOrgTreeRespVo> list = this.cusOrgMapper.findCondition((QueryWrapper<CusOrgTreeRespVo>)wrapper);
        if (CollectionUtils.isEmpty(list)) {
            return list;
        }
        return list.stream().filter(x -> org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)x.getParentId())).peek(x -> x.setChildren(this.getChildren((CusOrgTreeRespVo)x, list))).collect(Collectors.toList());
    }

    @Override
    public List<CusOrgTreeRespVo> editParentTree(EditCusOrgReqVo editCusOrgReqVo) {
        CusOrgVo cusOrgVo = new CusOrgVo();
        cusOrgVo.setCustomerOrgCode(editCusOrgReqVo.getCode());
        List<CusOrgVo> unSubList = this.findUnSubList(cusOrgVo);
        return CrmBeanUtil.copyList(unSubList, CusOrgTreeRespVo.class);
    }

    @Override
    public void disableBatch(ArrayList<String> ids, CrmEnableStatusEnum enable) {
        Assert.notEmpty(ids, (String)"id\u96c6\u5408\u5fc5\u4f20");
        Assert.isTrue((ids.size() == 1 ? 1 : 0) != 0, (String)"\u5ba2\u6237\u7ec4\u7ec7\u53ea\u80fd\u5355\u9009");
        String id = ids.get(0);
        CusOrgVo cusOrgVo = this.findById(id);
        if (cusOrgVo == null) {
            throw new BusinessException("\u5ba2\u6237\u7ec4\u7ec7\u4e0d\u5b58\u5728");
        }
        String ruleCode = cusOrgVo.getRuleCode();
        Assert.hasText((String)ruleCode, (String)"\u5ba2\u6237\u7ec4\u7ec7\u6811\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((boolean)CrmEnableStatusEnum.ENABLE.getCode().equals(cusOrgVo.getEnableStatus()), (String)"\u53ea\u6709\u88ab\u542f\u7528\u7684\u5ba2\u6237\u7ec4\u7ec7\uff0c\u624d\u80fd\u7981\u7528");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().likeRight(CrmTreeEntity::getRuleCode, (Object)ruleCode)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
    }

    @Override
    public List<MdmCustomerOrgSelectRespVo> customerOrgSelect(CusOrgVo cusOrgVo) {
        String currentCustomerOrgCode = cusOrgVo.getCurrentCustomerOrgCode();
        if (!StringUtils.isEmpty((Object)currentCustomerOrgCode)) {
            cusOrgVo.setCustomerOrgCode(currentCustomerOrgCode);
            return CrmBeanUtil.copyList(this.findUnSubList(cusOrgVo), MdmCustomerOrgSelectRespVo.class);
        }
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().like(!StringUtils.isEmpty((Object)cusOrgVo.getCustomerOrgName()), CusOrgEntity::getCustomerOrgName, (Object)cusOrgVo.getCustomerOrgName())).eq(!StringUtils.isEmpty((Object)cusOrgVo.getCustomerOrgLevel()), CusOrgEntity::getCustomerOrgLevel, (Object)cusOrgVo.getCustomerOrgLevel())).select(new SFunction[]{BaseIdEntity::getId, CusOrgEntity::getCustomerOrgCode, CusOrgEntity::getCustomerOrgName}).list();
        return CrmBeanUtil.copyList((List)list, MdmCustomerOrgSelectRespVo.class);
    }

    private List<CusOrgTreeRespVo> getChildren(CusOrgTreeRespVo root, List<CusOrgTreeRespVo> list) {
        if (!ObjectUtils.isEmpty((Object)root) && !CollectionUtils.isEmpty(list)) {
            return list.stream().filter(x -> root.getId().equals(x.getParentId())).peek(x -> x.setChildren(this.getChildren((CusOrgTreeRespVo)x, list))).collect(Collectors.toList());
        }
        return null;
    }

    @Override
    public List<BaseTreeRespVo> findBaseTreeConditionList(BaseTreeReqVo baseTreeReqVo) {
        return this.cusOrgMapper.findBaseTreeConditionList(baseTreeReqVo);
    }

    @Override
    public void setUpRuleCode() {
        List list = this.lambdaQuery().select(new SFunction[]{BaseIdEntity::getId, CusOrgEntity::getParentId, CrmBaseEntity::getEnableStatus}).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        this.updateBatchById(list.stream().peek(x -> x.setRuleCode(UUID.randomUUID().toString())).collect(Collectors.toList()));
        Set set = list.stream().map(BaseIdEntity::getId).collect(Collectors.toSet());
        List rootIdList = list.stream().filter(x -> StringUtils.isEmpty((Object)x.getParentId()) || !set.contains(x.getParentId())).map(BaseIdEntity::getId).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(rootIdList)) {
            return;
        }
        int i = 1;
        for (CusOrgEntity cusOrgEntity : list) {
            if (!rootIdList.contains(cusOrgEntity.getId())) continue;
            Assert.isTrue((i < 10000 ? 1 : 0) != 0, (String)"\u6bcf\u5c42\u7ec4\u7ec7\u4ec5\u652f\u6301\u6700\u5927\u6570\u91cf999");
            cusOrgEntity.setRuleCode(String.format("%03d", i++));
            this.setUpRuleCode(cusOrgEntity, list);
        }
        this.updateBatchById(list);
    }

    private String getLastRuleCode(CusOrgEntity entity) {
        String parentId = entity.getParentId();
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(CusOrgEntity::getParentId, (Object)parentId)).select(new SFunction[]{CrmTreeEntity::getRuleCode}).list();
        String ruleCode = "";
        if (!StringUtils.isEmpty((Object)parentId)) {
            CusOrgEntity parent = (CusOrgEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseIdEntity::getId, (Object)parentId)).select(new SFunction[]{BaseIdEntity::getId, CrmTreeEntity::getRuleCode}).one());
            Assert.notNull((Object)((Object)parent), (String)"\u4e0a\u7ea7\u5ba2\u6237\u7ec4\u7ec7\u4e0d\u5b58\u5728");
            ruleCode = parent.getRuleCode();
            if (StringUtils.isEmpty((Object)ruleCode)) {
                this.setUpRuleCode();
                parent = (CusOrgEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(BaseIdEntity::getId, (Object)parentId)).select(new SFunction[]{BaseIdEntity::getId, CrmTreeEntity::getRuleCode}).one());
                ruleCode = parent.getRuleCode();
            }
        }
        if (CollectionUtils.isEmpty((Collection)list)) {
            return ruleCode + "001";
        }
        if (list.stream().anyMatch(x -> StringUtils.isEmpty((Object)x.getRuleCode()))) {
            this.setUpRuleCode();
        }
        CusOrgEntity max = Collections.max(list, Comparator.comparing(CrmTreeEntity::getRuleCode));
        ruleCode = max.getRuleCode();
        String suffix = ruleCode.substring(ruleCode.length() - 3);
        String prefix = ruleCode.substring(0, ruleCode.length() - 3);
        int num = Integer.parseInt(suffix);
        Assert.isTrue((++num < 1000 ? 1 : 0) != 0, (String)"\u6bcf\u5c42\u5ba2\u6237\u7ec4\u7ec7\u6700\u5927\u652f\u6301\u5c0f\u4e8e1000");
        return prefix + String.format("%03d", num);
    }

    private void setUpRuleCode(CusOrgEntity cusOrgEntity, List<CusOrgEntity> list) {
        int i = 1;
        for (CusOrgEntity orgEntity : list) {
            if (!cusOrgEntity.getId().equals(orgEntity.getParentId())) continue;
            Assert.isTrue((i < 10000 ? 1 : 0) != 0, (String)"\u6bcf\u5c42\u7ec4\u7ec7\u4ec5\u652f\u6301\u6700\u5927\u6570\u91cf999");
            orgEntity.setRuleCode(cusOrgEntity.getRuleCode() + String.format("%03d", i++));
            this.setUpRuleCode(orgEntity, list);
        }
    }

    public static List<String> split(String text, int size) {
        ArrayList<String> ret = new ArrayList<String>((text.length() + size - 1) / size);
        for (int start = 0; start < text.length(); start += size) {
            ret.add(text.substring(0, Math.min(text.length(), start + size)));
        }
        return ret;
    }

    @Override
    public List<CusOrgVo> findUnSubList(CusOrgVo cusOrgVo) {
        String customerOrgCode = cusOrgVo.getCustomerOrgCode();
        if (StringUtils.isEmpty((Object)customerOrgCode)) {
            return Collections.emptyList();
        }
        String ruleCode = this.getRuleCode(customerOrgCode);
        Assert.hasText((String)ruleCode, (String)"ruleCode\u4e0d\u80fd\u4e3a\u7a7a");
        cusOrgVo.setRuleCode(ruleCode);
        return this.cusOrgMapper.ruleNotLikeRight(cusOrgVo);
    }

    @Override
    public List<CusOrgVo> findAllParentList(String customerOrgCode) {
        if (StringUtils.isEmpty((Object)customerOrgCode)) {
            return Collections.emptyList();
        }
        String ruleCode = this.getRuleCode(customerOrgCode);
        Assert.hasText((String)ruleCode, (String)"ruleCode\u4e0d\u80fd\u4e3a\u7a7a");
        List<String> split = CusOrgServiceImpl.split(ruleCode, 3);
        return this.listCondition(new MdmCustomerOrgConditionReqVo().setRuleCodeList(split));
    }

    private String getRuleCode(String customerOrgCode) {
        if (StringUtils.isEmpty((Object)customerOrgCode)) {
            return customerOrgCode;
        }
        CusOrgEntity one = (CusOrgEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CusOrgEntity::getCustomerOrgCode, (Object)customerOrgCode)).select(new SFunction[]{CrmTreeEntity::getRuleCode}).one());
        Assert.notNull((Object)((Object)one), (String)("\u5ba2\u6237\u7ec4\u7ec7[" + customerOrgCode + "]\u4e0d\u5b58\u5728"));
        String ruleCode = one.getRuleCode();
        if (StringUtils.isEmpty((Object)ruleCode)) {
            this.setUpRuleCode();
            one = (CusOrgEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CusOrgEntity::getCustomerOrgCode, (Object)customerOrgCode)).select(new SFunction[]{CrmTreeEntity::getRuleCode}).one());
            ruleCode = one.getRuleCode();
        }
        return ruleCode;
    }

    @Override
    public List<CusOrgVo> listCondition(MdmCustomerOrgConditionReqVo mdmCustomerOrgConditionReqVo) {
        return this.cusOrgMapper.listCondition(mdmCustomerOrgConditionReqVo);
    }
}

