/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.customer.manager;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.availablelistrule.advise.Advise;
import com.biz.crm.availablelistrule.advise.strategy.CustomerChangeAdviseTargetStrategy;
import com.biz.crm.customer.mapper.MdmCustomerMsgMapper;
import com.biz.crm.customer.model.MdmCustomerContactEntity;
import com.biz.crm.customer.model.MdmCustomerDockingEntity;
import com.biz.crm.customer.model.MdmCustomerMsgEntity;
import com.biz.crm.customer.service.IMdmCustomerContactService;
import com.biz.crm.customer.service.IMdmCustomerDockingService;
import com.biz.crm.nebular.mdm.customer.MdmCustomerDockingRespVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerDockingSearchReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.humanarea.EngineOrgRespVo;
import com.biz.crm.nebular.mdm.humanarea.EngineOrgSearchReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmBaseOrgSearchReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmCustomerOrgSearchReqVo;
import com.biz.crm.org.service.impl.IEngineOrgService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Component;

@Component
public class MdmCustomerMsgManager {
    private static final Logger log = LoggerFactory.getLogger(MdmCustomerMsgManager.class);
    @Resource
    private IMdmCustomerContactService mdmCustomerContactService;
    @Resource
    private IMdmCustomerDockingService mdmCustomerDockingService;
    @Resource
    private CustomerChangeAdviseTargetStrategy customerChangeAdviseTargetStrategy;
    @Resource
    private Advise advise;
    @Resource
    private IEngineOrgService engineOrgService;
    @Resource
    private MdmCustomerMsgMapper mdmCustomerMsgMapper;

    @Async
    public void sendCustomerChangeMsg(List<String> customerCodeList) {
        log.info("\u901a\u77e5\u5ba2\u6237\u4fe1\u606f\u6216\u5ba2\u6237\u7684\u7ec4\u7ec7\u53d1\u751f\u53d8\u5316,\u5ba2\u6237\u7f16\u7801\u96c6\u5408:{}", customerCodeList);
        if (!CollectionUtils.isEmpty(customerCodeList)) {
            this.advise.adviseTarget(this.customerChangeAdviseTargetStrategy, customerCodeList);
        }
    }

    public void updateContact(MdmCustomerMsgReqVo mdmCustomerMsgReqVo, MdmCustomerMsgEntity entity) {
        String customerCode = entity.getCustomerCode();
        if (StringUtils.isEmpty((String)customerCode)) {
            log.error("\u5ba2\u6237\u4fe1\u606f\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a:{}", (Object)entity);
            return;
        }
        this.setUpContact(mdmCustomerMsgReqVo, customerCode);
        this.setUpDocking(mdmCustomerMsgReqVo, customerCode);
    }

    private void setUpDocking(MdmCustomerMsgReqVo mdmCustomerMsgReqVo, String customerCode) {
        List mdmCustomerDockingReqVos = mdmCustomerMsgReqVo.getMdmCustomerDockingVos();
        ((LambdaUpdateChainWrapper)this.mdmCustomerDockingService.lambdaUpdate().eq(MdmCustomerDockingEntity::getCustomerCode, (Object)customerCode)).remove();
        if (!CollectionUtils.isEmpty((Collection)mdmCustomerDockingReqVos)) {
            mdmCustomerDockingReqVos.stream().peek(x -> x.setCustomerCode(customerCode)).forEach(x -> {});
            List mdmCustomerDockingEntities = CrmBeanUtil.copyList((List)mdmCustomerDockingReqVos, MdmCustomerDockingEntity.class);
            this.mdmCustomerDockingService.saveBatch(mdmCustomerDockingEntities);
        }
    }

    private void setUpContact(MdmCustomerMsgReqVo mdmCustomerMsgReqVo, String customerCode) {
        List mdmCustomerContactReqVos = mdmCustomerMsgReqVo.getMdmCustomerContactVos();
        ((LambdaUpdateChainWrapper)this.mdmCustomerContactService.lambdaUpdate().eq(MdmCustomerContactEntity::getCustomerCode, (Object)customerCode)).remove();
        if (!CollectionUtils.isEmpty((Collection)mdmCustomerContactReqVos)) {
            mdmCustomerContactReqVos.stream().peek(x -> x.setCustomerCode(customerCode)).forEach(x -> {});
            List mdmCustomerContactEntities = CrmBeanUtil.copyList((List)mdmCustomerContactReqVos, MdmCustomerContactEntity.class);
            this.mdmCustomerContactService.saveBatch(mdmCustomerContactEntities);
        }
    }

    public List<MdmCustomerDockingRespVo> dockingSearch(MdmCustomerDockingSearchReqVo mdmCustomerDockingSearchReqVo) {
        return this.mdmCustomerDockingService.dockingSearch(mdmCustomerDockingSearchReqVo);
    }

    public List<MdmCustomerMsgRespVo> findCurrentAndSubCustomerList(MdmCustomerOrgSearchReqVo mdmCustomerOrgSearchReqVo) {
        List<EngineOrgRespVo> engineOrgEntities;
        MdmBaseOrgSearchReqVo.setUpVo((MdmBaseOrgSearchReqVo)mdmCustomerOrgSearchReqVo);
        List orgCodeList = mdmCustomerOrgSearchReqVo.getOrgCodeList();
        String customerCodeOrName = mdmCustomerOrgSearchReqVo.getCustomerCodeOrName();
        if (!CollectionUtils.isEmpty((Collection)orgCodeList) && !CollectionUtils.isEmpty(engineOrgEntities = this.engineOrgService.findCurrentAndSubOrgCodeList((EngineOrgSearchReqVo)CrmBeanUtil.copy((Object)mdmCustomerOrgSearchReqVo, EngineOrgSearchReqVo.class)))) {
            orgCodeList = engineOrgEntities.stream().map(EngineOrgRespVo::getOrgCode).collect(Collectors.toList());
        }
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().in(!CollectionUtils.isEmpty((Collection)orgCodeList), (Object)"org_code", (Collection)orgCodeList)).eq(!StringUtils.isEmpty((String)mdmCustomerOrgSearchReqVo.getEnableStatus()), (Object)"enable_status", (Object)mdmCustomerOrgSearchReqVo.getEnableStatus())).and(!StringUtils.isEmpty((String)customerCodeOrName), x -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)x.like((Object)"customer_code", (Object)customerCodeOrName)).or()).like((Object)"customer_name", (Object)customerCodeOrName);
        });
        return this.mdmCustomerMsgMapper.pageCondition((Page<MdmCustomerMsgRespVo>)new Page((long)mdmCustomerOrgSearchReqVo.getPageNum().intValue(), (long)mdmCustomerOrgSearchReqVo.getPageSize().intValue()), (QueryWrapper<MdmCustomerMsgRespVo>)wrapper);
    }
}

