/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.material.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.material.mapper.MdmMaterialMapper;
import com.biz.crm.material.model.MdmMaterialEntity;
import com.biz.crm.material.service.IMdmMaterialService;
import com.biz.crm.nebular.mdm.humanarea.MdmMaterialOrgSearchReqVo;
import com.biz.crm.nebular.mdm.material.MdmMaterialPriceRespVo;
import com.biz.crm.nebular.mdm.material.MdmMaterialReqVo;
import com.biz.crm.nebular.mdm.material.MdmMaterialRespVo;
import com.biz.crm.nebular.mdm.material.MdmMaterialUnitRespVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelRespVo;
import com.biz.crm.productlevel.service.IMdmProductLevelService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.ValidateUtils;
import com.biz.crm.utils.DatabaseTypeUtil;
import io.jsonwebtoken.lang.Assert;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"mdmMaterialServiceExpandImpl"})
public class MdmMaterialServiceImpl
extends ServiceImpl<MdmMaterialMapper, MdmMaterialEntity>
implements IMdmMaterialService {
    private static final Logger log = LoggerFactory.getLogger(MdmMaterialServiceImpl.class);
    @Resource
    private MdmMaterialMapper mdmMaterialMapper;
    @Resource
    private IMdmProductLevelService mdmProductLevelService;
    private final String UNIT_CONVERSION_REGEX = "^[+]?([1-9][0-9]*(?:[.][0-9]*)?|0*\\.0*[1-9][0-9]*)(?:[eE][+-][0-9]+)?$";

    @Override
    public PageResult<MdmMaterialRespVo> findList(MdmMaterialReqVo mdmMaterialReqVo) {
        Page page = PageUtil.buildPage((Integer)mdmMaterialReqVo.getPageNum(), (Integer)mdmMaterialReqVo.getPageSize());
        if (StringUtils.isNotEmpty((String)mdmMaterialReqVo.getCode())) {
            MdmProductLevelRespVo productLevel = this.mdmProductLevelService.query(null, mdmMaterialReqVo.getCode());
            mdmMaterialReqVo.setRuleCode(productLevel.getRuleCode());
        }
        List<MdmMaterialRespVo> list = this.mdmMaterialMapper.findList((Page<MdmMaterialRespVo>)page, mdmMaterialReqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmMaterialRespVo query(MdmMaterialReqVo mdmMaterialReqVo) {
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq(!StringUtils.isEmpty((String)mdmMaterialReqVo.getId()), (Object)"a.id", (Object)mdmMaterialReqVo.getId())).eq(!StringUtils.isEmpty((String)mdmMaterialReqVo.getMaterialCode()), (Object)"a.material_code", (Object)mdmMaterialReqVo.getMaterialCode())).eq(!StringUtils.isEmpty((String)mdmMaterialReqVo.getMaterialName()), (Object)"a.material_name", (Object)mdmMaterialReqVo.getMaterialName())).eq(!StringUtils.isEmpty((String)mdmMaterialReqVo.getMaterialType()), (Object)"a.material_type", (Object)mdmMaterialReqVo.getMaterialType())).eq(!StringUtils.isEmpty((String)mdmMaterialReqVo.getFormInstanceId()), (Object)"a.form_instance_id", (Object)mdmMaterialReqVo.getFormInstanceId())).last(DatabaseTypeUtil.SEGMENT);
        return this.mdmMaterialMapper.findOne((QueryWrapper<MdmMaterialEntity>)wrapper);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmMaterialReqVo mdmMaterialReqVo) {
        if (StringUtils.isEmpty((String)mdmMaterialReqVo.getMaterialCode())) {
            mdmMaterialReqVo.setMaterialCode(CodeUtil.getCode());
        } else {
            MdmMaterialRespVo query = this.query(new MdmMaterialReqVo().setMaterialCode(mdmMaterialReqVo.getMaterialCode()));
            Assert.isNull((Object)query, (String)("\u7269\u6599\u7f16\u7801\u5df2\u5b58\u5728:" + mdmMaterialReqVo.getMaterialCode()));
        }
        String unitConversion = mdmMaterialReqVo.getUnitConversion();
        Assert.isTrue((!StringUtils.isEmpty((String)unitConversion) && unitConversion.matches("^[+]?([1-9][0-9]*(?:[.][0-9]*)?|0*\\.0*[1-9][0-9]*)(?:[eE][+-][0-9]+)?$") ? 1 : 0) != 0, (String)"\u5355\u4f4d\u6362\u7b97\u7cfb\u6570\u5fc5\u987b\u662f\u6b63\u6570");
        this.save(CrmBeanUtil.copy((Object)mdmMaterialReqVo, MdmMaterialEntity.class));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmMaterialReqVo mdmMaterialReqVo) {
        String unitConversion = mdmMaterialReqVo.getUnitConversion();
        Assert.isTrue((!StringUtils.isEmpty((String)unitConversion) && unitConversion.matches("^[+]?([1-9][0-9]*(?:[.][0-9]*)?|0*\\.0*[1-9][0-9]*)(?:[eE][+-][0-9]+)?$") ? 1 : 0) != 0, (String)"\u5355\u4f4d\u6362\u7b97\u7cfb\u6570\u5fc5\u987b\u662f\u6b63\u6570");
        this.updateById(CrmBeanUtil.copy((Object)mdmMaterialReqVo, MdmMaterialEntity.class));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmMaterialReqVo mdmMaterialReqVo) {
        ValidateUtils.validate((Object)mdmMaterialReqVo.getIds(), (String)"ids\u4e0d\u80fd\u4e3a\u7a7a");
        this.removeByIds(mdmMaterialReqVo.getIds());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(MdmMaterialReqVo mdmMaterialReqVo) {
        ValidateUtils.validate((Object)mdmMaterialReqVo.getIds(), (String)"ids\u4e0d\u80fd\u4e3a\u7a7a");
        mdmMaterialReqVo.getIds().forEach(id -> {
            Assert.hasText((String)id, (String)"\u4e0d\u80fd\u4f20\u7a7a\u503c");
            MdmMaterialEntity material = (MdmMaterialEntity)((Object)((Object)this.getById((Serializable)((Object)id))));
            Assert.notNull((Object)((Object)material), (String)"\u7269\u6599\u4e0d\u5b58\u5728");
            Assert.isTrue((!CrmEnableStatusEnum.ENABLE.getCode().equals(material.getEnableStatus()) ? 1 : 0) != 0, (String)"\u53ea\u80fd\u542f\u7528\u72b6\u6001\u4e3a\u201c\u7981\u7528\u201d\u7684\u7269\u6599");
            material.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            this.updateById((Object)material);
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(MdmMaterialReqVo mdmMaterialReqVo) {
        ValidateUtils.validate((Object)mdmMaterialReqVo.getIds(), (String)"ids\u4e0d\u80fd\u4e3a\u7a7a");
        mdmMaterialReqVo.getIds().forEach(id -> {
            Assert.hasText((String)id, (String)"\u4e0d\u80fd\u4f20\u7a7a\u503c");
            MdmMaterialEntity material = (MdmMaterialEntity)((Object)((Object)this.getById((Serializable)((Object)id))));
            Assert.notNull((Object)((Object)material), (String)"\u7269\u6599\u4e0d\u5b58\u5728");
            Assert.isTrue((!CrmEnableStatusEnum.DISABLE.getCode().equals(material.getEnableStatus()) ? 1 : 0) != 0, (String)"\u53ea\u80fd\u7981\u7528\u72b6\u6001\u4e3a\u201c\u542f\u7528\u201d\u7684\u7269\u6599");
            material.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode());
            this.updateById((Object)material);
        });
    }

    @Override
    public MdmMaterialEntity findDetailsByFormInstanceId(String formInstanceId) {
        return (MdmMaterialEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(!StringUtils.isEmpty((String)formInstanceId), CrmBaseEntity::getFormInstanceId, (Object)formInstanceId)).last(DatabaseTypeUtil.SEGMENT)).one());
    }

    @Override
    public List<MdmMaterialPriceRespVo> findCurrentAndSubMaterialList(MdmMaterialOrgSearchReqVo mdmMaterialOrgSearchReqVo) {
        Map materialBaseUnit = DictUtil.dictMap((String)"material_base_unit");
        Map materialSaleUnit = DictUtil.dictMap((String)"material_sale_unit");
        Integer pageNum = Optional.ofNullable(mdmMaterialOrgSearchReqVo.getPageNum()).orElse(1);
        Integer pageSize = Optional.ofNullable(mdmMaterialOrgSearchReqVo.getPageSize()).orElse(1000);
        Page page = new Page((long)pageNum.intValue(), (long)pageSize.intValue());
        List<MdmMaterialRespVo> mdmMaterialRespVos = this.mdmMaterialMapper.pageCondition((Page<MdmMaterialRespVo>)page, mdmMaterialOrgSearchReqVo);
        if (CollectionUtils.isEmpty(mdmMaterialRespVos)) {
            return Collections.emptyList();
        }
        return mdmMaterialRespVos.stream().map(x -> {
            MdmMaterialPriceRespVo mdmMaterialPriceRespVo = (MdmMaterialPriceRespVo)CrmBeanUtil.copy((Object)x, MdmMaterialPriceRespVo.class);
            MdmMaterialUnitRespVo baseUnitRespVo = new MdmMaterialUnitRespVo();
            String baseUnit = x.getBaseUnit();
            baseUnitRespVo.setUnit(baseUnit);
            baseUnitRespVo.setUnitName(StringUtils.isEmpty((String)baseUnit) ? baseUnit : (String)materialBaseUnit.get(baseUnit));
            String costPrice = x.getCostPrice();
            baseUnitRespVo.setCostPrice(costPrice);
            MdmMaterialUnitRespVo saleUnitRespVo = new MdmMaterialUnitRespVo();
            String saleUnit = x.getSaleUnit();
            saleUnitRespVo.setUnit(saleUnit);
            saleUnitRespVo.setUnitName(StringUtils.isEmpty((String)saleUnit) ? saleUnit : (String)materialSaleUnit.get(saleUnit));
            String unitConversion = x.getUnitConversion();
            if (!StringUtils.isEmpty((String)costPrice) && !StringUtils.isEmpty((String)unitConversion)) {
                saleUnitRespVo.setCostPrice(new BigDecimal(costPrice).multiply(new BigDecimal(unitConversion)).toString());
            }
            mdmMaterialPriceRespVo.setMdmMaterialUnitRespVos(Arrays.asList(baseUnitRespVo, saleUnitRespVo));
            return mdmMaterialPriceRespVo;
        }).collect(Collectors.toList());
    }
}

