/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.positionlevel.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.mdm.positioin.req.MdmPositionLevelDetailReqVo;
import com.biz.crm.nebular.mdm.positioin.req.MdmPositionLevelReqVo;
import com.biz.crm.nebular.mdm.positioin.resp.MdmPositionLevelDetailRespVo;
import com.biz.crm.nebular.mdm.positioin.resp.MdmPositionLevelRespVo;
import com.biz.crm.nebular.mdm.positioin.resp.MdmPositionLevelRoleRespVo;
import com.biz.crm.position.model.EnginePositionEntity;
import com.biz.crm.position.service.EnginePositionService;
import com.biz.crm.positionlevel.mapper.MdmPositionLevelMapper;
import com.biz.crm.positionlevel.model.MdmPositionLevelEntity;
import com.biz.crm.positionlevel.service.IMdmPositionLevelService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.util.UserUtils;
import com.biz.crm.utils.DatabaseTypeUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"MdmPositionLevelServiceExpandImpl"})
public class MdmPositionLevelServiceImpl
extends ServiceImpl<MdmPositionLevelMapper, MdmPositionLevelEntity>
implements IMdmPositionLevelService {
    private static final Logger log = LoggerFactory.getLogger(MdmPositionLevelServiceImpl.class);
    @Resource
    private MdmPositionLevelMapper mdmPositionLevelMapper;
    @Resource
    private EnginePositionService enginePositionService;

    @Override
    public PageResult<MdmPositionLevelRespVo> findList(MdmPositionLevelReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmPositionLevelRespVo> list = this.mdmPositionLevelMapper.findList((Page<MdmPositionLevelRespVo>)page, reqVo);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            HashMap roleGroupMap = new HashMap(16);
            List<String> positionLevelCodeList = list.stream().map(MdmPositionLevelRespVo::getPositionLevelCode).collect(Collectors.toList());
            List<MdmPositionLevelRoleRespVo> roleList = this.mdmPositionLevelMapper.selectPositionLevelRoleList(positionLevelCodeList);
            if (CollectionUtil.listNotEmptyNotSizeZero(roleList)) {
                for (MdmPositionLevelRoleRespVo item2 : roleList) {
                    ArrayList<MdmPositionLevelRoleRespVo> groupList = new ArrayList<MdmPositionLevelRoleRespVo>();
                    if (roleGroupMap.containsKey(item2.getPositionLevelCode())) {
                        groupList.addAll((Collection)roleGroupMap.get(item2.getPositionLevelCode()));
                    }
                    groupList.add(item2);
                    roleGroupMap.put(item2.getPositionLevelCode(), groupList);
                }
            }
            list.forEach(item -> {
                String roleCodeSplit = "";
                String roleNameSplit = "";
                if (roleGroupMap.containsKey(item.getPositionLevelCode())) {
                    List groupList = (List)roleGroupMap.get(item.getPositionLevelCode());
                    roleCodeSplit = groupList.stream().map(MdmPositionLevelRoleRespVo::getRoleCode).collect(Collectors.joining(","));
                    roleNameSplit = groupList.stream().map(MdmPositionLevelRoleRespVo::getRoleName).collect(Collectors.joining(","));
                }
                item.setRoleCode(roleCodeSplit);
                item.setRoleName(roleNameSplit);
            });
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmPositionLevelRespVo query(MdmPositionLevelReqVo reqVo) {
        MdmPositionLevelEntity entity;
        QueryWrapper wrapper = new QueryWrapper();
        if (StringUtils.isNotEmpty((String)reqVo.getId())) {
            wrapper.eq((Object)"id", (Object)reqVo.getId());
        }
        if (StringUtils.isNotEmpty((String)reqVo.getPositionLevelCode())) {
            wrapper.eq((Object)"code", (Object)reqVo.getPositionLevelCode());
        }
        if ((entity = (MdmPositionLevelEntity)((Object)this.mdmPositionLevelMapper.selectOne((Wrapper)wrapper))) == null) {
            throw new BusinessException("\u804c\u4f4d\u7ea7\u522b\u4e0d\u5b58\u5728");
        }
        MdmPositionLevelRespVo respVo = (MdmPositionLevelRespVo)CrmBeanUtil.copy((Object)((Object)entity), MdmPositionLevelRespVo.class);
        respVo.setPositionLevelCode(entity.getCode());
        respVo.setPositionLevelName(entity.getName());
        String roleCodeSplit = "";
        String roleNameSplit = "";
        List<MdmPositionLevelRoleRespVo> roleList = this.mdmPositionLevelMapper.selectPositionLevelRoleList(Collections.singletonList(entity.getCode()));
        if (CollectionUtil.listNotEmptyNotSizeZero(roleList)) {
            roleCodeSplit = roleList.stream().map(MdmPositionLevelRoleRespVo::getRoleCode).collect(Collectors.joining(","));
            roleNameSplit = roleList.stream().map(MdmPositionLevelRoleRespVo::getRoleName).collect(Collectors.joining(","));
        }
        respVo.setRoleCode(roleCodeSplit);
        respVo.setRoleName(roleNameSplit);
        respVo.setRoleList(roleList);
        return respVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmPositionLevelReqVo reqVo) {
        if (StringUtils.isEmpty((String)reqVo.getPositionLevelName())) {
            throw new BusinessException("\u7f3a\u5931\u804c\u4f4d\u7ea7\u522b\u540d\u79f0");
        }
        if (StringUtils.isEmpty((String)reqVo.getRoleCode())) {
            throw new BusinessException("\u7f3a\u5931\u89d2\u8272\u7f16\u7801");
        }
        if (StringUtils.isEmpty((String)reqVo.getRoleName())) {
            throw new BusinessException("\u7f3a\u5931\u89d2\u8272\u540d\u79f0");
        }
        MdmPositionLevelEntity entity = (MdmPositionLevelEntity)((Object)CrmBeanUtil.copy((Object)reqVo, MdmPositionLevelEntity.class));
        entity.setCode(CodeUtil.getCode());
        entity.setName(reqVo.getPositionLevelName());
        entity.setCreateTime(new Date());
        entity.setCreateUser(UserUtils.getUser() != null ? UserUtils.getUser().getUsername() : "");
        entity.setDeleteFlag(0);
        entity.setState(1);
        this.save((Object)entity);
        for (String roleCode : entity.getRoleCode().split(",")) {
            this.mdmPositionLevelMapper.insertPositionLevelRoleInEngine(UUID.randomUUID().toString(), entity.getCode(), roleCode);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmPositionLevelReqVo reqVo) {
        if (StringUtils.isEmpty((String)reqVo.getId())) {
            throw new BusinessException("\u7f3a\u5931id");
        }
        MdmPositionLevelEntity entity = (MdmPositionLevelEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        if (entity == null) {
            throw new BusinessException("\u804c\u4f4d\u7ea7\u522b\u4e0d\u5b58\u5728");
        }
        if (StringUtils.isEmpty((String)reqVo.getPositionLevelName())) {
            throw new BusinessException("\u7f3a\u5931\u804c\u4f4d\u7ea7\u522b\u540d\u79f0");
        }
        if (StringUtils.isEmpty((String)reqVo.getRoleCode())) {
            throw new BusinessException("\u7f3a\u5931\u89d2\u8272\u7f16\u7801");
        }
        if (StringUtils.isEmpty((String)reqVo.getRoleName())) {
            throw new BusinessException("\u7f3a\u5931\u89d2\u8272\u540d\u79f0");
        }
        if (StringUtils.isEmpty((String)reqVo.getEnableStatus())) {
            throw new BusinessException("\u7f3a\u5931\u542f\u7528\u72b6\u6001");
        }
        entity.setName(reqVo.getPositionLevelName());
        entity.setRoleCode(reqVo.getRoleCode());
        entity.setRoleName(reqVo.getRoleName());
        entity.setEnableStatus(reqVo.getEnableStatus());
        entity.setState(CrmEnableStatusEnum.ENABLE.getCode().equals(reqVo.getEnableStatus()) ? 1 : 0);
        entity.setModifyDate(new Date());
        entity.setModifyUser(UserUtils.getUser() != null ? UserUtils.getUser().getUsername() : "");
        this.updateById((Object)entity);
        this.mdmPositionLevelMapper.deletePositionLevelRoleInEngine(entity.getCode());
        for (String roleCode : entity.getRoleCode().split(",")) {
            this.mdmPositionLevelMapper.insertPositionLevelRoleInEngine(UUID.randomUUID().toString(), entity.getCode(), roleCode);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmPositionLevelReqVo reqVo) {
        Assert.notEmpty((Collection)reqVo.getIds(), (String)"\u8bf7\u4f20\u5165\u53c2\u6570");
        List list = this.mdmPositionLevelMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            list.forEach(o -> {
                List positionList = ((LambdaQueryChainWrapper)this.enginePositionService.lambdaQuery().eq(EnginePositionEntity::getPositionLevelCode, (Object)o.getCode())).list();
                Assert.isTrue((boolean)CollectionUtil.listEmpty((List)positionList), (String)("\u804c\u4f4d\u7ea7\u522b" + o.getName() + "\u5df2\u7ecf\u5173\u8054\u4e86\u804c\u4f4d\uff0c\u4e0d\u80fd\u5220\u9664"));
                this.removeById((Serializable)((Object)o.getId()));
                this.mdmPositionLevelMapper.deletePositionLevelRoleInEngine(o.getCode());
            });
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(MdmPositionLevelReqVo reqVo) {
        List ids = reqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        for (String id : ids) {
            Assert.hasText((String)id, (String)"id\u4e0d\u80fd\u4f20\u7a7a\u503c");
            MdmPositionLevelEntity entity = (MdmPositionLevelEntity)((Object)this.getById((Serializable)((Object)id)));
            Assert.notNull((Object)((Object)entity), (String)"id\u65e0\u6548");
            Assert.isTrue((boolean)CrmEnableStatusEnum.DISABLE.getCode().equals(entity.getEnableStatus()), (String)("\u53ea\u80fd\u542f\u7528\u72b6\u6001\u4e3a\u201c" + CrmEnableStatusEnum.DISABLE.getDes() + "\u201d\u7684\u804c\u4f4d\u7ea7\u522b"));
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(BaseIdEntity::getId, (Object)id)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).set(MdmPositionLevelEntity::getState, (Object)1)).set(MdmPositionLevelEntity::getModifyDate, (Object)new Date())).set(MdmPositionLevelEntity::getModifyUser, (Object)(UserUtils.getUser() != null ? UserUtils.getUser().getUsername() : ""))).update();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(MdmPositionLevelReqVo reqVo) {
        List ids = reqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        for (String id : ids) {
            Assert.hasText((String)id, (String)"id\u4e0d\u80fd\u4f20\u7a7a\u503c");
            MdmPositionLevelEntity entity = (MdmPositionLevelEntity)((Object)this.getById((Serializable)((Object)id)));
            Assert.notNull((Object)((Object)entity), (String)"id\u65e0\u6548");
            Assert.isTrue((boolean)CrmEnableStatusEnum.ENABLE.getCode().equals(entity.getEnableStatus()), (String)("\u53ea\u80fd\u7981\u7528\u72b6\u6001\u4e3a\u201c" + CrmEnableStatusEnum.ENABLE.getDes() + "\u201d\u7684\u804c\u4f4d\u7ea7\u522b"));
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(BaseIdEntity::getId, (Object)id)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).set(MdmPositionLevelEntity::getState, (Object)0)).set(MdmPositionLevelEntity::getModifyDate, (Object)new Date())).set(MdmPositionLevelEntity::getModifyUser, (Object)(UserUtils.getUser() != null ? UserUtils.getUser().getUsername() : ""))).update();
        }
    }

    @Override
    public PageResult<MdmPositionLevelDetailRespVo> positionList(MdmPositionLevelDetailReqVo mdmPositionLevelDetailReqVo) {
        Page page = new Page((long)mdmPositionLevelDetailReqVo.getPageNum().intValue(), (long)mdmPositionLevelDetailReqVo.getPageSize().intValue());
        List<MdmPositionLevelDetailRespVo> list = this.mdmPositionLevelMapper.positionList((Page<MdmPositionLevelDetailRespVo>)page, mdmPositionLevelDetailReqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public List<MdmPositionLevelRespVo> selectList(MdmPositionLevelReqVo mdmPositionLevelReqVo) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).like(!StringUtils.isEmpty((String)mdmPositionLevelReqVo.getPositionLevelCode()), MdmPositionLevelEntity::getCode, (Object)mdmPositionLevelReqVo.getPositionLevelCode())).like(!StringUtils.isEmpty((String)mdmPositionLevelReqVo.getPositionLevelName()), MdmPositionLevelEntity::getName, (Object)mdmPositionLevelReqVo.getPositionLevelName())).last(DatabaseTypeUtil.SEGMENT_ITEM)).list();
        return list != null ? list.stream().map(item -> {
            MdmPositionLevelRespVo respVo = (MdmPositionLevelRespVo)CrmBeanUtil.copy((Object)item, MdmPositionLevelRespVo.class);
            respVo.setPositionLevelCode(item.getCode());
            respVo.setPositionLevelName(item.getName());
            return respVo;
        }).collect(Collectors.toList()) : new ArrayList<MdmPositionLevelRespVo>();
    }
}

