/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.customer.base;

import com.alibaba.excel.util.CollectionUtils;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.biz.crm.common.PageResult;
import com.biz.crm.customer.base.CustomerTerminalStrategy;
import com.biz.crm.customer.mapper.MdmCustomerTerminalMapper;
import com.biz.crm.customer.model.MdmCustomerTerminalEntity;
import com.biz.crm.customer.service.IMdmCustomerTerminalService;
import com.biz.crm.nebular.mdm.customer.MdmCustomerTerminalReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerTerminalRespVo;
import com.biz.crm.util.StringUtils;
import io.jsonwebtoken.lang.Assert;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;

@Service
public class UncorrelatedCustomerMapper
implements CustomerTerminalStrategy {
    private final MdmCustomerTerminalMapper mdmCustomerTerminalMapper;
    private final IMdmCustomerTerminalService iMdmCustomerTerminalService;

    @Lazy
    public UncorrelatedCustomerMapper(MdmCustomerTerminalMapper mdmCustomerTerminalMapper, IMdmCustomerTerminalService iMdmCustomerTerminalService) {
        this.mdmCustomerTerminalMapper = mdmCustomerTerminalMapper;
        this.iMdmCustomerTerminalService = iMdmCustomerTerminalService;
    }

    @Override
    public Integer getType() {
        return 2;
    }

    @Override
    public PageResult<MdmCustomerTerminalRespVo> doOperate(MdmCustomerTerminalReqVo mdmCustomerTerminalReqVo) {
        String customerCode = mdmCustomerTerminalReqVo.getCustomerCode();
        Assert.hasText((String)customerCode, (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List terminalCodeList = ((LambdaQueryChainWrapper)this.iMdmCustomerTerminalService.lambdaQuery().eq(MdmCustomerTerminalEntity::getCustomerCode, (Object)customerCode)).select(new SFunction[]{MdmCustomerTerminalEntity::getTerminalCode}).list();
        if (!CollectionUtils.isEmpty((Collection)terminalCodeList)) {
            mdmCustomerTerminalReqVo.setTerminalCodeList(terminalCodeList.stream().map(MdmCustomerTerminalEntity::getTerminalCode).collect(Collectors.toList()));
        }
        Page page = new Page((long)mdmCustomerTerminalReqVo.getPageNum().intValue(), (long)mdmCustomerTerminalReqVo.getPageSize().intValue());
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq(!StringUtils.isEmpty((String)mdmCustomerTerminalReqVo.getTerminalType()), (Object)"a.terminal_type", (Object)mdmCustomerTerminalReqVo.getTerminalType())).and(!StringUtils.isEmpty((String)mdmCustomerTerminalReqVo.getTerminalNameOrCode()), i -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)i.like((Object)"a.terminal_name", (Object)mdmCustomerTerminalReqVo.getTerminalNameOrCode())).or()).like((Object)"a.terminal_code", (Object)mdmCustomerTerminalReqVo.getTerminalNameOrCode());
        })).notIn(!CollectionUtils.isEmpty((Collection)terminalCodeList), (Object)"a.terminal_code", (Collection)terminalCodeList.stream().map(MdmCustomerTerminalEntity::getTerminalCode).distinct().collect(Collectors.toList()));
        List<MdmCustomerTerminalRespVo> list = this.mdmCustomerTerminalMapper.uncorrelatedAnyCustomer((Page<MdmCustomerTerminalRespVo>)page, mdmCustomerTerminalReqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }
}

