/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dict.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.dict.entity.DictEntity;
import com.biz.crm.dict.service.DictService;
import com.biz.crm.dict.service.MdmDictAttrService;
import com.biz.crm.dict.service.MdmDictDataService;
import com.biz.crm.dict.service.MdmDictTypeService;
import com.biz.crm.nebular.mdm.dict.dictattr.req.MdmDictAttrPageReqVo;
import com.biz.crm.nebular.mdm.dict.dictattr.req.MdmDictAttrReqVo;
import com.biz.crm.nebular.mdm.dict.dictattr.resp.MdmDictAttrPageRespVo;
import com.biz.crm.nebular.mdm.dict.dictdata.req.MdmDictDataReqVo;
import com.biz.crm.nebular.mdm.dict.dictdata.req.MdmDictDataTreeVo;
import com.biz.crm.nebular.mdm.dict.dictdata.req.MdmDictDataVo;
import com.biz.crm.nebular.mdm.dict.dicttype.req.MdmDictTypePageReqVo;
import com.biz.crm.nebular.mdm.dict.dicttype.req.MdmDictTypeReqVo;
import com.biz.crm.nebular.mdm.dict.dicttype.resp.MdmDictTypePageRespVo;
import com.biz.crm.nebular.mdm.dict.resp.DictRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.annotation.Resource;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/dict"})
@Api(tags={"nebula\u6570\u636e\u5b57\u5178"})
@CrmGlobalLog
public class DictController {
    @Resource
    private DictService dictService;
    @Resource
    private MdmDictTypeService mdmDictTypeService;
    @Resource
    private MdmDictAttrService mdmDictAttrService;
    @Resource
    private MdmDictDataService mdmDictDataService;

    @GetMapping(value={"/one"})
    @ApiOperation(value="\u67e5\u8be2\u5bf9\u8c61")
    public DictEntity one(@RequestParam(value="typeCode") String typeCode, @RequestParam(value="dictCode") String dictCode) {
        return this.dictService.one(typeCode, dictCode);
    }

    @GetMapping(value={"/val"})
    @ApiOperation(value="\u67e5\u8be2\u503c")
    public String val(@RequestParam(value="typeCode") String typeCode, @RequestParam(value="dictCode") String dictCode) {
        return Optional.ofNullable(this.dictService.one(typeCode, dictCode)).map(DictEntity::getDictKey).orElse(null);
    }

    @GetMapping(value={"/map"})
    @ApiOperation(value="\u67e5\u8be2map")
    public Map<String, String> list(@RequestParam(value="typeCode") String typeCode) {
        return this.dictService.list(typeCode);
    }

    @ApiOperation(value="\u6279\u91cf\u67e5\u8be2map")
    @PostMapping(value={"/map_batch"})
    public List<DictRespVo> typeList(@RequestBody List<String> typeCodeList) {
        return this.dictService.typeList(typeCodeList);
    }

    @ApiOperation(value="\u5b57\u5178\u5206\u7c7b\uff1a\u5206\u9875\u67e5\u8be2\u5206\u7c7b\u5b57\u5178\u5217\u8868")
    @PostMapping(value={"/type_page"})
    public Result<PageResult<MdmDictTypePageRespVo>> conditionPage(@RequestBody MdmDictTypePageReqVo mdmDictTypePageReqVo) {
        return Result.ok(this.mdmDictTypeService.conditionPage(mdmDictTypePageReqVo));
    }

    @ApiOperation(value="\u5b57\u5178\u5206\u7c7b\uff1a\u589e\u52a0\u5b57\u5178\u5206\u7c7b")
    @PostMapping(value={"/type_add"})
    public Result<Object> add(@RequestBody MdmDictTypeReqVo mdmDictTypeReqVo) {
        this.mdmDictTypeService.add(mdmDictTypeReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u5b57\u5178\u5206\u7c7b\uff1a\u5206\u7c7b\u5355\u4e2a\u67e5\u8be2")
    @PostMapping(value={"/type_one"})
    public Result<MdmDictTypePageRespVo> one(@RequestBody MdmDictTypePageReqVo mdmDictTypePageReqVo) {
        return Result.ok((Object)this.mdmDictTypeService.one(mdmDictTypePageReqVo));
    }

    @ApiOperation(value="\u5b57\u5178\u5206\u7c7b\uff1a\u5206\u7c7b\u5220\u9664")
    @PostMapping(value={"/type_remove"})
    public Result<Object> removeCondition(@RequestParam(value="dictTypeCode") String dictTypeCode) {
        this.mdmDictTypeService.removeCondition(dictTypeCode);
        return Result.ok();
    }

    @ApiOperation(value="\u5c5e\u6027\u914d\u7f6e:\u589e\u52a0\u6216\u4fee\u6539\u5b57\u5178\u5c5e\u6027\u914d\u7f6e")
    @PostMapping(value={"/attr_add"})
    public Result<Object> addOrUpdate(@RequestBody MdmDictAttrReqVo mdmDictAttrReqVo) {
        this.mdmDictAttrService.addOrUpdate(mdmDictAttrReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u5c5e\u6027\u914d\u7f6e:\u5220\u9664\u5b57\u5178\u5c5e\u6027\u914d\u7f6e")
    @PostMapping(value={"/attr_remove"})
    public Result<Object> removeAttr(@RequestBody MdmDictAttrReqVo mdmDictAttrReqVo) {
        this.mdmDictAttrService.remove(mdmDictAttrReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u5c5e\u6027\u914d\u7f6e:\u5c5e\u6027\u914d\u7f6e\u5206\u9875\u67e5\u8be2")
    @PostMapping(value={"/attr_page"})
    public Result<PageResult<MdmDictAttrPageRespVo>> pageCondition(@RequestBody MdmDictAttrPageReqVo mdmDictAttrPageReqVo) {
        return Result.ok(this.mdmDictAttrService.pageCondition(mdmDictAttrPageReqVo));
    }

    @ApiOperation(value="\u5c5e\u6027\u914d\u7f6e\uff1a\u6839\u636e\u5c5e\u6027\u7f16\u7801\u67e5\u770b\u8be6\u60c5")
    @PostMapping(value={"/attr_detail"})
    public Result<MdmDictAttrPageRespVo> attrDetail(@RequestBody MdmDictAttrPageReqVo mdmDictAttrPageReqVo) {
        return Result.ok((Object)this.mdmDictAttrService.attrDetail(mdmDictAttrPageReqVo));
    }

    @ApiOperation(value="\u6570\u636e\u5b57\u5178\uff1a\u6dfb\u52a0\u6570\u636e\u5b57\u5178")
    @PostMapping(value={"/data_add"})
    public Result<Object> add(@RequestBody MdmDictDataVo mdmDictDataVo) {
        this.mdmDictDataService.add(mdmDictDataVo);
        return Result.ok();
    }

    @ApiOperation(value="\u6570\u636e\u5b57\u5178\uff1a\u5220\u9664\u6570\u636e\u5b57\u5178")
    @PostMapping(value={"/data_remove"})
    public Result<Object> remove(@RequestBody MdmDictDataReqVo mdmDictDataReqVo) {
        this.mdmDictDataService.remove(mdmDictDataReqVo.getDictDataCode());
        return Result.ok();
    }

    @ApiOperation(value="\u6570\u636e\u5b57\u5178\uff1a\u65b0\u589e\u7f16\u8f91\u65f6\u83b7\u53d6\u5b57\u5178\u7ed3\u6784\u4e0e\u6570\u636e\uff0c\u4f20\u5165\u884c\u7f16\u7801\u83b7\u53d6\u6570\u636e")
    @PostMapping(value={"/data_attr"})
    public Result<MdmDictDataVo> findDataStruct(@RequestBody MdmDictDataReqVo mdmDictDataReqVo) {
        return Result.ok((Object)this.mdmDictDataService.findDataStruct(mdmDictDataReqVo));
    }

    @ApiOperation(value="\u6570\u636e\u5b57\u5178\uff1a\u4fee\u6539\u6570\u636e\u5b57\u5178")
    @PostMapping(value={"/data_update"})
    public Result<Object> update(@RequestBody MdmDictDataVo mdmDictDataVo) {
        this.mdmDictDataService.update(mdmDictDataVo);
        return Result.ok();
    }

    @ApiOperation(value="\u6570\u636e\u5b57\u5178\uff1a\u67e5\u8be2\u6570\u636e\u5b57\u5178")
    @PostMapping(value={"/data_list"})
    public Result<List<MdmDictDataVo>> findData(@RequestBody MdmDictDataTreeVo mdmDictDataTreeVo) {
        return Result.ok(this.mdmDictDataService.findData(mdmDictDataTreeVo));
    }
}

