/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.org.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.annotation.Klock;
import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.CrmTreeEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.customer.model.MdmCustomerMsgEntity;
import com.biz.crm.customer.service.IMdmCustomerMsgService;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.humanarea.EngineOrgPositionRespVo;
import com.biz.crm.nebular.mdm.humanarea.EngineOrgReqVo;
import com.biz.crm.nebular.mdm.humanarea.EngineOrgRespVo;
import com.biz.crm.nebular.mdm.humanarea.EngineOrgSearchReqVo;
import com.biz.crm.nebular.mdm.humanarea.EngineOrgSelectRespVo;
import com.biz.crm.nebular.mdm.humanarea.EngineOrgTreeRespVo;
import com.biz.crm.nebular.mdm.humanarea.MdmBaseOrgSearchReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmOrgCustomerPageReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmOrgCustomerUpdateReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmOrgPositionPageReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmOrgPositionUpdateReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmOrgTerminalPageReqVo;
import com.biz.crm.nebular.mdm.terminal.req.MdmOrgTerminalReqVo;
import com.biz.crm.nebular.mdm.terminal.resp.MdmTerminalRespVo;
import com.biz.crm.org.manager.MdmOrgManager;
import com.biz.crm.org.mapper.EngineOrgMapper;
import com.biz.crm.org.model.EngineOrgEntity;
import com.biz.crm.org.service.IEngineOrgService;
import com.biz.crm.position.mapper.EnginePositionMapper;
import com.biz.crm.position.model.EnginePositionEntity;
import com.biz.crm.position.service.EnginePositionService;
import com.biz.crm.terminal.model.MdmTerminalEntity;
import com.biz.crm.terminal.service.IMdmTerminalService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.utils.DatabaseTypeUtil;
import com.biz.crm.utils.TreeRuleCodeUtil;
import com.bizunited.platform.common.vo.UuidVo;
import io.jsonwebtoken.lang.Assert;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"EngineOrgServiceExpandImpl"})
@CrmGlobalLog
public class EngineOrgServiceImpl
extends ServiceImpl<EngineOrgMapper, EngineOrgEntity>
implements IEngineOrgService {
    private static final Logger log = LoggerFactory.getLogger(EngineOrgServiceImpl.class);
    @Resource
    private EngineOrgMapper engineOrgMapper;
    @Resource
    private MdmOrgManager mdmOrgManager;
    @Resource
    private EnginePositionMapper enginePositionMapper;
    @Resource
    private IMdmTerminalService mdmTerminalService;
    @Resource
    private IMdmCustomerMsgService mdmCustomerMsgService;
    @Resource
    private EnginePositionService enginePositionService;

    @Override
    public PageResult<EngineOrgRespVo> findList(EngineOrgReqVo reqVo) {
        EngineOrgEntity one;
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        String code = reqVo.getCode();
        if (!StringUtils.isEmpty((String)code) && (one = (EngineOrgEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(EngineOrgEntity::getOrgCode, (Object)code)).one())) != null) {
            reqVo.setRuleCode(one.getRuleCode());
        }
        List<EngineOrgRespVo> list = this.engineOrgMapper.findList((Page<EngineOrgRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public EngineOrgRespVo query(EngineOrgReqVo reqVo) {
        EngineOrgEntity one = (EngineOrgEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)reqVo.getOrgCode()), EngineOrgEntity::getOrgCode, (Object)reqVo.getOrgCode())).eq(StringUtils.isNotEmpty((String)reqVo.getId()), EngineOrgEntity::getId, (Object)reqVo.getId())).last(DatabaseTypeUtil.SEGMENT)).one());
        return (EngineOrgRespVo)CrmBeanUtil.copy((Object)((Object)one), EngineOrgRespVo.class);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @Klock(name="mdm_org_operation", leaseTime=15L)
    public void save(EngineOrgReqVo reqVo) {
        Assert.hasText((String)reqVo.getOrgName(), (String)"\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getOrgLevel(), (String)"\u7ec4\u7ec7\u5c42\u7ea7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getEnableStatus(), (String)"\u542f\u7528\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        if (StringUtils.isEmpty((String)reqVo.getOrgCode())) {
            reqVo.setOrgCode(CodeUtil.generateCode((String)CodeRuleEnum.MDM_ORG_CODE.getCode()));
        }
        EngineOrgEntity entity = (EngineOrgEntity)((Object)CrmBeanUtil.copy((Object)reqVo, EngineOrgEntity.class));
        entity.setRuleCode(this.getCodeByParentId(entity.getParentId()));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @Klock(name="mdm_org_operation", leaseTime=15L)
    public void update(EngineOrgReqVo reqVo) {
        String id = reqVo.getId();
        Assert.hasText((String)id, (String)"\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        EngineOrgEntity entity = (EngineOrgEntity)((Object)this.getById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)entity), (String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728");
        String entityRuleCode = entity.getRuleCode();
        Assert.hasText((String)entityRuleCode, (String)"\u5f53\u524d\u7ec4\u7ec7ruleCode\u4e0d\u80fd\u4e3a\u7a7a");
        String parentId = reqVo.getParentId();
        boolean reloadRuleCode = false;
        if (!StringUtils.isEmpty((String)parentId)) {
            Assert.isTrue((!id.equals(parentId) ? 1 : 0) != 0, (String)"\u4e0a\u7ea7\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u5f53\u524d\u7ec4\u7ec7");
            if (!parentId.equals(entity.getParentId())) {
                reloadRuleCode = true;
                EngineOrgEntity parent = (EngineOrgEntity)((Object)this.getById((Serializable)((Object)parentId)));
                Assert.notNull((Object)((Object)parent), (String)"\u4e0a\u7ea7\u7ec4\u7ec7\u4e0d\u5b58\u5728");
                Assert.isTrue((boolean)CrmEnableStatusEnum.ENABLE.getCode().equals(parent.getEnableStatus()), (String)"\u4e0a\u7ea7\u7ec4\u7ec7\u88ab\u7981\u7528");
                String parentRuleCode = parent.getRuleCode();
                Assert.hasText((String)parentRuleCode, (String)"\u4e0a\u7ea7\u7ec4\u7ec7ruleCode\u4e0d\u80fd\u4e3a\u7a7a");
                Assert.isTrue((!parentRuleCode.startsWith(entityRuleCode) ? 1 : 0) != 0, (String)"\u4e0a\u7ea7\u7ec4\u7ec7\u4e0d\u80fd\u662f\u5f53\u524d\u7ec4\u7ec7\u7684\u4e0b\u7ea7\u7ec4\u7ec7");
            }
        } else if (!StringUtils.isEmpty((String)entity.getParentId())) {
            reloadRuleCode = true;
            entity.setParentId("");
        }
        this.convertEnableStatus(reqVo, id);
        this.updateById(CrmBeanUtil.copy((Object)reqVo, EngineOrgEntity.class));
        if (reloadRuleCode) {
            this.updateRuleCode(id);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @Klock(name="mdm_org_operation", leaseTime=15L)
    public void setUpRuleCode() {
        List all = this.lambdaQuery().list();
        all.forEach(item -> item.setRuleCode(UUID.randomUUID().toString()));
        this.updateBatchById(all);
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().isNull(EngineOrgEntity::getParentId)).or()).eq(EngineOrgEntity::getParentId, (Object)"")).list();
        for (int i = 0; i < list.size(); ++i) {
            this.updateCurAndChildren(((EngineOrgEntity)((Object)list.get(i))).getId(), TreeRuleCodeUtil.numToSingleCode(i + 1));
        }
    }

    private void convertEnableStatus(EngineOrgReqVo reqVo, String id) {
        EngineOrgEntity one;
        String enableStatus = reqVo.getEnableStatus();
        if (CrmEnableStatusEnum.contains((String)enableStatus) && (one = (EngineOrgEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(EngineOrgEntity::getId, (Object)id)).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.getRevertCode((String)enableStatus))).select(new SFunction[]{EngineOrgEntity::getId}).one())) != null) {
            reqVo.setIds(Collections.singletonList(reqVo.getId()));
            if (CrmEnableStatusEnum.ENABLE.getCode().equals(enableStatus)) {
                this.enableBatch(reqVo);
            } else if (CrmEnableStatusEnum.DISABLE.getCode().equals(enableStatus)) {
                this.disableBatch(reqVo);
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @Klock(name="mdm_org_operation", leaseTime=15L)
    public void deleteBatch(EngineOrgReqVo reqVo) {
        String id = this.valid(reqVo);
        EngineOrgEntity entity = (EngineOrgEntity)((Object)this.getById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)entity), (String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728");
        List subOrgList = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(EngineOrgEntity::getParentId, (Object)id)).select(new SFunction[]{EngineOrgEntity::getId}).list();
        Assert.isTrue((boolean)CollectionUtils.isEmpty((Collection)subOrgList), (String)"\u5305\u542b\u4e0b\u7ea7\u7ec4\u7ec7\u7684\u4f01\u4e1a\u7ec4\u7ec7\u4e0d\u80fd\u88ab\u5220\u9664");
        List positionList = ((LambdaQueryChainWrapper)this.enginePositionService.lambdaQuery().eq(EnginePositionEntity::getOrganizationId, (Object)id)).select(new SFunction[]{BaseIdEntity::getId}).list();
        Assert.isTrue((boolean)CollectionUtils.isEmpty((Collection)positionList), (String)"\u5b58\u5728\u5173\u8054\u804c\u4f4d\u65e0\u6cd5\u5220\u9664");
        List terminalList = ((LambdaQueryChainWrapper)this.mdmTerminalService.lambdaQuery().eq(MdmTerminalEntity::getOrgCode, (Object)entity.getOrgCode())).select(new SFunction[]{BaseIdEntity::getId}).list();
        Assert.isTrue((boolean)CollectionUtils.isEmpty((Collection)terminalList), (String)"\u5b58\u5728\u5173\u8054\u7ec8\u7aef\u65e0\u6cd5\u5220\u9664");
        List customerList = ((LambdaQueryChainWrapper)this.mdmCustomerMsgService.lambdaQuery().eq(MdmCustomerMsgEntity::getOrgCode, (Object)entity.getOrgCode())).select(new SFunction[]{BaseIdEntity::getId}).list();
        Assert.isTrue((boolean)CollectionUtils.isEmpty((Collection)customerList), (String)"\u5b58\u5728\u5173\u8054\u5ba2\u6237\u65e0\u6cd5\u5220\u9664");
        this.removeById((Serializable)((Object)id));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(EngineOrgReqVo reqVo) {
        EngineOrgEntity parentEntity;
        String id = this.valid(reqVo);
        EngineOrgEntity entity = (EngineOrgEntity)((Object)this.getById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)entity), (String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728");
        Assert.isTrue((boolean)CrmEnableStatusEnum.DISABLE.getCode().equals(entity.getEnableStatus()), (String)"\u53ea\u80fd\u542f\u7528\u72b6\u6001\u4e3a\u201d\u7981\u7528\u201c\u7684\u4f01\u4e1a\u7ec4\u7ec7");
        String parentId = entity.getParentId();
        while (!StringUtils.isEmpty((String)parentId) && (parentEntity = (EngineOrgEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(EngineOrgEntity::getId, (Object)parentId)).select(new SFunction[]{EngineOrgEntity::getId, EngineOrgEntity::getParentId, CrmBaseEntity::getEnableStatus}).one())) != null) {
            Assert.isTrue((!CrmEnableStatusEnum.DISABLE.getCode().equals(parentEntity.getEnableStatus()) ? 1 : 0) != 0, (String)"\u5f53\u524d\u7ec4\u7ec7\u7684\u4e0a\u7ea7\u7ec4\u7ec7\u4e3a\u7981\u7528\u72b6\u6001\uff0c\u65e0\u6cd5\u542f\u7528\u5f53\u524d\u7ec4\u7ec7");
            parentId = parentEntity.getParentId();
        }
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(EngineOrgEntity::getId, (Object)id)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).update();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(EngineOrgReqVo reqVo) {
        String id = this.valid(reqVo);
        EngineOrgEntity entity = (EngineOrgEntity)((Object)this.getById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)entity), (String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728");
        Assert.isTrue((boolean)CrmEnableStatusEnum.ENABLE.getCode().equals(entity.getEnableStatus()), (String)"\u53ea\u80fd\u7981\u7528\u72b6\u6001\u4e3a\u201d\u542f\u7528\u201c\u7684\u4f01\u4e1a\u7ec4\u7ec7");
        this.disableSubOrg(id);
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(EngineOrgEntity::getId, (Object)id)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
    }

    private void disableSubOrg(String id) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(EngineOrgEntity::getParentId, (Object)id)).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).select(new SFunction[]{EngineOrgEntity::getId}).list();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        List<String> collect = list.stream().map(EngineOrgEntity::getId).collect(Collectors.toList());
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(EngineOrgEntity::getId, collect)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
        collect.forEach(this::disableSubOrg);
    }

    private String valid(EngineOrgReqVo reqVo) {
        List ids = reqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((ids.size() == 1 ? 1 : 0) != 0, (String)"\u7ec4\u7ec7\u4ec5\u652f\u6301\u5355\u9009");
        String id = (String)ids.get(0);
        Assert.hasText((String)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        return id;
    }

    @Override
    public List<EngineOrgRespVo> listCondition(EngineOrgReqVo engineOrgReqVo) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().like(!StringUtils.isEmpty((String)engineOrgReqVo.getOrgCode()), EngineOrgEntity::getOrgCode, (Object)engineOrgReqVo.getOrgCode())).like(!StringUtils.isEmpty((String)engineOrgReqVo.getOrgName()), EngineOrgEntity::getOrgName, (Object)engineOrgReqVo.getOrgName())).eq(!StringUtils.isEmpty((String)engineOrgReqVo.getOrgLevel()), EngineOrgEntity::getOrgLevel, (Object)engineOrgReqVo.getOrgLevel())).in(!CollectionUtils.isEmpty((Collection)engineOrgReqVo.getOrgCodeList()), EngineOrgEntity::getOrgCode, (Collection)engineOrgReqVo.getOrgCodeList())).last(DatabaseTypeUtil.SEGMENT_ITEM)).list();
        return CrmBeanUtil.copyList((List)list, EngineOrgRespVo.class);
    }

    @Override
    public PageResult<MdmTerminalRespVo> findList(MdmOrgTerminalPageReqVo mdmOrgTerminalPageReqVo) {
        return this.mdmOrgManager.findList(mdmOrgTerminalPageReqVo);
    }

    @Override
    public PageResult<MdmCustomerMsgRespVo> findList(MdmOrgCustomerPageReqVo mdmOrgCustomerPageReqVo) {
        return this.mdmOrgManager.findList(mdmOrgCustomerPageReqVo);
    }

    @Override
    public PageResult<EngineOrgPositionRespVo> findOrgPositionList(MdmOrgPositionPageReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<EngineOrgPositionRespVo> list = this.enginePositionMapper.findOrgPositionList((Page<EngineOrgPositionRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public void updateOrgCode(MdmOrgCustomerUpdateReqVo mdmOrgCustomerUpdateReqVo) {
        this.mdmOrgManager.updateOrgCode(mdmOrgCustomerUpdateReqVo);
    }

    @Override
    public void terminalOrgCode(MdmOrgTerminalReqVo mdmOrgTerminalReqVo) {
        this.mdmOrgManager.terminalOrgCode(mdmOrgTerminalReqVo);
    }

    @Override
    public void positionOrgCode(MdmOrgPositionUpdateReqVo mdmOrgPositionUpdateReqVo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"org_code", (Object)mdmOrgPositionUpdateReqVo.getOrgCode());
        EngineOrgEntity engineOrgEntity = (EngineOrgEntity)((Object)this.engineOrgMapper.selectOne((Wrapper)queryWrapper));
        if (engineOrgEntity == null) {
            throw new BusinessException("\u65e0\u6548\u7684\u7ec4\u7ec7\u7f16\u7801");
        }
        this.mdmOrgManager.positionOrgCode(mdmOrgPositionUpdateReqVo, engineOrgEntity.getId());
    }

    @Override
    public List<String> findCurrentAndSubOrgCodeList(EngineOrgReqVo engineOrgReqVo) {
        EngineOrgEntity one;
        String orgCode = engineOrgReqVo.getOrgCode();
        if (!StringUtils.isEmpty((String)orgCode) && (one = (EngineOrgEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(EngineOrgEntity::getOrgCode, (Object)orgCode)).select(new SFunction[]{CrmTreeEntity::getRuleCode}).one())) != null) {
            engineOrgReqVo.setRuleCode(one.getRuleCode());
        }
        return this.engineOrgMapper.findCurrentAndSubOrgCodeList(engineOrgReqVo);
    }

    @Override
    public List<EngineOrgRespVo> findCurrentAndSubOrgCodeList(EngineOrgSearchReqVo engineOrgSearchReqVo) {
        MdmBaseOrgSearchReqVo.setUpVo((MdmBaseOrgSearchReqVo)engineOrgSearchReqVo);
        List orgCodeList = engineOrgSearchReqVo.getOrgCodeList();
        String orgCodeOrName = engineOrgSearchReqVo.getOrgCodeOrName();
        QueryWrapper wrapper = (QueryWrapper)Wrappers.query().and(!StringUtils.isEmpty((String)orgCodeOrName), x -> {
            QueryWrapper cfr_ignored_0 = (QueryWrapper)((QueryWrapper)((QueryWrapper)x.like((Object)"org_code", (Object)orgCodeOrName)).or()).like((Object)"org_name", (Object)orgCodeOrName);
        });
        List<EngineOrgRespVo> list = this.engineOrgMapper.pageCondition((Page<EngineOrgRespVo>)new Page((long)engineOrgSearchReqVo.getPageNum().intValue(), (long)engineOrgSearchReqVo.getPageSize().intValue()), (QueryWrapper<EngineOrgRespVo>)wrapper);
        if (CollectionUtils.isEmpty((Collection)orgCodeList) || CollectionUtils.isEmpty(list)) {
            return list;
        }
        ArrayList<EngineOrgRespVo> result = new ArrayList<EngineOrgRespVo>();
        List collect = list.stream().filter(x -> orgCodeList.contains(x.getOrgCode())).collect(Collectors.toList());
        while (!CollectionUtils.isEmpty(collect)) {
            result.addAll(collect);
            List currentOrgIdList = collect.stream().map(UuidVo::getId).collect(Collectors.toList());
            collect = list.stream().filter(x -> currentOrgIdList.contains(x.getParentId())).collect(Collectors.toList());
        }
        return result;
    }

    @Override
    public List<EngineOrgTreeRespVo> findCurrentAndSubOrgTree(EngineOrgSearchReqVo engineOrgSearchReqVo) {
        MdmBaseOrgSearchReqVo.setUpVo((MdmBaseOrgSearchReqVo)engineOrgSearchReqVo);
        List orgCodeList = engineOrgSearchReqVo.getOrgCodeList();
        List<EngineOrgTreeRespVo> list = this.engineOrgMapper.treeCondition((Page<EngineOrgTreeRespVo>)new Page((long)engineOrgSearchReqVo.getPageNum().intValue(), (long)engineOrgSearchReqVo.getPageSize().intValue()), engineOrgSearchReqVo);
        if (CollectionUtils.isEmpty(list)) {
            return list;
        }
        ArrayList<EngineOrgTreeRespVo> result = new ArrayList<EngineOrgTreeRespVo>();
        Set set = list.stream().map(EngineOrgTreeRespVo::getId).collect(Collectors.toSet());
        for (EngineOrgTreeRespVo engineOrgTreeRespVo : list) {
            if (CollectionUtils.isEmpty((Collection)orgCodeList) && (StringUtils.isEmpty((String)engineOrgTreeRespVo.getParentId()) || !set.contains(engineOrgTreeRespVo.getParentId()))) {
                result.add(engineOrgTreeRespVo);
            }
            for (EngineOrgTreeRespVo orgTreeRespVo : list) {
                if (!engineOrgTreeRespVo.getId().equals(orgTreeRespVo.getParentId())) continue;
                if (engineOrgTreeRespVo.getChildren() == null) {
                    engineOrgTreeRespVo.setChildren(new ArrayList());
                }
                engineOrgTreeRespVo.getChildren().add(orgTreeRespVo);
            }
        }
        return result;
    }

    @Override
    public List<EngineOrgRespVo> findOrgChildrenList(String orgId, String orgCode) {
        EngineOrgEntity org;
        List<Object> list = new ArrayList<EngineOrgRespVo>();
        if ((StringUtils.isNotEmpty((String)orgId) || StringUtils.isNotEmpty((String)orgCode)) && (org = (EngineOrgEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)orgId), EngineOrgEntity::getId, (Object)orgId)).eq(StringUtils.isNotEmpty((String)orgCode), EngineOrgEntity::getOrgCode, (Object)orgCode)).one())) != null) {
            List entityList = ((LambdaQueryChainWrapper)this.lambdaQuery().likeRight(CrmTreeEntity::getRuleCode, (Object)org.getRuleCode())).list();
            list = CrmBeanUtil.copyList((List)entityList, EngineOrgRespVo.class);
        }
        return list;
    }

    @Override
    public List<EngineOrgRespVo> findOrgParentList(String orgId, String orgCode) {
        ArrayList<EngineOrgRespVo> list = new ArrayList<EngineOrgRespVo>();
        EngineOrgEntity one = (EngineOrgEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)orgId), EngineOrgEntity::getId, (Object)orgId)).eq(StringUtils.isNotEmpty((String)orgCode), EngineOrgEntity::getOrgCode, (Object)orgCode)).one());
        if (one != null) {
            this.setParentOrg(list, one.getId());
        }
        return list;
    }

    @Override
    public List<EngineOrgSelectRespVo> orgSelect(EngineOrgReqVo engineOrgReqVo) {
        EngineOrgEntity one;
        String currentOrgCode = engineOrgReqVo.getCurrentOrgCode();
        if (!StringUtils.isEmpty((String)currentOrgCode) && (one = (EngineOrgEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(EngineOrgEntity::getOrgCode, (Object)currentOrgCode)).one())) != null) {
            engineOrgReqVo.setRuleCode(one.getRuleCode());
        }
        return this.engineOrgMapper.orgSelect(engineOrgReqVo);
    }

    private void setParentOrg(List<EngineOrgRespVo> list, String orgId) {
        EngineOrgEntity orgEntity;
        if (StringUtils.isNotEmpty((String)orgId) && (orgEntity = (EngineOrgEntity)((Object)this.getById((Serializable)((Object)orgId)))) != null) {
            EngineOrgRespVo orgRespVo = (EngineOrgRespVo)CrmBeanUtil.copy((Object)((Object)orgEntity), EngineOrgRespVo.class);
            list.add(orgRespVo);
            if (StringUtils.isNotEmpty((String)orgEntity.getParentId())) {
                this.setParentOrg(list, orgEntity.getParentId());
            }
        }
    }

    private String getCodeByParentId(String parentId) {
        EngineOrgEntity parent;
        String ruleCode = "";
        boolean top = true;
        String prefix = "";
        if (StringUtils.isNotEmpty((String)parentId) && (parent = (EngineOrgEntity)((Object)this.getById((Serializable)((Object)parentId)))) != null) {
            top = false;
            prefix = parent.getRuleCode();
        }
        List list = null;
        list = top ? ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().isNull(EngineOrgEntity::getParentId)).or()).eq(EngineOrgEntity::getParentId, (Object)"")).list() : ((LambdaQueryChainWrapper)this.lambdaQuery().eq(EngineOrgEntity::getParentId, (Object)parentId)).list();
        if (CollectionUtil.listEmpty((List)list)) {
            ruleCode = prefix + TreeRuleCodeUtil.numToSingleCode(1);
        } else {
            LinkedHashSet<Integer> set = new LinkedHashSet<Integer>();
            for (EngineOrgEntity item : list) {
                if (!StringUtils.isNotEmpty((String)item.getRuleCode())) continue;
                Integer integer = Integer.valueOf(item.getRuleCode().substring(item.getRuleCode().length() - 3));
                set.add(integer);
            }
            for (int i = 1; i < 999; ++i) {
                if (set.contains(i)) continue;
                ruleCode = prefix + TreeRuleCodeUtil.numToSingleCode(i);
                break;
            }
        }
        return ruleCode;
    }

    private void updateRuleCode(String orgId) {
        EngineOrgEntity org = (EngineOrgEntity)((Object)this.getById((Serializable)((Object)orgId)));
        if (org != null) {
            String ruleCode = this.getCodeByParentId(org.getParentId());
            this.updateCurAndChildren(orgId, ruleCode);
        }
    }

    private void updateCurAndChildren(String orgId, String curCode) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(EngineOrgEntity::getId, (Object)orgId)).set(CrmTreeEntity::getRuleCode, (Object)curCode)).update();
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(EngineOrgEntity::getParentId, (Object)orgId)).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            for (int i = 0; i < list.size(); ++i) {
                this.updateCurAndChildren(((EngineOrgEntity)((Object)list.get(i))).getId(), curCode + TreeRuleCodeUtil.numToSingleCode(i + 1));
            }
        }
    }
}

