/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.priceconditiontype.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.nebular.mdm.priceconditiongroup.resp.MdmPriceConditionGroupRelFieldRespVo;
import com.biz.crm.nebular.mdm.priceconditiontype.req.MdmPriceConditionTypeReqVo;
import com.biz.crm.nebular.mdm.priceconditiontype.resp.MdmPriceConditionTypeRelGroupRespVo;
import com.biz.crm.nebular.mdm.priceconditiontype.resp.MdmPriceConditionTypeRespVo;
import com.biz.crm.priceconditiongroup.mapper.MdmPriceConditionGroupMapper;
import com.biz.crm.priceconditiongroup.mapper.MdmPriceConditionGroupRelFieldMapper;
import com.biz.crm.priceconditiongroup.model.MdmPriceConditionGroupRelFieldEntity;
import com.biz.crm.priceconditiontype.mapper.MdmPriceConditionTypeMapper;
import com.biz.crm.priceconditiontype.mapper.MdmPriceConditionTypeRelGroupMapper;
import com.biz.crm.priceconditiontype.model.MdmPriceConditionTypeEntity;
import com.biz.crm.priceconditiontype.model.MdmPriceConditionTypeRelGroupEntity;
import com.biz.crm.priceconditiontype.service.IMdmPriceConditionTypeService;
import com.biz.crm.priceconditiontype.service.impl.PriceConditionTypeServiceHelper;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"MdmPriceConditionTypeServiceExpandImpl"})
public class MdmPriceConditionTypeServiceImpl
extends ServiceImpl<MdmPriceConditionTypeMapper, MdmPriceConditionTypeEntity>
implements IMdmPriceConditionTypeService {
    private static final Logger log = LoggerFactory.getLogger(MdmPriceConditionTypeServiceImpl.class);
    @Resource
    private MdmPriceConditionTypeMapper mdmPriceConditionTypeMapper;
    @Resource
    private MdmPriceConditionTypeRelGroupMapper mdmPriceConditionTypeRelGroupMapper;
    @Resource
    private PriceConditionTypeServiceHelper priceConditionTypeServiceHelper;
    @Resource
    private MdmPriceConditionGroupMapper mdmPriceConditionGroupMapper;
    @Resource
    private MdmPriceConditionGroupRelFieldMapper mdmPriceConditionGroupRelFieldMapper;

    @Override
    public PageResult<MdmPriceConditionTypeRespVo> findList(MdmPriceConditionTypeReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<MdmPriceConditionTypeRespVo> list = this.mdmPriceConditionTypeMapper.findList((Page<MdmPriceConditionTypeRespVo>)page, reqVo);
        this.priceConditionTypeServiceHelper.convertListDate(list);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmPriceConditionTypeRespVo query(MdmPriceConditionTypeReqVo reqVo) {
        MdmPriceConditionTypeEntity mdmPriceConditionTypeEntity = (MdmPriceConditionTypeEntity)((Object)this.mdmPriceConditionTypeMapper.selectById((Serializable)((Object)reqVo.getId())));
        AssertUtils.isNotNull((Object)((Object)mdmPriceConditionTypeEntity), (String)"\u8be5\u6761\u6570\u636e\u5728\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728");
        reqVo.setConditionTypeCode(mdmPriceConditionTypeEntity.getConditionTypeCode());
        MdmPriceConditionTypeRespVo mdmPriceConditionTypeRespVo = (MdmPriceConditionTypeRespVo)CrmBeanUtil.copy((Object)((Object)mdmPriceConditionTypeEntity), MdmPriceConditionTypeRespVo.class);
        List mdmPriceConditionTypeRelGroupEntities = this.mdmPriceConditionTypeRelGroupMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(MdmPriceConditionTypeRelGroupEntity::getConditionTypeCode, (Object)reqVo.getConditionTypeCode()));
        List mdmPriceConditionTypeRelGroupRespVos = CrmBeanUtil.copyList((List)mdmPriceConditionTypeRelGroupEntities, MdmPriceConditionTypeRelGroupRespVo.class);
        mdmPriceConditionTypeRespVo.setConditionTypeRelGroupReqVoList(mdmPriceConditionTypeRelGroupRespVos);
        ArrayList<MdmPriceConditionTypeRespVo> list = new ArrayList<MdmPriceConditionTypeRespVo>(Arrays.asList(mdmPriceConditionTypeRespVo));
        this.priceConditionTypeServiceHelper.convertListDate(list);
        mdmPriceConditionTypeRespVo = (MdmPriceConditionTypeRespVo)list.get(0);
        return mdmPriceConditionTypeRespVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmPriceConditionTypeReqVo reqVo) {
        this.priceConditionTypeServiceHelper.saveCheck(reqVo);
        MdmPriceConditionTypeEntity entity = (MdmPriceConditionTypeEntity)((Object)CrmBeanUtil.copy((Object)reqVo, MdmPriceConditionTypeEntity.class));
        entity.setIsRelated(GlobalWhetherEnum.NO.getCode());
        this.save((Object)entity);
        this.priceConditionTypeServiceHelper.saveOrUpdatePriceConditionTypeRelGroups(reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmPriceConditionTypeReqVo reqVo) {
        this.priceConditionTypeServiceHelper.editCheck(reqVo);
        MdmPriceConditionTypeEntity entity = (MdmPriceConditionTypeEntity)((Object)CrmBeanUtil.copy((Object)reqVo, MdmPriceConditionTypeEntity.class));
        this.updateById((Object)entity);
        this.priceConditionTypeServiceHelper.saveOrUpdatePriceConditionTypeRelGroups(reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmPriceConditionTypeReqVo reqVo) {
        AssertUtils.isNotEmpty((Collection)reqVo.getIds(), (String)"\u8bf7\u9009\u62e9\u9700\u8981\u5220\u9664\u7684\u6570\u636e");
        List mdmPriceConditionTypeEntities = this.mdmPriceConditionTypeMapper.selectBatchIds(reqVo.getIds());
        AssertUtils.isNotEmpty((Collection)mdmPriceConditionTypeEntities, (String)"\u9700\u8981\u5220\u9664\u7684\u6570\u636e\u5728\u6570\u636e\u5e93\u4e2d\u5747\u4e0d\u5b58\u5728");
        String conditionTypeCodesStr = mdmPriceConditionTypeEntities.stream().filter(o -> StringUtils.equals((CharSequence)GlobalWhetherEnum.YES.getCode(), (CharSequence)o.getIsRelated())).map(MdmPriceConditionTypeEntity::getConditionTypeCode).collect(Collectors.joining(","));
        AssertUtils.isTrue((boolean)StringUtils.isBlank((CharSequence)conditionTypeCodesStr), (String)("\u6761\u4ef6\u7c7b\u578b\u7f16\u7801\u4e3a{" + conditionTypeCodesStr + "}\u7684\u6570\u636e\u5173\u8054\u4e86\u5b9a\u4ef7\u8fc7\u7a0b\uff0c\u4e0d\u80fd\u5220\u9664\uff01"));
        List<String> groupCodes = this.mdmPriceConditionTypeMapper.findGroupCodesByIds(reqVo);
        List<String> typeCodes = mdmPriceConditionTypeEntities.stream().map(MdmPriceConditionTypeEntity::getConditionTypeCode).collect(Collectors.toList());
        List<MdmPriceConditionTypeRelGroupRespVo> mdmPriceConditionTypeRelGroupRespVos = this.mdmPriceConditionTypeRelGroupMapper.findGroupCodesWithOutTypeCodes(typeCodes);
        if (CollectionUtil.listNotEmpty(mdmPriceConditionTypeRelGroupRespVos)) {
            List noUpdateGroupCodes = mdmPriceConditionTypeRelGroupRespVos.stream().map(MdmPriceConditionTypeRelGroupRespVo::getConditionGroupCode).collect(Collectors.toList());
            List<String> updateGroupCodes = groupCodes.stream().filter(o -> !noUpdateGroupCodes.contains(o)).collect(Collectors.toList());
            if (CollectionUtil.listNotEmpty(updateGroupCodes)) {
                this.mdmPriceConditionGroupMapper.updateIsRelatedNoByConditionGroupCode(updateGroupCodes);
            }
        } else if (CollectionUtil.listNotEmpty(groupCodes)) {
            this.mdmPriceConditionGroupMapper.updateIsRelatedNoByConditionGroupCode(groupCodes);
        }
        this.mdmPriceConditionTypeMapper.deleteByParams(reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(MdmPriceConditionTypeReqVo reqVo) {
        List mdmPriceConditionTypeEntities = this.mdmPriceConditionTypeMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmPriceConditionTypeEntities)) {
            mdmPriceConditionTypeEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(mdmPriceConditionTypeEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(MdmPriceConditionTypeReqVo reqVo) {
        List mdmPriceConditionTypeEntities = this.mdmPriceConditionTypeMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmPriceConditionTypeEntities)) {
            mdmPriceConditionTypeEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(mdmPriceConditionTypeEntities);
    }

    @Override
    public List<MdmPriceConditionTypeRelGroupRespVo> groupByConditionType(MdmPriceConditionTypeReqVo mdmPriceConditionTypeReqVo) {
        AssertUtils.isNotEmpty((String)mdmPriceConditionTypeReqVo.getConditionTypeCode(), (String)"\u6761\u4ef6\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List groupEntities = this.mdmPriceConditionTypeRelGroupMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(MdmPriceConditionTypeRelGroupEntity::getConditionTypeCode, (Object)mdmPriceConditionTypeReqVo.getConditionTypeCode()));
        if (CollectionUtils.isEmpty((Collection)groupEntities)) {
            return Lists.newArrayList();
        }
        List groupRespVos = CrmBeanUtil.copyList((List)groupEntities, MdmPriceConditionTypeRelGroupRespVo.class);
        Set conditionGroupCodes = groupRespVos.stream().map(MdmPriceConditionTypeRelGroupRespVo::getConditionGroupCode).collect(Collectors.toSet());
        List fieldEntities = this.mdmPriceConditionGroupRelFieldMapper.selectList((Wrapper)Wrappers.lambdaQuery().in(MdmPriceConditionGroupRelFieldEntity::getConditionGroupCode, conditionGroupCodes));
        if (CollectionUtil.listNotEmpty((List)fieldEntities)) {
            List fieldRespVos = CrmBeanUtil.copyList((List)fieldEntities, MdmPriceConditionGroupRelFieldRespVo.class);
            Map<String, List<MdmPriceConditionGroupRelFieldRespVo>> collect = fieldRespVos.stream().collect(Collectors.groupingBy(MdmPriceConditionGroupRelFieldRespVo::getConditionGroupCode));
            groupRespVos.forEach(groupRespVo -> {
                for (Map.Entry stringListEntry : collect.entrySet()) {
                    if (!StringUtils.equals((CharSequence)((CharSequence)stringListEntry.getKey()), (CharSequence)groupRespVo.getConditionGroupCode())) continue;
                    groupRespVo.setMdmPriceConditionGroupRelFieldRespVos((List)stringListEntry.getValue());
                }
            });
        }
        return groupRespVos;
    }
}

