/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.pricesetting.service.impl;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceSettingReqVo;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceSettingRespVo;
import com.biz.crm.nebular.mdm.product.req.MdmProductReqVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.pricesetting.mapper.MdmPriceSettingMapper;
import com.biz.crm.pricesetting.model.MdmPriceSettingEntity;
import com.biz.crm.pricesetting.service.IMdmPriceSettingService;
import com.biz.crm.pricesetting.service.impl.MdmPriceSettingServiceHelper;
import com.biz.crm.product.service.IMdmProductService;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service
@ConditionalOnMissingBean(name={"MdmPriceSettingServiceExpandImpl"})
public class MdmPriceSettingServiceImpl
extends ServiceImpl<MdmPriceSettingMapper, MdmPriceSettingEntity>
implements IMdmPriceSettingService {
    private static final Logger log = LoggerFactory.getLogger(MdmPriceSettingServiceImpl.class);
    @Resource
    private MdmPriceSettingMapper mdmPriceSettingMapper;
    @Resource
    private MdmPriceSettingServiceHelper mdmPriceSettingServiceHelper;
    @Resource
    private IMdmProductService mdmProductService;

    @Override
    public PageResult<MdmPriceSettingRespVo> findList(MdmPriceSettingReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<MdmPriceSettingRespVo> list = this.mdmPriceSettingMapper.findList((Page<MdmPriceSettingRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmPriceSettingRespVo query(MdmPriceSettingReqVo reqVo) {
        AssertUtils.isNotEmpty((String)reqVo.getId(), (String)"\u67e5\u8be2\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        MdmPriceSettingEntity mdmPriceSettingEntity = (MdmPriceSettingEntity)((Object)this.mdmPriceSettingMapper.selectById((Serializable)((Object)reqVo.getId())));
        if (ObjectUtils.isEmpty((Object)((Object)mdmPriceSettingEntity))) {
            return new MdmPriceSettingRespVo();
        }
        MdmPriceSettingRespVo mdmPriceSettingRespVo = (MdmPriceSettingRespVo)CrmBeanUtil.copy((Object)((Object)mdmPriceSettingEntity), MdmPriceSettingRespVo.class);
        if (StringUtils.isNotEmpty((String)mdmPriceSettingRespVo.getProductCode())) {
            MdmProductReqVo mdmProductReqVo = new MdmProductReqVo();
            mdmProductReqVo.setProductCode(mdmPriceSettingRespVo.getProductCode());
            MdmProductRespVo mdmProductRespVo = this.mdmProductService.query(mdmProductReqVo);
            if (!ObjectUtils.isEmpty((Object)mdmProductRespVo)) {
                mdmPriceSettingRespVo.setMdmProductRespVo(mdmProductRespVo);
            }
        }
        return mdmPriceSettingRespVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmPriceSettingReqVo reqVo) {
        this.mdmPriceSettingServiceHelper.saveCheck(reqVo);
        this.mdmPriceSettingServiceHelper.dataUniqueSaveOrUpdate(reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmPriceSettingReqVo reqVo) {
        this.mdmPriceSettingServiceHelper.saveCheck(reqVo);
        this.mdmPriceSettingServiceHelper.dataUniqueSaveOrUpdate(reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmPriceSettingReqVo reqVo) {
        AssertUtils.isNotEmpty((Collection)reqVo.getIds(), (String)"\u5220\u9664\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        List mdmPriceSettingEntities = this.mdmPriceSettingMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmPriceSettingEntities)) {
            this.mdmPriceSettingMapper.deleteBatchIds(reqVo.getIds());
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(MdmPriceSettingReqVo reqVo) {
        List mdmPriceSettingEntities = this.mdmPriceSettingMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmPriceSettingEntities)) {
            mdmPriceSettingEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(mdmPriceSettingEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(MdmPriceSettingReqVo reqVo) {
        List mdmPriceSettingEntities = this.mdmPriceSettingMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmPriceSettingEntities)) {
            mdmPriceSettingEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(mdmPriceSettingEntities);
    }

    @Override
    public Map<String, BigDecimal> findPriceByGoodsAndCusCode(List<String> goodsCodes, String cusCodes) {
        HashMap<String, BigDecimal> reMap = new HashMap<String, BigDecimal>();
        if (org.springframework.util.CollectionUtils.isEmpty(goodsCodes)) {
            return reMap;
        }
        for (String goodsCode : goodsCodes) {
            reMap.put(goodsCode, BigDecimal.ONE);
        }
        return reMap;
    }
}

