/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.product.controller;

import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.mdm.product.req.MdmProductReqVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductAndProductLevelRespVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductRespVo;
import com.biz.crm.product.mapper.MdmProductMapper;
import com.biz.crm.product.service.IMdmProductService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mdmproduct"})
@Api(tags={"\u5546\u54c1\u4e3b\u8868"})
public class MdmProductController {
    private static final Logger log = LoggerFactory.getLogger(MdmProductController.class);
    @Resource
    private IMdmProductService mdmProductService;
    @Resource
    private MdmProductMapper mdmProductMapper;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/list"})
    @CrmLog
    @CrmDictMethod
    public Result<PageResult<MdmProductRespVo>> list(@RequestBody MdmProductReqVo mdmProductReqVo) {
        PageResult<MdmProductRespVo> result = this.mdmProductService.findList(mdmProductReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2")
    @PostMapping(value={"/query"})
    @CrmLog
    public Result<MdmProductRespVo> query(@RequestBody MdmProductReqVo mdmProductReqVo) {
        MdmProductRespVo model = this.mdmProductService.query(mdmProductReqVo);
        return Result.ok((Object)model);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    @CrmLog
    public Result save(@RequestBody MdmProductReqVo mdmProductReqVo) {
        this.mdmProductService.save(mdmProductReqVo);
        return Result.ok((String)"\u65b0\u589e\u6210\u529f");
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    @CrmLog
    public Result update(@RequestBody MdmProductReqVo mdmProductReqVo) {
        this.mdmProductService.update(mdmProductReqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664")
    @PostMapping(value={"/delete"})
    @CrmLog
    public Result delete(@RequestBody MdmProductReqVo mdmProductReqVo) {
        this.mdmProductService.deleteBatch(mdmProductReqVo);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528")
    @PostMapping(value={"/enable"})
    @CrmLog
    public Result enable(@RequestBody MdmProductReqVo mdmProductReqVo) {
        this.mdmProductService.enableBatch(mdmProductReqVo);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528")
    @PostMapping(value={"/disable"})
    @CrmLog
    public Result disable(@RequestBody MdmProductReqVo mdmProductReqVo) {
        this.mdmProductService.disableBatch(mdmProductReqVo);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u4e0a\u67b6")
    @PostMapping(value={"/upshelf"})
    @CrmLog
    public Result upShelf(@RequestBody MdmProductReqVo mdmProductReqVo) {
        this.mdmProductService.upShelf(mdmProductReqVo);
        return Result.ok((String)"\u4e0a\u67b6\u6210\u529f");
    }

    @ApiOperation(value="\u4e0b\u67b6")
    @PostMapping(value={"/downshelf"})
    @CrmLog
    public Result downShelf(@RequestBody MdmProductReqVo mdmProductReqVo) {
        this.mdmProductService.downShelf(mdmProductReqVo);
        return Result.ok((String)"\u4e0b\u67b6\u6210\u529f");
    }

    @ApiOperation(value="\u67e5\u8be2\u4ea7\u54c1\u548c\u4ea7\u54c1\u5c42\u7ea7\u96c6\u5408\u7684\u96c6\u5408")
    @PostMapping(value={"/findProductAndProductLevel"})
    @CrmLog
    public Result<List<MdmProductAndProductLevelRespVo>> findProductAndProductLevelByCodeOrName(@RequestBody MdmProductReqVo mdmProductReqVo) {
        List<MdmProductAndProductLevelRespVo> result = this.mdmProductMapper.findProductAndProductLevelByCodeOrName(mdmProductReqVo);
        return Result.ok(result);
    }
}

