/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.product.service.impl;

import com.biz.crm.base.BusinessException;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.FileTypeEnum;
import com.biz.crm.eunm.IsShelfEnum;
import com.biz.crm.eunm.ProductTypeEnum;
import com.biz.crm.exception.CrmExceptionType;
import com.biz.crm.exception.mdm.MdmProductException;
import com.biz.crm.material.model.MdmMaterialEntity;
import com.biz.crm.nebular.mdm.product.req.MdmProductMaterialReqVo;
import com.biz.crm.nebular.mdm.product.req.MdmProductReqVo;
import com.biz.crm.product.model.MdmProductEntity;
import com.biz.crm.product.model.MdmProductIntroductionEntity;
import com.biz.crm.product.model.MdmProductMaterialEntity;
import com.biz.crm.product.model.MdmProductMediaEntity;
import com.biz.crm.product.service.impl.MdmProductServiceHelper;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.google.common.collect.Lists;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MdmProductBuilder {
    private static final Logger log = LoggerFactory.getLogger(MdmProductBuilder.class);
    private MdmProductServiceHelper helper;
    private MdmProductReqVo reqVo;
    private MdmProductEntity productEntity;
    private MdmProductIntroductionEntity introductionEntity;
    private List<MdmProductMediaEntity> mediaEntities = Lists.newArrayList();
    private List<MdmProductMaterialEntity> materialEntities = Lists.newArrayList();

    public MdmProductBuilder(MdmProductServiceHelper helper, MdmProductReqVo reqVo) {
        this.helper = helper;
        this.reqVo = reqVo;
    }

    public static MdmProductBuilder builder(MdmProductServiceHelper helper, MdmProductReqVo reqVo) {
        return new MdmProductBuilder(helper, reqVo);
    }

    public MdmProductBuilder init() {
        return this;
    }

    public MdmProductBuilder check() {
        AssertUtils.isNotEmpty((String)this.reqVo.getProductCode(), (String)"\u8bf7\u8f93\u5165\u5546\u54c1\u7f16\u7801");
        AssertUtils.isNotEmpty((String)this.reqVo.getProductLevelCode(), (String)"\u8bf7\u9009\u62e9\u4ea7\u54c1\u5c42\u7ea7");
        AssertUtils.isNotEmpty((String)this.reqVo.getProductName(), (String)"\u8bf7\u8f93\u5165\u5546\u54c1\u540d\u79f0");
        AssertUtils.isNotEmpty((String)this.reqVo.getSaleUnit(), (String)"\u5546\u54c1\u9500\u552e\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((String)this.reqVo.getBaseUnit(), (String)"\u5546\u54c1\u57fa\u672c\u5355\u4f4d\u4e0d\u80fd\u4e3a\u7a7a");
        AssertUtils.isNotEmpty((Collection)this.reqVo.getMaterialList(), (CrmExceptionType)MdmProductException.PRODUCT_MATERIAL_NULL);
        if (StringUtils.equals((CharSequence)ProductTypeEnum.STANDARD.getCode(), (CharSequence)this.reqVo.getProductType()) && this.reqVo.getMaterialList().size() > 1) {
            throw new BusinessException(ProductTypeEnum.STANDARD.getCode() + "\u53ea\u80fd\u9009\u62e9\u4e00\u4e2a\u7269\u6599");
        }
        this.reqVo.getMaterialList().forEach(o -> {
            AssertUtils.isNotEmpty((String)o.getMaterialCode(), (String)"\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            if (StringUtils.equals((CharSequence)ProductTypeEnum.STANDARD.getCode(), (CharSequence)this.reqVo.getProductType())) {
                o.setRatio(null);
                AssertUtils.isNotNull((Object)o.getCount(), (String)(ProductTypeEnum.STANDARD.getDes() + "\u7269\u6599\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a"));
            } else if (StringUtils.equals((CharSequence)ProductTypeEnum.RANGE.getCode(), (CharSequence)this.reqVo.getProductType())) {
                o.setCount(null);
            } else if (StringUtils.equals((CharSequence)ProductTypeEnum.GIFT_PACKAGE.getCode(), (CharSequence)this.reqVo.getProductType())) {
                o.setRatio(null);
                AssertUtils.isNotNull((Object)o.getCount(), (String)(ProductTypeEnum.GIFT_PACKAGE.getDes() + "\u7269\u6599\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a"));
            }
        });
        Set<String> set = this.reqVo.getMaterialList().stream().map(MdmProductMaterialReqVo::getMaterialCode).collect(Collectors.toSet());
        AssertUtils.isTrue((this.reqVo.getMaterialList().size() == set.size() ? 1 : 0) != 0, (CrmExceptionType)MdmProductException.PRODUCT_MATERIAL_REPEAT, (String[])new String[0]);
        List<MdmProductEntity> products = this.helper.findProductsByParam(this.reqVo);
        if (CollectionUtils.isNotEmpty(products) && (StringUtils.isEmpty((CharSequence)this.reqVo.getId()) || !StringUtils.equals((CharSequence)products.get(0).getId(), (CharSequence)this.reqVo.getId()))) {
            new BusinessException((CrmExceptionType)MdmProductException.PRODUCT_CODE_EXIST);
        }
        if (StringUtils.equals((CharSequence)ProductTypeEnum.STANDARD.getCode(), (CharSequence)this.reqVo.getProductType()) && this.reqVo.getMaterialList().size() > 1) {
            new BusinessException((CrmExceptionType)MdmProductException.PRODUCT_MATERIAL_ERROR);
        }
        Map<String, MdmMaterialEntity> materialMap = this.helper.findMaterialMapByCodes(set);
        AssertUtils.isNotEmpty(materialMap, (String)"\u60a8\u9009\u62e9\u7684\u7269\u6599\u6570\u636e\u5df2\u88ab\u5220\u9664");
        set.forEach(o -> {
            MdmMaterialEntity entity = (MdmMaterialEntity)((Object)((Object)materialMap.get(o)));
            AssertUtils.isNotNull((Object)((Object)entity), (String)("\u60a8\u9009\u62e9\u7684\u7269\u6599:" + o + "\u5df2\u88ab\u5220\u9664"));
            AssertUtils.isTrue((boolean)StringUtils.equals((CharSequence)CrmEnableStatusEnum.ENABLE.getCode(), (CharSequence)entity.getEnableStatus()), (String)("\u60a8\u9009\u62e9\u7684\u7269\u6599:" + o + "\u5df2\u88ab\u7981\u7528"));
        });
        return this;
    }

    public MdmProductBuilder convert() {
        List videoList;
        MdmProductEntity mdmProductEntity = new MdmProductEntity();
        CrmBeanUtil.copyProperties((Object)this.reqVo, (Object)((Object)mdmProductEntity));
        if (StringUtils.isEmpty((CharSequence)mdmProductEntity.getIsShelf())) {
            mdmProductEntity.setIsShelf(IsShelfEnum.DOWN.getCode());
        }
        this.productEntity = mdmProductEntity;
        this.materialEntities = this.reqVo.getMaterialList().stream().map(o -> {
            MdmProductMaterialEntity materialEntity = new MdmProductMaterialEntity();
            CrmBeanUtil.copyProperties((Object)o, (Object)((Object)materialEntity));
            materialEntity.setId(UUID.randomUUID().toString());
            materialEntity.setProductCode(mdmProductEntity.getProductCode());
            return materialEntity;
        }).collect(Collectors.toList());
        List pictureList = this.reqVo.getPictureList().stream().filter(Objects::nonNull).map(o -> {
            MdmProductMediaEntity mediaEntity = new MdmProductMediaEntity();
            CrmBeanUtil.copyProperties((Object)o, (Object)((Object)mediaEntity));
            mediaEntity.setType(FileTypeEnum.PICTURE.getCode());
            mediaEntity.setProductCode(mdmProductEntity.getProductCode());
            return mediaEntity;
        }).collect(Collectors.toList());
        if (CollectionUtil.listNotEmpty(pictureList)) {
            this.mediaEntities.addAll(pictureList);
        }
        if (CollectionUtil.listNotEmpty(videoList = this.reqVo.getVideoList().stream().filter(Objects::nonNull).map(o -> {
            MdmProductMediaEntity mediaEntity = new MdmProductMediaEntity();
            CrmBeanUtil.copyProperties((Object)o, (Object)((Object)mediaEntity));
            mediaEntity.setProductCode(mdmProductEntity.getProductCode());
            mediaEntity.setType(FileTypeEnum.VIDEO.getCode());
            return mediaEntity;
        }).collect(Collectors.toList()))) {
            this.mediaEntities.addAll(videoList);
        }
        if (Objects.nonNull(this.reqVo.getIntroductionVo())) {
            MdmProductIntroductionEntity introductionEntity = new MdmProductIntroductionEntity();
            CrmBeanUtil.copyProperties((Object)this.reqVo.getIntroductionVo(), (Object)((Object)introductionEntity));
            introductionEntity.setProductCode(mdmProductEntity.getProductCode());
            this.introductionEntity = introductionEntity;
        }
        return this;
    }

    public void save() {
        this.helper.saveProductEntity(this.productEntity);
        this.helper.saveProductIntroduction(this.introductionEntity, Boolean.TRUE, this.productEntity.getProductCode());
        this.helper.saveProductMaterials(this.materialEntities, Boolean.TRUE, this.productEntity.getProductCode());
        this.helper.saveProductMedias(this.mediaEntities, Boolean.TRUE, this.productEntity.getProductCode());
    }

    public void update() {
        this.helper.saveProductEntity(this.productEntity);
        this.helper.saveProductIntroduction(this.introductionEntity, Boolean.FALSE, this.productEntity.getProductCode());
        this.helper.saveProductMaterials(this.materialEntities, Boolean.FALSE, this.productEntity.getProductCode());
        this.helper.saveProductMedias(this.mediaEntities, Boolean.FALSE, this.productEntity.getProductCode());
    }
}

