/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.rolepositionlevel.service.impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.rolepositionlevel.mapper.EngineRolePositionLevelMapper;
import com.biz.crm.rolepositionlevel.model.EngineRolePositionLevelEntity;
import com.biz.crm.rolepositionlevel.service.IEngineRolePositionLevelService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;

@Service
@ConditionalOnMissingBean(name={"EngineRolePositionLevelServiceExpandImpl"})
public class EngineRolePositionLevelServiceImpl
extends ServiceImpl<EngineRolePositionLevelMapper, EngineRolePositionLevelEntity>
implements IEngineRolePositionLevelService {
    private static final Logger log = LoggerFactory.getLogger(EngineRolePositionLevelServiceImpl.class);
    @Resource
    private EngineRolePositionLevelMapper engineRolePositionLevelMapper;

    @Override
    public void savePositionLevelRole(String positionLevelCode, List<String> roleCodeList) {
        for (String roleCode : roleCodeList) {
            this.savePositionLevelRole(positionLevelCode, roleCode);
        }
    }

    @Override
    public void savePositionLevelRole(String positionLevelCode, String roleCode) {
        List list;
        if (StringUtils.isNotEmpty((String)positionLevelCode) && StringUtils.isNotEmpty((String)roleCode) && CollectionUtil.listEmpty((List)(list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(EngineRolePositionLevelEntity::getPositionLevelCode, (Object)positionLevelCode)).eq(EngineRolePositionLevelEntity::getRoleCode, (Object)roleCode)).list()))) {
            EngineRolePositionLevelEntity entity = new EngineRolePositionLevelEntity();
            entity.setRoleCode(roleCode);
            entity.setPositionLevelCode(positionLevelCode);
            this.save((Object)entity);
        }
    }

    @Override
    public void removeRoleCode(List<String> roleCodeList) {
        if (CollectionUtil.listNotEmptyNotSizeZero(roleCodeList)) {
            ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(EngineRolePositionLevelEntity::getRoleCode, roleCodeList)).remove();
        }
    }

    @Override
    public void removeRoleCode(String roleCode) {
        if (StringUtils.isNotEmpty((String)roleCode)) {
            ((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(EngineRolePositionLevelEntity::getRoleCode, (Object)roleCode)).remove();
        }
    }

    @Override
    public void removePositionLevelCode(List<String> positionLevelCodeList) {
        if (CollectionUtil.listNotEmptyNotSizeZero(positionLevelCodeList)) {
            ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(EngineRolePositionLevelEntity::getPositionLevelCode, positionLevelCodeList)).remove();
        }
    }

    @Override
    public void removePositionLevelCode(String positionLevelCode) {
        if (StringUtils.isNotEmpty((String)positionLevelCode)) {
            ((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(EngineRolePositionLevelEntity::getPositionLevelCode, (Object)positionLevelCode)).remove();
        }
    }
}

