/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dict.service.impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.dict.entity.EngineDictEntity;
import com.biz.crm.dict.entity.EngineDictItemEntity;
import com.biz.crm.dict.mapper.EngineDictItemMapper;
import com.biz.crm.dict.service.IEngineDictAttrConfService;
import com.biz.crm.dict.service.IEngineDictItemService;
import com.biz.crm.dict.service.IEngineDictService;
import com.biz.crm.nebular.mdm.dict.req.EngineDictAttrConfReqVo;
import com.biz.crm.nebular.mdm.dict.req.EngineDictItemReqVo;
import com.biz.crm.nebular.mdm.dict.resp.EngineDictAttrConfRespVo;
import com.biz.crm.nebular.mdm.dict.resp.EngineDictItemListHeadRespVo;
import com.biz.crm.nebular.mdm.dict.resp.EngineDictItemRespVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.utils.ReflectUtil;
import com.bizunited.platform.common.vo.UuidVo;
import io.jsonwebtoken.lang.Assert;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"EngineDictItemServiceExpandImpl"})
public class EngineDictItemServiceImpl
extends ServiceImpl<EngineDictItemMapper, EngineDictItemEntity>
implements IEngineDictItemService {
    private static final Logger log = LoggerFactory.getLogger(EngineDictItemServiceImpl.class);
    @Resource
    private EngineDictItemMapper engineDictItemMapper;
    @Resource
    private IEngineDictAttrConfService iEngineDictAttrConfService;
    @Resource
    private IEngineDictService engineDictService;

    @Override
    public List<EngineDictItemRespVo> tree(EngineDictItemReqVo reqVo) {
        ArrayList<EngineDictItemRespVo> result = new ArrayList<EngineDictItemRespVo>();
        List<EngineDictItemRespVo> list = this.engineDictItemMapper.findList(null, reqVo);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            List<EngineDictItemRespVo> allList = this.getAllParentList(list);
            if (StringUtils.isNotEmpty((String)reqVo.getDictEntityId())) {
                HashMap<String, Map> map = new HashMap<String, Map>(16);
                String dictEntityId = reqVo.getDictEntityId();
                List<EngineDictItemListHeadRespVo> filedList = this.listHead(new EngineDictItemReqVo().setDictEntityId(dictEntityId));
                for (EngineDictItemListHeadRespVo filed : filedList) {
                    Map dictMap;
                    if (!StringUtils.isNotEmpty((String)filed.getSelectDictType()) || (dictMap = DictUtil.getDictValueMapsByCodes((String)filed.getSelectDictType())).isEmpty()) continue;
                    map.put(filed.getFieldCode(), dictMap);
                }
                if (!map.isEmpty()) {
                    allList.forEach(item -> map.forEach((k, v) -> {
                        Object fieldKy = ReflectUtil.getFiledValueByName(item, k);
                        if (fieldKy != null && v.containsKey(fieldKy.toString())) {
                            ReflectUtil.setFieldValue(item, k, v.get(fieldKy.toString()));
                        }
                    }));
                }
            }
            result.addAll(this.generateTree(allList));
        }
        return result;
    }

    private List<EngineDictItemRespVo> generateTree(List<EngineDictItemRespVo> totalList) {
        ArrayList<EngineDictItemRespVo> treeList = new ArrayList<EngineDictItemRespVo>();
        ArrayList<Object> curLevelList = new ArrayList<Object>();
        ArrayList<Object> restList = new ArrayList<Object>();
        Map<String, EngineDictItemRespVo> totalMap = totalList.stream().collect(Collectors.toMap(UuidVo::getId, v -> v));
        for (EngineDictItemRespVo item : totalList) {
            if (StringUtils.isEmpty((String)item.getParentId()) || !totalMap.containsKey(item.getParentId())) {
                treeList.add(item);
                curLevelList.add(item);
                continue;
            }
            restList.add(item);
        }
        while (curLevelList.size() > 0 && restList.size() > 0) {
            ArrayList<EngineDictItemRespVo> restTempList = new ArrayList<EngineDictItemRespVo>();
            ArrayList<EngineDictItemRespVo> curLevelTempList = new ArrayList<EngineDictItemRespVo>();
            Map<String, String> curLevelMap = curLevelList.stream().collect(Collectors.toMap(UuidVo::getId, UuidVo::getId));
            HashMap curLevelChildrenMap = new HashMap();
            for (EngineDictItemRespVo engineDictItemRespVo : restList) {
                if (curLevelMap.containsKey(engineDictItemRespVo.getParentId())) {
                    curLevelTempList.add(engineDictItemRespVo);
                    ArrayList<EngineDictItemRespVo> childrenList = new ArrayList<EngineDictItemRespVo>();
                    if (curLevelChildrenMap.containsKey(engineDictItemRespVo.getParentId())) {
                        childrenList.addAll((Collection)curLevelChildrenMap.get(engineDictItemRespVo.getParentId()));
                    }
                    childrenList.add(engineDictItemRespVo);
                    curLevelChildrenMap.put(engineDictItemRespVo.getParentId(), childrenList);
                    continue;
                }
                restTempList.add(engineDictItemRespVo);
            }
            for (EngineDictItemRespVo engineDictItemRespVo : curLevelList) {
                if (!curLevelChildrenMap.containsKey(engineDictItemRespVo.getId())) continue;
                engineDictItemRespVo.setChildren((List)curLevelChildrenMap.get(engineDictItemRespVo.getId()));
            }
            curLevelList.clear();
            curLevelList.addAll(curLevelTempList);
            restList.clear();
            restList.addAll(restTempList);
        }
        return treeList;
    }

    @Override
    public EngineDictItemRespVo query(EngineDictItemReqVo reqVo) {
        EngineDictItemEntity one = (EngineDictItemEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)reqVo.getId()), BaseIdEntity::getId, (Object)reqVo.getId())).one());
        EngineDictItemRespVo respVo = (EngineDictItemRespVo)CrmBeanUtil.copy((Object)((Object)one), EngineDictItemRespVo.class);
        return respVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(EngineDictItemReqVo reqVo) {
        reqVo.setId(null);
        this.verify(reqVo);
        EngineDictItemEntity entity = (EngineDictItemEntity)((Object)CrmBeanUtil.copy((Object)reqVo, EngineDictItemEntity.class));
        entity.setDictItemStatus(true);
        entity.setCreateTime(new Date());
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(EngineDictItemReqVo reqVo) {
        Assert.hasText((String)reqVo.getId(), (String)"\u7f3a\u5931id");
        this.verify(reqVo);
        EngineDictItemEntity entity = (EngineDictItemEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        CrmBeanUtil.copyProperties((Object)reqVo, (Object)((Object)entity));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(EngineDictItemReqVo reqVo) {
        List engineDictItemEntities = this.engineDictItemMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)engineDictItemEntities)) {
            engineDictItemEntities.forEach(o -> {
                List children = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(EngineDictItemEntity::getParentId, (Object)o.getId())).list();
                Assert.isTrue((boolean)CollectionUtil.listEmpty((List)children), (String)"\u5b58\u5728\u5b50\u8282\u70b9\uff0c\u8bf7\u5148\u5220\u9664\u5b50\u8282\u70b9");
                this.removeById((Serializable)((Object)o.getId()));
            });
        }
    }

    @Override
    public List<EngineDictItemListHeadRespVo> listHead(EngineDictItemReqVo engineDictItemReqVo) {
        ArrayList<EngineDictItemListHeadRespVo> result = new ArrayList<EngineDictItemListHeadRespVo>();
        result.add(EngineDictItemListHeadRespVo.builder().fieldCode("dictKey").fieldName("\u5b57\u5178\u503c").required("1").build());
        result.add(EngineDictItemListHeadRespVo.builder().fieldCode("dictValue").fieldName("\u5b57\u5178\u7f16\u7801").required("1").build());
        result.add(EngineDictItemListHeadRespVo.builder().fieldCode("dictDesc").fieldName("\u5b57\u5178\u63cf\u8ff0").required("0").build());
        result.add(EngineDictItemListHeadRespVo.builder().fieldCode("dictSort").fieldName("\u5b57\u5178\u6392\u5e8f").required("1").build());
        EngineDictAttrConfReqVo param = EngineDictAttrConfReqVo.builder().dictEntityId(engineDictItemReqVo.getDictEntityId()).build();
        param.setPageSize(Integer.valueOf(15));
        PageResult<EngineDictAttrConfRespVo> confResult = this.iEngineDictAttrConfService.findList(param);
        confResult.getData().stream().sorted(Comparator.comparing(e -> Objects.isNull(e.getShowOrder()) ? 0 : e.getShowOrder())).forEach(e -> result.add(EngineDictItemListHeadRespVo.builder().fieldCode(e.getExtField()).fieldName(e.getFieldName()).required(e.getRequired()).selectDictType(e.getSelectDictType()).build()));
        return result;
    }

    private List<EngineDictItemRespVo> getAllParentList(List<EngineDictItemRespVo> list) {
        ArrayList<EngineDictItemRespVo> result = new ArrayList<EngineDictItemRespVo>();
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            HashSet<String> idSet = new HashSet<String>();
            for (EngineDictItemRespVo item : list) {
                idSet.add(item.getId());
                this.setParent(item.getParentId(), idSet);
            }
            if (!idSet.isEmpty()) {
                List parentList = ((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, idSet)).list();
                result.addAll(CrmBeanUtil.copyList((List)parentList, EngineDictItemRespVo.class));
            }
        }
        return result;
    }

    private void setParent(String id, Set<String> idSet) {
        if (StringUtils.isNotEmpty((String)id)) {
            if (idSet.contains(id)) {
                return;
            }
            EngineDictItemEntity one = (EngineDictItemEntity)((Object)this.getById((Serializable)((Object)id)));
            if (one != null) {
                idSet.add(id);
                this.setParent(one.getParentId(), idSet);
            }
        }
    }

    private void verify(EngineDictItemReqVo reqVo) {
        Assert.hasText((String)reqVo.getDictKey(), (String)"\u5b57\u5178\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getDictValue(), (String)"\u5b57\u5178\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)reqVo.getDictSort(), (String)"\u5b57\u5178\u6392\u5e8f\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getDictEntityId(), (String)"\u5bf9\u5e94\u5b57\u5178\u4e0d\u80fd\u4e3a\u7a7a");
        EngineDictEntity dict = (EngineDictEntity)((Object)this.engineDictService.getById((Serializable)((Object)reqVo.getDictEntityId())));
        Assert.notNull((Object)((Object)dict), (String)"\u5bf9\u5e94\u5b57\u5178\u4e0d\u5b58\u5728");
        reqVo.setDictEntityCode(dict.getDictCode());
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().ne(StringUtils.isNotEmpty((String)reqVo.getId()), BaseIdEntity::getId, (Object)reqVo.getId())).eq(EngineDictItemEntity::getDictEntityId, (Object)reqVo.getDictEntityId())).eq(EngineDictItemEntity::getDictValue, (Object)reqVo.getDictValue())).list();
        Assert.isTrue((boolean)CollectionUtil.listEmpty((List)list), (String)"\u5b57\u5178\u7f16\u7801\u5df2\u7ecf\u5b58\u5728");
        if (StringUtils.isEmpty((String)reqVo.getParentId())) {
            reqVo.setDictLevel(Integer.valueOf(1));
        } else {
            EngineDictItemEntity parent = (EngineDictItemEntity)((Object)this.getById((Serializable)((Object)reqVo.getParentId())));
            Assert.notNull((Object)((Object)parent), (String)"\u4e0a\u7ea7\u4e0d\u5b58\u5728");
            reqVo.setDictLevel(Integer.valueOf(parent.getDictLevel() == null ? 1 : parent.getDictLevel() + 1));
        }
    }
}

