/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.humanarea.service.impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.humanarea.mapper.MdmCommonQueryMapper;
import com.biz.crm.humanarea.service.MdmCommonQueryService;
import com.biz.crm.nebular.mdm.constant.YesOrNoEnum;
import com.biz.crm.nebular.mdm.humanarea.EngineOrgRelationQueryReqVo;
import com.biz.crm.nebular.mdm.humanarea.EngineOrgRelationRespVo;
import com.biz.crm.nebular.mdm.humanarea.EnginePositionRespVo;
import com.biz.crm.org.model.EngineOrgEntity;
import com.biz.crm.org.service.IEngineOrgService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MdmCommonQueryServiceImpl
implements MdmCommonQueryService {
    private static final Logger log = LoggerFactory.getLogger(MdmCommonQueryServiceImpl.class);
    @Resource
    private MdmCommonQueryMapper mdmCommonQueryMapper;
    @Resource
    private IEngineOrgService engineOrgService;

    @Override
    public List<EngineOrgRelationRespVo> findOrgRelationList(EngineOrgRelationQueryReqVo reqVo) {
        ArrayList<EngineOrgRelationRespVo> list = new ArrayList();
        List orgCodeList = reqVo.getOrgCodeList();
        if (CollectionUtil.listEmpty((List)orgCodeList)) {
            return new ArrayList<EngineOrgRelationRespVo>();
        }
        List orgList = ((LambdaQueryChainWrapper)this.engineOrgService.lambdaQuery().in(EngineOrgEntity::getOrgCode, (Collection)orgCodeList)).list();
        if (CollectionUtil.listEmpty((List)orgList)) {
            return new ArrayList<EngineOrgRelationRespVo>();
        }
        List<Object> positionList = new ArrayList();
        if (Integer.valueOf(YesOrNoEnum.IO.YES.getCode()).equals(reqVo.getPositionQueryType())) {
            positionList = this.mdmCommonQueryMapper.findPositionUserOrgList(new ArrayList<String>(), CrmEnableStatusEnum.ENABLE.getCode());
            HashMap ruleCodeMap = new HashMap(16);
            if (CollectionUtil.listNotEmptyNotSizeZero(positionList)) {
                for (EnginePositionRespVo enginePositionRespVo : positionList) {
                    ArrayList<EnginePositionRespVo> mapValueList = new ArrayList<EnginePositionRespVo>();
                    if (ruleCodeMap.containsKey(enginePositionRespVo.getRuleCode())) {
                        mapValueList.addAll((Collection)ruleCodeMap.get(enginePositionRespVo.getRuleCode()));
                    }
                    mapValueList.add(enginePositionRespVo);
                    ruleCodeMap.put(enginePositionRespVo.getRuleCode(), mapValueList);
                }
            }
            for (EngineOrgEntity engineOrgEntity : orgList) {
                EngineOrgRelationRespVo copy = (EngineOrgRelationRespVo)CrmBeanUtil.copy((Object)((Object)engineOrgEntity), EngineOrgRelationRespVo.class);
                ArrayList orgPositionList = new ArrayList();
                for (Map.Entry entry : ruleCodeMap.entrySet()) {
                    if (!((String)entry.getKey()).startsWith(engineOrgEntity.getRuleCode())) continue;
                    orgPositionList.addAll((Collection)entry.getValue());
                }
                copy.setPositionList(orgPositionList);
                list.add(copy);
            }
        } else if (Integer.valueOf(YesOrNoEnum.IO.NO.getCode()).equals(reqVo.getPositionQueryType())) {
            positionList = this.mdmCommonQueryMapper.findPositionUserOrgList(orgCodeList, CrmEnableStatusEnum.ENABLE.getCode());
            HashMap orgCodeMap = new HashMap(16);
            if (CollectionUtil.listNotEmptyNotSizeZero(positionList)) {
                for (EnginePositionRespVo enginePositionRespVo : positionList) {
                    ArrayList<EnginePositionRespVo> mapValueList = new ArrayList<EnginePositionRespVo>();
                    if (orgCodeMap.containsKey(enginePositionRespVo.getOrgCode())) {
                        mapValueList.addAll((Collection)orgCodeMap.get(enginePositionRespVo.getOrgCode()));
                    }
                    mapValueList.add(enginePositionRespVo);
                    orgCodeMap.put(enginePositionRespVo.getOrgCode(), mapValueList);
                }
            }
            for (EngineOrgEntity engineOrgEntity : orgList) {
                EngineOrgRelationRespVo copy = (EngineOrgRelationRespVo)CrmBeanUtil.copy((Object)((Object)engineOrgEntity), EngineOrgRelationRespVo.class);
                if (orgCodeMap.containsKey(engineOrgEntity.getOrgCode())) {
                    copy.setPositionList((List)orgCodeMap.get(engineOrgEntity.getOrgCode()));
                }
                list.add(copy);
            }
        } else {
            list = CrmBeanUtil.copyList((List)orgList, EngineOrgRelationRespVo.class);
        }
        return list;
    }
}

