/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.product.service.impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.material.model.MdmMaterialEntity;
import com.biz.crm.material.service.IMdmMaterialService;
import com.biz.crm.nebular.mdm.product.req.MdmProductMaterialReqVo;
import com.biz.crm.nebular.mdm.product.resp.MdmProductMaterialRespVo;
import com.biz.crm.product.mapper.MdmProductMaterialMapper;
import com.biz.crm.product.model.MdmProductMaterialEntity;
import com.biz.crm.product.service.IMdmProductMaterialService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class MdmProductMaterialServiceImpl
extends ServiceImpl<MdmProductMaterialMapper, MdmProductMaterialEntity>
implements IMdmProductMaterialService {
    private static final Logger log = LoggerFactory.getLogger(MdmProductMaterialServiceImpl.class);
    @Resource
    private MdmProductMaterialMapper mdmProductMaterialMapper;
    @Resource
    private IMdmMaterialService mdmMaterialService;

    @Override
    public PageResult<MdmProductMaterialRespVo> findList(MdmProductMaterialReqVo mdmProductMaterialReqVo) {
        Page page = PageUtil.buildPage((Integer)mdmProductMaterialReqVo.getPageNum(), (Integer)mdmProductMaterialReqVo.getPageSize());
        List<MdmProductMaterialRespVo> list = this.mdmProductMaterialMapper.findList((Page<MdmProductMaterialRespVo>)page, mdmProductMaterialReqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public List<MdmProductMaterialRespVo> findProductMaterialList(MdmProductMaterialReqVo mdmProductMaterialReqVo) {
        if (StringUtils.isEmpty((CharSequence)mdmProductMaterialReqVo.getProductCode())) {
            return new ArrayList<MdmProductMaterialRespVo>();
        }
        return this.mdmProductMaterialMapper.findList(null, mdmProductMaterialReqVo);
    }

    @Override
    public MdmProductMaterialRespVo query(MdmProductMaterialReqVo mdmProductMaterialReqVo) {
        MdmProductMaterialEntity one;
        MdmProductMaterialRespVo respVo = null;
        if ((StringUtils.isNotEmpty((CharSequence)mdmProductMaterialReqVo.getId()) || StringUtils.isNotEmpty((CharSequence)mdmProductMaterialReqVo.getMaterialCode())) && (one = (MdmProductMaterialEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((CharSequence)mdmProductMaterialReqVo.getId()), BaseIdEntity::getId, (Object)mdmProductMaterialReqVo.getId())).eq(StringUtils.isNotEmpty((CharSequence)mdmProductMaterialReqVo.getMaterialCode()), MdmProductMaterialEntity::getMaterialCode, (Object)mdmProductMaterialReqVo.getMaterialCode())).one())) != null) {
            respVo = (MdmProductMaterialRespVo)CrmBeanUtil.copy((Object)((Object)one), MdmProductMaterialRespVo.class);
            MdmMaterialEntity material = (MdmMaterialEntity)((Object)((LambdaQueryChainWrapper)this.mdmMaterialService.lambdaQuery().eq(MdmMaterialEntity::getMaterialCode, (Object)one.getMaterialCode())).one());
            if (material != null) {
                CrmBeanUtil.copyProperties((Object)((Object)material), (Object)respVo);
            }
        }
        return respVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmProductMaterialReqVo mdmProductMaterialReqVo) {
        MdmProductMaterialEntity entity = (MdmProductMaterialEntity)((Object)CrmBeanUtil.copy((Object)mdmProductMaterialReqVo, MdmProductMaterialEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmProductMaterialReqVo mdmProductMaterialReqVo) {
        MdmProductMaterialEntity entity = (MdmProductMaterialEntity)((Object)this.getById((Serializable)((Object)mdmProductMaterialReqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmProductMaterialReqVo mdmProductMaterialReqVo) {
        List mdmProductMaterialEntities = this.mdmProductMaterialMapper.selectBatchIds(mdmProductMaterialReqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmProductMaterialEntities)) {
            mdmProductMaterialEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(mdmProductMaterialEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(MdmProductMaterialReqVo mdmProductMaterialReqVo) {
        List mdmProductMaterialEntities = this.mdmProductMaterialMapper.selectBatchIds(mdmProductMaterialReqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmProductMaterialEntities)) {
            mdmProductMaterialEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(mdmProductMaterialEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(MdmProductMaterialReqVo mdmProductMaterialReqVo) {
        List mdmProductMaterialEntities = this.mdmProductMaterialMapper.selectBatchIds(mdmProductMaterialReqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmProductMaterialEntities)) {
            mdmProductMaterialEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(mdmProductMaterialEntities);
    }
}

