/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dict.service.impl;

import com.alibaba.excel.util.CollectionUtils;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.dict.entity.DictEntity;
import com.biz.crm.dict.mapper.DictMapper;
import com.biz.crm.dict.service.DictService;
import com.biz.crm.nebular.mdm.dict.resp.DictRespVo;
import com.biz.crm.util.CrmBeanUtil;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class DictServiceImpl
extends ServiceImpl<DictMapper, DictEntity>
implements DictService {
    private final DictMapper dictMapper;

    @Autowired
    public DictServiceImpl(DictMapper dictMapper) {
        this.dictMapper = dictMapper;
    }

    @Override
    public DictEntity one(String typeCode, String dictCode) {
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)Wrappers.query().eq((Object)"a.dict_code", (Object)typeCode)).eq((Object)"b.dict_value", (Object)dictCode);
        return this.dictMapper.one((QueryWrapper<DictEntity>)wrapper);
    }

    @Override
    public Map<String, String> list(String typeCode) {
        return Optional.of(this.dictMapper.list((QueryWrapper<DictEntity>)((QueryWrapper)Wrappers.query().eq((Object)"a.dict_code", (Object)typeCode))).stream().collect(Collectors.toMap(DictEntity::getDictValue, DictEntity::getDictKey))).orElse(Collections.emptyMap());
    }

    @Override
    public List<DictRespVo> typeList(List<String> typeCodeList) {
        if (CollectionUtils.isEmpty(typeCodeList)) {
            return Collections.emptyList();
        }
        List<DictEntity> list = this.dictMapper.list((QueryWrapper<DictEntity>)((QueryWrapper)Wrappers.query().in((Object)"a.dict_code", typeCodeList)));
        return CrmBeanUtil.copyList(list, DictRespVo.class);
    }
}

