/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dict.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.dict.entity.MdmDictAttrEntity;
import com.biz.crm.dict.mapper.MdmDictAttrMapper;
import com.biz.crm.dict.service.MdmDictAttrService;
import com.biz.crm.dict.service.MdmDictTypeService;
import com.biz.crm.nebular.mdm.dict.dictattr.req.MdmDictAttrPageReqVo;
import com.biz.crm.nebular.mdm.dict.dictattr.req.MdmDictAttrReqVo;
import com.biz.crm.nebular.mdm.dict.dictattr.resp.MdmDictAttrPageRespVo;
import com.biz.crm.nebular.mdm.dict.dicttype.req.MdmDictTypePageReqVo;
import com.biz.crm.nebular.mdm.dict.dicttype.resp.MdmDictTypePageRespVo;
import com.biz.crm.nebular.mdm.dict.enums.MdmDictAttrEnum;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.context.annotation.Lazy;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class MdmDictAttrServiceImpl
extends ServiceImpl<MdmDictAttrMapper, MdmDictAttrEntity>
implements MdmDictAttrService {
    @Lazy
    @Resource
    private MdmDictTypeService mdmDictTypeService;
    @Resource
    private MdmDictAttrMapper mdmDictAttrMapper;

    @Override
    public void addOrUpdate(MdmDictAttrReqVo mdmDictAttrReqVo) {
        this.checkAttr(mdmDictAttrReqVo);
        MdmDictTypePageRespVo one = this.mdmDictTypeService.one(new MdmDictTypePageReqVo().setDictTypeCode(mdmDictAttrReqVo.getDictTypeCode()));
        Assert.notNull((Object)one, (String)"\u5b57\u5178\u5206\u7c7b\u4e0d\u5b58\u5728");
        MdmDictAttrEntity entity = (MdmDictAttrEntity)((Object)CrmBeanUtil.copy((Object)mdmDictAttrReqVo, MdmDictAttrEntity.class));
        this.saveOrUpdate((Object)entity);
    }

    private void checkAttr(MdmDictAttrReqVo mdmDictAttrReqVo) {
        Assert.hasText((String)mdmDictAttrReqVo.getDictTypeCode(), (String)"\u5b57\u5178\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)mdmDictAttrReqVo.getFieldCode(), (String)"\u5c5e\u6027\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)mdmDictAttrReqVo.getFieldName(), (String)"\u5c5e\u6027\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((mdmDictAttrReqVo.getShowOrder() != null && mdmDictAttrReqVo.getShowOrder() > 0 ? 1 : 0) != 0, (String)"\u5c5e\u6027\u6392\u5e8f\u5fc5\u987b\u662f\u6b63\u6570");
        Assert.isTrue((!MdmDictAttrEnum.getAllCode().contains(mdmDictAttrReqVo.getFieldCode()) ? 1 : 0) != 0, (String)"\u5c5e\u6027\u7f16\u7801\u5df2\u5b58\u5728");
        mdmDictAttrReqVo.setId(mdmDictAttrReqVo.getDictTypeCode() + mdmDictAttrReqVo.getFieldCode());
        if (StringUtils.isEmpty((String)mdmDictAttrReqVo.getShowModel())) {
            mdmDictAttrReqVo.setShowModel("1");
        }
        if (StringUtils.isEmpty((String)mdmDictAttrReqVo.getIsDefault())) {
            mdmDictAttrReqVo.setIsDefault("1");
        }
    }

    @Override
    public List<MdmDictAttrPageRespVo> list(String dictTypeCode) {
        if (StringUtils.isEmpty((String)dictTypeCode)) {
            return Collections.emptyList();
        }
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmDictAttrEntity::getDictTypeCode, (Object)dictTypeCode)).list();
        return CrmBeanUtil.copyList((List)list, MdmDictAttrPageRespVo.class);
    }

    @Override
    public PageResult<MdmDictAttrPageRespVo> pageCondition(MdmDictAttrPageReqVo mdmDictAttrPageReqVo) {
        Page page = new Page((long)mdmDictAttrPageReqVo.getPageNum().intValue(), (long)mdmDictAttrPageReqVo.getPageSize().intValue());
        String dictTypeCode = mdmDictAttrPageReqVo.getDictTypeCode();
        Assert.hasText((String)dictTypeCode, (String)"\u5b57\u5178\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().like(!StringUtils.isEmpty((String)mdmDictAttrPageReqVo.getFieldCode()), (Object)"field_code", (Object)mdmDictAttrPageReqVo.getFieldCode())).eq((Object)"dict_type_code", (Object)dictTypeCode)).eq((Object)"is_default", (Object)"1");
        List<MdmDictAttrPageRespVo> list = this.mdmDictAttrMapper.findList((Page<MdmDictAttrPageRespVo>)page, (QueryWrapper<MdmDictAttrPageRespVo>)wrapper);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public void initial(String dictTypeCode) {
        MdmDictAttrEntity attrKey = new MdmDictAttrEntity();
        attrKey.setDictTypeCode(dictTypeCode);
        attrKey.setShowModel("1");
        attrKey.setFieldCode(MdmDictAttrEnum.MDM_DICT_KEY.getCode());
        attrKey.setFieldName(MdmDictAttrEnum.MDM_DICT_KEY.getVal());
        attrKey.setShowOrder(-4);
        attrKey.setIsDefault("0");
        attrKey.setId(dictTypeCode + MdmDictAttrEnum.MDM_DICT_KEY.getCode());
        MdmDictAttrEntity attrVal = new MdmDictAttrEntity();
        attrVal.setDictTypeCode(dictTypeCode);
        attrVal.setShowModel("1");
        attrVal.setFieldCode(MdmDictAttrEnum.MDM_DICT_VAL.getCode());
        attrVal.setFieldName(MdmDictAttrEnum.MDM_DICT_VAL.getVal());
        attrVal.setShowOrder(-3);
        attrVal.setIsDefault("0");
        attrVal.setId(dictTypeCode + MdmDictAttrEnum.MDM_DICT_VAL.getCode());
        MdmDictAttrEntity attrDesc = new MdmDictAttrEntity();
        attrDesc.setDictTypeCode(dictTypeCode);
        attrDesc.setShowModel("1");
        attrDesc.setFieldCode(MdmDictAttrEnum.MDM_DICT_DESC.getCode());
        attrDesc.setFieldName(MdmDictAttrEnum.MDM_DICT_DESC.getVal());
        attrDesc.setShowOrder(-2);
        attrDesc.setIsDefault("0");
        attrDesc.setId(dictTypeCode + MdmDictAttrEnum.MDM_DICT_DESC.getCode());
        MdmDictAttrEntity attrOrder = new MdmDictAttrEntity();
        attrOrder.setDictTypeCode(dictTypeCode);
        attrOrder.setShowModel("1");
        attrOrder.setFieldCode(MdmDictAttrEnum.MDM_DICT_ORDER.getCode());
        attrOrder.setFieldName(MdmDictAttrEnum.MDM_DICT_ORDER.getVal());
        attrOrder.setShowOrder(-1);
        attrOrder.setIsDefault("0");
        attrOrder.setId(dictTypeCode + MdmDictAttrEnum.MDM_DICT_ORDER.getCode());
        for (MdmDictAttrEntity mdmDictAttrEntity : Arrays.asList(attrKey, attrVal, attrDesc, attrOrder)) {
            this.saveOrUpdate((Object)mdmDictAttrEntity);
        }
    }

    @Override
    public void remove(MdmDictAttrReqVo mdmDictAttrReqVo) {
        List ids = mdmDictAttrReqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"\u5c5e\u6027id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, (Collection)ids)).eq(MdmDictAttrEntity::getIsDefault, (Object)"1")).remove();
    }

    @Override
    public MdmDictAttrPageRespVo attrDetail(MdmDictAttrPageReqVo mdmDictAttrPageReqVo) {
        String fieldCode = mdmDictAttrPageReqVo.getFieldCode();
        Assert.hasText((String)fieldCode, (String)"\u5b57\u5178\u5206\u7c7b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        QueryWrapper wrapper = (QueryWrapper)Wrappers.query().eq((Object)"field_code", (Object)fieldCode);
        return this.mdmDictAttrMapper.condition((QueryWrapper<MdmDictAttrPageRespVo>)wrapper);
    }
}

