/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.positioncustomerorg.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.positioncustomerorg.MdmPositionCustomerOrgPageReqVo;
import com.biz.crm.nebular.mdm.positioncustomerorg.MdmPositionCustomerOrgRespVo;
import com.biz.crm.nebular.mdm.positioncustomerorg.MdmPositionCustomerOrgUpdateReqVo;
import com.biz.crm.positioncustomerorg.mapper.MdmPositionCustomerOrgMapper;
import com.biz.crm.positioncustomerorg.model.MdmPositionCustomerOrgEntity;
import com.biz.crm.positioncustomerorg.service.MdmPositionCustomerOrgService;
import com.biz.crm.util.PageUtil;
import io.jsonwebtoken.lang.Assert;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"MdmPositionCustomerOrgServiceExpandImpl"})
public class MdmPositionCustomerOrgServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmPositionCustomerOrgMapper, MdmPositionCustomerOrgEntity>
implements MdmPositionCustomerOrgService {
    private static final Logger log = LoggerFactory.getLogger(MdmPositionCustomerOrgServiceImpl.class);
    @Resource
    private MdmPositionCustomerOrgMapper mdmPositionCustomerOrgMapper;

    @Override
    public PageResult<MdmPositionCustomerOrgRespVo> unRelationPage(MdmPositionCustomerOrgPageReqVo mdmPositionCustomerOrgPageReqVo) {
        String customerOrgCode = mdmPositionCustomerOrgPageReqVo.getCustomerOrgCode();
        Assert.hasText((String)customerOrgCode, (String)"\u5ba2\u6237\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Page page = PageUtil.buildPage((Integer)mdmPositionCustomerOrgPageReqVo.getPageNum(), (Integer)mdmPositionCustomerOrgPageReqVo.getPageSize());
        List<String> positionCodeList = this.mdmPositionCustomerOrgMapper.findRelationPosition(customerOrgCode);
        mdmPositionCustomerOrgPageReqVo.setPositionCodeList(positionCodeList);
        List<MdmPositionCustomerOrgRespVo> data = this.mdmPositionCustomerOrgMapper.unRelationPage(page, mdmPositionCustomerOrgPageReqVo);
        return PageResult.builder().data(data).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public List<MdmPositionCustomerOrgRespVo> relationList(MdmPositionCustomerOrgPageReqVo mdmPositionCustomerOrgPageReqVo) {
        Assert.hasText((String)mdmPositionCustomerOrgPageReqVo.getCustomerOrgCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        return this.mdmPositionCustomerOrgMapper.relationList(mdmPositionCustomerOrgPageReqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void add(MdmPositionCustomerOrgUpdateReqVo mdmPositionCustomerOrgUpdateReqVo) {
        String customerOrgCode = mdmPositionCustomerOrgUpdateReqVo.getCustomerOrgCode();
        List positionCodeList = mdmPositionCustomerOrgUpdateReqVo.getPositionCodeList();
        Assert.hasText((String)customerOrgCode, (String)"\u5ba2\u6237\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)positionCodeList, (String)"\u804c\u4f4d\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        List collect = positionCodeList.stream().map(positionCode -> {
            MdmPositionCustomerOrgEntity mdmPositionCustomerOrgEntity = new MdmPositionCustomerOrgEntity();
            mdmPositionCustomerOrgEntity.setPositionCode((String)positionCode);
            mdmPositionCustomerOrgEntity.setCustomerOrgCode(customerOrgCode);
            mdmPositionCustomerOrgEntity.setId(positionCode + customerOrgCode);
            return mdmPositionCustomerOrgEntity;
        }).collect(Collectors.toList());
        this.saveOrUpdateBatch(collect);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void remove(MdmPositionCustomerOrgUpdateReqVo mdmPositionCustomerOrgUpdateReqVo) {
        String customerOrgCode = mdmPositionCustomerOrgUpdateReqVo.getCustomerOrgCode();
        List positionCodeList = mdmPositionCustomerOrgUpdateReqVo.getPositionCodeList();
        Assert.hasText((String)customerOrgCode, (String)"\u5ba2\u6237\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)positionCodeList, (String)"\u804c\u4f4d\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmPositionCustomerOrgEntity::getCustomerOrgCode, (Object)customerOrgCode)).in(MdmPositionCustomerOrgEntity::getPositionCode, (Collection)positionCodeList)).remove();
    }
}

