/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.priceconditiongroup.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.eunm.GlobalWhetherEnum;
import com.biz.crm.nebular.mdm.priceconditiongroup.req.MdmPriceConditionGroupReqVo;
import com.biz.crm.nebular.mdm.priceconditiongroup.resp.MdmPriceConditionGroupRelFieldRespVo;
import com.biz.crm.nebular.mdm.priceconditiongroup.resp.MdmPriceConditionGroupRespVo;
import com.biz.crm.priceconditiongroup.mapper.MdmPriceConditionGroupMapper;
import com.biz.crm.priceconditiongroup.mapper.MdmPriceConditionGroupRelFieldMapper;
import com.biz.crm.priceconditiongroup.model.MdmPriceConditionGroupEntity;
import com.biz.crm.priceconditiongroup.model.MdmPriceConditionGroupRelFieldEntity;
import com.biz.crm.priceconditiongroup.service.IMdmPriceConditionGroupService;
import com.biz.crm.priceconditiongroup.service.impl.MdmPriceConditionGroupRelFieldServiceImpl;
import com.biz.crm.priceconditiongroup.service.impl.PriceConditionGroupServiceHelper;
import com.biz.crm.util.AssertUtils;
import com.biz.crm.util.CrmBeanUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"MdmPriceConditionGroupServiceExpandImpl"})
public class MdmPriceConditionGroupServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmPriceConditionGroupMapper, MdmPriceConditionGroupEntity>
implements IMdmPriceConditionGroupService {
    private static final Logger log = LoggerFactory.getLogger(MdmPriceConditionGroupServiceImpl.class);
    @Resource
    private MdmPriceConditionGroupMapper mdmPriceConditionGroupMapper;
    @Resource
    private MdmPriceConditionGroupRelFieldMapper mdmPriceConditionGroupRelFieldMapper;
    @Resource
    private PriceConditionGroupServiceHelper priceConditionGroupServiceHelper;
    @Resource
    private MdmPriceConditionGroupRelFieldServiceImpl mdmPriceConditionGroupRelFieldService;

    @Override
    public PageResult<MdmPriceConditionGroupRespVo> findList(MdmPriceConditionGroupReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<MdmPriceConditionGroupRespVo> list = this.mdmPriceConditionGroupMapper.findList((Page<MdmPriceConditionGroupRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmPriceConditionGroupRespVo query(MdmPriceConditionGroupReqVo reqVo) {
        MdmPriceConditionGroupEntity mdmPriceConditionGroupEntity = (MdmPriceConditionGroupEntity)((Object)this.mdmPriceConditionGroupMapper.selectById((Serializable)((Object)reqVo.getId())));
        AssertUtils.isNotNull((Object)((Object)mdmPriceConditionGroupEntity), (String)"\u8be5\u6761\u6570\u636e\u5728\u6570\u636e\u5e93\u4e2d\u4e0d\u5b58\u5728");
        reqVo.setConditionGroupCode(mdmPriceConditionGroupEntity.getConditionGroupCode());
        MdmPriceConditionGroupRespVo mdmPriceConditionGroupRespVo = (MdmPriceConditionGroupRespVo)CrmBeanUtil.copy((Object)((Object)mdmPriceConditionGroupEntity), MdmPriceConditionGroupRespVo.class);
        List mdmPriceConditionGroupRelFieldEntityList = this.mdmPriceConditionGroupRelFieldMapper.selectList((Wrapper)Wrappers.lambdaQuery().eq(MdmPriceConditionGroupRelFieldEntity::getConditionGroupCode, (Object)reqVo.getConditionGroupCode()));
        List mdmPriceConditionGroupRelFieldRespVos = CrmBeanUtil.copyList((List)mdmPriceConditionGroupRelFieldEntityList, MdmPriceConditionGroupRelFieldRespVo.class);
        mdmPriceConditionGroupRespVo.setConditionFieldList(mdmPriceConditionGroupRelFieldRespVos);
        return mdmPriceConditionGroupRespVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmPriceConditionGroupReqVo reqVo) {
        this.priceConditionGroupServiceHelper.saveCheck(reqVo);
        MdmPriceConditionGroupEntity entity = (MdmPriceConditionGroupEntity)((Object)CrmBeanUtil.copy((Object)reqVo, MdmPriceConditionGroupEntity.class));
        entity.setIsRelated(GlobalWhetherEnum.NO.getCode());
        this.save((Object)entity);
        this.priceConditionGroupServiceHelper.saveOrUpdatePriceConditionGroupRelFields(reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmPriceConditionGroupReqVo reqVo) {
        this.priceConditionGroupServiceHelper.editCheck(reqVo);
        MdmPriceConditionGroupEntity entity = (MdmPriceConditionGroupEntity)((Object)CrmBeanUtil.copy((Object)reqVo, MdmPriceConditionGroupEntity.class));
        this.updateById((Object)entity);
        this.priceConditionGroupServiceHelper.saveOrUpdatePriceConditionGroupRelFields(reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmPriceConditionGroupReqVo reqVo) {
        AssertUtils.isNotEmpty((Collection)reqVo.getIds(), (String)"\u8bf7\u9009\u62e9\u9700\u8981\u5220\u9664\u7684\u6570\u636e");
        List mdmPriceConditionGroupEntities = this.mdmPriceConditionGroupMapper.selectBatchIds(reqVo.getIds());
        String conditionGroupCodeStr = mdmPriceConditionGroupEntities.stream().filter(entity -> StringUtils.equals((CharSequence)GlobalWhetherEnum.YES.getCode(), (CharSequence)entity.getIsRelated())).map(MdmPriceConditionGroupEntity::getConditionGroupCode).collect(Collectors.joining(","));
        AssertUtils.isTrue((boolean)StringUtils.isBlank((CharSequence)conditionGroupCodeStr), (String)("\u6761\u4ef6\u5b57\u6bb5\u7f16\u7801\u4e3a{" + conditionGroupCodeStr + "}\u7684\u6570\u636e\u5173\u8054\u4e86\u6761\u4ef6\u7c7b\u578b\uff0c\u4e0d\u80fd\u5220\u9664\uff01"));
        this.mdmPriceConditionGroupMapper.deleteByParams(reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(MdmPriceConditionGroupReqVo reqVo) {
        List mdmPriceConditionGroupEntities = this.mdmPriceConditionGroupMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmPriceConditionGroupEntities)) {
            mdmPriceConditionGroupEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(mdmPriceConditionGroupEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(MdmPriceConditionGroupReqVo reqVo) {
        List mdmPriceConditionGroupEntities = this.mdmPriceConditionGroupMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmPriceConditionGroupEntities)) {
            mdmPriceConditionGroupEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(mdmPriceConditionGroupEntities);
    }
}

