/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.engineform.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.dict.service.IEngineDictItemService;
import com.biz.crm.dict.service.IEngineDictService;
import com.biz.crm.engineform.mapper.EngineFormListTemplateMapper;
import com.biz.crm.engineform.model.EngineFormListTemplateEntity;
import com.biz.crm.engineform.service.IEngineFormListTemplateService;
import com.biz.crm.nebular.mdm.dict.req.EngineDictItemReqVo;
import com.biz.crm.nebular.mdm.dict.req.EngineDictReqVo;
import com.biz.crm.nebular.mdm.dict.resp.EngineDictItemRespVo;
import com.biz.crm.nebular.mdm.dict.resp.EngineDictRespVo;
import com.biz.crm.nebular.mdm.engineform.req.EngineFormListTemplateReqVo;
import com.biz.crm.nebular.mdm.engineform.resp.EngineFormListTemplateRespVo;
import com.biz.crm.util.CrmBeanUtil;
import io.jsonwebtoken.lang.Assert;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"EngineFormListTemplateServiceExpandImpl"})
public class EngineFormListTemplateServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<EngineFormListTemplateMapper, EngineFormListTemplateEntity>
implements IEngineFormListTemplateService {
    private static final Logger log = LoggerFactory.getLogger(EngineFormListTemplateServiceImpl.class);
    @Resource
    private EngineFormListTemplateMapper engineFormListTemplateMapper;
    @Resource
    private IEngineDictItemService engineDictItemService;
    @Resource
    private IEngineDictService engineDictService;

    @Override
    public PageResult<EngineFormListTemplateRespVo> findList(EngineFormListTemplateReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<EngineFormListTemplateRespVo> list = this.engineFormListTemplateMapper.findList((Page<EngineFormListTemplateRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public EngineFormListTemplateRespVo query(EngineFormListTemplateReqVo reqVo) {
        return this.engineFormListTemplateMapper.query(reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(EngineFormListTemplateReqVo reqVo) {
        EngineFormListTemplateEntity entity = (EngineFormListTemplateEntity)CrmBeanUtil.copy((Object)reqVo, EngineFormListTemplateEntity.class);
        this.save(entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(EngineFormListTemplateReqVo reqVo) {
        EngineFormListTemplateEntity entity = (EngineFormListTemplateEntity)this.getById((Serializable)((Object)reqVo.getId()));
        this.updateById(entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(EngineFormListTemplateReqVo reqVo) {
        List engineFormListTemplateEntities = this.engineFormListTemplateMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)engineFormListTemplateEntities)) {
            engineFormListTemplateEntities.forEach(o -> o.setTStatus(0));
        }
        this.updateBatchById(engineFormListTemplateEntities);
    }

    @Override
    public List<EngineFormListTemplateRespVo> activityFormList() {
        EngineDictRespVo respVo = this.engineDictService.query(new EngineDictReqVo().setDictCode("act_detail_prefix"));
        Assert.notNull((Object)respVo, (String)"\u67e5\u8be2\u5bf9\u5e94\u8868\u5355\u5931\u8d25\uff01");
        List<EngineDictItemRespVo> engineDictItemRespVos = this.engineDictItemService.tree(new EngineDictItemReqVo().setDictEntityId(respVo.getId()));
        Assert.notNull(engineDictItemRespVos, (String)"\u67e5\u8be2\u5bf9\u5e94\u8868\u5355\u5931\u8d25\uff01");
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery().eq(EngineFormListTemplateEntity::getTStatus, (Object)1);
        for (EngineDictItemRespVo resp : engineDictItemRespVos) {
            wrapper.like(EngineFormListTemplateEntity::getCode, (Object)resp.getDictValue());
        }
        List engineFormListTemplateEntities = this.engineFormListTemplateMapper.selectList((Wrapper)wrapper);
        return CrmBeanUtil.copyList((List)engineFormListTemplateEntities, EngineFormListTemplateRespVo.class);
    }
}

