/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.permission.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.mdm.permission.MdmDataPermissionReqVo;
import com.biz.crm.nebular.mdm.permission.MdmDataPermissionRespVo;
import com.biz.crm.permission.mapper.MdmDataPermissionMapper;
import com.biz.crm.permission.model.MdmDataPermissionEntity;
import com.biz.crm.permission.service.IMdmDataPermissionService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.utils.DatabaseTypeUtil;
import io.jsonwebtoken.lang.Assert;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"MdmDataPermissionServiceExpandImpl"})
public class MdmDataPermissionServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmDataPermissionMapper, MdmDataPermissionEntity>
implements IMdmDataPermissionService {
    private static final Logger log = LoggerFactory.getLogger(MdmDataPermissionServiceImpl.class);
    @Resource
    private MdmDataPermissionMapper mdmDataPermissionMapper;

    @Override
    @CrmDictMethod
    public PageResult<MdmDataPermissionRespVo> findList(MdmDataPermissionReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmDataPermissionRespVo> list = this.mdmDataPermissionMapper.findList((Page<MdmDataPermissionRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmDataPermissionRespVo query(MdmDataPermissionReqVo reqVo) {
        MdmDataPermissionEntity one = (MdmDataPermissionEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(!StringUtils.isEmpty((String)reqVo.getFormInstanceId()), CrmBaseEntity::getFormInstanceId, (Object)reqVo.getFormInstanceId())).last(DatabaseTypeUtil.SEGMENT)).one());
        return (MdmDataPermissionRespVo)CrmBeanUtil.copy((Object)((Object)one), MdmDataPermissionRespVo.class);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmDataPermissionReqVo reqVo) {
        String listConfigCode = reqVo.getListConfigCode();
        Assert.hasText((String)listConfigCode, (String)"\u5217\u8868\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        String permissionDimension = reqVo.getPermissionDimension();
        Assert.hasText((String)permissionDimension, (String)"\u6743\u9650\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
        String competenceCode = reqVo.getCompetenceCode();
        Assert.hasText((String)competenceCode, (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        switch (permissionDimension) {
            case "role": {
                String roleCode = reqVo.getRoleCode();
                Assert.hasText((String)roleCode, (String)"\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                reqVo.setId(roleCode + permissionDimension + listConfigCode + competenceCode);
                break;
            }
            case "org": {
                String orgCode = reqVo.getOrgCode();
                Assert.hasText((String)orgCode, (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                reqVo.setId(orgCode + permissionDimension + listConfigCode + competenceCode);
                break;
            }
            default: {
                throw new BusinessException("\u4e0d\u652f\u6301\u7684\u7ef4\u5ea6\u7c7b\u578b");
            }
        }
        MdmDataPermissionEntity entity = (MdmDataPermissionEntity)((Object)CrmBeanUtil.copy((Object)reqVo, MdmDataPermissionEntity.class));
        this.saveOrUpdate((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmDataPermissionReqVo reqVo) {
        this.save(reqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmDataPermissionReqVo reqVo) {
        List ids = reqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, (Collection)ids)).remove();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(MdmDataPermissionReqVo reqVo) {
        List<String> ids = this.valid(reqVo);
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, ids)).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).select(new SFunction[]{BaseIdEntity::getId}).list();
        Assert.isTrue((ids.size() == list.size() ? 1 : 0) != 0, (String)"\u53ea\u80fd\u542f\u7528\u72b6\u6001\u4e3a\u201d\u7981\u7528\u201c\u7684\u6570\u636e\u6743\u9650");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, ids)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).update();
    }

    private List<String> valid(MdmDataPermissionReqVo reqVo) {
        List ids = reqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        String id = (String)ids.get(0);
        Assert.hasText((String)id, (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        return ids;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(MdmDataPermissionReqVo reqVo) {
        List<String> ids = this.valid(reqVo);
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(BaseIdEntity::getId, ids)).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).select(new SFunction[]{BaseIdEntity::getId}).list();
        Assert.isTrue((ids.size() == list.size() ? 1 : 0) != 0, (String)"\u53ea\u80fd\u7981\u7528\u72b6\u6001\u4e3a\u201d\u542f\u7528\u201c\u7684\u6570\u636e\u6743\u9650");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, ids)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
    }

    @Override
    public MdmDataPermissionRespVo queryCondition(MdmDataPermissionReqVo mdmDataPermissionReqVo) {
        String competenceCode = mdmDataPermissionReqVo.getCompetenceCode();
        Assert.hasText((String)competenceCode, (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        String listConfigCode = mdmDataPermissionReqVo.getListConfigCode();
        String permissionDimension = mdmDataPermissionReqVo.getPermissionDimension();
        Assert.hasText((String)permissionDimension, (String)"\u6743\u9650\u7ef4\u5ea6\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)listConfigCode, (String)"\u5217\u8868\u914d\u7f6e\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)Wrappers.lambdaQuery().eq(MdmDataPermissionEntity::getPermissionDimension, (Object)permissionDimension)).eq(MdmDataPermissionEntity::getListConfigCode, (Object)listConfigCode)).eq(MdmDataPermissionEntity::getCompetenceCode, (Object)competenceCode)).last(DatabaseTypeUtil.SEGMENT);
        switch (permissionDimension) {
            case "role": {
                String roleCode = mdmDataPermissionReqVo.getRoleCode();
                Assert.hasText((String)roleCode, (String)"\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                wrapper.eq(MdmDataPermissionEntity::getRoleCode, (Object)roleCode);
                break;
            }
            case "org": {
                String orgCode = mdmDataPermissionReqVo.getOrgCode();
                Assert.hasText((String)orgCode, (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
                wrapper.eq(MdmDataPermissionEntity::getOrgCode, (Object)orgCode);
                break;
            }
            default: {
                throw new BusinessException("\u4e0d\u652f\u6301\u7684\u7ef4\u5ea6\u7c7b\u578b");
            }
        }
        MdmDataPermissionEntity one = (MdmDataPermissionEntity)((Object)this.getOne((Wrapper)wrapper));
        return (MdmDataPermissionRespVo)CrmBeanUtil.copy((Object)((Object)one), MdmDataPermissionRespVo.class);
    }
}

