/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.productlevel.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.CrmTreeEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.material.model.MdmMaterialEntity;
import com.biz.crm.material.service.IMdmMaterialService;
import com.biz.crm.nebular.mdm.productlevel.req.MdmProductLevelReqVo;
import com.biz.crm.nebular.mdm.productlevel.req.MdmProductLevelSelectReqVo;
import com.biz.crm.nebular.mdm.productlevel.req.MdmProductLevelTreeReqVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelRespVo;
import com.biz.crm.nebular.mdm.productlevel.resp.MdmProductLevelTreeRespVo;
import com.biz.crm.productlevel.mapper.MdmProductLevelMapper;
import com.biz.crm.productlevel.model.MdmProductLevelEntity;
import com.biz.crm.productlevel.service.IMdmProductLevelService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.utils.TreeRuleCodeUtil;
import com.biz.crm.utils.TreeUtil;
import io.jsonwebtoken.lang.Assert;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
@ConditionalOnMissingBean(name={"MdmProductLevelServiceExpandImpl"})
public class MdmProductLevelServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmProductLevelMapper, MdmProductLevelEntity>
implements IMdmProductLevelService {
    private static final Logger log = LoggerFactory.getLogger(MdmProductLevelServiceImpl.class);
    @Resource
    private MdmProductLevelMapper mdmProductLevelMapper;
    @Resource
    private IMdmMaterialService mdmMaterialService;

    @Override
    public PageResult<MdmProductLevelRespVo> findList(MdmProductLevelReqVo mdmProductLevelReqVo) {
        MdmProductLevelEntity one;
        Page page = PageUtil.buildPage((Integer)mdmProductLevelReqVo.getPageNum(), (Integer)mdmProductLevelReqVo.getPageSize());
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)mdmProductLevelReqVo.getCode()) && (one = (MdmProductLevelEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmProductLevelEntity::getProductLevelCode, (Object)mdmProductLevelReqVo.getCode())).one())) != null) {
            mdmProductLevelReqVo.setRuleCode(one.getRuleCode());
        }
        List<MdmProductLevelRespVo> list = this.mdmProductLevelMapper.findList((Page<MdmProductLevelRespVo>)page, mdmProductLevelReqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmProductLevelRespVo query(String id, String productLevelCode) {
        MdmProductLevelEntity parent;
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)id) && org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)productLevelCode)) {
            throw new BusinessException("\u7f3a\u5931\u53c2\u6570");
        }
        MdmProductLevelEntity one = (MdmProductLevelEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)id), BaseIdEntity::getId, (Object)id)).eq(org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)productLevelCode), MdmProductLevelEntity::getProductLevelCode, (Object)productLevelCode)).one());
        if (one == null) {
            return null;
        }
        MdmProductLevelRespVo respVo = (MdmProductLevelRespVo)CrmBeanUtil.copy((Object)((Object)one), MdmProductLevelRespVo.class);
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)one.getParentId()) && (parent = (MdmProductLevelEntity)((Object)this.getById((Serializable)((Object)one.getParentId())))) != null) {
            respVo.setParentName(parent.getProductLevelName());
        }
        return respVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmProductLevelReqVo mdmProductLevelReqVo) {
        if (ObjectUtils.isEmpty((Object)mdmProductLevelReqVo)) {
            return;
        }
        Assert.notNull((Object)mdmProductLevelReqVo, (String)"\u7a7a\u53c2\u6570");
        Assert.hasText((String)mdmProductLevelReqVo.getProductLevelName(), (String)"\u4ea7\u54c1\u5c42\u7ea7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)mdmProductLevelReqVo.getProductLevelType(), (String)"\u4ea7\u54c1\u5c42\u7ea7\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        MdmProductLevelEntity entity = (MdmProductLevelEntity)((Object)CrmBeanUtil.copy((Object)mdmProductLevelReqVo, MdmProductLevelEntity.class));
        if (ObjectUtils.isEmpty((Object)((Object)entity))) {
            return;
        }
        if (!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)entity.getRemarks()) && entity.getRemarks().length() > 200) {
            throw new IllegalArgumentException("\u5907\u6ce8\u4e0d\u80fd\u8d85\u8fc7200");
        }
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)entity.getProductLevelCode())) {
            entity.setProductLevelCode(CodeUtil.generateCode((String)CodeRuleEnum.MDM_PRODUCT_LEVEL_CODE.getCode()));
        }
        entity.setRuleCode(this.getCodeByParentId(entity.getParentId()));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmProductLevelReqVo mdmProductLevelReqVo) {
        Assert.notNull((Object)mdmProductLevelReqVo, (String)"\u7a7a\u53c2\u6570");
        Assert.hasText((String)mdmProductLevelReqVo.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)mdmProductLevelReqVo.getProductLevelName(), (String)"\u4ea7\u54c1\u5c42\u7ea7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)mdmProductLevelReqVo.getProductLevelType(), (String)"\u4ea7\u54c1\u5c42\u7ea7\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        MdmProductLevelEntity entity = (MdmProductLevelEntity)((Object)this.getById((Serializable)((Object)mdmProductLevelReqVo.getId())));
        Assert.notNull((Object)((Object)entity), (String)"id\u65e0\u6548");
        boolean updateRuleCode = false;
        int levelNum = 1;
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)mdmProductLevelReqVo.getParentId())) {
            if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)entity.getParentId())) {
                updateRuleCode = true;
                entity.setParentId("");
            }
        } else {
            MdmProductLevelRespVo parent = this.query(mdmProductLevelReqVo.getParentId(), null);
            Assert.notNull((Object)parent, (String)"\u4e0a\u7ea7\u4ea7\u54c1\u5c42\u7ea7\u4e0d\u5b58\u5728");
            Assert.isTrue((!parent.getId().equals(entity.getId()) ? 1 : 0) != 0, (String)"\u4e0a\u7ea7\u4ea7\u54c1\u5c42\u7ea7\u4e0d\u80fd\u662f\u81ea\u5df1");
            if (!parent.getId().equals(entity.getParentId())) {
                Assert.isTrue((!entity.getRuleCode().startsWith(parent.getRuleCode()) ? 1 : 0) != 0, (String)"\u4e0a\u7ea7\u4ea7\u54c1\u5c42\u7ea7\u4e0d\u80fd\u662f\u5f53\u524d\u5c42\u7ea7\u7684\u4e0b\u7ea7");
                entity.setParentId(parent.getId());
                updateRuleCode = true;
                levelNum = parent.getLevelNum() + 1;
            }
        }
        entity.setProductLevelType(mdmProductLevelReqVo.getProductLevelType());
        entity.setProductLevelName(mdmProductLevelReqVo.getProductLevelName());
        entity.setRemarks(mdmProductLevelReqVo.getRemarks());
        this.updateById((Object)entity);
        if (updateRuleCode) {
            String ruleCode = this.getCodeByParentId(entity.getParentId());
            this.updateCurAndChildren(entity.getId(), ruleCode, levelNum);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmProductLevelReqVo mdmProductLevelReqVo) {
        List ids = mdmProductLevelReqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"\u53c2\u6570\u4e3a\u7a7a");
        Assert.isTrue((ids.size() == 1 ? 1 : 0) != 0, (String)"\u4ea7\u54c1\u5c42\u7ea7\u4e0d\u652f\u6301\u6279\u91cf\u5220\u9664");
        ids.forEach(id -> {
            Assert.hasText((String)id, (String)"\u4e0d\u80fd\u4f20\u7a7a\u503c");
            MdmProductLevelEntity entity = (MdmProductLevelEntity)((Object)((Object)this.getById((Serializable)((Object)id))));
            Assert.notNull((Object)((Object)entity), (String)"\u65e0\u6548\u7684id");
            List children = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmProductLevelEntity::getParentId, (Object)entity.getId())).list();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)children)) {
                throw new BusinessException("\u5f53\u524d\u4ea7\u54c1\u5c42\u7ea7\u5305\u542b\u5b50\u5c42\u7ea7\uff0c\u65e0\u6cd5\u5220\u9664\uff0c\u82e5\u9700\u8981\u5220\u9664\u8bf7\u5148\u5220\u9664\u5b50\u5c42\u7ea7");
            }
            List materialList = ((LambdaQueryChainWrapper)this.mdmMaterialService.lambdaQuery().eq(MdmMaterialEntity::getProductLevelCode, (Object)entity.getProductLevelCode())).list();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)materialList)) {
                throw new BusinessException("\u5f53\u524d\u4ea7\u54c1\u5c42\u7ea7\u5df2\u5173\u8054\u7269\u6599\uff0c\u65e0\u6cd5\u5220\u9664\uff0c\u82e5\u9700\u8981\u5220\u9664\u8bf7\u5148\u5220\u9664\u5173\u8054\u7269\u6599");
            }
        });
        this.removeByIds(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(MdmProductLevelReqVo mdmProductLevelReqVo) {
        List ids = mdmProductLevelReqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"\u7f3a\u5931\u53c2\u6570");
        Assert.isTrue((ids.size() == 1 ? 1 : 0) != 0, (String)"\u4ea7\u54c1\u5c42\u7ea7\u4e0d\u652f\u6301\u6279\u91cf\u542f\u7528");
        ids.forEach(id -> {
            Assert.hasText((String)id, (String)"\u4e0d\u80fd\u4f20\u7a7a\u503c");
            MdmProductLevelEntity entity = (MdmProductLevelEntity)((Object)((Object)this.getById((Serializable)((Object)id))));
            Assert.notNull((Object)((Object)entity), (String)"\u65e0\u6548\u7684id");
            Assert.isTrue((boolean)CrmEnableStatusEnum.ENABLE.getCode().equals(entity.getEnableStatus()), (String)"\u8be5\u4ea7\u54c1\u5c42\u7ea7\u5df2\u7ecf\u662f\u542f\u7528\u72b6\u6001\uff0c\u4e0d\u80fd\u518d\u542f\u7528");
            List<MdmProductLevelRespVo> parentList = this.getParentList((String)id, null);
            if (CollectionUtil.listNotEmptyNotSizeZero(parentList)) {
                parentList.forEach(item -> Assert.isTrue((boolean)CrmEnableStatusEnum.ENABLE.getCode().equals(item.getEnableStatus()), (String)"\u4ea7\u54c1\u5c42\u7ea7\u4e0a\u7ea7\u5b58\u5728\u672a\u542f\u7528\u7684\u4ea7\u54c1\u5c42\u7ea7\uff0c\u8bf7\u5148\u542f\u7528"));
            }
            entity.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
            this.updateById((Object)entity);
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(MdmProductLevelReqVo mdmProductLevelReqVo) {
        List ids = mdmProductLevelReqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"\u7f3a\u5931\u53c2\u6570");
        Assert.isTrue((ids.size() == 1 ? 1 : 0) != 0, (String)"\u4ea7\u54c1\u5c42\u7ea7\u4e0d\u652f\u6301\u6279\u91cf\u7981\u7528");
        ids.forEach(id -> {
            Assert.hasText((String)id, (String)"\u4e0d\u80fd\u4f20\u7a7a\u503c");
            MdmProductLevelEntity entity = (MdmProductLevelEntity)((Object)((Object)this.getById((Serializable)((Object)id))));
            Assert.notNull((Object)((Object)entity), (String)"\u65e0\u6548\u7684id");
            Assert.isTrue((boolean)CrmEnableStatusEnum.DISABLE.getCode().equals(entity.getEnableStatus()), (String)"\u8be5\u4ea7\u54c1\u5c42\u7ea7\u5df2\u7ecf\u662f\u7981\u7528\u72b6\u6001\uff0c\u4e0d\u80fd\u518d\u7981\u7528");
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().likeRight(MdmProductLevelEntity::getRuleCode, (Object)entity.getRuleCode())).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
        });
    }

    @Override
    public MdmProductLevelEntity findDetailsByFormInstanceId(String formInstanceId) {
        if (org.apache.commons.lang3.StringUtils.isBlank((CharSequence)formInstanceId)) {
            return null;
        }
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"form_instance_id", (Object)formInstanceId);
        MdmProductLevelEntity mdmProductLevelEntity = (MdmProductLevelEntity)((Object)this.mdmProductLevelMapper.selectOne((Wrapper)wrapper));
        if (null == mdmProductLevelEntity) {
            return null;
        }
        return mdmProductLevelEntity;
    }

    @Override
    public List<MdmProductLevelTreeRespVo> tree(MdmProductLevelTreeReqVo mdmProductLevelTreeReqVo) {
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)Wrappers.query().eq(!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)mdmProductLevelTreeReqVo.getId()), (Object)"id", (Object)mdmProductLevelTreeReqVo.getId())).like(!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)mdmProductLevelTreeReqVo.getProductLevelCode()), (Object)"product_level_code", (Object)mdmProductLevelTreeReqVo.getProductLevelCode())).eq(!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)mdmProductLevelTreeReqVo.getParentId()), (Object)"parent_id", (Object)mdmProductLevelTreeReqVo.getParentId())).eq(!org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)mdmProductLevelTreeReqVo.getProductLevelType()), (Object)"product_level_type", (Object)mdmProductLevelTreeReqVo.getProductLevelType())).eq(!ObjectUtils.isEmpty((Object)mdmProductLevelTreeReqVo.getLevelNum()), (Object)"level_num", (Object)mdmProductLevelTreeReqVo.getLevelNum());
        List<MdmProductLevelTreeRespVo> list = this.mdmProductLevelMapper.findCondition((QueryWrapper<MdmProductLevelTreeRespVo>)wrapper);
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        return list.stream().filter(x -> org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)x.getParentId())).peek(x -> x.setChildren(this.getChildren((MdmProductLevelTreeRespVo)x, list))).collect(Collectors.toList());
    }

    private List<MdmProductLevelTreeRespVo> getChildren(MdmProductLevelTreeRespVo root, List<MdmProductLevelTreeRespVo> list) {
        if (!ObjectUtils.isEmpty((Object)root) && !org.springframework.util.CollectionUtils.isEmpty(list)) {
            return list.stream().filter(x -> root.getId().equals(x.getParentId())).peek(x -> x.setChildren(this.getChildren((MdmProductLevelTreeRespVo)x, list))).collect(Collectors.toList());
        }
        return null;
    }

    private List<MdmProductLevelEntity> findParentIdByProductLevel(String parentId) {
        QueryWrapper wrapper = new QueryWrapper();
        wrapper.eq((Object)"parent_id", (Object)parentId);
        return this.mdmProductLevelMapper.selectList((Wrapper)wrapper);
    }

    @Override
    public List<String> getCurrentAndSubLevelCode(String productLevelCode) {
        List<MdmProductLevelRespVo> childrenList;
        ArrayList<String> list = new ArrayList<String>();
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)productLevelCode) && CollectionUtil.listNotEmptyNotSizeZero(childrenList = this.getChildrenList(null, productLevelCode))) {
            list.addAll(childrenList.stream().map(MdmProductLevelRespVo::getProductLevelCode).collect(Collectors.toList()));
        }
        return list;
    }

    @Override
    public List<MdmProductLevelTreeRespVo> editTree(MdmProductLevelTreeReqVo mdmProductLevelTreeReqVo) {
        List<MdmProductLevelTreeRespVo> mdmProductLevelTreeRespVos;
        String code = mdmProductLevelTreeReqVo.getProductLevelCode();
        String ruleCode = "";
        if (!StringUtils.isEmpty((Object)code)) {
            QueryWrapper wrapper = (QueryWrapper)Wrappers.query().eq((Object)"product_level_code", (Object)code);
            MdmProductLevelEntity one = (MdmProductLevelEntity)((Object)this.getOne((Wrapper)wrapper, false));
            ruleCode = Optional.ofNullable(one).map(CrmTreeEntity::getRuleCode).orElse(null);
        }
        if (!CollectionUtils.isEmpty(mdmProductLevelTreeRespVos = this.mdmProductLevelMapper.ruleNotLikeRight(ruleCode))) {
            return TreeUtil.convert(mdmProductLevelTreeRespVos, "id", "parentId", "children");
        }
        return Collections.emptyList();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void reloadRuleCode() {
        List allList = this.lambdaQuery().list();
        allList.forEach(item -> item.setRuleCode(item.getId()));
        this.updateBatchById(allList);
        List topList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().isNull(MdmProductLevelEntity::getParentId)).or()).eq(MdmProductLevelEntity::getParentId, (Object)"")).list();
        for (int i = 0; i < topList.size(); ++i) {
            this.updateCurAndChildren(((MdmProductLevelEntity)((Object)topList.get(i))).getId(), TreeRuleCodeUtil.numToSingleCode(i + 1), 1);
        }
    }

    private void updateCurAndChildren(String id, String ruleCode, int levelNum) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(BaseIdEntity::getId, (Object)id)).set(MdmProductLevelEntity::getRuleCode, (Object)ruleCode)).set(MdmProductLevelEntity::getLevelNum, (Object)levelNum)).update();
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmProductLevelEntity::getParentId, (Object)id)).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            for (int i = 0; i < list.size(); ++i) {
                this.updateCurAndChildren(((MdmProductLevelEntity)((Object)list.get(i))).getId(), ruleCode + TreeRuleCodeUtil.numToSingleCode(i + 1), levelNum + 1);
            }
        }
    }

    private String getCodeByParentId(String parentId) {
        MdmProductLevelEntity parent;
        String ruleCode = "";
        boolean top = true;
        String prefix = "";
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)parentId) && (parent = (MdmProductLevelEntity)((Object)this.getById((Serializable)((Object)parentId)))) != null) {
            top = false;
            prefix = parent.getRuleCode();
        }
        List list = null;
        list = top ? ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().isNull(MdmProductLevelEntity::getParentId)).or()).eq(MdmProductLevelEntity::getParentId, (Object)"")).list() : ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmProductLevelEntity::getParentId, (Object)parentId)).list();
        if (CollectionUtil.listEmpty((List)list)) {
            ruleCode = prefix + TreeRuleCodeUtil.numToSingleCode(1);
        } else {
            LinkedHashSet<Integer> set = new LinkedHashSet<Integer>();
            for (MdmProductLevelEntity item : list) {
                if (!org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)item.getRuleCode())) continue;
                Integer integer = Integer.valueOf(item.getRuleCode().substring(item.getRuleCode().length() - 3));
                set.add(integer);
            }
            for (int i = 1; i < 999; ++i) {
                if (set.contains(i)) continue;
                ruleCode = prefix + TreeRuleCodeUtil.numToSingleCode(i);
                break;
            }
        }
        return ruleCode;
    }

    @Override
    public List<MdmProductLevelRespVo> getParentList(String id, String productLevelCode) {
        List parentList;
        Set<String> parentRuleCodes;
        MdmProductLevelEntity one;
        ArrayList<MdmProductLevelRespVo> list = new ArrayList<MdmProductLevelRespVo>();
        if (org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)id) && org.apache.commons.lang3.StringUtils.isEmpty((CharSequence)productLevelCode) && (one = (MdmProductLevelEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)id), BaseIdEntity::getId, (Object)id)).eq(org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)productLevelCode), MdmProductLevelEntity::getProductLevelCode, (Object)productLevelCode)).one())) != null && !(parentRuleCodes = TreeRuleCodeUtil.splitParentRuleCodes(one.getRuleCode())).isEmpty() && CollectionUtil.listNotEmptyNotSizeZero((List)(parentList = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmProductLevelEntity::getRuleCode, parentRuleCodes)).list()))) {
            list.addAll(CrmBeanUtil.copyList((List)parentList, MdmProductLevelRespVo.class));
        }
        return list;
    }

    @Override
    public List<MdmProductLevelRespVo> getChildrenList(String id, String productLevelCode) {
        List children;
        MdmProductLevelEntity one;
        ArrayList<MdmProductLevelRespVo> list = new ArrayList<MdmProductLevelRespVo>();
        if ((org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)id) || org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)productLevelCode)) && (one = (MdmProductLevelEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)id), BaseIdEntity::getId, (Object)id)).eq(org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)productLevelCode), MdmProductLevelEntity::getProductLevelCode, (Object)productLevelCode)).one())) != null && CollectionUtil.listNotEmptyNotSizeZero((List)(children = ((LambdaQueryChainWrapper)this.lambdaQuery().likeRight(MdmProductLevelEntity::getRuleCode, (Object)one.getRuleCode())).list()))) {
            list.addAll(CrmBeanUtil.copyList((List)children, MdmProductLevelRespVo.class));
        }
        return list;
    }

    @Override
    public List<MdmProductLevelRespVo> productLevelSelectList(MdmProductLevelSelectReqVo reqVo) {
        List entityList;
        ArrayList<MdmProductLevelRespVo> list = new ArrayList<MdmProductLevelRespVo>();
        List<Object> underCodes = new ArrayList();
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)reqVo.getUnderProductLevelCode())) {
            underCodes = this.getCurrentAndSubLevelCode(reqVo.getUnderProductLevelCode());
        }
        List<Object> notUnderCodes = new ArrayList();
        if (org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)reqVo.getNotUnderProductLevelCode())) {
            notUnderCodes = this.getCurrentAndSubLevelCode(reqVo.getNotUnderProductLevelCode());
        }
        if (CollectionUtil.listNotEmptyNotSizeZero((List)(entityList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().like(org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)reqVo.getProductLevelCode()), MdmProductLevelEntity::getProductLevelCode, (Object)reqVo.getProductLevelCode())).like(org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)reqVo.getProductLevelName()), MdmProductLevelEntity::getProductLevelName, (Object)reqVo.getProductLevelName())).in(CollectionUtil.listNotEmptyNotSizeZero(underCodes), MdmProductLevelEntity::getProductLevelCode, underCodes)).notIn(CollectionUtil.listNotEmptyNotSizeZero(notUnderCodes), MdmProductLevelEntity::getProductLevelCode, notUnderCodes)).list()))) {
            list.addAll(CrmBeanUtil.copyList((List)entityList, MdmProductLevelRespVo.class));
        }
        return list;
    }
}

