/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.customer.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.common.PageResult;
import com.biz.crm.customer.base.CustomerTerminalQueryContext;
import com.biz.crm.customer.mapper.MdmCustomerTerminalMapper;
import com.biz.crm.customer.model.MdmCustomerTerminalEntity;
import com.biz.crm.customer.service.IMdmCustomerTerminalService;
import com.biz.crm.nebular.mdm.customer.MdmCustomerCorrelatedTerminalReplaceReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerCorrelatedTerminalReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerTerminalReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerTerminalRespVo;
import com.biz.crm.utils.DatabaseTypeUtil;
import io.jsonwebtoken.lang.Assert;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
@ConditionalOnMissingBean(name={"MdmCustomerTerminalServiceExpandImpl"})
public class MdmCustomerTerminalServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmCustomerTerminalMapper, MdmCustomerTerminalEntity>
implements IMdmCustomerTerminalService {
    private static final Logger log = LoggerFactory.getLogger(MdmCustomerTerminalServiceImpl.class);
    private final CustomerTerminalQueryContext customerTerminalQueryContext;

    @Autowired
    public MdmCustomerTerminalServiceImpl(CustomerTerminalQueryContext customerTerminalQueryContext) {
        this.customerTerminalQueryContext = customerTerminalQueryContext;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void correlatedTerminal(MdmCustomerCorrelatedTerminalReqVo mdmCustomerCorrelatedTerminalReqVo) {
        String customerCode = mdmCustomerCorrelatedTerminalReqVo.getCustomerCode();
        Assert.hasText((String)customerCode, (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Set terminalCodeList = mdmCustomerCorrelatedTerminalReqVo.getTerminalCodeList();
        Assert.notEmpty((Collection)terminalCodeList, (String)"\u7ec8\u7aef\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        Set terminalIdList = mdmCustomerCorrelatedTerminalReqVo.getTerminalCodeList();
        List collect = terminalIdList.stream().map(x -> {
            MdmCustomerTerminalEntity mdmCustomerTerminalEntity = new MdmCustomerTerminalEntity();
            mdmCustomerTerminalEntity.setCustomerCode(customerCode);
            mdmCustomerTerminalEntity.setTerminalCode((String)x);
            mdmCustomerTerminalEntity.setId(customerCode + x);
            return mdmCustomerTerminalEntity;
        }).collect(Collectors.toList());
        this.saveBatch(collect);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public PageResult<MdmCustomerTerminalRespVo> customerTerminalPage(MdmCustomerTerminalReqVo mdmCustomerTerminalReqVo) {
        Assert.hasText((String)mdmCustomerTerminalReqVo.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notNull((Object)mdmCustomerTerminalReqVo.getQueryType(), (String)"\u67e5\u8be2\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        return this.customerTerminalQueryContext.doOperate(mdmCustomerTerminalReqVo);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void unbind(MdmCustomerCorrelatedTerminalReqVo mdmCustomerCorrelatedTerminalReqVo) {
        Assert.hasText((String)mdmCustomerCorrelatedTerminalReqVo.getCustomerCode(), (String)"\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notEmpty((Collection)mdmCustomerCorrelatedTerminalReqVo.getTerminalCodeList(), (String)"\u7ec8\u7aef\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmCustomerTerminalEntity::getCustomerCode, (Object)mdmCustomerCorrelatedTerminalReqVo.getCustomerCode())).in(MdmCustomerTerminalEntity::getTerminalCode, (Collection)mdmCustomerCorrelatedTerminalReqVo.getTerminalCodeList())).remove();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void replaceCustomer(MdmCustomerCorrelatedTerminalReplaceReqVo mdmCustomerCorrelatedTerminalReplaceReqVo) {
        Assert.hasText((String)mdmCustomerCorrelatedTerminalReplaceReqVo.getOldCustomerCode(), (String)"\u539f\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)mdmCustomerCorrelatedTerminalReplaceReqVo.getNewCustomerCode(), (String)"\u65b0\u5ba2\u6237\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.notEmpty((Collection)mdmCustomerCorrelatedTerminalReplaceReqVo.getTerminalCodeList(), (String)"\u7ec8\u7aef\u7f16\u7801\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmCustomerTerminalEntity::getCustomerCode, (Object)mdmCustomerCorrelatedTerminalReplaceReqVo.getOldCustomerCode())).in(MdmCustomerTerminalEntity::getTerminalCode, (Collection)mdmCustomerCorrelatedTerminalReplaceReqVo.getTerminalCodeList())).set(MdmCustomerTerminalEntity::getCustomerCode, (Object)mdmCustomerCorrelatedTerminalReplaceReqVo.getNewCustomerCode())).update();
    }

    @Override
    public List<String> terminalCodeList(MdmCustomerTerminalReqVo mdmCustomerTerminalReqVo) {
        return ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(!StringUtils.isEmpty((Object)mdmCustomerTerminalReqVo.getCustomerCode()), MdmCustomerTerminalEntity::getCustomerCode, (Object)mdmCustomerTerminalReqVo.getCustomerCode())).in(!CollectionUtils.isEmpty((Collection)mdmCustomerTerminalReqVo.getTerminalCodeList()), MdmCustomerTerminalEntity::getTerminalCode, (Collection)mdmCustomerTerminalReqVo.getTerminalCodeList())).last(DatabaseTypeUtil.SEGMENT_ITEM)).select(new SFunction[]{MdmCustomerTerminalEntity::getTerminalCode}).list().stream().map(MdmCustomerTerminalEntity::getTerminalCode).collect(Collectors.toList());
    }
}

