/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.button.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.button.mapper.MdmButtonMapper;
import com.biz.crm.button.model.MdmButtonEntity;
import com.biz.crm.button.service.MdmButtonService;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CrmDelFlagEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.mdm.button.MdmButtonReqVo;
import com.biz.crm.nebular.mdm.button.MdmButtonRespVo;
import com.biz.crm.util.CrmBeanUtil;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

@Service
@ConditionalOnMissingBean(name={"MdmButtonServiceExpandImpl"})
public class MdmButtonServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmButtonMapper, MdmButtonEntity>
implements MdmButtonService {
    private static final Logger log = LoggerFactory.getLogger(MdmButtonServiceImpl.class);
    @Resource
    private MdmButtonMapper mdmButtonMapper;

    @Override
    public PageResult<MdmButtonRespVo> findList(MdmButtonReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<MdmButtonRespVo> list = this.mdmButtonMapper.findList((Page<MdmButtonRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmButtonRespVo query(MdmButtonReqVo reqVo) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmButtonReqVo reqVo) {
        MdmButtonEntity entity = (MdmButtonEntity)((Object)CrmBeanUtil.copy((Object)reqVo, MdmButtonEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmButtonReqVo reqVo) {
        MdmButtonEntity entity = (MdmButtonEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmButtonReqVo reqVo) {
        List mdmButtonEntities = this.mdmButtonMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmButtonEntities)) {
            mdmButtonEntities.forEach(o -> o.setDelFlag(CrmDelFlagEnum.DELETE.getCode()));
        }
        this.updateBatchById(mdmButtonEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(MdmButtonReqVo reqVo) {
        List mdmButtonEntities = this.mdmButtonMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmButtonEntities)) {
            mdmButtonEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(mdmButtonEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(MdmButtonReqVo reqVo) {
        List mdmButtonEntities = this.mdmButtonMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmButtonEntities)) {
            mdmButtonEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(mdmButtonEntities);
    }

    @Override
    public List<MdmButtonRespVo> listCondition(MdmButtonReqVo mdmButtonReqVo) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(!CollectionUtils.isEmpty((Collection)mdmButtonReqVo.getFunctionCodeList()), MdmButtonEntity::getFunctionCode, (Collection)mdmButtonReqVo.getFunctionCodeList())).eq(!StringUtils.isEmpty((Object)mdmButtonReqVo.getFunctionCode()), MdmButtonEntity::getFunctionCode, (Object)mdmButtonReqVo.getFunctionCode())).like(!StringUtils.isEmpty((Object)mdmButtonReqVo.getButtonCode()), MdmButtonEntity::getButtonCode, (Object)mdmButtonReqVo.getButtonCode())).like(!StringUtils.isEmpty((Object)mdmButtonReqVo.getButtonName()), MdmButtonEntity::getButtonName, (Object)mdmButtonReqVo.getButtonName())).list();
        return CrmBeanUtil.copyList((List)list, MdmButtonRespVo.class);
    }
}

