/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.buttonrole.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.buttonrole.mapper.MdmButtonRoleMapper;
import com.biz.crm.buttonrole.model.MdmButtonRoleEntity;
import com.biz.crm.buttonrole.service.MdmButtonRoleService;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.mdm.buttonrole.MdmButtonRoleReqVo;
import com.biz.crm.nebular.mdm.buttonrole.MdmButtonRoleRespVo;
import com.biz.crm.util.CrmBeanUtil;
import java.io.Serializable;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnMissingBean(name={"MdmButtonRoleServiceExpandImpl"})
public class MdmButtonRoleServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmButtonRoleMapper, MdmButtonRoleEntity>
implements MdmButtonRoleService {
    private static final Logger log = LoggerFactory.getLogger(MdmButtonRoleServiceImpl.class);
    @Resource
    private MdmButtonRoleMapper mdmButtonRoleMapper;

    @Override
    public PageResult<MdmButtonRoleRespVo> findList(MdmButtonRoleReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<MdmButtonRoleRespVo> list = this.mdmButtonRoleMapper.findList((Page<MdmButtonRoleRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmButtonRoleRespVo query(MdmButtonRoleReqVo reqVo) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmButtonRoleReqVo reqVo) {
        MdmButtonRoleEntity entity = (MdmButtonRoleEntity)((Object)CrmBeanUtil.copy((Object)reqVo, MdmButtonRoleEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmButtonRoleReqVo reqVo) {
        MdmButtonRoleEntity entity = (MdmButtonRoleEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmButtonRoleReqVo reqVo) {
    }

    @Override
    public List<String> findButtonCodeByRole(String roleCode) {
        Assert.hasText((String)roleCode, (String)"\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        return ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmButtonRoleEntity::getRoleCode, (Object)roleCode)).select(new SFunction[]{MdmButtonRoleEntity::getButtonCode}).list().stream().map(MdmButtonRoleEntity::getRoleCode).collect(Collectors.toList());
    }

    @Override
    public void update(String roleCode, List<String> buttonCodeList) {
        Assert.hasText((String)roleCode, (String)"\u89d2\u8272\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmButtonRoleEntity::getRoleCode, (Object)roleCode)).remove();
        if (CollectionUtils.isEmpty(buttonCodeList)) {
            return;
        }
        List collect = buttonCodeList.stream().map(x -> {
            MdmButtonRoleEntity mdmButtonRoleEntity = new MdmButtonRoleEntity();
            mdmButtonRoleEntity.setRoleCode(roleCode);
            mdmButtonRoleEntity.setButtonCode((String)x);
            mdmButtonRoleEntity.setId(x + roleCode);
            return mdmButtonRoleEntity;
        }).collect(Collectors.toList());
        this.saveBatch(collect);
    }
}

