/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.common.service.impl;

import com.alibaba.excel.util.CollectionUtils;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.CrmTreeTenEntity;
import com.biz.crm.common.service.BaseTreeService;
import com.biz.crm.cusorg.service.CusOrgService;
import com.biz.crm.nebular.mdm.permission.BaseTreeReqVo;
import com.biz.crm.nebular.mdm.permission.BaseTreeRespVo;
import com.biz.crm.nebular.mdm.permission.MdmPermissionModelReqVo;
import com.biz.crm.org.model.MdmOrgEntity;
import com.biz.crm.org.service.IMdmOrgService;
import com.biz.crm.permission.mapper.MdmPermissionMapper;
import com.biz.crm.productlevel.model.MdmProductLevelEntity;
import com.biz.crm.productlevel.service.IMdmProductLevelService;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.StringUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.springframework.stereotype.Service;

@Service
public class BaseTreeServiceImpl
implements BaseTreeService {
    @Resource
    private IMdmOrgService mdmOrgService;
    @Resource
    private MdmPermissionMapper mdmPermissionMapper;
    @Resource
    private IMdmProductLevelService mdmProductLevelService;
    @Resource
    private CusOrgService cusOrgService;

    @Override
    public List<BaseTreeRespVo> orgTree(BaseTreeReqVo baseTreeReqVo) {
        List<BaseTreeRespVo> tree = new ArrayList<BaseTreeRespVo>();
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.mdmOrgService.lambdaQuery().like(!StringUtils.isEmpty((String)baseTreeReqVo.getName()), MdmOrgEntity::getOrgName, (Object)baseTreeReqVo.getName())).or()).like(!StringUtils.isEmpty((String)baseTreeReqVo.getName()), MdmOrgEntity::getOrgCode, (Object)baseTreeReqVo.getName())).select(new SFunction[]{BaseIdEntity::getId, MdmOrgEntity::getParentCode, MdmOrgEntity::getOrgCode, MdmOrgEntity::getOrgName, CrmTreeTenEntity::getRuleCode}).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            HashSet<String> set = new HashSet<String>();
            for (MdmOrgEntity item : list) {
                String ruleCode = item.getRuleCode();
                if (!StringUtils.isNotEmpty((String)ruleCode)) continue;
                set.add(ruleCode);
                while (ruleCode.length() > 3) {
                    ruleCode = ruleCode.substring(0, ruleCode.length() - 3);
                    set.add(ruleCode);
                }
            }
            if (!set.isEmpty()) {
                list = ((LambdaQueryChainWrapper)this.mdmOrgService.lambdaQuery().in(CrmTreeTenEntity::getRuleCode, set)).list();
            }
            List<BaseTreeRespVo> collect = list.stream().map(x -> {
                BaseTreeRespVo baseTreeRespVo = new BaseTreeRespVo();
                baseTreeRespVo.setId(x.getId());
                baseTreeRespVo.setParentCode(x.getParentCode());
                baseTreeRespVo.setCode(x.getOrgCode());
                baseTreeRespVo.setName(x.getOrgName());
                return baseTreeRespVo;
            }).collect(Collectors.toList());
            tree = this.generateTreeByParentCode(collect);
        }
        return tree;
    }

    private List<BaseTreeRespVo> convertTree(List<BaseTreeRespVo> collect) {
        LinkedList<BaseTreeRespVo> rootList = new LinkedList<BaseTreeRespVo>();
        Set set = collect.stream().map(BaseTreeRespVo::getCode).collect(Collectors.toSet());
        for (BaseTreeRespVo baseTreeRespVo : collect) {
            if (StringUtils.isEmpty((String)baseTreeRespVo.getParentCode()) || !set.contains(baseTreeRespVo.getParentCode())) {
                rootList.add(baseTreeRespVo);
            }
            for (BaseTreeRespVo treeRespVo : collect) {
                if (!baseTreeRespVo.getCode().equals(treeRespVo.getParentCode())) continue;
                if (baseTreeRespVo.getChildren() == null) {
                    baseTreeRespVo.setChildren(new LinkedList());
                }
                baseTreeRespVo.getChildren().add(treeRespVo);
            }
        }
        return rootList;
    }

    @Override
    public List<BaseTreeRespVo> menuTree(BaseTreeReqVo baseTreeReqVo) {
        MdmPermissionModelReqVo mdmPermissionModelReqVo = new MdmPermissionModelReqVo();
        mdmPermissionModelReqVo.setCompetenceCode(baseTreeReqVo.getCode());
        mdmPermissionModelReqVo.setCompetenceName(baseTreeReqVo.getName());
        List<BaseTreeRespVo> list = this.mdmPermissionMapper.findMenuTree(mdmPermissionModelReqVo);
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        String name = baseTreeReqVo.getName();
        if (StringUtils.isEmpty((String)name)) {
            return this.convertTree(list);
        }
        return this.convertTree(list, name);
    }

    private List<BaseTreeRespVo> convertTree(List<BaseTreeRespVo> list, String name) {
        Pattern namePattern = Pattern.compile(name);
        List<BaseTreeRespVo> rootList = list.stream().filter(x -> StringUtils.isEmpty((String)x.getParentCode()) || namePattern.matcher(x.getName()).find()).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(rootList)) {
            return rootList;
        }
        ArrayList<BaseTreeRespVo> result = new ArrayList<BaseTreeRespVo>();
        ArrayList<BaseTreeRespVo> subList = new ArrayList<BaseTreeRespVo>();
        for (BaseTreeRespVo baseTreeRespVo : rootList) {
            this.setUpChildren(baseTreeRespVo, list, result, subList);
        }
        return result;
    }

    @Override
    public List<BaseTreeRespVo> productLevelTree(BaseTreeReqVo baseTreeReqVo) {
        List<BaseTreeRespVo> tree = new ArrayList<BaseTreeRespVo>();
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.mdmProductLevelService.lambdaQuery().like(StringUtils.isNotEmpty((String)baseTreeReqVo.getName()), MdmProductLevelEntity::getProductLevelName, (Object)baseTreeReqVo.getName())).or()).like(StringUtils.isNotEmpty((String)baseTreeReqVo.getName()), MdmProductLevelEntity::getProductLevelCode, (Object)baseTreeReqVo.getName())).select(new SFunction[]{BaseIdEntity::getId, MdmProductLevelEntity::getProductLevelCode, MdmProductLevelEntity::getProductLevelName, MdmProductLevelEntity::getParentId, MdmProductLevelEntity::getRuleCode}).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            HashSet<String> set = new HashSet<String>();
            for (MdmProductLevelEntity item : list) {
                String ruleCode = item.getRuleCode();
                if (!StringUtils.isNotEmpty((String)ruleCode)) continue;
                set.add(ruleCode);
                while (ruleCode.length() > 3) {
                    ruleCode = ruleCode.substring(0, ruleCode.length() - 3);
                    set.add(ruleCode);
                }
            }
            if (!set.isEmpty()) {
                list = ((LambdaQueryChainWrapper)this.mdmProductLevelService.lambdaQuery().in(MdmProductLevelEntity::getRuleCode, set)).select(new SFunction[]{BaseIdEntity::getId, MdmProductLevelEntity::getProductLevelCode, MdmProductLevelEntity::getProductLevelName, MdmProductLevelEntity::getParentId, MdmProductLevelEntity::getRuleCode}).list();
            }
            List<BaseTreeRespVo> collect = list.stream().map(x -> {
                BaseTreeRespVo baseTreeRespVo = new BaseTreeRespVo();
                baseTreeRespVo.setId(x.getId());
                baseTreeRespVo.setParentId(x.getParentId());
                baseTreeRespVo.setCode(x.getProductLevelCode());
                baseTreeRespVo.setName(x.getProductLevelName());
                return baseTreeRespVo;
            }).collect(Collectors.toList());
            tree = this.generateTree(collect);
        }
        return tree;
    }

    @Override
    public List<BaseTreeRespVo> customerOrgTree(BaseTreeReqVo baseTreeReqVo) {
        List<BaseTreeRespVo> list = this.cusOrgService.findBaseTreeConditionList(baseTreeReqVo);
        if (CollectionUtils.isEmpty(list)) {
            return list;
        }
        String name = baseTreeReqVo.getName();
        if (StringUtils.isEmpty((String)name)) {
            return this.convertTree(list);
        }
        List<BaseTreeRespVo> baseTreeRespVos = this.convertTree(list, name);
        return baseTreeRespVos.stream().filter(x -> !CollectionUtils.isEmpty((Collection)x.getChildren())).collect(Collectors.toList());
    }

    private void setUpChildren(BaseTreeRespVo baseTreeRespVo, List<BaseTreeRespVo> list, List<BaseTreeRespVo> result, List<BaseTreeRespVo> subList) {
        if (StringUtils.isEmpty((String)baseTreeRespVo.getParentId())) {
            if (!result.contains(baseTreeRespVo)) {
                result.add(baseTreeRespVo);
            }
            if (!subList.contains(baseTreeRespVo)) {
                subList.add(baseTreeRespVo);
            }
            return;
        }
        if (subList.contains(baseTreeRespVo)) {
            return;
        }
        Optional<BaseTreeRespVo> any = list.stream().filter(x -> baseTreeRespVo.getParentId().equals(x.getId())).findAny();
        if (!any.isPresent()) {
            return;
        }
        BaseTreeRespVo parentTreeRespVo = any.get();
        ArrayList<BaseTreeRespVo> children = parentTreeRespVo.getChildren();
        if (CollectionUtils.isEmpty((Collection)children)) {
            children = new ArrayList<BaseTreeRespVo>();
        }
        children.add(baseTreeRespVo);
        parentTreeRespVo.setChildren(children);
        subList.add(baseTreeRespVo);
        this.setUpChildren(parentTreeRespVo, list, result, subList);
    }

    private void match(BaseTreeRespVo baseTreeRespVo, List<BaseTreeRespVo> children, List<BaseTreeRespVo> list, Set<String> set) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        List sub = list.stream().filter(x -> baseTreeRespVo.getId().equals(x.getParentId())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(sub)) {
            return;
        }
        for (BaseTreeRespVo treeRespVo : sub) {
            if (set.contains(treeRespVo.getId())) {
                children.add(treeRespVo);
                continue;
            }
            this.match(treeRespVo, children, list, set);
        }
    }

    private List<BaseTreeRespVo> generateTree(List<BaseTreeRespVo> totalList) {
        ArrayList<BaseTreeRespVo> treeList = new ArrayList<BaseTreeRespVo>();
        ArrayList<Object> curLevelList = new ArrayList<Object>();
        ArrayList<Object> restList = new ArrayList<Object>();
        Map<String, BaseTreeRespVo> totalMap = totalList.stream().collect(Collectors.toMap(BaseTreeRespVo::getId, v -> v));
        for (BaseTreeRespVo item : totalList) {
            if (StringUtils.isEmpty((String)item.getParentId()) || !totalMap.containsKey(item.getParentId())) {
                treeList.add(item);
                curLevelList.add(item);
                continue;
            }
            restList.add(item);
        }
        while (curLevelList.size() > 0 && restList.size() > 0) {
            ArrayList<BaseTreeRespVo> restTempList = new ArrayList<BaseTreeRespVo>();
            ArrayList<BaseTreeRespVo> curLevelTempList = new ArrayList<BaseTreeRespVo>();
            Map<String, String> curLevelMap = curLevelList.stream().collect(Collectors.toMap(BaseTreeRespVo::getId, BaseTreeRespVo::getId));
            HashMap curLevelChildrenMap = new HashMap();
            for (BaseTreeRespVo baseTreeRespVo : restList) {
                if (curLevelMap.containsKey(baseTreeRespVo.getParentId())) {
                    curLevelTempList.add(baseTreeRespVo);
                    ArrayList<BaseTreeRespVo> childrenList = new ArrayList<BaseTreeRespVo>();
                    if (curLevelChildrenMap.containsKey(baseTreeRespVo.getParentId())) {
                        childrenList.addAll((Collection)curLevelChildrenMap.get(baseTreeRespVo.getParentId()));
                    }
                    childrenList.add(baseTreeRespVo);
                    curLevelChildrenMap.put(baseTreeRespVo.getParentId(), childrenList);
                    continue;
                }
                restTempList.add(baseTreeRespVo);
            }
            for (BaseTreeRespVo baseTreeRespVo : curLevelList) {
                if (!curLevelChildrenMap.containsKey(baseTreeRespVo.getId())) continue;
                baseTreeRespVo.setChildren((List)curLevelChildrenMap.get(baseTreeRespVo.getId()));
            }
            curLevelList.clear();
            curLevelList.addAll(curLevelTempList);
            restList.clear();
            restList.addAll(restTempList);
        }
        return treeList;
    }

    private List<BaseTreeRespVo> generateTreeByParentCode(List<BaseTreeRespVo> totalList) {
        ArrayList<BaseTreeRespVo> treeList = new ArrayList<BaseTreeRespVo>();
        ArrayList<Object> curLevelList = new ArrayList<Object>();
        ArrayList<Object> restList = new ArrayList<Object>();
        Map<String, BaseTreeRespVo> totalMap = totalList.stream().collect(Collectors.toMap(BaseTreeRespVo::getCode, v -> v));
        for (BaseTreeRespVo item : totalList) {
            if (StringUtils.isEmpty((String)item.getParentCode()) || !totalMap.containsKey(item.getParentCode())) {
                treeList.add(item);
                curLevelList.add(item);
                continue;
            }
            restList.add(item);
        }
        while (curLevelList.size() > 0 && restList.size() > 0) {
            ArrayList<BaseTreeRespVo> restTempList = new ArrayList<BaseTreeRespVo>();
            ArrayList<BaseTreeRespVo> curLevelTempList = new ArrayList<BaseTreeRespVo>();
            Map<String, String> curLevelMap = curLevelList.stream().collect(Collectors.toMap(BaseTreeRespVo::getCode, BaseTreeRespVo::getCode));
            HashMap curLevelChildrenMap = new HashMap();
            for (BaseTreeRespVo baseTreeRespVo : restList) {
                if (curLevelMap.containsKey(baseTreeRespVo.getParentCode())) {
                    curLevelTempList.add(baseTreeRespVo);
                    ArrayList<BaseTreeRespVo> childrenList = new ArrayList<BaseTreeRespVo>();
                    if (curLevelChildrenMap.containsKey(baseTreeRespVo.getParentCode())) {
                        childrenList.addAll((Collection)curLevelChildrenMap.get(baseTreeRespVo.getParentCode()));
                    }
                    childrenList.add(baseTreeRespVo);
                    curLevelChildrenMap.put(baseTreeRespVo.getParentCode(), childrenList);
                    continue;
                }
                restTempList.add(baseTreeRespVo);
            }
            for (BaseTreeRespVo baseTreeRespVo : curLevelList) {
                if (!curLevelChildrenMap.containsKey(baseTreeRespVo.getCode())) continue;
                baseTreeRespVo.setChildren((List)curLevelChildrenMap.get(baseTreeRespVo.getCode()));
            }
            curLevelList.clear();
            curLevelList.addAll(curLevelTempList);
            restList.clear();
            restList.addAll(restTempList);
        }
        return treeList;
    }
}

