/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.customer.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.customer.mapper.MdmCustomerAddressMapper;
import com.biz.crm.customer.model.MdmCustomerAddressEntity;
import com.biz.crm.customer.service.IMdmCustomerAddressService;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.mdm.customer.MdmCustomerAddressReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerAddressRespVo;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@ConditionalOnMissingBean(name={"MdmCustomerAddressServiceExpandImpl"})
public class MdmCustomerAddressServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmCustomerAddressMapper, MdmCustomerAddressEntity>
implements IMdmCustomerAddressService {
    private static final Logger log = LoggerFactory.getLogger(MdmCustomerAddressServiceImpl.class);
    @Resource
    private MdmCustomerAddressMapper mdmCustomerAddressMapper;

    @Override
    @CrmLog
    public PageResult<MdmCustomerAddressRespVo> findList(MdmCustomerAddressReqVo mdmCustomerAddressReqVo) {
        Page page = new Page((long)mdmCustomerAddressReqVo.getPageNum().intValue(), (long)mdmCustomerAddressReqVo.getPageSize().intValue());
        List<MdmCustomerAddressRespVo> list = this.mdmCustomerAddressMapper.findList((Page<MdmCustomerAddressRespVo>)page, mdmCustomerAddressReqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    private void convert(List<MdmCustomerAddressRespVo> list) {
        if (!CollectionUtils.isEmpty(list)) {
            for (MdmCustomerAddressRespVo mdmCustomerAddressRespVo : list) {
                String defaultAddress;
                if (mdmCustomerAddressRespVo == null || StringUtils.isEmpty((String)(defaultAddress = mdmCustomerAddressRespVo.getDefaultAddress()))) continue;
                if ("0".equals(defaultAddress)) {
                    mdmCustomerAddressRespVo.setDefaultAddress("\u5426");
                }
                if (!"1".equals(defaultAddress)) continue;
                mdmCustomerAddressRespVo.setDefaultAddress("\u662f");
            }
        }
    }

    @Override
    @CrmLog
    public MdmCustomerAddressRespVo query(MdmCustomerAddressReqVo mdmCustomerAddressReqVo) {
        LambdaQueryWrapper wrapper = (LambdaQueryWrapper)((LambdaQueryWrapper)new LambdaQueryWrapper().eq(!StringUtils.isEmpty((String)mdmCustomerAddressReqVo.getId()), BaseIdEntity::getId, (Object)mdmCustomerAddressReqVo.getId())).eq(!StringUtils.isEmpty((String)mdmCustomerAddressReqVo.getFormInstanceId()), CrmBaseEntity::getFormInstanceId, (Object)mdmCustomerAddressReqVo.getFormInstanceId());
        MdmCustomerAddressRespVo mdmCustomerAddressRespVo = (MdmCustomerAddressRespVo)CrmBeanUtil.copy((Object)this.getOne((Wrapper)wrapper, false), MdmCustomerAddressRespVo.class);
        this.convert(Collections.singletonList(mdmCustomerAddressRespVo));
        return mdmCustomerAddressRespVo;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void save(MdmCustomerAddressReqVo mdmCustomerAddressReqVo) {
        MdmCustomerAddressEntity entity = (MdmCustomerAddressEntity)((Object)CrmBeanUtil.copy((Object)mdmCustomerAddressReqVo, MdmCustomerAddressEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void update(MdmCustomerAddressReqVo mdmCustomerAddressReqVo) {
        MdmCustomerAddressEntity entity = (MdmCustomerAddressEntity)((Object)CrmBeanUtil.copy((Object)mdmCustomerAddressReqVo, MdmCustomerAddressEntity.class));
        this.updateById((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void deleteBatch(MdmCustomerAddressReqVo mdmCustomerAddressReqVo) {
        List ids = mdmCustomerAddressReqVo.getIds();
        if (CollectionUtils.isEmpty((Collection)ids)) {
            throw new BusinessException("ids\u4e0d\u80fd\u4e3a\u7a7a");
        }
        this.removeByIds(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void enableBatch(MdmCustomerAddressReqVo mdmCustomerAddressReqVo) {
        List mdmCustomerAddressEntities = this.mdmCustomerAddressMapper.selectBatchIds(mdmCustomerAddressReqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmCustomerAddressEntities)) {
            mdmCustomerAddressEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode()));
        }
        this.updateBatchById(mdmCustomerAddressEntities);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @CrmLog
    public void disableBatch(MdmCustomerAddressReqVo mdmCustomerAddressReqVo) {
        List mdmCustomerAddressEntities = this.mdmCustomerAddressMapper.selectBatchIds(mdmCustomerAddressReqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)mdmCustomerAddressEntities)) {
            mdmCustomerAddressEntities.forEach(o -> o.setEnableStatus(CrmEnableStatusEnum.DISABLE.getCode()));
        }
        this.updateBatchById(mdmCustomerAddressEntities);
    }
}

