/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dict.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.dict.mapper.MdmDictDataMapper;
import com.biz.crm.dict.model.MdmDictDataEntity;
import com.biz.crm.dict.model.MdmDictTypeEntity;
import com.biz.crm.dict.service.IMdmDictAttrConfService;
import com.biz.crm.dict.service.IMdmDictDataService;
import com.biz.crm.dict.service.IMdmDictTypeService;
import com.biz.crm.dict.service.MdmDictService;
import com.biz.crm.nebular.mdm.dict.req.MdmDictAttrConfReqVo;
import com.biz.crm.nebular.mdm.dict.req.MdmDictDataReqVo;
import com.biz.crm.nebular.mdm.dict.resp.MdmDictAttrConfRespVo;
import com.biz.crm.nebular.mdm.dict.resp.MdmDictDataRespVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.ReflectUtil;
import com.biz.crm.util.StringUtils;
import com.bizunited.platform.common.vo.UuidVo;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"MdmDictDataServiceExpandImpl"})
public class MdmDictDataServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmDictDataMapper, MdmDictDataEntity>
implements IMdmDictDataService {
    private static final Logger log = LoggerFactory.getLogger(MdmDictDataServiceImpl.class);
    @Resource
    private MdmDictDataMapper mdmDictDataMapper;
    @Resource
    private IMdmDictTypeService mdmDictTypeService;
    @Resource
    private IMdmDictAttrConfService mdmDictAttrConfService;
    @Resource
    private MdmDictService mdmDictService;

    @Override
    public List<MdmDictDataRespVo> tree(MdmDictDataReqVo reqVo) {
        Assert.hasText((String)reqVo.getDictTypeCode(), (String)"\u7f3a\u5931\u5b57\u5178\u7c7b\u578b\u7f16\u7801");
        ArrayList<MdmDictDataRespVo> result = new ArrayList<MdmDictDataRespVo>();
        List<MdmDictDataRespVo> list = this.mdmDictDataMapper.findList(null, reqVo);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            List<MdmDictDataRespVo> allList = this.getAllParentList(reqVo.getDictTypeCode(), list);
            List<MdmDictAttrConfRespVo> confList = this.mdmDictAttrConfService.findAttrConfList(new MdmDictAttrConfReqVo().setDictTypeCode(reqVo.getDictTypeCode()));
            HashMap<String, Map> map = new HashMap<String, Map>(16);
            for (MdmDictAttrConfRespVo filed : confList) {
                Map dictMap;
                if (!StringUtils.isNotEmpty((String)filed.getSelectDictTypeCode()) || (dictMap = DictUtil.getDictValueMapsByCodes((String)filed.getSelectDictTypeCode())).isEmpty()) continue;
                map.put(filed.getFieldCode(), dictMap);
            }
            if (!map.isEmpty()) {
                allList.forEach(item -> map.forEach((k, v) -> {
                    Object fieldKy = ReflectUtil.getFiledValueByName((Object)item, (String)k);
                    if (fieldKy != null && v.containsKey(fieldKy.toString())) {
                        ReflectUtil.setFieldValue((Object)item, (String)k, v.get(fieldKy.toString()));
                    }
                }));
            }
            result.addAll(this.generateTree(allList));
        }
        return result;
    }

    @Override
    public PageResult<MdmDictDataRespVo> findList(MdmDictDataReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<MdmDictDataRespVo> list = this.mdmDictDataMapper.findList((Page<MdmDictDataRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public List<MdmDictDataRespVo> list(MdmDictDataReqVo mdmDictDataReqVo) {
        if (StringUtils.isEmpty((String)mdmDictDataReqVo.getDictTypeCode())) {
            return new ArrayList<MdmDictDataRespVo>();
        }
        return this.mdmDictDataMapper.findList(null, mdmDictDataReqVo);
    }

    @Override
    public MdmDictDataRespVo query(MdmDictDataReqVo reqVo) {
        if (StringUtils.isNotEmpty((String)reqVo.getId())) {
            MdmDictDataEntity one = (MdmDictDataEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)reqVo.getId()), BaseIdEntity::getId, (Object)reqVo.getId())).one());
            return (MdmDictDataRespVo)CrmBeanUtil.copy((Object)((Object)one), MdmDictDataRespVo.class);
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmDictDataReqVo reqVo) {
        reqVo.setId(null);
        this.verify(reqVo);
        MdmDictDataEntity entity = (MdmDictDataEntity)((Object)CrmBeanUtil.copy((Object)reqVo, MdmDictDataEntity.class));
        this.save((Object)entity);
        this.mdmDictService.updateRedisCache(entity.getDictTypeCode());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmDictDataReqVo reqVo) {
        Assert.hasText((String)reqVo.getId(), (String)"\u7f3a\u5931id");
        MdmDictDataEntity entity = (MdmDictDataEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        Assert.notNull((Object)((Object)entity), (String)"\u672a\u627e\u5230\u6570\u636e\u5b57\u5178");
        this.verify(reqVo);
        CrmBeanUtil.copyProperties((Object)reqVo, (Object)((Object)entity));
        this.updateById((Object)entity);
        this.mdmDictService.updateRedisCache(entity.getDictTypeCode());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmDictDataReqVo reqVo) {
        Assert.notEmpty((Collection)reqVo.getIds(), (String)"\u7a7a\u53c2\u6570");
        Assert.isTrue((reqVo.getIds().size() == 1 ? 1 : 0) != 0, (String)"\u4e0d\u652f\u6301\u6279\u91cf\u5220\u9664");
        reqVo.getIds().forEach(id -> {
            Assert.hasText((String)id, (String)"\u4e0d\u80fd\u4f20\u7a7a\u503c");
            MdmDictDataEntity entity = (MdmDictDataEntity)((Object)((Object)this.getById((Serializable)((Object)id))));
            Assert.notNull((Object)((Object)entity), (String)("\u672a\u627e\u5230id[" + id + "]\u5bf9\u5e94\u7684\u6570\u636e\u5b57\u5178"));
            List children = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmDictDataEntity::getDictTypeCode, (Object)entity.getDictTypeCode())).eq(MdmDictDataEntity::getParentDictCode, (Object)entity.getDictCode())).select(new SFunction[]{BaseIdEntity::getId}).list();
            Assert.isTrue((boolean)CollectionUtil.listEmpty((List)children), (String)"\u8be5\u5b57\u5178\u5b58\u5728\u4e0b\u7ea7\u5b57\u5178\uff0c\u4e0d\u80fd\u5220\u9664");
            this.removeById((Serializable)((Object)id));
            this.mdmDictService.updateRedisCache(entity.getDictTypeCode());
        });
    }

    private void verify(MdmDictDataReqVo reqVo) {
        Assert.hasText((String)reqVo.getDictCode(), (String)"\u5b57\u5178\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getDictValue(), (String)"\u5b57\u5178\u503c\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getDictSort(), (String)"\u987a\u5e8f\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getDictTypeCode(), (String)"\u5bf9\u5e94\u5b57\u5178\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        MdmDictTypeEntity dict = (MdmDictTypeEntity)((Object)this.mdmDictTypeService.getById((Serializable)((Object)reqVo.getDictTypeCode())));
        Assert.notNull((Object)((Object)dict), (String)"\u5bf9\u5e94\u5b57\u5178\u4e0d\u5b58\u5728");
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().ne(StringUtils.isNotEmpty((String)reqVo.getId()), BaseIdEntity::getId, (Object)reqVo.getId())).eq(MdmDictDataEntity::getDictTypeCode, (Object)reqVo.getDictTypeCode())).eq(MdmDictDataEntity::getDictCode, (Object)reqVo.getDictCode())).list();
        Assert.isTrue((boolean)CollectionUtil.listEmpty((List)list), (String)"\u5b57\u5178\u7f16\u7801\u5df2\u7ecf\u5b58\u5728");
        if (StringUtils.isEmpty((String)reqVo.getParentDictCode())) {
            reqVo.setLevelNum(Integer.valueOf(1));
        } else {
            MdmDictDataEntity parent = (MdmDictDataEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmDictDataEntity::getDictTypeCode, (Object)dict.getDictTypeCode())).eq(MdmDictDataEntity::getDictCode, (Object)reqVo.getParentDictCode())).one());
            Assert.notNull((Object)((Object)parent), (String)"\u4e0a\u7ea7\u5b57\u5178\u4e0d\u5b58\u5728");
            reqVo.setLevelNum(Integer.valueOf(parent.getLevelNum() == null ? 1 : parent.getLevelNum() + 1));
        }
    }

    private List<MdmDictDataRespVo> getAllParentList(String dictTypeCode, List<MdmDictDataRespVo> list) {
        ArrayList<MdmDictDataRespVo> result = new ArrayList<MdmDictDataRespVo>();
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            HashSet<String> codeSet = new HashSet<String>();
            for (MdmDictDataRespVo item : list) {
                codeSet.add(item.getDictCode());
                this.setParent(dictTypeCode, item.getParentDictCode(), codeSet);
            }
            if (!codeSet.isEmpty()) {
                List parentList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmDictDataEntity::getDictTypeCode, (Object)dictTypeCode)).in(MdmDictDataEntity::getDictCode, codeSet)).list();
                result.addAll(CrmBeanUtil.copyList((List)parentList, MdmDictDataRespVo.class));
            }
        }
        return result;
    }

    private void setParent(String dictTypeCode, String dictCode, Set<String> codeSet) {
        if (StringUtils.isNotEmpty((String)dictCode)) {
            if (codeSet.contains(dictCode)) {
                return;
            }
            MdmDictDataEntity one = (MdmDictDataEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmDictDataEntity::getDictTypeCode, (Object)dictTypeCode)).eq(MdmDictDataEntity::getDictCode, (Object)dictCode)).select(new SFunction[]{MdmDictDataEntity::getDictCode, MdmDictDataEntity::getParentDictCode}).one());
            if (one != null) {
                codeSet.add(dictCode);
                this.setParent(dictTypeCode, one.getParentDictCode(), codeSet);
            }
        }
    }

    private List<MdmDictDataRespVo> generateTree(List<MdmDictDataRespVo> totalList) {
        ArrayList<MdmDictDataRespVo> treeList = new ArrayList<MdmDictDataRespVo>();
        ArrayList<Object> curLevelList = new ArrayList<Object>();
        ArrayList<Object> restList = new ArrayList<Object>();
        Map<String, MdmDictDataRespVo> totalMap = totalList.stream().collect(Collectors.toMap(MdmDictDataRespVo::getDictCode, v -> v));
        for (MdmDictDataRespVo item : totalList) {
            if (StringUtils.isEmpty((String)item.getParentDictCode()) || !totalMap.containsKey(item.getParentDictCode())) {
                treeList.add(item);
                curLevelList.add(item);
                continue;
            }
            restList.add(item);
        }
        while (curLevelList.size() > 0 && restList.size() > 0) {
            ArrayList<MdmDictDataRespVo> restTempList = new ArrayList<MdmDictDataRespVo>();
            ArrayList<MdmDictDataRespVo> curLevelTempList = new ArrayList<MdmDictDataRespVo>();
            Map<String, String> curLevelMap = curLevelList.stream().collect(Collectors.toMap(UuidVo::getId, UuidVo::getId));
            HashMap curLevelChildrenMap = new HashMap();
            for (MdmDictDataRespVo mdmDictDataRespVo : restList) {
                if (curLevelMap.containsKey(mdmDictDataRespVo.getParentDictCode())) {
                    curLevelTempList.add(mdmDictDataRespVo);
                    ArrayList<MdmDictDataRespVo> childrenList = new ArrayList<MdmDictDataRespVo>();
                    if (curLevelChildrenMap.containsKey(mdmDictDataRespVo.getParentDictCode())) {
                        childrenList.addAll((Collection)curLevelChildrenMap.get(mdmDictDataRespVo.getParentDictCode()));
                    }
                    childrenList.add(mdmDictDataRespVo);
                    curLevelChildrenMap.put(mdmDictDataRespVo.getParentDictCode(), childrenList);
                    continue;
                }
                restTempList.add(mdmDictDataRespVo);
            }
            for (MdmDictDataRespVo mdmDictDataRespVo : curLevelList) {
                if (!curLevelChildrenMap.containsKey(mdmDictDataRespVo.getDictCode())) continue;
                mdmDictDataRespVo.setChildren((List)curLevelChildrenMap.get(mdmDictDataRespVo.getDictCode()));
            }
            curLevelList.clear();
            curLevelList.addAll(curLevelTempList);
            restList.clear();
            restList.addAll(restTempList);
        }
        return treeList;
    }
}

