/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dict.service.impl;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.biz.crm.dict.model.MdmDictAttrConfEntity;
import com.biz.crm.dict.model.MdmDictDataEntity;
import com.biz.crm.dict.service.IMdmDictAttrConfService;
import com.biz.crm.dict.service.IMdmDictDataService;
import com.biz.crm.dict.service.MdmDictService;
import com.biz.crm.nebular.mdm.dict.resp.MdmDictAttrConfRespVo;
import com.biz.crm.nebular.mdm.dict.resp.MdmDictDataRespVo;
import com.biz.crm.nebular.mdm.dict.resp.MdmDictGroupVo;
import com.biz.crm.service.RedisService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class MdmDictServiceImpl
implements MdmDictService {
    private static final Logger log = LoggerFactory.getLogger(MdmDictServiceImpl.class);
    @Resource
    private IMdmDictDataService mdmDictDataService;
    @Resource
    private IMdmDictAttrConfService mdmDictAttrConfService;
    @Resource
    private RedisService redisService;

    @Override
    public List<MdmDictGroupVo> getMdmDictList(List<String> dictTypeCodeList) {
        ArrayList<MdmDictGroupVo> list = new ArrayList<MdmDictGroupVo>();
        dictTypeCodeList.forEach(dictTypeCode -> {
            this.deleteRedisCache((String)dictTypeCode);
            MdmDictGroupVo group = this.getDictGroup((String)dictTypeCode);
            if (group != null) {
                this.addRedisCache(group);
                list.add(group);
            }
        });
        return list;
    }

    @Override
    public void updateRedisCache(String dictTypeCode) {
        if (StringUtils.isNotEmpty((String)dictTypeCode)) {
            this.deleteRedisCache(dictTypeCode);
            MdmDictGroupVo group = this.getDictGroup(dictTypeCode);
            if (group != null) {
                this.addRedisCache(group);
            }
        }
    }

    @Override
    public void deleteRedisCache(String dictTypeCode) {
        if (StringUtils.isNotEmpty((String)dictTypeCode)) {
            this.redisService.del(new String[]{"DICT_TYPE_GROUP_:" + dictTypeCode});
        }
    }

    private void addRedisCache(MdmDictGroupVo group) {
        if (group != null) {
            this.redisService.set("DICT_TYPE_GROUP_:" + group.getDictTypeCode(), (Object)group);
        }
    }

    private MdmDictGroupVo getDictGroup(String dictTypeCode) {
        MdmDictGroupVo respVo = null;
        List list = ((LambdaQueryChainWrapper)this.mdmDictDataService.lambdaQuery().eq(MdmDictDataEntity::getDictTypeCode, (Object)dictTypeCode)).list();
        if (list != null && list.size() > 0) {
            respVo = new MdmDictGroupVo();
            respVo.setDictTypeCode(dictTypeCode);
            respVo.setDataList(CrmBeanUtil.copyList((List)list, MdmDictDataRespVo.class));
            List confEntityList = ((LambdaQueryChainWrapper)this.mdmDictAttrConfService.lambdaQuery().eq(MdmDictAttrConfEntity::getDictTypeCode, (Object)dictTypeCode)).list();
            if (confEntityList != null && confEntityList.size() > 0) {
                respVo.setConfList(CrmBeanUtil.copyList((List)confEntityList, MdmDictAttrConfRespVo.class));
            }
        }
        return respVo;
    }
}

