/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.dict.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.common.PageResult;
import com.biz.crm.dict.mapper.MdmDictTypeMapper;
import com.biz.crm.dict.model.MdmDictAttrConfEntity;
import com.biz.crm.dict.model.MdmDictDataEntity;
import com.biz.crm.dict.model.MdmDictTypeEntity;
import com.biz.crm.dict.service.IMdmDictAttrConfService;
import com.biz.crm.dict.service.IMdmDictDataService;
import com.biz.crm.dict.service.IMdmDictTypeService;
import com.biz.crm.dict.service.MdmDictService;
import com.biz.crm.nebular.mdm.dict.req.MdmDictTypeReqVo;
import com.biz.crm.nebular.mdm.dict.resp.MdmDictTypeRespVo;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import java.io.Serializable;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"MdmDictTypeServiceExpandImpl"})
public class MdmDictTypeServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmDictTypeMapper, MdmDictTypeEntity>
implements IMdmDictTypeService {
    private static final Logger log = LoggerFactory.getLogger(MdmDictTypeServiceImpl.class);
    @Resource
    private MdmDictTypeMapper mdmDictTypeMapper;
    @Resource
    private IMdmDictDataService mdmDictDataService;
    @Resource
    private IMdmDictAttrConfService mdmDictAttrConfService;
    @Resource
    private MdmDictService mdmDictService;

    @Override
    public PageResult<MdmDictTypeRespVo> findList(MdmDictTypeReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<MdmDictTypeRespVo> list = this.mdmDictTypeMapper.findList((Page<MdmDictTypeRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmDictTypeRespVo query(MdmDictTypeReqVo reqVo) {
        MdmDictTypeEntity one;
        if ((StringUtils.isNotEmpty((String)reqVo.getId()) || StringUtils.isNotEmpty((String)reqVo.getDictTypeCode())) && (one = (MdmDictTypeEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)reqVo.getId()), BaseIdEntity::getId, (Object)reqVo.getId())).eq(StringUtils.isNotEmpty((String)reqVo.getDictTypeCode()), MdmDictTypeEntity::getDictTypeCode, (Object)reqVo.getDictTypeCode())).one())) != null) {
            return (MdmDictTypeRespVo)CrmBeanUtil.copy((Object)((Object)one), MdmDictTypeRespVo.class);
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmDictTypeReqVo reqVo) {
        Assert.hasText((String)reqVo.getDictTypeCode(), (String)"\u5b57\u5178\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getDictTypeName(), (String)"\u5b57\u5178\u7c7b\u578b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getDictTypeModule(), (String)"\u6a21\u5757\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmDictTypeEntity::getDictTypeCode, (Object)reqVo.getDictTypeCode())).list();
        Assert.isTrue((boolean)CollectionUtil.listEmpty((List)list), (String)"\u5b57\u5178\u7c7b\u578b\u7f16\u7801\u5df2\u7ecf\u5b58\u5728");
        MdmDictTypeEntity entity = (MdmDictTypeEntity)((Object)CrmBeanUtil.copy((Object)reqVo, MdmDictTypeEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmDictTypeReqVo reqVo) {
        Assert.hasText((String)reqVo.getId(), (String)"id\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getDictTypeCode(), (String)"\u5b57\u5178\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getDictTypeName(), (String)"\u5b57\u5178\u7c7b\u578b\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getDictTypeModule(), (String)"\u6a21\u5757\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        MdmDictTypeEntity entity = (MdmDictTypeEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        Assert.notNull((Object)((Object)entity), (String)"id\u65e0\u6548");
        Assert.isTrue((boolean)entity.getDictTypeCode().equals(reqVo.getDictTypeCode()), (String)"\u5b57\u5178\u7c7b\u578b\u7f16\u7801\u4e0d\u80fd\u4fee\u6539");
        CrmBeanUtil.copyProperties((Object)reqVo, (Object)((Object)entity));
        this.updateById((Object)entity);
        this.mdmDictService.updateRedisCache(entity.getDictTypeCode());
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmDictTypeReqVo reqVo) {
        Assert.notEmpty((Collection)reqVo.getIds(), (String)"\u7a7a\u53c2\u6570");
        reqVo.getIds().forEach(id -> {
            Assert.hasText((String)id, (String)"\u4e0d\u80fd\u4f20\u7a7a\u503c");
            MdmDictTypeEntity entity = (MdmDictTypeEntity)((Object)((Object)this.getById((Serializable)((Object)id))));
            Assert.notNull((Object)((Object)entity), (String)("\u672a\u627e\u5230id[" + id + "]\u5bf9\u5e94\u7684\u6570\u636e\u5b57\u5178"));
            List dataList = ((LambdaQueryChainWrapper)this.mdmDictDataService.lambdaQuery().eq(MdmDictDataEntity::getDictTypeCode, (Object)entity.getDictTypeCode())).list();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)dataList)) {
                throw new BusinessException("\u5b57\u5178\u7c7b\u578b[" + entity.getDictTypeCode() + "]\u5df2\u7ecf\u5b58\u5728\u5b57\u5178\u503c\u4e0d\u5141\u8bb8\u5220\u9664\uff01");
            }
            ((LambdaUpdateChainWrapper)this.mdmDictAttrConfService.lambdaUpdate().eq(MdmDictAttrConfEntity::getDictTypeCode, (Object)entity.getDictTypeCode())).remove();
            this.removeById((Serializable)((Object)id));
            this.mdmDictService.deleteRedisCache(entity.getDictTypeCode());
        });
    }
}

