/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.org.controller;

import com.biz.crm.aop.CrmGlobalLog;
import com.biz.crm.aop.CrmLog;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.nebular.mdm.org.req.MdmOrgReqVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgSelectReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgSelectRespVo;
import com.biz.crm.org.service.IMdmOrgService;
import com.biz.crm.util.Result;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/mdmorg"})
@Api(tags={"MDM-\u7ec4\u7ec7\u7ba1\u7406"})
@CrmGlobalLog
public class MdmOrgController {
    private static final Logger log = LoggerFactory.getLogger(MdmOrgController.class);
    @Autowired
    private IMdmOrgService mdmOrgService;

    @ApiOperation(value="\u67e5\u8be2\u5217\u8868")
    @PostMapping(value={"/list"})
    @CrmLog
    @CrmDictMethod
    public Result<PageResult<MdmOrgRespVo>> list(@RequestBody MdmOrgReqVo mdmOrgReqVo) {
        PageResult<MdmOrgRespVo> result = this.mdmOrgService.findList(mdmOrgReqVo);
        return Result.ok(result);
    }

    @ApiOperation(value="\u67e5\u8be2")
    @PostMapping(value={"/query"})
    @CrmLog
    @CrmDictMethod
    public Result<MdmOrgRespVo> query(@RequestBody MdmOrgReqVo mdmOrgReqVo) {
        MdmOrgRespVo respVo = this.mdmOrgService.query(mdmOrgReqVo);
        return Result.ok((Object)respVo);
    }

    @ApiOperation(value="\u65b0\u589e")
    @PostMapping(value={"/save"})
    @CrmLog
    public Result save(@RequestBody MdmOrgReqVo mdmOrgReqVo) {
        this.mdmOrgService.save(mdmOrgReqVo);
        return Result.ok();
    }

    @ApiOperation(value="\u66f4\u65b0")
    @PostMapping(value={"/update"})
    @CrmLog
    public Result update(@RequestBody MdmOrgReqVo mdmOrgReqVo) {
        this.mdmOrgService.update(mdmOrgReqVo);
        return Result.ok((String)"\u4fee\u6539\u6210\u529f");
    }

    @ApiOperation(value="\u5220\u9664")
    @PostMapping(value={"/delete"})
    @CrmLog
    public Result delete(@RequestBody MdmOrgReqVo mdmOrgReqVo) {
        this.mdmOrgService.deleteBatch(mdmOrgReqVo);
        return Result.ok((String)"\u5220\u9664\u6210\u529f");
    }

    @ApiOperation(value="\u542f\u7528")
    @PostMapping(value={"/enable"})
    @CrmLog
    public Result enable(@RequestBody MdmOrgReqVo mdmOrgReqVo) {
        this.mdmOrgService.enableBatch(mdmOrgReqVo);
        return Result.ok((String)"\u542f\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7981\u7528")
    @PostMapping(value={"/disable"})
    @CrmLog
    public Result disable(@RequestBody MdmOrgReqVo mdmOrgReqVo) {
        this.mdmOrgService.disableBatch(mdmOrgReqVo);
        return Result.ok((String)"\u7981\u7528\u6210\u529f");
    }

    @ApiOperation(value="\u7ec4\u7ec7\u4e0b\u62c9\u6846\u5217\u8868")
    @PostMapping(value={"/findOrgSelectList"})
    @CrmDictMethod
    public Result<List<MdmOrgSelectRespVo>> findOrgSelectList(@RequestBody MdmOrgSelectReqVo reqVo) {
        return Result.ok(this.mdmOrgService.findOrgSelectList(reqVo));
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7id\u6216\u8005\u7f16\u7801\u67e5\u8be2\u5168\u90e8\u4e0b\u7ea7\uff08\u542b\u5f53\u524d\uff09\u7ec4\u7ec7\u5217\u8868")
    @PostMapping(value={"/findAllChildrenOrgList"})
    @CrmDictMethod
    public Result<List<MdmOrgRespVo>> findAllChildrenOrgList(@RequestBody MdmOrgReqVo reqVo) {
        return Result.ok(this.mdmOrgService.findAllChildrenOrgList(reqVo.getId(), reqVo.getOrgCode()));
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7id\u6216\u8005\u7f16\u7801\u67e5\u8be2\u5f53\u524d\u7ec4\u7ec7\u7684\u76f4\u63a5\u4e0b\u7ea7\uff08\u4e0d\u542b\u5f53\u524d\uff09\u7ec4\u7ec7\u5217\u8868")
    @PostMapping(value={"/findSingleChildrenOrgList"})
    @CrmDictMethod
    public Result<List<MdmOrgRespVo>> findSingleChildrenOrgList(@RequestBody MdmOrgReqVo reqVo) {
        return Result.ok(this.mdmOrgService.findSingleChildrenOrgList(reqVo.getId(), reqVo.getOrgCode()));
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7id\u6216\u8005\u7f16\u7801\u67e5\u8be2\u5168\u90e8\u4e0a\u7ea7\uff08\u542b\u5f53\u524d\uff09\u7ec4\u7ec7\u5217\u8868")
    @PostMapping(value={"/findAllParentOrgList"})
    @CrmDictMethod
    public Result<List<MdmOrgRespVo>> findAllParentOrgList(@RequestBody MdmOrgReqVo reqVo) {
        return Result.ok(this.mdmOrgService.findAllParentOrgList(reqVo.getId(), reqVo.getOrgCode()));
    }

    @ApiOperation(value="\u6839\u636e\u7ec4\u7ec7id\u6216\u8005\u7f16\u7801\u67e5\u8be2\u5f53\u524d\u7ec4\u7ec7\u7684\u76f4\u63a5\u4e0a\u7ea7\u7ec4\u7ec7")
    @PostMapping(value={"/findSingleParentOrg"})
    @CrmDictMethod
    public Result<MdmOrgRespVo> findSingleParentOrg(@RequestBody MdmOrgReqVo reqVo) {
        return Result.ok((Object)this.mdmOrgService.findSingleParentOrg(reqVo.getId(), reqVo.getOrgCode()));
    }

    @ApiOperation(value="\u91cd\u7f6e\u7ec4\u7ec7\u6811\u964d\u7ef4\u7f16\u7801")
    @PostMapping(value={"/resetRuleCode"})
    @CrmDictMethod
    public Result resetRuleCode() {
        this.mdmOrgService.resetRuleCode();
        return Result.ok();
    }
}

