/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.org.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.annotation.Klock;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.base.CrmTreeTenEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.customer.model.MdmCustomerMsgEntity;
import com.biz.crm.customer.service.IMdmCustomerMsgService;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.mdm.org.req.MdmOrgReqVo;
import com.biz.crm.nebular.mdm.org.req.MdmOrgSelectReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgSelectRespVo;
import com.biz.crm.org.mapper.MdmOrgMapper;
import com.biz.crm.org.model.MdmOrgEntity;
import com.biz.crm.org.service.IMdmOrgService;
import com.biz.crm.orgregion.model.MdmOrgRegionEntity;
import com.biz.crm.orgregion.service.IMdmOrgRegionService;
import com.biz.crm.position.model.MdmPositionEntity;
import com.biz.crm.position.service.IMdmPositionService;
import com.biz.crm.terminal.model.MdmTerminalEntity;
import com.biz.crm.terminal.service.IMdmTerminalService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.utils.TreeRuleCodeUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"MdmOrgServiceExpandImpl"})
public class MdmOrgServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmOrgMapper, MdmOrgEntity>
implements IMdmOrgService {
    private static final Logger log = LoggerFactory.getLogger(MdmOrgServiceImpl.class);
    @Resource
    private MdmOrgMapper mdmOrgMapper;
    @Resource
    private IMdmPositionService mdmPositionService;
    @Resource
    private IMdmTerminalService mdmTerminalService;
    @Resource
    private IMdmCustomerMsgService mdmCustomerMsgService;
    @Resource
    private IMdmOrgRegionService mdmOrgRegionService;

    @Override
    public PageResult<MdmOrgRespVo> findList(MdmOrgReqVo reqVo) {
        MdmOrgEntity one;
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        if (!StringUtils.isEmpty((String)reqVo.getCode()) && (one = (MdmOrgEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmOrgEntity::getOrgCode, (Object)reqVo.getCode())).one())) != null) {
            reqVo.setRuleCode(one.getRuleCode());
        }
        List<MdmOrgRespVo> list = this.mdmOrgMapper.findList((Page<MdmOrgRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmOrgRespVo query(MdmOrgReqVo reqVo) {
        MdmOrgEntity one;
        if ((StringUtils.isNotEmpty((String)reqVo.getId()) || StringUtils.isNotEmpty((String)reqVo.getOrgCode())) && (one = (MdmOrgEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)reqVo.getId()), BaseIdEntity::getId, (Object)reqVo.getId())).eq(StringUtils.isNotEmpty((String)reqVo.getOrgCode()), MdmOrgEntity::getOrgCode, (Object)reqVo.getOrgCode())).one())) != null) {
            return (MdmOrgRespVo)CrmBeanUtil.copy((Object)((Object)one), MdmOrgRespVo.class);
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmOrgReqVo reqVo) {
        Assert.hasText((String)reqVo.getOrgName(), (String)"\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getOrgType(), (String)"\u7ec4\u7ec7\u5c42\u7ea7\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getEnableStatus(), (String)"\u542f\u7528\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a");
        MdmOrgEntity entity = (MdmOrgEntity)((Object)CrmBeanUtil.copy((Object)reqVo, MdmOrgEntity.class));
        int levelNum = 1;
        if (StringUtils.isNotEmpty((String)reqVo.getParentCode())) {
            MdmOrgEntity parent = (MdmOrgEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmOrgEntity::getOrgCode, (Object)reqVo.getParentCode())).one());
            Assert.notNull((Object)((Object)parent), (String)"\u4e0a\u7ea7\u7ec4\u7ec7\u4e0d\u5b58\u5728");
            Assert.isTrue((boolean)CrmEnableStatusEnum.ENABLE.getCode().equals(parent.getEnableStatus()), (String)"\u4e0a\u7ea7\u7ec4\u7ec7\u88ab\u7981\u7528");
            levelNum = parent.getLevelNum() + 1;
        }
        entity.setRuleCode(this.generateRuleCodeByParentCode(entity.getParentCode()));
        entity.setLevelNum(levelNum);
        if (StringUtils.isEmpty((String)entity.getOrgCode())) {
            entity.setOrgCode(CodeUtil.generateCode((String)CodeRuleEnum.MDM_ORG_CODE.getCode()));
        }
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmOrgReqVo reqVo) {
        String id = reqVo.getId();
        Assert.hasText((String)id, (String)"\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getOrgCode(), (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getOrgName(), (String)"\u7ec4\u7ec7\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        MdmOrgEntity entity = (MdmOrgEntity)((Object)this.getById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)entity), (String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728");
        Assert.isTrue((boolean)entity.getOrgCode().equals(reqVo.getOrgCode()), (String)"\u7ec4\u7ec7\u7f16\u7801\u4e0d\u80fd\u4fee\u6539");
        String entityRuleCode = entity.getRuleCode();
        String parentCode = reqVo.getParentCode();
        boolean reloadRuleCode = false;
        int levelNum = 1;
        if (StringUtils.isNotEmpty((String)parentCode)) {
            Assert.isTrue((!entity.getOrgCode().equals(parentCode) ? 1 : 0) != 0, (String)"\u4e0a\u7ea7\u7ec4\u7ec7\u4e0d\u80fd\u4e3a\u5f53\u524d\u7ec4\u7ec7");
            if (!parentCode.equals(entity.getParentCode())) {
                reloadRuleCode = true;
                MdmOrgEntity parent = (MdmOrgEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmOrgEntity::getOrgCode, (Object)parentCode)).one());
                Assert.notNull((Object)((Object)parent), (String)"\u4e0a\u7ea7\u7ec4\u7ec7\u4e0d\u5b58\u5728");
                Assert.isTrue((boolean)CrmEnableStatusEnum.ENABLE.getCode().equals(parent.getEnableStatus()), (String)"\u4e0a\u7ea7\u7ec4\u7ec7\u88ab\u7981\u7528");
                String parentRuleCode = parent.getRuleCode();
                Assert.hasText((String)parentRuleCode, (String)"\u4e0a\u7ea7\u7ec4\u7ec7ruleCode\u4e0d\u80fd\u4e3a\u7a7a");
                Assert.isTrue((!parentRuleCode.startsWith(entityRuleCode) ? 1 : 0) != 0, (String)"\u4e0a\u7ea7\u7ec4\u7ec7\u4e0d\u80fd\u662f\u5f53\u524d\u7ec4\u7ec7\u7684\u4e0b\u7ea7\u7ec4\u7ec7");
                levelNum = parent.getLevelNum() + 1;
            }
        } else if (!StringUtils.isEmpty((String)entity.getParentCode())) {
            reloadRuleCode = true;
            reqVo.setParentCode("");
        }
        if (!entity.getEnableStatus().equals(reqVo.getEnableStatus()) && CrmEnableStatusEnum.DISABLE.getCode().equals(reqVo.getEnableStatus())) {
            this.disableBatch(new MdmOrgReqVo().setIds(Collections.singletonList(entity.getId())));
        }
        this.updateById(CrmBeanUtil.copy((Object)reqVo, MdmOrgEntity.class));
        if (reloadRuleCode) {
            String ruleCode = this.generateRuleCodeByParentCode(reqVo.getParentCode());
            this.updateCurAndChildren(entity.getOrgCode(), ruleCode, levelNum);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmOrgReqVo reqVo) {
        Assert.notEmpty((Collection)reqVo.getIds(), (String)"\u7f3a\u5931\u53c2\u6570");
        Assert.isTrue((reqVo.getIds().size() == 1 ? 1 : 0) != 0, (String)"\u4e0d\u652f\u6301\u6279\u91cf\u64cd\u4f5c");
        reqVo.getIds().forEach(id -> {
            Assert.hasText((String)id, (String)"\u4e0d\u80fd\u4f20\u7a7a\u503c");
            MdmOrgEntity one = (MdmOrgEntity)((Object)((Object)this.getById((Serializable)((Object)id))));
            Assert.notNull((Object)((Object)one), (String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728");
            List children = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmOrgEntity::getParentCode, (Object)one.getOrgCode())).select(new SFunction[]{BaseIdEntity::getId}).list();
            Assert.isTrue((boolean)CollectionUtils.isEmpty((Collection)children), (String)"\u5305\u542b\u4e0b\u7ea7\u7ec4\u7ec7\u7684\u7ec4\u7ec7\u4e0d\u80fd\u88ab\u5220\u9664");
            List positionList = ((LambdaQueryChainWrapper)this.mdmPositionService.lambdaQuery().eq(MdmPositionEntity::getOrgCode, (Object)one.getOrgCode())).select(new SFunction[]{BaseIdEntity::getId}).list();
            Assert.isTrue((boolean)CollectionUtils.isEmpty((Collection)positionList), (String)"\u5b58\u5728\u5173\u8054\u804c\u4f4d\u65e0\u6cd5\u5220\u9664");
            List terminalList = ((LambdaQueryChainWrapper)this.mdmTerminalService.lambdaQuery().eq(MdmTerminalEntity::getOrgCode, (Object)one.getOrgCode())).select(new SFunction[]{BaseIdEntity::getId}).list();
            Assert.isTrue((boolean)CollectionUtils.isEmpty((Collection)terminalList), (String)"\u5b58\u5728\u5173\u8054\u7ec8\u7aef\u65e0\u6cd5\u5220\u9664");
            List customerList = ((LambdaQueryChainWrapper)this.mdmCustomerMsgService.lambdaQuery().eq(MdmCustomerMsgEntity::getOrgCode, (Object)one.getOrgCode())).select(new SFunction[]{BaseIdEntity::getId}).list();
            Assert.isTrue((boolean)CollectionUtils.isEmpty((Collection)customerList), (String)"\u5b58\u5728\u5173\u8054\u5ba2\u6237\u65e0\u6cd5\u5220\u9664");
            List orgRegionList = ((LambdaQueryChainWrapper)this.mdmOrgRegionService.lambdaQuery().eq(MdmOrgRegionEntity::getOrgCode, (Object)one.getOrgCode())).select(new SFunction[]{BaseIdEntity::getId}).list();
            Assert.isTrue((boolean)CollectionUtils.isEmpty((Collection)orgRegionList), (String)"\u5b58\u5728\u5173\u8054\u884c\u653f\u533a\u57df\u65e0\u6cd5\u5220\u9664");
            this.removeById((Serializable)((Object)id));
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(MdmOrgReqVo reqVo) {
        Assert.notEmpty((Collection)reqVo.getIds(), (String)"\u7f3a\u5931\u53c2\u6570");
        Assert.isTrue((reqVo.getIds().size() == 1 ? 1 : 0) != 0, (String)"\u4e0d\u652f\u6301\u6279\u91cf\u64cd\u4f5c");
        reqVo.getIds().forEach(id -> {
            MdmOrgEntity entity = (MdmOrgEntity)((Object)((Object)this.getById((Serializable)((Object)id))));
            Assert.notNull((Object)((Object)entity), (String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728");
            Assert.isTrue((boolean)CrmEnableStatusEnum.DISABLE.getCode().equals(entity.getEnableStatus()), (String)"\u53ea\u80fd\u542f\u7528\u72b6\u6001\u4e3a\u201d\u7981\u7528\u201c\u7684\u4f01\u4e1a\u7ec4\u7ec7");
            Set<String> parentRuleCodes = TreeRuleCodeUtil.splitParentRuleCodes(entity.getRuleCode());
            List disableParentList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).in(CrmTreeTenEntity::getRuleCode, parentRuleCodes)).list();
            Assert.isTrue((boolean)CollectionUtil.listEmpty((List)disableParentList), (String)"\u5b58\u5728\u672a\u542f\u7528\u7684\u4e0a\u7ea7\u7ec4\u7ec7\uff0c\u65e0\u6cd5\u542f\u7528\u5f53\u524d\u7ec4\u7ec7");
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(BaseIdEntity::getId, id)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).update();
        });
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(MdmOrgReqVo reqVo) {
        Assert.notEmpty((Collection)reqVo.getIds(), (String)"\u7f3a\u5931\u53c2\u6570");
        Assert.isTrue((reqVo.getIds().size() == 1 ? 1 : 0) != 0, (String)"\u4e0d\u652f\u6301\u6279\u91cf\u64cd\u4f5c");
        reqVo.getIds().forEach(id -> {
            MdmOrgEntity entity = (MdmOrgEntity)((Object)((Object)this.getById((Serializable)((Object)id))));
            Assert.notNull((Object)((Object)entity), (String)"\u7ec4\u7ec7\u4e0d\u5b58\u5728");
            Assert.isTrue((boolean)CrmEnableStatusEnum.ENABLE.getCode().equals(entity.getEnableStatus()), (String)"\u53ea\u80fd\u7981\u7528\u72b6\u6001\u4e3a\u201d\u542f\u7528\u201c\u7684\u4f01\u4e1a\u7ec4\u7ec7");
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().likeRight(CrmTreeTenEntity::getRuleCode, (Object)entity.getRuleCode())).eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
        });
    }

    @Override
    public List<MdmOrgSelectRespVo> findOrgSelectList(MdmOrgSelectReqVo reqVo) {
        MdmOrgEntity one;
        String underThisRuleCode = null;
        String notUnderThisRuleCode = null;
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        if (StringUtils.isNotEmpty((String)reqVo.getUnderThisOrgCode()) && (one = (MdmOrgEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmOrgEntity::getOrgCode, (Object)reqVo.getUnderThisOrgCode())).select(new SFunction[]{CrmTreeTenEntity::getRuleCode}).one())) != null) {
            underThisRuleCode = one.getRuleCode();
        }
        if (StringUtils.isNotEmpty((String)reqVo.getNotUnderThisOrgCode()) && (one = (MdmOrgEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmOrgEntity::getOrgCode, (Object)reqVo.getNotUnderThisOrgCode())).select(new SFunction[]{CrmTreeTenEntity::getRuleCode}).one())) != null) {
            notUnderThisRuleCode = one.getRuleCode();
        }
        return this.mdmOrgMapper.findOrgSelectList((Page<MdmOrgSelectRespVo>)page, reqVo, CrmEnableStatusEnum.ENABLE.getCode(), underThisRuleCode, notUnderThisRuleCode);
    }

    @Override
    public List<MdmOrgRespVo> findAllChildrenOrgList(String orgId, String orgCode) {
        MdmOrgEntity org;
        ArrayList<MdmOrgRespVo> list = new ArrayList<MdmOrgRespVo>();
        if ((StringUtils.isNotEmpty((String)orgId) || StringUtils.isNotEmpty((String)orgCode)) && (org = (MdmOrgEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)orgId), BaseIdEntity::getId, (Object)orgId)).eq(StringUtils.isNotEmpty((String)orgCode), MdmOrgEntity::getOrgCode, (Object)orgCode)).select(new SFunction[]{CrmTreeTenEntity::getRuleCode}).one())) != null) {
            List entityList = ((LambdaQueryChainWrapper)this.lambdaQuery().likeRight(CrmTreeTenEntity::getRuleCode, (Object)org.getRuleCode())).list();
            list.addAll(CrmBeanUtil.copyList((List)entityList, MdmOrgRespVo.class));
        }
        return list;
    }

    @Override
    public List<MdmOrgRespVo> findAllChildrenOrgListByList(List<String> ids, List<String> orgCodeList) {
        List orgEntityList;
        ArrayList<MdmOrgRespVo> list = new ArrayList<MdmOrgRespVo>();
        if ((CollectionUtil.listNotEmptyNotSizeZero(ids) || CollectionUtil.listNotEmptyNotSizeZero(orgCodeList)) && CollectionUtil.listNotEmptyNotSizeZero((List)(orgEntityList = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().in(CollectionUtil.listNotEmptyNotSizeZero(ids), BaseIdEntity::getId, ids)).in(CollectionUtil.listNotEmptyNotSizeZero(orgCodeList), MdmOrgEntity::getOrgCode, orgCodeList)).select(new SFunction[]{CrmTreeTenEntity::getRuleCode}).list()))) {
            List collect = orgEntityList.stream().map(CrmTreeTenEntity::getRuleCode).collect(Collectors.toList());
            HashSet set = new HashSet();
            for (String ruleCode : collect) {
                List childrenList = ((LambdaQueryChainWrapper)this.lambdaQuery().likeRight(CrmTreeTenEntity::getRuleCode, (Object)ruleCode)).select(new SFunction[]{MdmOrgEntity::getOrgCode}).list();
                if (!CollectionUtil.listNotEmptyNotSizeZero((List)childrenList)) continue;
                set.addAll(childrenList.stream().map(MdmOrgEntity::getOrgCode).collect(Collectors.toList()));
            }
            if (!set.isEmpty()) {
                List orgList = ((LambdaQueryChainWrapper)this.lambdaQuery().in(MdmOrgEntity::getOrgCode, set)).list();
                list.addAll(CrmBeanUtil.copyList((List)orgList, MdmOrgRespVo.class));
            }
        }
        return list;
    }

    @Override
    public List<String> findAllChildrenOrgCodeList(String orgId, String orgCode) {
        MdmOrgEntity org;
        ArrayList<String> list = new ArrayList<String>();
        if ((StringUtils.isNotEmpty((String)orgId) || StringUtils.isNotEmpty((String)orgCode)) && (org = (MdmOrgEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)orgId), BaseIdEntity::getId, (Object)orgId)).eq(StringUtils.isNotEmpty((String)orgCode), MdmOrgEntity::getOrgCode, (Object)orgCode)).select(new SFunction[]{CrmTreeTenEntity::getRuleCode}).one())) != null) {
            List entityList = ((LambdaQueryChainWrapper)this.lambdaQuery().likeRight(CrmTreeTenEntity::getRuleCode, (Object)org.getRuleCode())).select(new SFunction[]{MdmOrgEntity::getOrgCode}).list();
            list.addAll(entityList.stream().map(MdmOrgEntity::getOrgCode).collect(Collectors.toList()));
        }
        return list;
    }

    @Override
    public List<MdmOrgRespVo> findSingleChildrenOrgList(String orgId, String orgCode) {
        MdmOrgEntity org;
        ArrayList<MdmOrgRespVo> list = new ArrayList<MdmOrgRespVo>();
        if ((StringUtils.isNotEmpty((String)orgId) || StringUtils.isNotEmpty((String)orgCode)) && (org = (MdmOrgEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)orgId), BaseIdEntity::getId, (Object)orgId)).eq(StringUtils.isNotEmpty((String)orgCode), MdmOrgEntity::getOrgCode, (Object)orgCode)).one())) != null) {
            List entityList = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmOrgEntity::getParentCode, (Object)org.getOrgCode())).list();
            list.addAll(CrmBeanUtil.copyList((List)entityList, MdmOrgRespVo.class));
        }
        return list;
    }

    @Override
    public List<MdmOrgRespVo> findAllParentOrgList(String orgId, String orgCode) {
        ArrayList<MdmOrgRespVo> list = new ArrayList<MdmOrgRespVo>();
        MdmOrgEntity one = (MdmOrgEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)orgId), BaseIdEntity::getId, (Object)orgId)).eq(StringUtils.isNotEmpty((String)orgCode), MdmOrgEntity::getOrgCode, (Object)orgCode)).one());
        if (one != null) {
            Set<String> ruleCodes = TreeRuleCodeUtil.splitParentRuleCodes(one.getRuleCode());
            List entityList = ((LambdaQueryChainWrapper)this.lambdaQuery().in(CrmTreeTenEntity::getRuleCode, ruleCodes)).list();
            list.addAll(CrmBeanUtil.copyList((List)entityList, MdmOrgRespVo.class));
        }
        return list;
    }

    @Override
    public MdmOrgRespVo findSingleParentOrg(String orgId, String orgCode) {
        MdmOrgEntity parent;
        MdmOrgEntity one;
        if ((StringUtils.isNotEmpty((String)orgId) || StringUtils.isNotEmpty((String)orgCode)) && (one = (MdmOrgEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)orgId), BaseIdEntity::getId, (Object)orgId)).eq(StringUtils.isNotEmpty((String)orgCode), MdmOrgEntity::getOrgCode, (Object)orgCode)).one())) != null && StringUtils.isNotEmpty((String)one.getParentCode()) && (parent = (MdmOrgEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmOrgEntity::getOrgCode, (Object)one.getParentCode())).one())) != null) {
            return (MdmOrgRespVo)CrmBeanUtil.copy((Object)((Object)parent), MdmOrgRespVo.class);
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    @Klock
    public void resetRuleCode() {
        List all = this.lambdaQuery().list();
        all.forEach(item -> item.setRuleCode(UUID.randomUUID().toString()));
        this.updateBatchById(all);
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().isNull(MdmOrgEntity::getParentCode)).or()).eq(MdmOrgEntity::getParentCode, (Object)"")).list();
        for (int i = 0; i < list.size(); ++i) {
            this.updateCurAndChildren(((MdmOrgEntity)((Object)list.get(i))).getOrgCode(), TreeRuleCodeUtil.numToSingleCode(i + 1), 1);
        }
    }

    private String generateRuleCodeByParentCode(String parentCode) {
        MdmOrgEntity parent;
        String ruleCode = "";
        boolean top = true;
        String prefix = "";
        if (StringUtils.isNotEmpty((String)parentCode) && (parent = (MdmOrgEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmOrgEntity::getOrgCode, (Object)parentCode)).one())) != null) {
            top = false;
            prefix = parent.getRuleCode();
        }
        List list = null;
        list = top ? ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().isNull(MdmOrgEntity::getParentCode)).or()).eq(MdmOrgEntity::getParentCode, (Object)"")).list() : ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmOrgEntity::getParentCode, (Object)parentCode)).list();
        if (CollectionUtil.listEmpty((List)list)) {
            ruleCode = prefix + TreeRuleCodeUtil.numToSingleCode(1);
        } else {
            LinkedHashSet<Integer> set = new LinkedHashSet<Integer>();
            for (MdmOrgEntity item : list) {
                if (!StringUtils.isNotEmpty((String)item.getRuleCode())) continue;
                Integer integer = TreeRuleCodeUtil.getCurLevelNum(item.getRuleCode());
                set.add(integer);
            }
            for (int i = 1; i < 999; ++i) {
                if (set.contains(i)) continue;
                ruleCode = prefix + TreeRuleCodeUtil.numToSingleCode(i);
                break;
            }
        }
        return ruleCode;
    }

    private void updateCurAndChildren(String orgCode, String curCode, int levelNum) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmOrgEntity::getOrgCode, (Object)orgCode)).set(CrmTreeTenEntity::getRuleCode, (Object)curCode)).set(CrmTreeTenEntity::getLevelNum, (Object)levelNum)).update();
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmOrgEntity::getParentCode, (Object)orgCode)).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            for (int i = 0; i < list.size(); ++i) {
                this.updateCurAndChildren(((MdmOrgEntity)((Object)list.get(i))).getOrgCode(), curCode + TreeRuleCodeUtil.numToSingleCode(i + 1), levelNum + 1);
            }
        }
    }
}

