/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.permission.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.mdm.permission.MdmListConfigReqVo;
import com.biz.crm.nebular.mdm.permission.MdmListConfigRespVo;
import com.biz.crm.nebular.mdm.permission.MdmPermissionMenuRespVo;
import com.biz.crm.nebular.mdm.permission.MdmPermissionModelReqVo;
import com.biz.crm.nebular.mdm.permission.MdmPermissionObjReqVo;
import com.biz.crm.nebular.mdm.permission.MdmPermissionObjRespVo;
import com.biz.crm.nebular.mdm.permission.MdmPermissionReqVo;
import com.biz.crm.nebular.mdm.permission.MdmPermissionRespVo;
import com.biz.crm.nebular.mdm.permission.MdmPermissionSearchTypeVo;
import com.biz.crm.nebular.mdm.permission.MdmPermissionSubModelRespVo;
import com.biz.crm.permission.mapper.MdmPermissionMapper;
import com.biz.crm.permission.model.MdmCompetenceEntity;
import com.biz.crm.permission.model.MdmPermissionEntity;
import com.biz.crm.permission.model.MdmPermissionSearchTypeEntity;
import com.biz.crm.permission.service.IMdmListConfigService;
import com.biz.crm.permission.service.IMdmPermissionService;
import com.biz.crm.permission.service.MdmPermissionSearchTypeService;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.DictUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.utils.DatabaseTypeUtil;
import com.biz.crm.utils.PinYinUtil;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.ObjectUtils;

@Service
@ConditionalOnMissingBean(name={"MdmPermissionServiceExpandImpl"})
public class MdmPermissionServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmPermissionMapper, MdmPermissionEntity>
implements IMdmPermissionService {
    private static final Logger log = LoggerFactory.getLogger(MdmPermissionServiceImpl.class);
    @Resource
    private MdmPermissionMapper mdmPermissionMapper;
    @Resource
    private IMdmListConfigService mdmListConfigService;
    @Resource
    private MdmPermissionSearchTypeService mdmPermissionSearchTypeService;

    @Override
    @CrmDictMethod
    public PageResult<MdmPermissionRespVo> findList(MdmPermissionReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmPermissionRespVo> list = this.mdmPermissionMapper.findList((Page<MdmPermissionRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmPermissionRespVo query(MdmPermissionReqVo reqVo) {
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmPermissionReqVo reqVo) {
        String competenceCode = reqVo.getCompetenceCode();
        Assert.hasText((String)competenceCode, (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        String listConfigCode = reqVo.getListConfigCode();
        Assert.hasText((String)listConfigCode, (String)"\u5217\u8868\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        MdmPermissionEntity one = (MdmPermissionEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPermissionEntity::getCompetenceCode, (Object)reqVo.getCompetenceCode())).eq(MdmPermissionEntity::getListConfigCode, (Object)reqVo.getListConfigCode())).last(DatabaseTypeUtil.SEGMENT)).select(new SFunction[]{BaseIdEntity::getId}).one());
        Assert.isNull((Object)((Object)one), (String)"\u6b64\u83dc\u5355+\u5217\u8868\u7ec4\u5408\u5df2\u5b58\u5728\uff0c\u8bf7\u91cd\u65b0\u8f93\u5165");
        MdmPermissionEntity entity = (MdmPermissionEntity)((Object)CrmBeanUtil.copy((Object)reqVo, MdmPermissionEntity.class));
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmPermissionReqVo reqVo) {
        Assert.hasText((String)reqVo.getId(), (String)"\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getCompetenceCode(), (String)"\u83dc\u5355\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getListConfigCode(), (String)"\u5217\u8868\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        this.updateById(CrmBeanUtil.copy((Object)reqVo, MdmPermissionEntity.class));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmPermissionReqVo reqVo) {
        List ids = reqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isTrue((ids.size() == 1 ? 1 : 0) != 0, (String)"\u6743\u9650\u914d\u7f6e\u4ec5\u652f\u6301\u5355\u9009");
        this.removeByIds(ids);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(MdmPermissionReqVo reqVo) {
        List ids = reqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, (Collection)ids)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).update();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(MdmPermissionReqVo reqVo) {
        List ids = reqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(BaseIdEntity::getId, (Collection)ids)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
    }

    @Override
    public List<MdmListConfigRespVo> configList(MdmListConfigReqVo mdmListConfigReqVo) {
        List<MdmListConfigRespVo> configList = !StringUtils.isEmpty((String)mdmListConfigReqVo.getCompetenceCode()) ? this.mdmPermissionMapper.findConfigList(mdmListConfigReqVo) : this.mdmListConfigService.listCondition(mdmListConfigReqVo);
        if (!CollectionUtils.isEmpty(configList)) {
            return configList.stream().sorted(Comparator.comparing(x -> PinYinUtil.getPinYin(x.getListConfigName()))).collect(Collectors.toList());
        }
        return configList;
    }

    @Override
    public List<MdmPermissionMenuRespVo> menuList(MdmPermissionModelReqVo mdmPermissionModelReqVo) {
        List<MdmCompetenceEntity> list = this.mdmPermissionMapper.findMenuList(mdmPermissionModelReqVo);
        if (CollectionUtils.isEmpty(list)) {
            return Collections.emptyList();
        }
        List modelList = list.stream().filter(x -> StringUtils.isEmpty((String)x.getParentId()) && !StringUtils.isEmpty((String)x.getModelType())).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(modelList)) {
            return Collections.emptyList();
        }
        return modelList.stream().map(mdmCompetenceEntity -> {
            MdmPermissionMenuRespVo mdmPermissionMenuRespVo = new MdmPermissionMenuRespVo();
            mdmPermissionMenuRespVo.setModelType(mdmCompetenceEntity.getModelType());
            mdmPermissionMenuRespVo.setModelTypeName(mdmCompetenceEntity.getModelTypeName());
            List collect = list.stream().filter(x -> mdmCompetenceEntity.getId().equals(x.getParentId())).map(x -> {
                MdmPermissionSubModelRespVo mdmPermissionSubModelRespVo = new MdmPermissionSubModelRespVo();
                mdmPermissionSubModelRespVo.setCompetenceCode(x.getCompetenceCode());
                mdmPermissionSubModelRespVo.setCompetenceName(x.getCompetenceName());
                return mdmPermissionSubModelRespVo;
            }).collect(Collectors.toList());
            mdmPermissionMenuRespVo.setChildren(collect);
            return mdmPermissionMenuRespVo;
        }).collect(Collectors.toList());
    }

    @Override
    public List<MdmPermissionObjRespVo> objList(MdmPermissionReqVo mdmPermissionReqVo) {
        Map map = DictUtil.getDictValueMapsByCodes((String)"permission_obj");
        if (ObjectUtils.isEmpty((Object)map)) {
            return Collections.emptyList();
        }
        String competenceCode = mdmPermissionReqVo.getCompetenceCode();
        String listConfigCode = mdmPermissionReqVo.getListConfigCode();
        if (StringUtils.isEmpty((String)competenceCode) || StringUtils.isEmpty((String)listConfigCode)) {
            return this.obtainEmptyObj(map);
        }
        MdmPermissionEntity mdmPermissionEntity = (MdmPermissionEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPermissionEntity::getCompetenceCode, (Object)competenceCode)).eq(MdmPermissionEntity::getListConfigCode, (Object)listConfigCode)).last(DatabaseTypeUtil.SEGMENT)).one());
        if (mdmPermissionEntity == null) {
            log.error("\u5bf9\u8c61competenceCode:{},listConfigCode:{}\u4e0d\u5b58\u5728", (Object)competenceCode, (Object)listConfigCode);
            return Collections.emptyList();
        }
        String permissionObj = mdmPermissionEntity.getPermissionObj();
        if (StringUtils.isEmpty((String)permissionObj)) {
            Integer isSelect = mdmPermissionReqVo.getIsSelect();
            if (isSelect != null && isSelect == 1) {
                return Collections.emptyList();
            }
            return this.obtainEmptyObj(map);
        }
        List<String> permissionObjList = Arrays.asList(permissionObj.split(","));
        return map.keySet().stream().map(x -> {
            MdmPermissionObjRespVo mdmPermissionObjRespVo = new MdmPermissionObjRespVo();
            mdmPermissionObjRespVo.setPermissionObjCode(x);
            mdmPermissionObjRespVo.setPermissionObjName((String)map.get(x));
            mdmPermissionObjRespVo.setIsSelect(Integer.valueOf(permissionObjList.contains(x) ? 1 : 0));
            return mdmPermissionObjRespVo;
        }).filter(x -> {
            Integer isSelect = mdmPermissionReqVo.getIsSelect();
            if (isSelect != null && 1 == isSelect) {
                return x.getIsSelect() == 1;
            }
            return true;
        }).collect(Collectors.toList());
    }

    private List<MdmPermissionObjRespVo> obtainEmptyObj(Map<String, String> map) {
        return map.keySet().stream().map(x -> {
            MdmPermissionObjRespVo mdmPermissionObjRespVo = new MdmPermissionObjRespVo();
            mdmPermissionObjRespVo.setPermissionObjCode(x);
            mdmPermissionObjRespVo.setPermissionObjName((String)map.get(x));
            mdmPermissionObjRespVo.setIsSelect(Integer.valueOf(0));
            return mdmPermissionObjRespVo;
        }).collect(Collectors.toList());
    }

    @Override
    public List<MdmPermissionSearchTypeVo> searchTypeList(MdmPermissionSearchTypeVo mdmPermissionSearchTypeVo) {
        String permissionObjCode = mdmPermissionSearchTypeVo.getPermissionObjCode();
        List list = ((LambdaQueryChainWrapper)this.mdmPermissionSearchTypeService.lambdaQuery().eq(!StringUtils.isEmpty((String)permissionObjCode), MdmPermissionSearchTypeEntity::getPermissionObjCode, (Object)permissionObjCode)).list();
        return CrmBeanUtil.copyList((List)list, MdmPermissionSearchTypeVo.class);
    }

    @Override
    public void saveObj(MdmPermissionObjReqVo mdmPermissionObjReqVo) {
        String permissionId = mdmPermissionObjReqVo.getPermissionId();
        Assert.hasText((String)permissionId, (String)"\u6743\u9650\u914d\u7f6eid\u4e0d\u80fd\u4e3a\u7a7a");
        List mdmPermissionObjRespVos = mdmPermissionObjReqVo.getMdmPermissionObjRespVos();
        if (CollectionUtils.isEmpty((Collection)mdmPermissionObjRespVos)) {
            ((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(BaseIdEntity::getId, (Object)permissionId)).set(MdmPermissionEntity::getPermissionObj, null);
            return;
        }
        String collect = mdmPermissionObjRespVos.stream().map(MdmPermissionObjRespVo::getPermissionObjCode).collect(Collectors.joining(","));
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(BaseIdEntity::getId, (Object)permissionId)).set(MdmPermissionEntity::getPermissionObj, (Object)collect)).update();
    }

    @Override
    public List<MdmPermissionSubModelRespVo> menuSelect(MdmPermissionModelReqVo mdmPermissionModelReqVo) {
        List mdmPermissionSubModelRespVos;
        Integer isSelect = mdmPermissionModelReqVo.getIsSelect();
        if (isSelect != null && 1 == isSelect) {
            mdmPermissionSubModelRespVos = this.mdmPermissionMapper.findConfigMenuList(mdmPermissionModelReqVo);
        } else {
            List<MdmCompetenceEntity> menuList = this.mdmPermissionMapper.findMenuList(mdmPermissionModelReqVo);
            mdmPermissionSubModelRespVos = CrmBeanUtil.copyList(menuList, MdmPermissionSubModelRespVo.class);
        }
        if (!CollectionUtils.isEmpty((Collection)mdmPermissionSubModelRespVos)) {
            return mdmPermissionSubModelRespVos.stream().sorted(Comparator.comparing(x -> PinYinUtil.getPinYin(x.getCompetenceName()))).collect(Collectors.toList());
        }
        return mdmPermissionSubModelRespVos;
    }
}

