/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.position.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.annotation.Klock;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.BusinessException;
import com.biz.crm.base.CrmTreeTenEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.mdm.constant.UserTypeEnum;
import com.biz.crm.nebular.mdm.constant.YesOrNoEnum;
import com.biz.crm.nebular.mdm.org.req.MdmOrgReqVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRespVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionReqVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionSelectReqVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionUserOrgReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionSelectRespVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionUserOrgRespVo;
import com.biz.crm.nebular.mdm.positionlevel.req.MdmPositionLevelReqVo;
import com.biz.crm.nebular.mdm.positionlevel.resp.MdmPositionLevelRespVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRespVo;
import com.biz.crm.org.service.IMdmOrgService;
import com.biz.crm.position.mapper.MdmPositionMapper;
import com.biz.crm.position.model.MdmPositionEntity;
import com.biz.crm.position.service.IMdmPositionService;
import com.biz.crm.positionlevel.service.IMdmPositionLevelService;
import com.biz.crm.user.service.IMdmUserService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.StringUtils;
import com.biz.crm.utils.TreeRuleCodeUtil;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;
import org.springframework.util.CollectionUtils;

@Service
@ConditionalOnMissingBean(name={"MdmPositionServiceExpandImpl"})
public class MdmPositionServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmPositionMapper, MdmPositionEntity>
implements IMdmPositionService {
    private static final Logger log = LoggerFactory.getLogger(MdmPositionServiceImpl.class);
    @Resource
    private MdmPositionMapper mdmPositionMapper;
    @Resource
    private IMdmOrgService mdmOrgService;
    @Resource
    private IMdmUserService mdmUserService;
    @Resource
    private IMdmPositionLevelService mdmPositionLevelService;

    @Override
    public PageResult<MdmPositionRespVo> findList(MdmPositionReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<MdmPositionRespVo> list = this.mdmPositionMapper.findList((Page<MdmPositionRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmPositionRespVo query(MdmPositionReqVo reqVo) {
        MdmPositionEntity one;
        if ((StringUtils.isNotEmpty((String)reqVo.getId()) || StringUtils.isNotEmpty((String)reqVo.getPositionCode())) && (one = (MdmPositionEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(!StringUtils.isEmpty((String)reqVo.getId()), BaseIdEntity::getId, (Object)reqVo.getId())).eq(!StringUtils.isEmpty((String)reqVo.getPositionCode()), MdmPositionEntity::getPositionCode, (Object)reqVo.getPositionCode())).one())) != null) {
            return (MdmPositionRespVo)CrmBeanUtil.copy((Object)((Object)one), MdmPositionRespVo.class);
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmPositionReqVo reqVo) {
        MdmPositionEntity entity = (MdmPositionEntity)((Object)CrmBeanUtil.copy((Object)reqVo, MdmPositionEntity.class));
        if (StringUtils.isEmpty((String)entity.getPositionName())) {
            Assert.hasText((String)reqVo.getPositionLevelCode(), (String)"\u7f3a\u5931\u804c\u4f4d\u7ea7\u522b\u7f16\u7801");
            MdmPositionLevelRespVo positionLevel = this.mdmPositionLevelService.query(new MdmPositionLevelReqVo().setPositionLevelCode(reqVo.getPositionLevelCode()));
            Assert.notNull((Object)positionLevel, (String)"\u65e0\u6548\u7684\u804c\u4f4d\u7ea7\u522b\u7f16\u7801");
            entity.setPositionName(this.generatePositionName(positionLevel.getPositionLevelCode(), positionLevel.getPositionLevelName()));
        }
        if (StringUtils.isEmpty((String)entity.getPositionCode())) {
            entity.setPositionCode(CodeUtil.generateCode((String)CodeRuleEnum.MDM_POSITION_CODE.getCode()));
        }
        int levelNum = 1;
        if (StringUtils.isNotEmpty((String)reqVo.getParentCode())) {
            MdmPositionEntity parent = (MdmPositionEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionEntity::getPositionCode, (Object)reqVo.getParentCode())).one());
            Assert.notNull((Object)((Object)parent), (String)"\u4e0a\u7ea7\u804c\u4f4d\u4e0d\u5b58\u5728");
            Assert.isTrue((boolean)CrmEnableStatusEnum.ENABLE.getCode().equals(parent.getEnableStatus()), (String)"\u4e0a\u7ea7\u804c\u4f4d\u88ab\u7981\u7528");
            levelNum = parent.getLevelNum() + 1;
        }
        entity.setRuleCode(this.generateRuleCodeByParentCode(entity.getParentCode()));
        entity.setLevelNum(levelNum);
        this.save((Object)entity);
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public String saveAndReturnPositionCode(MdmPositionReqVo reqVo) {
        String positionCode = "";
        MdmPositionEntity entity = (MdmPositionEntity)((Object)CrmBeanUtil.copy((Object)reqVo, MdmPositionEntity.class));
        if (StringUtils.isEmpty((String)entity.getPositionName())) {
            Assert.hasText((String)reqVo.getPositionLevelCode(), (String)"\u7f3a\u5931\u804c\u4f4d\u7ea7\u522b\u7f16\u7801");
            MdmPositionLevelRespVo positionLevel = this.mdmPositionLevelService.query(new MdmPositionLevelReqVo().setPositionLevelCode(reqVo.getPositionLevelCode()));
            Assert.notNull((Object)positionLevel, (String)"\u65e0\u6548\u7684\u804c\u4f4d\u7ea7\u522b\u7f16\u7801");
            entity.setPositionName(this.generatePositionName(positionLevel.getPositionLevelCode(), positionLevel.getPositionLevelName()));
        }
        if (StringUtils.isEmpty((String)entity.getPositionCode())) {
            positionCode = CodeUtil.generateCode((String)CodeRuleEnum.MDM_POSITION_CODE.getCode());
            entity.setPositionCode(positionCode);
        } else {
            positionCode = reqVo.getPositionCode();
        }
        int levelNum = 1;
        if (StringUtils.isNotEmpty((String)reqVo.getParentCode())) {
            MdmPositionEntity parent = (MdmPositionEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionEntity::getPositionCode, (Object)reqVo.getParentCode())).one());
            Assert.notNull((Object)((Object)parent), (String)"\u4e0a\u7ea7\u804c\u4f4d\u4e0d\u5b58\u5728");
            Assert.isTrue((boolean)CrmEnableStatusEnum.ENABLE.getCode().equals(parent.getEnableStatus()), (String)"\u4e0a\u7ea7\u804c\u4f4d\u88ab\u7981\u7528");
            levelNum = parent.getLevelNum() + 1;
        }
        entity.setRuleCode(this.generateRuleCodeByParentCode(entity.getParentCode()));
        entity.setLevelNum(levelNum);
        this.save((Object)entity);
        return positionCode;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmPositionReqVo reqVo) {
        String id = reqVo.getId();
        Assert.hasText((String)id, (String)"\u4e3b\u952e\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getPositionCode(), (String)"\u804c\u4f4d\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.hasText((String)reqVo.getPositionName(), (String)"\u804c\u4f4d\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a");
        MdmPositionEntity entity = (MdmPositionEntity)((Object)this.getById((Serializable)((Object)id)));
        Assert.notNull((Object)((Object)entity), (String)"\u804c\u4f4d\u4e0d\u5b58\u5728");
        Assert.isTrue((boolean)entity.getPositionCode().equals(reqVo.getPositionCode()), (String)"\u804c\u4f4d\u7f16\u7801\u4e0d\u80fd\u4fee\u6539");
        String entityRuleCode = entity.getRuleCode();
        String parentCode = reqVo.getParentCode();
        boolean reloadRuleCode = false;
        int levelNum = 1;
        if (StringUtils.isNotEmpty((String)parentCode)) {
            Assert.isTrue((!entity.getPositionCode().equals(parentCode) ? 1 : 0) != 0, (String)"\u4e0a\u7ea7\u804c\u4f4d\u4e0d\u80fd\u4e3a\u5f53\u524d\u804c\u4f4d");
            if (!parentCode.equals(entity.getParentCode())) {
                reloadRuleCode = true;
                MdmPositionEntity parent = (MdmPositionEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionEntity::getPositionCode, (Object)parentCode)).one());
                Assert.notNull((Object)((Object)parent), (String)"\u4e0a\u7ea7\u804c\u4f4d\u4e0d\u5b58\u5728");
                Assert.isTrue((boolean)CrmEnableStatusEnum.ENABLE.getCode().equals(parent.getEnableStatus()), (String)"\u4e0a\u7ea7\u804c\u4f4d\u88ab\u7981\u7528");
                String parentRuleCode = parent.getRuleCode();
                Assert.hasText((String)parentRuleCode, (String)"\u4e0a\u7ea7\u804c\u4f4druleCode\u4e0d\u80fd\u4e3a\u7a7a");
                Assert.isTrue((!parentRuleCode.startsWith(entityRuleCode) ? 1 : 0) != 0, (String)"\u4e0a\u7ea7\u804c\u4f4d\u4e0d\u80fd\u662f\u5f53\u524d\u804c\u4f4d\u7684\u4e0b\u7ea7\u804c\u4f4d");
                levelNum = parent.getLevelNum() + 1;
            }
        } else if (!StringUtils.isEmpty((String)entity.getParentCode())) {
            reloadRuleCode = true;
            reqVo.setParentCode("");
        }
        if (!entity.getEnableStatus().equals(reqVo.getEnableStatus()) && CrmEnableStatusEnum.DISABLE.getCode().equals(reqVo.getEnableStatus())) {
            this.disableBatch(new MdmPositionReqVo().setIds(Collections.singletonList(entity.getId())));
        }
        this.updateById(CrmBeanUtil.copy((Object)reqVo, MdmPositionEntity.class));
        if (reloadRuleCode) {
            String ruleCode = this.generateRuleCodeByParentCode(reqVo.getParentCode());
            this.updateCurAndChildren(entity.getPositionCode(), ruleCode, levelNum);
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmPositionReqVo reqVo) {
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(MdmPositionReqVo reqVo) {
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(MdmPositionReqVo reqVo) {
    }

    @Override
    public List<MdmPositionRespVo> findAllParentPositionList(String id, String positionCode) {
        MdmPositionEntity position;
        ArrayList<MdmPositionRespVo> list = new ArrayList<MdmPositionRespVo>();
        if ((StringUtils.isNotEmpty((String)id) || StringUtils.isNotEmpty((String)positionCode)) && (position = (MdmPositionEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)id), BaseIdEntity::getId, (Object)id)).eq(StringUtils.isNotEmpty((String)positionCode), MdmPositionEntity::getPositionCode, (Object)positionCode)).one())) != null) {
            Set<String> ruleCodeSet = TreeRuleCodeUtil.splitParentRuleCodes(position.getRuleCode());
            List parentList = ((LambdaQueryChainWrapper)this.lambdaQuery().in(CrmTreeTenEntity::getRuleCode, ruleCodeSet)).list();
            list.addAll(CrmBeanUtil.copyList((List)parentList, MdmPositionRespVo.class));
        }
        return list;
    }

    @Override
    public List<MdmPositionRespVo> findAllChildrenPositionList(String id, String positionCode) {
        MdmPositionEntity position;
        if ((StringUtils.isNotEmpty((String)id) || StringUtils.isNotEmpty((String)positionCode)) && (position = (MdmPositionEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)id), BaseIdEntity::getId, (Object)id)).eq(StringUtils.isNotEmpty((String)positionCode), MdmPositionEntity::getPositionCode, (Object)positionCode)).select(new SFunction[]{CrmTreeTenEntity::getRuleCode}).one())) != null) {
            List list = ((LambdaQueryChainWrapper)this.lambdaQuery().likeRight(CrmTreeTenEntity::getRuleCode, (Object)position.getRuleCode())).list();
            return CrmBeanUtil.copyList((List)list, MdmPositionRespVo.class);
        }
        return new ArrayList<MdmPositionRespVo>();
    }

    @Override
    public List<String> findAllChildrenPositionCodeList(String id, String positionCode) {
        MdmPositionEntity position;
        if ((StringUtils.isNotEmpty((String)id) || StringUtils.isNotEmpty((String)positionCode)) && (position = (MdmPositionEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)id), BaseIdEntity::getId, (Object)id)).eq(StringUtils.isNotEmpty((String)positionCode), MdmPositionEntity::getPositionCode, (Object)positionCode)).select(new SFunction[]{CrmTreeTenEntity::getRuleCode}).one())) != null) {
            List list = ((LambdaQueryChainWrapper)this.lambdaQuery().likeRight(CrmTreeTenEntity::getRuleCode, (Object)position.getRuleCode())).select(new SFunction[]{MdmPositionEntity::getPositionCode}).list();
            return list.stream().map(MdmPositionEntity::getPositionCode).collect(Collectors.toList());
        }
        return new ArrayList<String>();
    }

    @Override
    public List<MdmPositionRespVo> findSingleChildrenPositionList(String id, String positionCode) {
        List children;
        MdmPositionEntity position;
        ArrayList<MdmPositionRespVo> list = new ArrayList<MdmPositionRespVo>();
        if ((StringUtils.isNotEmpty((String)id) || StringUtils.isNotEmpty((String)positionCode)) && (position = (MdmPositionEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)id), BaseIdEntity::getId, (Object)id)).eq(StringUtils.isNotEmpty((String)positionCode), MdmPositionEntity::getPositionCode, (Object)positionCode)).one())) != null && CollectionUtil.listNotEmptyNotSizeZero((List)(children = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionEntity::getParentCode, (Object)position.getPositionCode())).list()))) {
            list.addAll(CrmBeanUtil.copyList((List)children, MdmPositionRespVo.class));
        }
        return list;
    }

    @Override
    public List<MdmPositionSelectRespVo> findPositionSelectList(MdmPositionSelectReqVo reqVo) {
        reqVo.setEnableStatus(CrmEnableStatusEnum.ENABLE.getCode());
        List<MdmPositionSelectRespVo> list = this.mdmPositionMapper.findPositionSelectList(null, reqVo);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list.forEach(item -> item.setUnionName(this.generateUnionName(item.getOrgName(), item.getPositionName(), item.getFullName())));
        }
        return list;
    }

    @Override
    public PageResult<MdmPositionSelectRespVo> positionSelectPage(MdmPositionSelectReqVo reqVo) {
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        List<MdmPositionSelectRespVo> list = this.mdmPositionMapper.findPositionSelectList((Page<MdmPositionSelectRespVo>)page, reqVo);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            list.forEach(item -> item.setUnionName(this.generateUnionName(item.getOrgName(), item.getPositionName(), item.getFullName())));
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmPositionRespVo getUserPrimaryPosition(MdmUserReqVo reqVo) {
        List<MdmPositionRespVo> positionRelation = this.mdmPositionMapper.findPositionRelation(new MdmPositionReqVo().setUserName(reqVo.getUserName()).setUserId(reqVo.getId()));
        if (CollectionUtil.listNotEmptyNotSizeZero(positionRelation)) {
            for (MdmPositionRespVo positionItem : positionRelation) {
                if (!YesOrNoEnum.IO.YES.getCode().equals(positionItem.getPrimaryFlag())) continue;
                return positionItem;
            }
        }
        return null;
    }

    @Override
    public MdmPositionRespVo getUserCurrentPosition(MdmUserReqVo reqVo) {
        MdmUserRespVo userRespVo = this.mdmUserService.query(reqVo);
        if (userRespVo != null && UserTypeEnum.USER.getCode().equals(userRespVo.getUserType()) && CollectionUtil.listNotEmptyNotSizeZero((List)userRespVo.getPositionList())) {
            MdmPositionRespVo primaryPosition = null;
            for (MdmPositionRespVo positionItem : userRespVo.getPositionList()) {
                if (YesOrNoEnum.IO.YES.getCode().equals(positionItem.getPrimaryFlag())) {
                    primaryPosition = positionItem;
                }
                if (!YesOrNoEnum.IO.YES.getCode().equals(positionItem.getCurrentFlag())) continue;
                return positionItem;
            }
            if (primaryPosition != null) {
                this.changeUserCurrentPosition(new MdmPositionReqVo().setPositionCode(primaryPosition.getPositionCode()).setUserName(userRespVo.getUserName()));
                return primaryPosition;
            }
        }
        return null;
    }

    @Override
    public List<MdmPositionRespVo> getUserAllPositionList(MdmUserReqVo reqVo) {
        return this.mdmPositionMapper.findPositionRelation(new MdmPositionReqVo().setUserName(reqVo.getUserName()).setUserId(reqVo.getId()));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void changeUserPrimaryPosition(MdmPositionReqVo reqVo) {
        MdmUserRespVo userRespVo;
        if (StringUtils.isNotEmpty((String)reqVo.getUserName()) && StringUtils.isNotEmpty((String)reqVo.getPositionCode()) && (userRespVo = this.mdmUserService.query(new MdmUserReqVo().setUserName(reqVo.getUserName()))) != null && UserTypeEnum.USER.getCode().equals(userRespVo.getUserType()) && CollectionUtil.listNotEmptyNotSizeZero((List)userRespVo.getPositionList())) {
            List positionCodeList = userRespVo.getPositionList().stream().map(MdmPositionRespVo::getPositionCode).collect(Collectors.toList());
            if (positionCodeList.contains(reqVo.getPositionCode())) {
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().ne(MdmPositionEntity::getPositionCode, (Object)reqVo.getPositionCode())).in(MdmPositionEntity::getPositionCode, positionCodeList)).set(MdmPositionEntity::getPrimaryFlag, (Object)YesOrNoEnum.IO.NO)).update();
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmPositionEntity::getPositionCode, (Object)reqVo.getPositionCode())).set(MdmPositionEntity::getPrimaryFlag, (Object)YesOrNoEnum.IO.YES)).update();
            } else {
                throw new BusinessException("\u8be5\u7528\u6237\u6ca1\u6709\u5173\u8054\u8be5\u804c\u4f4d");
            }
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void changeUserCurrentPosition(MdmPositionReqVo reqVo) {
        MdmUserRespVo userRespVo;
        if (StringUtils.isNotEmpty((String)reqVo.getUserName()) && StringUtils.isNotEmpty((String)reqVo.getPositionCode()) && (userRespVo = this.mdmUserService.query(new MdmUserReqVo().setUserName(reqVo.getUserName()))) != null && UserTypeEnum.USER.getCode().equals(userRespVo.getUserType()) && CollectionUtil.listNotEmptyNotSizeZero((List)userRespVo.getPositionList())) {
            List positionCodeList = userRespVo.getPositionList().stream().map(MdmPositionRespVo::getPositionCode).collect(Collectors.toList());
            if (positionCodeList.contains(reqVo.getPositionCode())) {
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().ne(MdmPositionEntity::getPositionCode, (Object)reqVo.getPositionCode())).in(MdmPositionEntity::getPositionCode, positionCodeList)).set(MdmPositionEntity::getCurrentFlag, (Object)YesOrNoEnum.IO.NO)).update();
                ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmPositionEntity::getPositionCode, (Object)reqVo.getPositionCode())).set(MdmPositionEntity::getCurrentFlag, (Object)YesOrNoEnum.IO.YES)).update();
            } else {
                throw new BusinessException("\u8be5\u7528\u6237\u6ca1\u6709\u5173\u8054\u8be5\u804c\u4f4d");
            }
        }
    }

    @Override
    public List<MdmPositionUserOrgRespVo> findPositionUserOrgList(MdmPositionUserOrgReqVo reqVo) {
        List childrenPositionCodeList;
        List<MdmPositionRespVo> childrenPositionList;
        List childrenOrgCodeList;
        List<MdmOrgRespVo> childrenOrgList;
        if (StringUtils.isNotEmpty((String)reqVo.getAllUnderThisOrgCode())) {
            childrenOrgList = this.mdmOrgService.findAllChildrenOrgList(null, reqVo.getAllUnderThisOrgCode());
            if (CollectionUtil.listEmpty(childrenOrgList)) {
                return new ArrayList<MdmPositionUserOrgRespVo>();
            }
            childrenOrgCodeList = childrenOrgList.stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
            if (CollectionUtil.listEmpty((List)reqVo.getOrgCodeList())) {
                reqVo.setOrgCodeList(childrenOrgCodeList);
            } else {
                reqVo.getOrgCodeList().retainAll(childrenOrgCodeList);
            }
        }
        if (StringUtils.isNotEmpty((String)reqVo.getAllUnderThisOrgCodeExcludeSelf())) {
            childrenOrgList = this.mdmOrgService.findAllChildrenOrgList(null, reqVo.getAllUnderThisOrgCodeExcludeSelf());
            if (CollectionUtil.listEmpty(childrenOrgList) || childrenOrgList.size() == 1) {
                return new ArrayList<MdmPositionUserOrgRespVo>();
            }
            childrenOrgCodeList = childrenOrgList.stream().filter(item -> !item.getOrgCode().equals(reqVo.getAllUnderThisOrgCodeExcludeSelf())).map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
            if (CollectionUtil.listEmpty((List)reqVo.getOrgCodeList())) {
                reqVo.setOrgCodeList(childrenOrgCodeList);
            } else {
                reqVo.getOrgCodeList().retainAll(childrenOrgCodeList);
            }
        }
        if (StringUtils.isNotEmpty((String)reqVo.getAllUnderThisPositionCode())) {
            childrenPositionList = this.findAllChildrenPositionList(null, reqVo.getAllUnderThisPositionCode());
            if (CollectionUtil.listEmpty(childrenPositionList)) {
                return new ArrayList<MdmPositionUserOrgRespVo>();
            }
            childrenPositionCodeList = childrenPositionList.stream().map(MdmPositionRespVo::getPositionCode).collect(Collectors.toList());
            if (CollectionUtil.listEmpty((List)reqVo.getPositionCodeList())) {
                reqVo.setPositionCodeList(childrenPositionCodeList);
            } else {
                reqVo.getPositionCodeList().retainAll(childrenPositionCodeList);
            }
        }
        if (StringUtils.isNotEmpty((String)reqVo.getAllUnderThisPositionCodeExcludeSelf())) {
            childrenPositionList = this.findAllChildrenPositionList(null, reqVo.getAllUnderThisPositionCodeExcludeSelf());
            if (CollectionUtil.listEmpty(childrenPositionList) || childrenPositionList.size() == 1) {
                return new ArrayList<MdmPositionUserOrgRespVo>();
            }
            childrenPositionCodeList = childrenPositionList.stream().filter(item -> !item.getPositionCode().equals(reqVo.getAllUnderThisPositionCodeExcludeSelf())).map(MdmPositionRespVo::getPositionCode).collect(Collectors.toList());
            if (CollectionUtil.listEmpty((List)reqVo.getPositionCodeList())) {
                reqVo.setPositionCodeList(childrenPositionCodeList);
            } else {
                reqVo.getPositionCodeList().retainAll(childrenPositionCodeList);
            }
        }
        return this.mdmPositionMapper.findPositionUserOrgList(null, reqVo);
    }

    @Override
    public PageResult<MdmPositionUserOrgRespVo> findPositionUserOrgPageList(MdmPositionUserOrgReqVo reqVo) {
        List childrenOrgCodeList;
        List<MdmOrgRespVo> childrenOrgList;
        Page page = new Page((long)reqVo.getPageNum().intValue(), (long)reqVo.getPageSize().intValue());
        if (StringUtils.isNotEmpty((String)reqVo.getAllUnderThisOrgCode())) {
            childrenOrgList = this.mdmOrgService.findAllChildrenOrgList(null, reqVo.getAllUnderThisOrgCode());
            if (CollectionUtil.listEmpty(childrenOrgList)) {
                return PageResult.builder().data(new ArrayList()).count(Long.valueOf(0L)).build();
            }
            childrenOrgCodeList = childrenOrgList.stream().map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
            if (CollectionUtil.listEmpty((List)reqVo.getOrgCodeList())) {
                reqVo.setOrgCodeList(childrenOrgCodeList);
            } else {
                reqVo.getOrgCodeList().retainAll(childrenOrgCodeList);
            }
        }
        if (StringUtils.isNotEmpty((String)reqVo.getAllUnderThisOrgCodeExcludeSelf())) {
            childrenOrgList = this.mdmOrgService.findAllChildrenOrgList(null, reqVo.getAllUnderThisOrgCodeExcludeSelf());
            if (CollectionUtil.listEmpty(childrenOrgList) || childrenOrgList.size() == 1) {
                return PageResult.builder().data(new ArrayList()).count(Long.valueOf(0L)).build();
            }
            childrenOrgCodeList = childrenOrgList.stream().filter(item -> !item.getOrgCode().equals(reqVo.getAllUnderThisOrgCodeExcludeSelf())).map(MdmOrgRespVo::getOrgCode).collect(Collectors.toList());
            if (CollectionUtil.listEmpty((List)reqVo.getOrgCodeList())) {
                reqVo.setOrgCodeList(childrenOrgCodeList);
            } else {
                reqVo.getOrgCodeList().retainAll(childrenOrgCodeList);
            }
        }
        if (StringUtils.isNotEmpty((String)reqVo.getAllUnderThisPositionCode())) {
            List<MdmPositionRespVo> childrenPositionList = this.findAllChildrenPositionList(null, reqVo.getAllUnderThisPositionCode());
            if (CollectionUtil.listEmpty(childrenPositionList)) {
                return PageResult.builder().data(new ArrayList()).count(Long.valueOf(0L)).build();
            }
            List childrenPositionCodeList = childrenPositionList.stream().map(MdmPositionRespVo::getPositionCode).collect(Collectors.toList());
            if (CollectionUtil.listEmpty((List)reqVo.getPositionCodeList())) {
                reqVo.setPositionCodeList(childrenPositionCodeList);
            } else {
                reqVo.getPositionCodeList().retainAll(childrenPositionCodeList);
            }
        }
        List<MdmPositionUserOrgRespVo> list = this.mdmPositionMapper.findPositionUserOrgList((Page<MdmPositionUserOrgRespVo>)page, reqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void batchUpdatePositionOrg(MdmPositionUserOrgReqVo reqVo) {
        Assert.notEmpty((Collection)reqVo.getPositionCodeList(), (String)"\u7f3a\u5931\u804c\u4f4d\u7f16\u7801");
        Assert.notNull((Object)reqVo.getOrgCode(), (String)"\u7f3a\u5931\u7ec4\u7ec7\u7f16\u7801");
        MdmOrgRespVo org = this.mdmOrgService.query(new MdmOrgReqVo().setOrgCode(reqVo.getOrgCode()));
        Assert.notNull((Object)org, (String)"\u672a\u627e\u5230\u7ec4\u7ec7");
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().in(MdmPositionEntity::getPositionCode, (Collection)reqVo.getPositionCodeList())).set(MdmPositionEntity::getOrgCode, (Object)org.getOrgCode())).update();
    }

    @Override
    @Klock
    @Transactional(rollbackFor={Exception.class})
    public void resetPositionRuleCode() {
        ((LambdaUpdateChainWrapper)this.lambdaUpdate().set(CrmTreeTenEntity::getRuleCode, (Object)UUID.randomUUID().toString())).update();
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().isNull(MdmPositionEntity::getParentCode)).or()).eq(MdmPositionEntity::getParentCode, (Object)"")).list();
        for (int i = 0; i < list.size(); ++i) {
            this.updateCurAndChildren(((MdmPositionEntity)((Object)list.get(i))).getOrgCode(), TreeRuleCodeUtil.numToSingleCode(i + 1), 1);
        }
    }

    private String generateUnionName(String orgName, String positionName, String fullName) {
        return (orgName == null ? "" : orgName) + "/" + (positionName == null ? "" : positionName) + "/" + (fullName == null ? "" : fullName);
    }

    private String generatePositionName(String positionLevelCode, String positionLevelName) {
        List positionList = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionEntity::getPositionLevelCode, (Object)positionLevelCode)).list();
        if (CollectionUtils.isEmpty((Collection)positionList)) {
            return positionLevelName + "_1";
        }
        Integer max = 1;
        for (MdmPositionEntity item : positionList) {
            Integer cur;
            String[] array1 = item.getPositionName().split("[\\D]+");
            String s = array1[array1.length - 1];
            if (!StringUtils.isNotEmpty((String)s) || (cur = Integer.valueOf(s)) <= max) continue;
            max = cur;
        }
        return positionLevelName + "_" + (max + 1);
    }

    private String generateRuleCodeByParentCode(String parentCode) {
        MdmPositionEntity parent;
        String ruleCode = "";
        boolean top = true;
        String prefix = "";
        if (StringUtils.isNotEmpty((String)parentCode) && (parent = (MdmPositionEntity)((Object)((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionEntity::getPositionCode, (Object)parentCode)).one())) != null) {
            top = false;
            prefix = parent.getRuleCode();
        }
        List list = null;
        list = top ? ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().isNull(MdmPositionEntity::getParentCode)).or()).eq(MdmPositionEntity::getParentCode, (Object)"")).list() : ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionEntity::getParentCode, (Object)parentCode)).list();
        if (CollectionUtil.listEmpty((List)list)) {
            ruleCode = prefix + TreeRuleCodeUtil.numToSingleCode(1);
        } else {
            LinkedHashSet<Integer> set = new LinkedHashSet<Integer>();
            for (MdmPositionEntity item : list) {
                if (!StringUtils.isNotEmpty((String)item.getRuleCode())) continue;
                Integer integer = TreeRuleCodeUtil.getCurLevelNum(item.getRuleCode());
                set.add(integer);
            }
            for (int i = 1; i < 999; ++i) {
                if (set.contains(i)) continue;
                ruleCode = prefix + TreeRuleCodeUtil.numToSingleCode(i);
                break;
            }
        }
        return ruleCode;
    }

    private void updateCurAndChildren(String orgCode, String curCode, int levelNum) {
        ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(MdmPositionEntity::getPositionCode, (Object)orgCode)).set(CrmTreeTenEntity::getRuleCode, (Object)curCode)).set(CrmTreeTenEntity::getLevelNum, (Object)levelNum)).update();
        List list = ((LambdaQueryChainWrapper)this.lambdaQuery().eq(MdmPositionEntity::getParentCode, (Object)orgCode)).list();
        if (CollectionUtil.listNotEmptyNotSizeZero((List)list)) {
            for (int i = 0; i < list.size(); ++i) {
                this.updateCurAndChildren(((MdmPositionEntity)((Object)list.get(i))).getPositionCode(), curCode + TreeRuleCodeUtil.numToSingleCode(i + 1), levelNum + 1);
            }
        }
    }
}

