/*
 * Decompiled with CFR 0.152.
 */
package com.biz.crm.positionlevel.service.impl;

import com.baomidou.mybatisplus.core.mapper.BaseMapper;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.conditions.update.LambdaUpdateChainWrapper;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.biz.crm.base.BaseIdEntity;
import com.biz.crm.base.CrmBaseEntity;
import com.biz.crm.common.PageResult;
import com.biz.crm.eunm.CodeRuleEnum;
import com.biz.crm.eunm.CrmEnableStatusEnum;
import com.biz.crm.nebular.mdm.position.req.MdmPositionReqVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRespVo;
import com.biz.crm.nebular.mdm.positionlevel.req.MdmPositionLevelReqVo;
import com.biz.crm.nebular.mdm.positionlevel.resp.MdmPositionLevelRespVo;
import com.biz.crm.nebular.mdm.role.resp.MdmRoleRespVo;
import com.biz.crm.position.model.MdmPositionEntity;
import com.biz.crm.position.service.IMdmPositionService;
import com.biz.crm.positionlevel.mapper.MdmPositionLevelMapper;
import com.biz.crm.positionlevel.model.MdmPositionLevelEntity;
import com.biz.crm.positionlevel.model.MdmPositionLevelRoleEntity;
import com.biz.crm.positionlevel.service.IMdmPositionLevelRoleService;
import com.biz.crm.positionlevel.service.IMdmPositionLevelService;
import com.biz.crm.role.mode.MdmRoleEntity;
import com.biz.crm.role.service.IMdmRoleService;
import com.biz.crm.util.CodeUtil;
import com.biz.crm.util.CollectionUtil;
import com.biz.crm.util.CrmBeanUtil;
import com.biz.crm.util.PageUtil;
import com.biz.crm.util.StringUtils;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.Assert;

@Service
@ConditionalOnMissingBean(name={"MdmPositionLevelServiceExpandImpl"})
public class MdmPositionLevelServiceImpl<M extends BaseMapper<T>, T>
extends ServiceImpl<MdmPositionLevelMapper, MdmPositionLevelEntity>
implements IMdmPositionLevelService {
    private static final Logger log = LoggerFactory.getLogger(MdmPositionLevelServiceImpl.class);
    @Resource
    private MdmPositionLevelMapper mdmPositionLevelMapper;
    @Resource
    private IMdmPositionLevelRoleService mdmPositionLevelRoleService;
    @Resource
    private IMdmRoleService mdmRoleService;
    @Resource
    private IMdmPositionService mdmPositionService;

    @Override
    public PageResult<MdmPositionLevelRespVo> findList(MdmPositionLevelReqVo reqVo) {
        Page page = PageUtil.buildPage((Integer)reqVo.getPageNum(), (Integer)reqVo.getPageSize());
        List<MdmPositionLevelRespVo> list = this.mdmPositionLevelMapper.findList((Page<MdmPositionLevelRespVo>)page, reqVo);
        if (CollectionUtil.listNotEmptyNotSizeZero(list)) {
            List roleEntityList;
            List positionLevelCodeList = list.stream().map(MdmPositionLevelRespVo::getPositionLevelCode).collect(Collectors.toList());
            List positionLevelRoleEntityList = ((LambdaQueryChainWrapper)this.mdmPositionLevelRoleService.lambdaQuery().in(MdmPositionLevelRoleEntity::getPositionLevelCode, positionLevelCodeList)).list();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)positionLevelRoleEntityList) && CollectionUtil.listNotEmptyNotSizeZero((List)(roleEntityList = ((LambdaQueryChainWrapper)this.mdmRoleService.lambdaQuery().in(MdmRoleEntity::getRoleCode, (Collection)positionLevelRoleEntityList.stream().map(MdmPositionLevelRoleEntity::getRoleCode).collect(Collectors.toSet()))).list()))) {
                Map<String, String> roleCodeNameMap = roleEntityList.stream().collect(Collectors.toMap(MdmRoleEntity::getRoleCode, MdmRoleEntity::getRoleName));
                Map<String, List<MdmPositionLevelRoleEntity>> roleGroupMap = positionLevelRoleEntityList.stream().collect(Collectors.groupingBy(MdmPositionLevelRoleEntity::getPositionLevelCode));
                list.forEach(item -> {
                    if (roleGroupMap.containsKey(item.getPositionLevelCode())) {
                        List roleItemList = (List)roleGroupMap.get(item.getPositionLevelCode());
                        ArrayList codeList = new ArrayList();
                        ArrayList nameList = new ArrayList();
                        roleItemList.forEach(roleItem -> {
                            if (roleCodeNameMap.containsKey(roleItem.getRoleCode())) {
                                codeList.add(roleItem.getRoleCode());
                                nameList.add(roleCodeNameMap.get(roleItem.getRoleCode()));
                            }
                        });
                        item.setRoleCode(String.join((CharSequence)",", codeList));
                        item.setRoleName(String.join((CharSequence)",", nameList));
                    }
                });
            }
        }
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public MdmPositionLevelRespVo query(MdmPositionLevelReqVo reqVo) {
        if (StringUtils.isNotEmpty((String)reqVo.getId()) || StringUtils.isNotEmpty((String)reqVo.getPositionLevelCode())) {
            MdmPositionLevelEntity entity = (MdmPositionLevelEntity)((Object)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(StringUtils.isNotEmpty((String)reqVo.getId()), BaseIdEntity::getId, (Object)reqVo.getId())).eq(StringUtils.isNotEmpty((String)reqVo.getPositionLevelCode()), MdmPositionLevelEntity::getPositionLevelCode, (Object)reqVo.getPositionLevelCode())).one());
            Assert.notNull((Object)((Object)entity), (String)"\u804c\u4f4d\u7ea7\u522b\u4e0d\u5b58\u5728");
            MdmPositionLevelRespVo respVo = (MdmPositionLevelRespVo)CrmBeanUtil.copy((Object)((Object)entity), MdmPositionLevelRespVo.class);
            List positionLevelRoleEntityList = ((LambdaQueryChainWrapper)this.mdmPositionLevelRoleService.lambdaQuery().eq(MdmPositionLevelRoleEntity::getPositionLevelCode, (Object)entity.getPositionLevelCode())).list();
            if (CollectionUtil.listNotEmptyNotSizeZero((List)positionLevelRoleEntityList)) {
                List roleEntityList = ((LambdaQueryChainWrapper)this.mdmRoleService.lambdaQuery().in(MdmRoleEntity::getRoleCode, (Collection)positionLevelRoleEntityList.stream().map(MdmPositionLevelRoleEntity::getRoleCode).collect(Collectors.toList()))).list();
                List roleList = CrmBeanUtil.copyList((List)roleEntityList, MdmRoleRespVo.class);
                respVo.setRoleCode(roleList.stream().map(MdmRoleRespVo::getRoleCode).collect(Collectors.joining(",")));
                respVo.setRoleName(roleList.stream().map(MdmRoleRespVo::getRoleName).collect(Collectors.joining(",")));
                respVo.setRoleList(roleList);
            }
            return respVo;
        }
        return null;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void save(MdmPositionLevelReqVo reqVo) {
        Assert.hasText((String)reqVo.getPositionLevelName(), (String)"\u7f3a\u5931\u804c\u4f4d\u7ea7\u522b\u540d\u79f0");
        Assert.hasText((String)reqVo.getRoleCode(), (String)"\u7f3a\u5931\u89d2\u8272\u7f16\u7801");
        Assert.hasText((String)reqVo.getEnableStatus(), (String)"\u7f3a\u5931\u542f\u7528\u72b6\u6001");
        MdmPositionLevelEntity entity = (MdmPositionLevelEntity)((Object)CrmBeanUtil.copy((Object)reqVo, MdmPositionLevelEntity.class));
        if (StringUtils.isEmpty((String)entity.getPositionLevelCode())) {
            entity.setPositionLevelCode(CodeUtil.generateCode((String)CodeRuleEnum.MDM_POSITION_LEVEL_CODE.getCode()));
        }
        this.save((Object)entity);
        this.mdmPositionLevelRoleService.replacePositionLevelRole(entity.getPositionLevelCode(), Arrays.asList(reqVo.getRoleCode().split(",")));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void update(MdmPositionLevelReqVo reqVo) {
        Assert.hasText((String)reqVo.getId(), (String)"\u7f3a\u5931id");
        MdmPositionLevelEntity entity = (MdmPositionLevelEntity)((Object)this.getById((Serializable)((Object)reqVo.getId())));
        Assert.notNull((Object)((Object)entity), (String)"\u804c\u4f4d\u7ea7\u522b\u4e0d\u5b58\u5728");
        Assert.hasText((String)reqVo.getPositionLevelCode(), (String)"\u7f3a\u5931\u804c\u4f4d\u7ea7\u522b\u7f16\u7801");
        Assert.hasText((String)reqVo.getPositionLevelName(), (String)"\u7f3a\u5931\u804c\u4f4d\u7ea7\u522b\u540d\u79f0");
        Assert.hasText((String)reqVo.getRoleCode(), (String)"\u7f3a\u5931\u89d2\u8272\u7f16\u7801");
        Assert.hasText((String)reqVo.getRoleCode(), (String)"\u7f3a\u5931\u542f\u7528\u72b6\u6001");
        CrmBeanUtil.copyProperties((Object)reqVo, (Object)((Object)entity));
        this.updateById((Object)entity);
        this.mdmPositionLevelRoleService.replacePositionLevelRole(entity.getPositionLevelCode(), Arrays.asList(reqVo.getRoleCode().split(",")));
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void deleteBatch(MdmPositionLevelReqVo reqVo) {
        Assert.notEmpty((Collection)reqVo.getIds(), (String)"\u8bf7\u4f20\u5165\u53c2\u6570");
        List list = this.mdmPositionLevelMapper.selectBatchIds(reqVo.getIds());
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            list.forEach(o -> {
                List positionList = ((LambdaQueryChainWrapper)this.mdmPositionService.lambdaQuery().eq(MdmPositionEntity::getPositionLevelCode, (Object)o.getPositionLevelCode())).list();
                Assert.isTrue((boolean)CollectionUtil.listEmpty((List)positionList), (String)("\u804c\u4f4d\u7ea7\u522b" + o.getPositionLevelName() + "\u5df2\u7ecf\u5173\u8054\u4e86\u804c\u4f4d\uff0c\u4e0d\u80fd\u5220\u9664"));
                this.mdmPositionLevelRoleService.removePositionLevel(o.getPositionLevelCode());
                this.removeById((Serializable)((Object)o.getId()));
            });
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void enableBatch(MdmPositionLevelReqVo reqVo) {
        List ids = reqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        for (String id : ids) {
            Assert.hasText((String)id, (String)"id\u4e0d\u80fd\u4f20\u7a7a\u503c");
            MdmPositionLevelEntity entity = (MdmPositionLevelEntity)((Object)this.getById((Serializable)((Object)id)));
            Assert.notNull((Object)((Object)entity), (String)"id\u65e0\u6548");
            Assert.isTrue((boolean)CrmEnableStatusEnum.DISABLE.getCode().equals(entity.getEnableStatus()), (String)("\u53ea\u80fd\u542f\u7528\u72b6\u6001\u4e3a\u201c" + CrmEnableStatusEnum.DISABLE.getDes() + "\u201d\u7684\u804c\u4f4d\u7ea7\u522b"));
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(BaseIdEntity::getId, (Object)id)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).update();
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public void disableBatch(MdmPositionLevelReqVo reqVo) {
        List ids = reqVo.getIds();
        Assert.notEmpty((Collection)ids, (String)"id\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a");
        for (String id : ids) {
            Assert.hasText((String)id, (String)"id\u4e0d\u80fd\u4f20\u7a7a\u503c");
            MdmPositionLevelEntity entity = (MdmPositionLevelEntity)((Object)this.getById((Serializable)((Object)id)));
            Assert.notNull((Object)((Object)entity), (String)"id\u65e0\u6548");
            Assert.isTrue((boolean)CrmEnableStatusEnum.ENABLE.getCode().equals(entity.getEnableStatus()), (String)("\u53ea\u80fd\u7981\u7528\u72b6\u6001\u4e3a\u201c" + CrmEnableStatusEnum.ENABLE.getDes() + "\u201d\u7684\u804c\u4f4d\u7ea7\u522b"));
            ((LambdaUpdateChainWrapper)((LambdaUpdateChainWrapper)this.lambdaUpdate().eq(BaseIdEntity::getId, (Object)id)).set(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.DISABLE.getCode())).update();
        }
    }

    @Override
    public PageResult<MdmPositionRespVo> positionList(MdmPositionReqVo mdmPositionReqVo) {
        Assert.hasText((String)mdmPositionReqVo.getPositionLevelCode(), (String)"\u7f3a\u5931\u804c\u4f4d\u7ea7\u522b\u7f16\u7801");
        Page page = new Page((long)mdmPositionReqVo.getPageNum().intValue(), (long)mdmPositionReqVo.getPageSize().intValue());
        List<MdmPositionRespVo> list = this.mdmPositionLevelMapper.positionList((Page<MdmPositionRespVo>)page, mdmPositionReqVo);
        return PageResult.builder().data(list).count(Long.valueOf(page.getTotal())).build();
    }

    @Override
    public List<MdmPositionLevelRespVo> selectList(MdmPositionLevelReqVo mdmPositionLevelReqVo) {
        List list = ((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)((LambdaQueryChainWrapper)this.lambdaQuery().eq(CrmBaseEntity::getEnableStatus, (Object)CrmEnableStatusEnum.ENABLE.getCode())).like(!StringUtils.isEmpty((String)mdmPositionLevelReqVo.getPositionLevelCode()), MdmPositionLevelEntity::getPositionLevelCode, (Object)mdmPositionLevelReqVo.getPositionLevelCode())).like(!StringUtils.isEmpty((String)mdmPositionLevelReqVo.getPositionLevelName()), MdmPositionLevelEntity::getPositionLevelName, (Object)mdmPositionLevelReqVo.getPositionLevelName())).list();
        return list != null ? CrmBeanUtil.copyList((List)list, MdmPositionLevelRespVo.class) : new ArrayList();
    }
}

